/*
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 2000 MIPS Technologies, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 * MIPS boards bootprom interface for the Linux kernel.
 *
 */

#ifndef _MACH_VENUS_PROM_H
#define _MACH_VENUS_PROM_H

extern char *prom_getcmdline(void);
extern char *prom_getenv(char *name);
//extern void setup_prom_printf(int tty_no);
//#ifdef CONFIG_SERIAL_8250 && CONFIG_PRINTK
#ifdef CONFIG_SERIAL_8250
#ifdef CONFIG_PRINTK
extern void prom_printf(char *fmt, ...);
#else
#define prom_printf(...)	(__VA_ARGS__, 0)
#endif
#else
#define prom_printf(...)	(__VA_ARGS__, 0)
#endif
extern void prom_init_cmdline(void);
extern void prom_meminit(void);
//extern void prom_fixup_mem_map(unsigned long start_mem, unsigned long end_mem);
extern unsigned long prom_free_prom_memory (void);
//extern void mips_display_message(const char *str);
//extern void mips_display_word(unsigned int num);
//extern int get_ethernet_addr(char *ethernet_addr);

/* Memory descriptor management. */
#define PROM_MAX_PMEMBLOCKS    8
struct prom_pmemblock {
        unsigned long base; /* Within KSEG0. */
        unsigned int size;  /* In bytes. */
        unsigned int type;  /* free or prom memory */
};

#endif /* !(_MACH_VENUS_PROM_H) */
