#include <linux/module.h>
#include <linux/config.h>
#include <linux/init.h>
#include <linux/time.h>
#include <linux/jiffies.h>
#include <linux/sysctl.h>

#define LED_ON		1
#define LED_OFF		0
#define LED_WHITE	30
#define LED_AMBER	31

int		led_blinking = 1;
static struct timer_list pwrled_blinking_timer;
static char	ledstatus = 0;

#define MIS_GP0DIR	((volatile unsigned int *)0xb801b100)
#define MIS_GP0DATO	((volatile unsigned int *)0xb801b108)
#define BLINK_DELAY	HZ*3

static void	pwrled_setgpio(int gpio_num, int value)
{
        int             bitOffset;
        volatile int    *regAddr;
        int             regValue;

        bitOffset = gpio_num;
        regAddr = (volatile int *)MIS_GP0DIR;
        regValue = *regAddr;
        regValue = regValue | (0x01 << bitOffset);
        *regAddr = regValue;
        regAddr = (volatile int *)MIS_GP0DATO;
        regValue = *regAddr;
        if(value)
                regValue = regValue | (0x01 << bitOffset);      // set to 1
        else
                regValue = regValue & (~(0x01 << bitOffset));   // set to 0
        *regAddr = regValue;
}

static void pwrled_blinking_timer_func_1(unsigned long ptr)
{
        int *pstatus = (int *)ptr;

        *pstatus = (*pstatus) ? LED_OFF : LED_ON;
        pwrled_setgpio(LED_AMBER, *pstatus);
        pwrled_blinking_timer.expires = jiffies + HZ/2;
        add_timer(&pwrled_blinking_timer);
}

static void pwrled_blinking_timer_func_2(unsigned long ptr)
{
        int *pstatus = (int *)ptr;
	static char led[4][2] = {
		{LED_WHITE, LED_ON}, {LED_WHITE, LED_OFF},
		{LED_AMBER, LED_ON}, {LED_AMBER, LED_OFF} };

        *pstatus = ++*pstatus % 4;
        pwrled_setgpio(led[*pstatus][0], led[*pstatus][1]);
        pwrled_blinking_timer.expires = jiffies + HZ/4;
        add_timer(&pwrled_blinking_timer);
}

static void pwrled_blinking_timer_func_3(unsigned long ptr)
{
        int *pstatus = (int *)ptr;
	static char led[8][2] = {
		{LED_WHITE, LED_ON}, {LED_WHITE, LED_OFF},
		{LED_AMBER, LED_ON}, {LED_AMBER, LED_OFF},
		{LED_AMBER, LED_ON}, {LED_AMBER, LED_OFF},
		{LED_AMBER, LED_ON}, {LED_AMBER, LED_OFF} };

        *pstatus = ++*pstatus % 8;
        pwrled_setgpio(led[*pstatus][0], led[*pstatus][1]);
        pwrled_blinking_timer.expires = jiffies + HZ/4;
        add_timer(&pwrled_blinking_timer);
}

static void pwrled_blinking_timer_func_4(unsigned long ptr)
{
        int *pstatus = (int *)ptr;

        *pstatus = (*pstatus) ? LED_OFF : LED_ON;
        pwrled_setgpio(LED_WHITE, *pstatus); // WHITE
        pwrled_blinking_timer.expires = jiffies + HZ/4;
        add_timer(&pwrled_blinking_timer);
}

int
proc_led_blinking(ctl_table *ctl, int write, struct file *filp, void *buffer, size_t *lenp,  loff_t *ppos)
{
	int		ret;
	int		org_val = led_blinking;

	ret = proc_dointvec(ctl, write, filp, buffer, lenp, ppos);

	printk(KERN_INFO "proc_led_blinking = %d\n", led_blinking);

	/* if orignal value equals new value, do nothing */
	if (org_val == led_blinking) return ret;

	if(write) {
		switch(led_blinking) {
		case 0: // turn off blinking.
			del_timer(&pwrled_blinking_timer);
			pwrled_setgpio(LED_AMBER, LED_OFF);
			pwrled_setgpio(LED_WHITE, LED_ON);
			break;
		case 1: // System booting
			del_timer(&pwrled_blinking_timer);
			pwrled_setgpio(LED_WHITE, LED_OFF);
			pwrled_setgpio(LED_AMBER, LED_OFF);
			init_timer(&pwrled_blinking_timer);
			ledstatus = -1;
			pwrled_blinking_timer.function = pwrled_blinking_timer_func_1;
			pwrled_blinking_timer.data = (unsigned long)&ledstatus;
			pwrled_blinking_timer.expires = jiffies + HZ/2;
			add_timer(&pwrled_blinking_timer);
			break;
		case 2: // Flash or memory error
			del_timer(&pwrled_blinking_timer);
			pwrled_setgpio(LED_WHITE, LED_OFF);
			pwrled_setgpio(LED_AMBER, LED_OFF);
			init_timer(&pwrled_blinking_timer);
			ledstatus = -1;
			pwrled_blinking_timer.function = pwrled_blinking_timer_func_2;
			pwrled_blinking_timer.data = (unsigned long)&ledstatus;
			pwrled_blinking_timer.expires = jiffies + HZ/4;
			add_timer(&pwrled_blinking_timer);
			break;
		case 3: // Firmware update fails
			del_timer(&pwrled_blinking_timer);
			pwrled_setgpio(LED_WHITE, LED_OFF);
			pwrled_setgpio(LED_AMBER, LED_OFF);
			init_timer(&pwrled_blinking_timer);
			ledstatus = -1;
			pwrled_blinking_timer.function = pwrled_blinking_timer_func_3;
			pwrled_blinking_timer.data = (unsigned long)&ledstatus;
			pwrled_blinking_timer.expires = jiffies + HZ/4;
			add_timer(&pwrled_blinking_timer);
			break;
		case 4: // Warning: HDD is not healthy
			del_timer(&pwrled_blinking_timer);
			pwrled_setgpio(LED_WHITE, LED_OFF);
			pwrled_setgpio(LED_AMBER, LED_OFF);
			init_timer(&pwrled_blinking_timer);
			ledstatus = -1;
			pwrled_blinking_timer.function = pwrled_blinking_timer_func_4;
			pwrled_blinking_timer.data = (unsigned long)&ledstatus;
			pwrled_blinking_timer.expires = jiffies + HZ/4;
			add_timer(&pwrled_blinking_timer);
			break;
		case 10: // power on
			del_timer(&pwrled_blinking_timer);
			pwrled_setgpio(LED_WHITE, LED_ON);
			pwrled_setgpio(LED_AMBER, LED_OFF);
			break;
		case 11: // standby
			del_timer(&pwrled_blinking_timer);
			pwrled_setgpio(LED_WHITE, LED_OFF);
			pwrled_setgpio(LED_AMBER, LED_ON);
			break;
		case 12: // USB power on
			pwrled_setgpio(26, 0);
			break;
		default:
			led_blinking = org_val;
		}
		return ret;
	}

    return ret;
}

int __init led_blinking_init(void)
{
	ledstatus = 0;

	pwrled_setgpio(LED_AMBER, LED_OFF);
	pwrled_setgpio(LED_WHITE, LED_OFF);
	init_timer(&pwrled_blinking_timer);
	pwrled_blinking_timer.function = pwrled_blinking_timer_func_1;
	pwrled_blinking_timer.data = (unsigned long)&ledstatus;
	pwrled_blinking_timer.expires = jiffies + BLINK_DELAY;
	add_timer(&pwrled_blinking_timer);

	return 0;
}
