#!/bin/sh
#
# Script to setup GPIO pins for Broadcom Atlanta Board
#
# GPIO 0 - Soft power switch
# GPIO 1 - System ready LED
# GPIO 2 - SDA
# GPIO 3 - HD 5V enable
# GPIO 4 - Temperature alarm
# GPIO 5 - SCL
# GPIO 6 - HD 12V enable
# GPIO 7 - Reset switch
#
#########################################################

# Setup GPIO 0 as soft power switch
# Soft power switch is input with normal polarity
echo direction=in > /proc/miscio/soft_power_switch_config
echo polarity=normal > /proc/miscio/soft_power_switch_config
echo interrupt=yes > /proc/miscio/soft_power_switch_config
echo interrupt level=1 > /proc/miscio/soft_power_switch_config

# Setup GPIO 1 as system ready LED
# System ready LED is output with reverse polarity
echo direction=out > /proc/miscio/system_ready_LED_config
echo polarity=reverse > /proc/miscio/system_ready_LED_config
echo interrupt=no > /proc/miscio/system_ready_LED_config
echo interrupt level=1 > /proc/miscio/system_ready_LED_config

# GPIO 2 is SDA
# SDA is both input and output and will be configured by 
# the software application

# GPIO 3 is 5V power enable for the hard drive
# This will be configured via the hard configuration
# NVRAM variable

# Setup GPIO 4 as Temperature alarm
# Temperature alarm is an input with reverse polarity
echo direction=in > /proc/miscio/temperature_alert_config
echo polarity=reverse > /proc/miscio/temperature_alert_config
echo interrupt=yes > /proc/miscio/temperature_alert_config
echo interrupt level=0 > /proc/miscio/temperature_alert_config

# GPIO 5 is SCL
# SCL is an output and will be configured by the 
# software application

# GPIO 6 is 12V power enable for the hard drive
# This will be configured via the hard configuration
# NVRAM variable

# GPIO 7 is Reset
# Reset is configured byt the software application

exit 0
