#!/bin/bash
#
# Miscellaneous steps to prepare the root filesystem
#
#
# Copyright 2001-2004, Broadcom Corporation
# All Rights Reserved.
#
# THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
# KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
# SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
#


ROOTDIR=$PWD

# tmp
mkdir -p var
mkdir -p tmp
ln -sf /tmp/var/lock var/lock
ln -sf /tmp/var/log var/log
ln -sf /tmp/var/run var/run
ln -sf /tmp/var/tmp var/tmp
mkdir -p var/lib
ln -sf /tmp/var/lib/nfs var/lib/nfs
(cd $ROOTDIR/usr && ln -sf ../tmp)

# dev
mkdir -p dev

# etc
mkdir -p etc
echo "/lib" > etc/ld.so.conf
echo "/usr/lib" >> etc/ld.so.conf
echo "order hosts,bind" > etc/host.conf
echo "hosts: files dns" > etc/nsswitch.conf
ln -sf /tmp/resolv.conf etc/resolv.conf
ln -sf /tmp/hosts etc/hosts
/sbin/ldconfig -r $ROOTDIR

# miscellaneous
mkdir -p mnt
mkdir -p proc
mkdir -p shares

# clean lib
rm -rf lib/libgcc*
rm -rf lib/modules/2.4.20/security*
rm -rf lib/modules/2.4.20/kernel/arch*
rm -rf lib/modules/2.4.20/kernel/drivers/i2c*
rm -rf lib/modules/2.4.20/kernel/drivers/net/wl*
rm -rf lib/modules/2.4.20/kernel/drivers/net/bcm*
rm -rf lib/modules/2.4.20/kernel/drivers/se*

