%define initdir /etc/rc.d/init.d

Summary: A program which manages RPC connections.
Name: portmap
Version: 4.0
Release: 46
Group: System Environment/Daemons
License: BSD
Source0: ftp://coast.cs.purdue.edu/pub/tools/unix/portmap/portmap_4.tar.gz
Source1: portmap.init
Source2: pmap_set.8
Source3: pmap_dump.8
Source4: portmap.8
Patch0: portmap-4.0-linux.patch
Patch1: portmap-malloc.patch
Patch2: portmap-4.0-cleanup.patch
Patch3: portmap-4.0-rpc_user.patch
Patch4: portmap-4.0-sigpipe.patch
Prereq: /sbin/chkconfig /etc/init.d
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: initscripts >= 5.54, util-linux >= 2.11b

%description
The portmapper program is a security tool which prevents theft of NIS
(YP), NFS and other sensitive information via the portmapper.  A
portmapper manages RPC connections, which are used by protocols like
NFS and NIS.

The portmap package should be installed on any machine which acts as a
server for protocols using RPC.

%prep 
%setup -q -n portmap_4
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1 -b .rpcuser
%patch4 -p1 -b .sigpipe

%build
make FACILITY=LOG_AUTH ZOMBIES='-DIGNORE_SIGCHLD -Dlint' LIBS="-lnsl" RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf ${RPM_BUILD_ROOT}

mkdir -p ${RPM_BUILD_ROOT}/sbin
install -m 755 portmap ${RPM_BUILD_ROOT}/sbin

mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
install -m 755 pmap_set ${RPM_BUILD_ROOT}%{_sbindir}
install -m 755 pmap_dump ${RPM_BUILD_ROOT}%{_sbindir}

mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
install -m 644 $RPM_SOURCE_DIR/pmap_set.8 ${RPM_BUILD_ROOT}%{_mandir}/man8
install -m 644 $RPM_SOURCE_DIR/pmap_dump.8 ${RPM_BUILD_ROOT}%{_mandir}/man8
install -m 644 $RPM_SOURCE_DIR/portmap.8 ${RPM_BUILD_ROOT}%{_mandir}/man8

mkdir -p ${RPM_BUILD_ROOT}%{initdir}
install -m 755 $RPM_SOURCE_DIR/portmap.init ${RPM_BUILD_ROOT}%{initdir}/portmap

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
/sbin/chkconfig --add portmap
/usr/sbin/groupadd -g 32 rpc > /dev/null 2>&1
/usr/sbin/useradd -c "Portmapper RPC user" -d / -g 32 -M -s /sbin/nologin -u 32 rpc > /dev/null 2>&1
exit 0

%triggerpostun -- portmap <= portmap-4.0-22
/sbin/chkconfig --add portmap

%preun
if [ $1 = 0 ] ; then
  service portmap stop > /dev/null 2>&1
  /sbin/chkconfig --del portmap
fi

%postun
if [ "$1" -ge "1" ]; then
  service portmap condrestart > /dev/null 2>&1
fi

%files
%defattr(-,root,root)
%doc README CHANGES BLURB

/sbin/portmap
%{_sbindir}/pmap_dump
%{_sbindir}/pmap_set

%{_mandir}/man8/*

%config	%{initdir}/portmap

%changelog
* Tue Aug  6 2002 Trond Eivind Glomsrd <teg@redhat.com> 4.0-46
- initscript tweaks (#70717)

* Thu Jul 18 2002 Trond Eivind Glomsrd <teg@redhat.com> 4.0-45
- Fix #63556
- Don't strip binaries explicitly

* Wed Jul 17 2002 Trond Eivind Glomsrd <teg@redhat.com> 4.0-44
- Change the references in the man page from inetd/inetd.conf
  to xinetd equivalents (#60861)

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Feb 27 2002 Trond Eivind Glomsrd <teg@redhat.com> 4.0-41
- Rebuild

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Sep 12 2001 Trond Eivind Glomsrd <teg@redhat.com> 4.0-39
- Use /sbin/nologin as shell (#53087)
- s/Copyright/License/

* Sun Jun 24 2001 Elliot Lee <sopwith@redhat.com>
- Bump release + rebuild.

* Sun Apr 29 2001 Bill Nottingham <notting@redhat.com>
- fix condrestart

* Fri Apr 20 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Remove "\n" from echo statement (#36721)

* Wed Feb 28 2001 Trond Eivind Glomsrd <teg@redhat.com>
- clear group memberships (#23195)

* Sun Feb 11 2001 Trond Eivind Glomsrd <teg@redhat.com>
- don't die on SIGPIPE (#21748)
- Fix condrestart so it maintains portmap state

* Wed Feb  7 2001 Trond Eivind Glomsrd <teg@redhat.com>
- improve i18n

* Wed Jan 24 2001 Matt Wilson <msw@redhat.com>
- new style i18n init script

* Fri Jan 19 2001 Trond Eivind Glomsrd <teg@redhat.com>
- fix manpage (#13218)
- gettextize 
- exit if /etc/sysconfig/network doesn't exist
  and make sure it works when networking is off (#23757)

* Tue Jan  2 2001 Bill Nottingham <notting@redhat.com>
- setgid too, not just setuid (#23195)

* Thu Aug 10 2000 Jeff Johnson <jbj@redhat.com>
- add restart shell function (#15914).

* Sun Aug  6 2000 Philipp Knirsch <pknirsch@redhat.com>
- Changed the uid/gid of the rpc user to be 32/32

* Fri Aug  4 2000 Philipp Knirsch <pknirsch@redhat.com>
- Fixed a build warning for daemon.c (missing <stdlib.h> include)
- Portmap now running under user rpc if possible (#12427) 

* Wed Aug  2 2000 Bill Nottingham <notting@redhat.com>
- start a little later (after syslog)
- do dump/reload on restart (#14612)

* Thu Jul 20 2000 Bill Nottingham <notting@redhat.com>
- move initscript back

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sat Jul  8 2000 Bill Nottingham <notting@redhat.com>
- make trigger work on a few later versions

* Tue Jun 27 2000 Than Ngo <than@redhat.de>
- /etc/rc.d/init.d -> /etc/init.d
- condrestart in %postun
- fix initscript
- add requires initscript
- remove links from packaging

* Tue Jun  6 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging.

* Wed May 10 2000 Jeff Johnson <jbj@redhat.com>
- apply cleanup patch (H.J. Lu)

* Mon Feb  7 2000 Jeff Johnson <jbj@redhat.com>
- compress man pages.

* Wed Dec  1 1999 Bill Nottingham <notting@redhat.com>
- add patch to fix some malloc issues from HP

* Fri Sep 10 1999 Bill Nottingham <notting@redhat.com>
- chkconfig --del in %preun, not %postun

* Mon Aug 16 1999 Bill Nottingham <notting@redhat.com>
- initscript munging

* Tue Mar 23 1999 Preston Brown <pbrown@redhat.com>
- added man pages.

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 14)

* Fri Dec 18 1998 Cristian Gafton <gafton@redhat.com>
- build for glibc 2.1

* Tue Jul  7 1998 Jeff Johnson <jbj@redhat.com>
- start/stop portmap at levels 11/89

* Mon May 04 1998 Cristian Gafton <gafton@redhat.com>
- fixed the trigger script

* Fri May 01 1998 Jeff Johnson <jbj@redhat.com>
- added triggerpostun

* Fri May 01 1998 Cristian Gafton <gafton@redhat.com>
- added %trigger to fix a previously broken package

* Thu Apr 23 1998 Michael K. Johnson <johnsonm@redhat.com>
- enhanced initscripts

* Thu Jan 08 1998 Erik Troan <ewt@redhat.com>
- rebuilt against glibc 2.0.6

* Tue Oct 28 1997 Erik Troan <ewt@redhat.com>
- fixed service name in stop section of init script

* Tue Oct 21 1997 Donnie Barnes <djb@redhat.com>
- fixed chkconfig support

* Sun Oct 19 1997 Erik Troan <ewt@redhat.com>
- added restart, status commands to init script
- added chkconfig support
- uses a buildroot and %attr tags

* Fri Jul 18 1997 Erik Troan <ewt@redhat.com>
- built against glibc
