/* 
   restore machine password

   This program is written to cooperate with the Unix SMB/CIFS implementation.

   Copyright (C) Broadcom Corporation              2004

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <ctype.h>
#include <signal.h>
#include "tdb.h"
#include "includes.h"

BOOL secrets_restore_machine_password(const char *pass, const char *domain, uint32 last_change_time, uint32 sec_channel_type);
BOOL secrets_restore_domain_sid(const char *domain, const DOM_SID *sid);

void
setup()
{
	pstring configfile;
	pstrcpy(configfile, dyn_CONFIGFILE);

	if (!lp_load(configfile,True,False,False)) {
		fprintf(stderr, "Can't load %s - run testparm to debug it\n", 
			dyn_CONFIGFILE);
		exit(2);
	}

	setup_logging("tdb_restore_secrets", True);
}

int main(int argc, char *argv[])
{
	const char * fname;
	const char * domain;
	const char * password;
	uint32 lct;
	uint32 sct;
	const char * sid_data;
	int raw[sizeof(DOM_SID)];
	DOM_SID sid;
	
	if (argc != 6) {
		printf("Usage: %s <domain> <password> <last_change_time> <sec_channel_type> <sid_data>\n", argv[0]);
		exit(1);
	}

	domain = argv[1];
	password = argv[2];
	lct = atoi(argv[3]);
	sct = atoi(argv[4]);
	sid_data = argv[5];

	setup();

	if (secrets_restore_machine_password(password, domain, lct, sct) == False)
	{
		printf("Restore failed.\n");
		exit(3);
	}

	sscanf(	sid_data, "S-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x-%x",
			&sid.sid_rev_num, &sid.num_auths, 
			&sid.id_auth[ 0 ], &sid.id_auth[ 0 ], &sid.id_auth[ 2 ],
			&sid.id_auth[ 3 ], &sid.id_auth[ 4 ], &sid.id_auth[ 5 ],
			&sid.sub_auths[0], &sid.sub_auths[1], &sid.sub_auths[2],
			&sid.sub_auths[3], &sid.sub_auths[4], &sid.sub_auths[5], 
			&sid.sub_auths[6], &sid.sub_auths[7], &sid.sub_auths[8], 
			&sid.sub_auths[9], &sid.sub_auths[10], &sid.sub_auths[11], 
			&sid.sub_auths[12], &sid.sub_auths[13], &sid.sub_auths[14], 
			&sid.sub_auths[15] );

	if (secrets_restore_domain_sid(domain, &sid) == False)
	{
		printf("Restore failed.\n");
		exit(4);
	}

	return 0;
}

