/*
   bcmwpa.h - interface definitions of shared WPA-related functions

   Copyright 2004, Broadcom Corporation
   All Rights Reserved.                
                                       
   This is UNPUBLISHED PROPRIETARY SOURCE CODE of Broadcom Corporation;   
   the contents of this file may not be disclosed to third parties, copied
   or duplicated in any form, in whole or in part, without the prior      
   written permission of Broadcom Corporation.                            

   $Id$
 */

#ifndef _BCMWPA_H_
#define _BCMWPA_H_

/* Field sizes for WPA key hierarchy */
#define WPA_MIC_KEY_LEN		16
#define WPA_ENCR_KEY_LEN	16
#define WPA_TEMP_ENCR_KEY_LEN	16
#define WPA_TEMP_TX_KEY_LEN	8
#define WPA_TEMP_RX_KEY_LEN	8

#define PMK_LEN			32
#define TKIP_PTK_LEN	64
#define TKIP_TK_LEN		32
#define AES_PTK_LEN		48
#define AES_TK_LEN		16

/* limits for pre-shared key lengths */
#define WPA_MIN_PSK_LEN		8
#define WPA_MAX_PSK_LEN		64


#define MAX_ARRAY 1
#define MIN_ARRAY 0

/* convert wsec to WPA mcast cipher. algo is needed only when WEP is enabled. */
#define WPA_MCAST_CIPHER(wsec, algo)	(WSEC_WEP_ENABLED(wsec) ? \
		((algo) == CRYPTO_ALGO_WEP128 ? WPA_CIPHER_WEP_104 : WPA_CIPHER_WEP_40) : \
			WSEC_TKIP_ENABLED(wsec) ? WPA_CIPHER_TKIP : \
			WSEC_AES_ENABLED(wsec) ? WPA_CIPHER_AES_CCM : WPA_CIPHER_NONE)

/* Return address of max or min array depending first argument.
   Return first array addr in case of a draw. */
extern char *wpa_array_cmp(int max, uint8 *x, uint8 *y, int len);

/* Increment the array argument */
extern void wpa_incr_array(uint8 *array, int len);

/* Convert WPI IE cipher suite to locally used value */
extern bool wpa_cipher(wpa_suite_t *suite, ushort *cipher, bool wep_ok);

/* Look for a WPA IE; return it's address if found, NULL otherwise */
extern wpa_ie_fixed_t *bcm_find_wpaie(uint8 *parse, uint len);

/* Check whether pointed-to IE looks like WPA. */
extern bool bcm_is_wpa_ie(uint8 *ie, uint8 **tlvs, int *tlvs_len);

#ifdef	WPAPSK

/* Calculate a pair-wise transient key */
extern void wpa_calc_ptk(struct ether_addr *auth_ea, struct ether_addr *sta_ea,
	uint8 *anonce, uint8* snonce, uint8 *pmk, uint pmk_len, uint8 *ptk,
	uint ptk_len);

/* Compute Message Integrity Code (MIC) over EAPOL message */
extern bool wpa_make_mic(eapol_header_t *eapol, uint key_desc, uint8 *mic_key,
	uchar *mic);

/* Check MIC of EAPOL message */
extern bool wpa_check_mic(eapol_header_t *eapol, uint key_desc, uint8 *mic_key);

/* Decrypt a group transient key from a WPA key message */
extern bool wpa_decr_gtk(eapol_wpa_key_header_t *body, uint16 key_info,
	uint8 *ekey, uint8 *gtk);
#endif	/* WPAPSK */

#endif	/* _BCMWPA_H_ */
