/*
 * Streaming encryption device driver header file 
 *
 * Copyright 2004, Broadcom Corporation
 * All Rights Reserved.
 *
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Broadcom Corporation;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of Broadcom Corporation.
 *
 * $Id$ $DateTime$ $Author$
 */
#ifndef _LINUX_SE_H
#define _LINUX_SE_H
	 
#define MAX_SE_DEVS  256 /* Max number of se dev */

#define SE_KEY_SIZE		32 /* 256-bit key */
#define SE_PASSWD_DIGEST_SIZE    16 /* bytes */
#define SE_MAX_ENC_PASSWD_LEN    512 /* bytes */

#define SE_MAX_UDEV_NAME_SIZE 	 128  /* bytes */
#define SE_MAX_PASSWD_LEN		 256  /* bytes */


/* ERROR CODE */
#define SE_ERR_INVALID_PASSWD	0x00E0
#define SE_ERR_OP_NOT_ALLOWED   0x00E1
#define SE_ERR_INVALID_OPCODE   0x00E2
#define SE_ERR_SB_CORRUPTED   	0x00E3


typedef struct _se_version_t
{
	int major;
	int minor;
} se_version_t;


typedef enum _se_start_opcode_t
{
	CREATE_PLAIN_POOL = 0x50,
	CREATE_ENC_POOL,
	ACCESS_PLAIN_POOL,
	ACCESS_ENC_POOL
} se_start_opcode_t;


typedef struct _se_startinfo_t
{
	se_start_opcode_t  opcode;
	int udev_major;    /* underlying device major number */
	int udev_minor;    /* underlying device minor number */
	char udev_name[SE_MAX_UDEV_NAME_SIZE]; /* underlying device name string */
	int udev_size;     /* underlying device size in sectors */
	unsigned char password[SE_MAX_PASSWD_LEN]; /* password string */
	unsigned char key[SE_KEY_SIZE];
	unsigned char digest[SE_PASSWD_DIGEST_SIZE];
	int rsa_enc_password_len;
	unsigned char rsa_enc_password[SE_MAX_ENC_PASSWD_LEN];
} se_startinfo_t;


typedef enum _se_change_opcode_t
{
	ADD_PASSWD = 0x80,
	CHANGE_PASSWD,
	REMOVE_PASSWD
} se_change_opcode_t;


typedef struct _se_changeinfo_t
{
	se_change_opcode_t opcode;
	unsigned char password[SE_MAX_PASSWD_LEN]; /* password string */
	unsigned char key[SE_KEY_SIZE];
	unsigned char digest[SE_PASSWD_DIGEST_SIZE];
	int rsa_enc_password_len;
	unsigned char rsa_enc_password[SE_MAX_ENC_PASSWD_LEN];	
} se_changeinfo_t;


/* SE super block magic string
 */
#define SE_MAGIC_STR_OFFSET 0
#define SE_SUPER_MAGIC_STRING "BrcmSeMagicStr"

/* SE state
 */
#define SE_STATE_OFFSET 16 

typedef enum _se_state_t
{
	SE_PLAIN = 0x00A0,
	SE_ENCRYPTED,
	SE_CHANGING,
	SE_ADDING,
	SE_REMOVING
} se_state_t;



/* IOCTL
 */
#define SE_IOC_MAGIC 'E'

/* Get the SE driver version.
 */
#define SE_IOC_GETVER   _IOR(SE_IOC_MAGIC, 0x00, se_version_t) /* Get SE device driver version */

/* Set up the info such as underlying device and encryption key 
 * to start the SE device.
 */
#define SE_IOC_START  	_IOW(SE_IOC_MAGIC, 0x01, se_startinfo_t)  

/* Stop SE device.
 */
#define SE_IOC_STOP     _IO(SE_IOC_MAGIC, 0x02)   


/* Change the SE device encryption key, add encryption key to
 * a SE device (convert a plain disk pool to an encrypted one), 
 * or remove encryption key from a SE device (convert an 
 * encrypted disk pool to a plain one). 
 */
#define SE_IOC_CHANGE  	_IOW(SE_IOC_MAGIC, 0x03, se_changeinfo_t)  


/* Hard reset the module usage count to 0 so that
 * we can always unload the module.
 */
#define SE_IOC_RESET 	_IO(SE_IOC_MAGIC, 0x04)     

	 
#endif /* #ifndef _LINUX_SE_H */
