
/******************************************************************************
 *
 *  Copyright 2000
 *  Broadcom Corporation
 *  16215 Alton Parkway
 *  PO Box 57013
 *  Irvine CA 92619-7013
 *
 *****************************************************************************/

/* 
 * Broadcom Corporation uBSec SDK 
 */

/*
 * ubsec_lib.h:  Header file for library APIl
 */

/*
 * Revision History:
 *
 * When      Who  What
 * 05/24/00  JJT  Created.
 * 09/20/00  DNA  Added SSL Ioctl Function Prototypes
 * 06/14/02  GG   Added AES  Function Prototypes
 *
 */

/*
 * All buffer lengths are supplied in bits.
 *
 */

#ifndef _UBSEC_LIB_PUB_H_
#define _UBSEC_LIB_PUB_H_

/* UBSEC_LIB Version  */

#define UBSEC_LIB_VERSION_MAJOR 0x1
#define UBSEC_LIB_VERSION_MINOR 0x1
#define UBSEC_LIB_VERSION_REV 	'b' /* Single alphanumeric character, start with blank, then a,b,c... */

#define BITSTOBYTES(bitsize) (ROUNDUP_TO_32_BIT(bitsize)/8)

#define SHA_BIT_SIZE  (160)

#ifdef CRYPTONET_DEVICE
#define UBSEC_SSL_DEVICE 	CRYPTONET_DEVICE 
#define UBSEC_KEY_DEVICE 	CRYPTONET_DEVICE
#define UBSEC_CRYPTO_DEVICE	CRYPTONET_DEVICE 
#else
#define UBSEC_SSL_DEVICE "/dev/cryptonet"
#define UBSEC_KEY_DEVICE "/dev/cryptonet"
#define UBSEC_CRYPTO_DEVICE "/dev/cryptonet"
#endif

/* The defines are copied from ubsio.h */
#ifndef MAX_CRYPT_KEY_LENGTH
#define MAX_CRYPT_KEY_LENGTH	24
#endif
#ifndef MAC_KEY_LENGTH
#define MAC_KEY_LENGTH		64
#endif
#ifndef AES_CRYPT_KEY_LENGTH
#define AES_CRYPT_KEY_LENGTH	32
#endif

/*
 * Raw I/O routines. Normally, only ubsec_open and ubsec_close would be called
 * by applications.
 */
int ubsec_open(char *device);
int ubsec_close(int fd);
int ubsec_ioctl(int ubsec_fd, unsigned char *buf, long cmd);

void ubsec_ioctl_time(unsigned long *time_us);

/*
 * General utility routines.
 */
int ubsec_bytes_to_bits(unsigned char *n, int bytes);
int ubsec_bits_to_bytes(int bits);


/* Symmetric encryption routines */
/* DES/3DES */


typedef struct ubsec_crypto_context_s {
	unsigned int	flags;
	unsigned char	crypto[MAX_CRYPT_KEY_LENGTH];
	unsigned char	auth[MAC_KEY_LENGTH];
} ubsec_crypto_context_t, *ubsec_crypto_context_p;

/*
 * Initialize crypto context.
 */
int ubsec_crypto_init(unsigned char *k1, unsigned char *k2, unsigned char *k3,
	unsigned char *auth_key, int encr_alg, int auth_alg, ubsec_crypto_context_p ctx);

int ubsec_crypto_done(ubsec_crypto_context_p ctx);

/*
 * Pass a buffer to encrypt/decrypt/authenticate.
 */
int ubsec_crypto_data_ioctl(int fd, int cmd, ubsec_crypto_context_p ctx, 
	unsigned char *data_in, unsigned char *iv, unsigned long in_len,
	unsigned short crypto_offset, unsigned char *data_out, unsigned long out_len,
	unsigned long *optime);

/* AES */

typedef struct ubsec_aes_context_s {
	unsigned int	flags;
	unsigned char	crypto[AES_CRYPT_KEY_LENGTH];
	unsigned char	auth[MAC_KEY_LENGTH];
} ubsec_aes_context_t, *ubsec_aes_context_p;

/*
 * Initialize AES context.
 */
int ubsec_aes_init(unsigned char *key, unsigned char *auth_key, 
	unsigned int encr_alg_flags, unsigned int auth_alg, ubsec_aes_context_p ctx);

int ubsec_aes_done(ubsec_aes_context_p ctx);


/*
 * Pass a buffer to AES encrypt/decrypt/authenticate. 
 */
int ubsec_aes_data_ioctl(int fd, unsigned int cmd, ubsec_aes_context_p ctx, 
	unsigned char *data_in, unsigned char *ivic, unsigned long in_len,
	unsigned short crypto_offset, unsigned char *data_out, unsigned long out_len,
	unsigned long *optime);

/*
 * Ubecom Routines
 */

/* SSL Routines */

int
ubsec_ssl_mac_ioctl(
		    int              fd,
		    unsigned char *  data_in,      /* data to authenticate */
		    unsigned int     data_in_len,  /* length of data to auth */
		    unsigned char *  auth_key,     /* secret key */
		    unsigned int     auth_key_len, /* length of secret key */
		    unsigned char *  seq_num,      /* sequence number */
		    unsigned char    type,         /* content type */
		    unsigned short   data_length,  /* data length */
		    unsigned int     auth_alg,     /* hash agthm: sha or md5 */
		    unsigned char *  data_out,     /* buffer for output data */
		    unsigned int     data_out_len  /* length of output buffer */
		    );

/* TLS Routines */

int
ubsec_tls_mac_ioctl(
		    int              fd,
		    unsigned char *  data_in,      /* data to authenticate */
		    unsigned int     data_in_len,  /* length of data to auth */
		    unsigned char *  auth_key,     /* MAC Secret Key */
		    unsigned int     auth_key_len, /* MAC Secret Key Length in Bytes */
		    unsigned char *  seq_num,      /* sequence number */
		    unsigned long    version,      /* TLS Version */
		    unsigned char    type,         /* TLS Content Type */
		    unsigned long    datalength,   /* data length */
		    unsigned int     auth_alg,     /* hash agthm: sha or md5 */
		    unsigned char *  data_out,     /* buffer for output data */
		    unsigned int     data_out_len  /* length of output buffer */
		    );

/* Hash Routines */
int
ubsec_hash_ioctl(
		 int fd,
		 unsigned char *data_in,          /* input data buffer */
		 unsigned int data_in_len,        /* length of input data buffer */
		 int auth_alg,                    /* sha or md5 hash alg */
		 unsigned char *data_out,         /* output data buffer */
		 unsigned int data_out_len        /* length of output data buffer */
		 );

/*********************************************************** Statistics */
typedef struct ubsec_stats_s {
  int BlocksEncryptedCount;
  int BlocksDecryptedCount;
  int BytesEncryptedCount;
  int BytesDecryptedCount;
  int CryptoFailedCount;
  int IKECount;
  int IKEFailedCount;
  int DHPublicCount;
  int DHSharedCount;
  int RSAPublicCount;
  int RSAPrivateCount;
  int DSASignCount;
  int DSAVerifyCount;
  int DMAErrorCount;
} ubsec_stats_t, *ubsec_stats_pt;
 
 
int
ubsec_stats_ioctl(int ubsec_fd,
                  int device_num,
                  ubsec_stats_pt stats);

#endif /* _UBSEC_LIB_PUB_H_ */




