/*
 * Serial bus (2-wire and 3-wire) protocol via GPIO bit banging.
 *
 * Copyright 2001-2004, Broadcom Corporation
 * All Rights Reserved.
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
*/
#ifndef _SER_BUS_H_
#define _SER_BUS_H_

struct gpio_bb_hwinfo {
	int device;
	int sclPinNum;
	int sdaPinNum;
	int sdoPinNum;
	int sdiPinNum;
	int scsPinNum;
};

/* ------------------------------------------------------------------------- */
/* Board (Hardware) Specific Stuff 											 */
/* ------------------------------------------------------------------------- */
/* Devices for which bit banging is supported. */
#define		GPIO_BB_2WIRE		1
#define		GPIO_BB_3WIRE		2

/* PIN Defines */

/* 2WIRE */
#define	GPIO_2WIRE_SCL		5	/* output */
#define	GPIO_2WIRE_SDA		2	/* output/input */
#define GPIO_2WIRE_OUTMASK	0x00000024	/* SDO set as output at start*/

/* Misc IO 3WIRE */
#define	GPIO_3WIRE_SCL		0	/* output */
#define	GPIO_3WIRE_CS1		1	/* output */
#define	GPIO_3WIRE_SDO		2	/* output NOTE: shared with 2WIRE SDA. */
#define	GPIO_3WIRE_SDI		3	/* input */
#define	GPIO_3WIRE_SINT		4	/* input */

#define GPIO_3WIRE_OUTMASK	0x00000007

#define GPIO_INVALID_PIN	0xFF

/* ------------------------------------------------------------------------- */
/* Hardware Specific Function Prototypes									 */
/* ------------------------------------------------------------------------- */
extern int set3WireInitState (struct gpio_bb_hwinfo *gpiohwInfo);
extern void clear3WireInitState (struct gpio_bb_hwinfo *gpiohwInfo, int sdaOrig);
extern void bcm_serbus_setsdadirin(void);
extern void bcm_serbus_setsdadirout(void);
extern int bcm_serbus_lock(struct gpio_bb_hwinfo *gpiohwInfo);
extern void bcm_serbus_unlock(struct gpio_bb_hwinfo *gpiohwInfo, int sdaOrig);
extern void bcm_serbus_setscl(void *data, int state);
extern void bcm_serbus_setsda(void *data, int state);
extern void bcm_serbus_setscs(void *data, int state);
extern void bcm_serbus_setsdo(void *data, int state);
extern int bcm_serbus_getscl(void *data);
extern int bcm_serbus_getsda(void *data);
extern int bcm_serbus_getsdi(void *data);
extern int bcm_serbus_init(struct gpio_bb_hwinfo *gpioHwInfo);
extern void bcm_serbus_exit(void);

#endif /* _SER_BUS_H_ */

