/*
 * Early initialization code for BCM94710 boards
 *
 * Copyright 2001-2004, Broadcom Corporation
 * All Rights Reserved.
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <asm/bootinfo.h>
#include <asm/addrspace.h>

void __init
prom_init(int argc, const char **argv)
{
	unsigned long mem;
	unsigned long aliasAddress = KSEG0ADDR((0x100000 - sizeof(aliasAddress)));

	mips_machgroup = MACH_GROUP_BRCM;
	mips_machtype = MACH_BCM947XX;

	while ((aliasAddress > (KSEG0ADDR(0))) && 
			(*(unsigned long *)aliasAddress == 0)) {
		aliasAddress -= sizeof(aliasAddress);
	}

	/* Figure out memory size by finding aliases */
	for (mem = (1 << 20); mem < (128 << 20); mem += (1 << 20)) {
		if (*(unsigned long *)((unsigned long)(aliasAddress) + mem) == 
		    *(unsigned long *)(aliasAddress))
			break;
	}
	add_memory_region(0, mem, BOOT_MEM_RAM);
}

void __init prom_free_prom_memory(void)
{
}
