/* $Id: linux_logo.h,v 1.1.1.1 2003/02/03 22:38:14 mhuang Exp $
 * include/asm-sparc/linux_logo.h: This is a linux logo
 *                                 to be displayed on boot.
 *
 * Copyright (C) 1996 Larry Ewing (lewing@isc.tamu.edu)
 * Copyright (C) 1998 Jakub Jelinek (jj@sunsite.mff.cuni.cz)
 *
 * You can put anything here, but:
 * LINUX_LOGO_COLORS has to be less than 224
 * image size has to be 80x80
 * values have to start from 0x20
 * (i.e. RGB(linux_logo_red[0],
 *	     linux_logo_green[0],
 *	     linux_logo_blue[0]) is color 0x20)
 * BW image has to be 80x80 as well, with MS bit
 * on the left
 * Serial_console ascii image can be any size,
 * but should contain %s to display the version
 */
 
#include <linux/init.h>
#include <linux/version.h>

#define linux_logo_banner "Linux/SPARC version " UTS_RELEASE

#define __HAVE_ARCH_LINUX_LOGO
#define __HAVE_ARCH_LINUX_LOGO16

#define LINUX_LOGO_COLORS	221

#ifdef INCLUDE_LINUX_LOGO_DATA

unsigned char linux_logo_red[] __initdata = {
    0x00, 0x06, 0x0a, 0x0e, 0x16, 0x1a, 0x1e, 0x22,
    0x12, 0x00, 0x2a, 0x36, 0x42, 0x4e, 0x4a, 0x56,
    0x26, 0x46, 0x2e, 0x32, 0x52, 0x3a, 0x02, 0x65,
    0x5e, 0x3e, 0x74, 0x8a, 0xa2, 0x9a, 0x86, 0xc6,
    0xc3, 0x65, 0xbb, 0xd2, 0xda, 0xd6, 0xe2, 0xf6,
    0xfd, 0xae, 0x7b, 0xdd, 0xea, 0x6a, 0xaa, 0xe7,
    0xbe, 0x5a, 0xee, 0x9e, 0x95, 0x80, 0x76, 0x79,
    0x62, 0x36, 0x9a, 0xe2, 0xec, 0xe1, 0xb8, 0xd7,
    0xaf, 0x25, 0xbc, 0xc0, 0xef, 0xea, 0xe8, 0xe8,
    0xf5, 0xf1, 0xda, 0xd3, 0x79, 0xdb, 0xf4, 0xf6,
    0xf6, 0xf6, 0xe2, 0x3d, 0xb4, 0xce, 0xe6, 0xee,
    0xf6, 0x68, 0xd8, 0xec, 0xf5, 0xc6, 0xc8, 0x9c,
    0x89, 0xd2, 0xee, 0xcb, 0xb9, 0xd2, 0x66, 0x5e,
    0x8b, 0xbe, 0xa8, 0xd5, 0xca, 0xb6, 0xae, 0x9c,
    0xc5, 0xbe, 0xbe, 0xca, 0x90, 0xb2, 0x9a, 0xa8,
    0xb6, 0xf2, 0xce, 0xfa, 0xb2, 0x6e, 0xa6, 0xfe,
    0xf6, 0xec, 0xfe, 0xd2, 0xea, 0xf5, 0xf2, 0xf2,
    0xe9, 0xee, 0xf6, 0xf2, 0xee, 0xf6, 0xda, 0xd4,
    0xfa, 0xca, 0xf2, 0xf6, 0xfe, 0xf2, 0xda, 0xe4,
    0xf6, 0xdd, 0xf2, 0xee, 0xfa, 0xf0, 0x12, 0x4a,
    0xd6, 0xf2, 0x8e, 0xf2, 0xf6, 0xf6, 0xb5, 0xf1,
    0x26, 0x9a, 0xea, 0xf6, 0xe0, 0xd2, 0x16, 0x9a,
    0x2e, 0xd2, 0x70, 0xd6, 0x46, 0x7c, 0xb4, 0x62,
    0xda, 0xee, 0xd6, 0xa3, 0x74, 0xa7, 0xa2, 0xe0,
    0xae, 0xbe, 0xce, 0xe2, 0xa3, 0x8e, 0x6d, 0x8e,
    0x32, 0xaf, 0x50, 0x9e, 0x5b, 0x8a, 0x98, 0x82,
    0x7a, 0x82, 0x56, 0x7c, 0x8a, 0x56, 0x5e, 0x86,
    0x6a, 0x52, 0x59, 0x64, 0x5e,
};

unsigned char linux_logo_green[] __initdata = {
    0x00, 0x06, 0x0a, 0x0e, 0x16, 0x1a, 0x1e, 0x22,
    0x12, 0x00, 0x2a, 0x36, 0x42, 0x4e, 0x4a, 0x56,
    0x26, 0x46, 0x2e, 0x32, 0x52, 0x3a, 0x02, 0x65,
    0x5e, 0x3e, 0x74, 0x8a, 0xa2, 0x9a, 0x86, 0xc6,
    0xc3, 0x62, 0xbb, 0xd2, 0xda, 0xd6, 0xe2, 0xf6,
    0xfd, 0xae, 0x7b, 0xdd, 0xea, 0x6a, 0xaa, 0xe7,
    0xbe, 0x5a, 0xee, 0x9e, 0x95, 0x80, 0x62, 0x5c,
    0x4e, 0x26, 0x72, 0xaa, 0xba, 0xaf, 0x90, 0xae,
    0x92, 0x1a, 0xa4, 0x85, 0xb6, 0xbe, 0xc3, 0xc8,
    0xcf, 0xd0, 0xc2, 0xce, 0x57, 0xa2, 0xd6, 0xda,
    0xda, 0xd7, 0xb8, 0x2a, 0x7b, 0x91, 0xae, 0xca,
    0xda, 0x45, 0x9e, 0xb2, 0xd7, 0x9b, 0x90, 0x76,
    0x5c, 0xa2, 0xbe, 0xa6, 0x85, 0x96, 0x4e, 0x46,
    0x66, 0x92, 0x7a, 0x9a, 0x96, 0x9d, 0x9a, 0x6b,
    0x8a, 0x8e, 0xb2, 0xca, 0x90, 0xa6, 0x79, 0x7c,
    0xb6, 0xf2, 0xce, 0xfa, 0xb2, 0x6e, 0xa6, 0xfa,
    0xea, 0xd7, 0xf6, 0xbc, 0xda, 0xde, 0xda, 0xe6,
    0xca, 0xd8, 0xea, 0xe0, 0xcc, 0xf2, 0xce, 0xb2,
    0xee, 0xa2, 0xd6, 0xe6, 0xf6, 0xd7, 0xc5, 0xb8,
    0xc6, 0xb9, 0xce, 0xde, 0xce, 0xc6, 0x0e, 0x36,
    0xae, 0xbe, 0x86, 0xba, 0xbe, 0xe6, 0x8e, 0xc4,
    0x1e, 0x8e, 0xae, 0xba, 0xb2, 0xa6, 0x12, 0x7a,
    0x20, 0xc6, 0x64, 0xaa, 0x2f, 0x70, 0x85, 0x46,
    0xce, 0xd6, 0xa6, 0x6e, 0x51, 0x72, 0x92, 0xa6,
    0x87, 0x96, 0xa2, 0xd6, 0x85, 0x7a, 0x6a, 0x6e,
    0x22, 0x76, 0x36, 0x76, 0x3c, 0x6e, 0x63, 0x53,
    0x66, 0x62, 0x42, 0x50, 0x56, 0x42, 0x56, 0x56,
    0x56, 0x3e, 0x51, 0x52, 0x56,
};

unsigned char linux_logo_blue[] __initdata = {
    0x00, 0x06, 0x0a, 0x0e, 0x16, 0x1a, 0x1e, 0x22,
    0x12, 0x01, 0x2a, 0x36, 0x42, 0x4e, 0x4a, 0x56,
    0x26, 0x46, 0x2e, 0x32, 0x52, 0x3a, 0x06, 0x65,
    0x5e, 0x3e, 0x74, 0x8a, 0xa2, 0x9a, 0x86, 0xc6,
    0xc3, 0x59, 0xbb, 0xd2, 0xda, 0xd6, 0xe2, 0xf6,
    0xfd, 0xae, 0x7b, 0xdd, 0xea, 0x6a, 0xaa, 0xe7,
    0xbe, 0x5a, 0xee, 0x9e, 0x95, 0x80, 0x2e, 0x08,
    0x0a, 0x06, 0x0a, 0x0b, 0x0b, 0x0f, 0x0c, 0x0f,
    0x3d, 0x09, 0x73, 0x09, 0x0d, 0x0a, 0x10, 0x1e,
    0x2d, 0x13, 0x86, 0xba, 0x19, 0x0a, 0x36, 0x3c,
    0x26, 0x14, 0x0d, 0x06, 0x07, 0x0a, 0x0b, 0x0f,
    0x4a, 0x06, 0x0a, 0x0c, 0x2b, 0x0a, 0x0b, 0x0a,
    0x06, 0x0a, 0x0a, 0x11, 0x0b, 0x0a, 0x0a, 0x1e,
    0x0f, 0x0d, 0x0a, 0x0b, 0x22, 0x6a, 0x72, 0x0b,
    0x0b, 0x22, 0x90, 0xca, 0x90, 0x92, 0x3c, 0x2c,
    0xb6, 0xf2, 0xce, 0xfa, 0xb2, 0x6e, 0xa6, 0xea,
    0xb6, 0x7c, 0xda, 0x8e, 0xa6, 0x87, 0x66, 0xb6,
    0x81, 0x6a, 0xc6, 0x9a, 0x5b, 0xd2, 0xb6, 0x6a,
    0xca, 0x45, 0x92, 0xb2, 0xca, 0x52, 0x8a, 0x3e,
    0x2e, 0x66, 0x66, 0xae, 0x3e, 0x47, 0x06, 0x0e,
    0x52, 0x36, 0x6a, 0x0e, 0x0e, 0xbe, 0x2c, 0x0e,
    0x0a, 0x5a, 0x0d, 0x0e, 0x3e, 0x0a, 0x06, 0x2e,
    0x06, 0x9e, 0x4e, 0x36, 0x06, 0x58, 0x24, 0x06,
    0x9e, 0xae, 0x3a, 0x08, 0x08, 0x07, 0x5e, 0x0a,
    0x32, 0x2e, 0x2a, 0xb2, 0x43, 0x48, 0x5f, 0x2e,
    0x06, 0x06, 0x07, 0x24, 0x06, 0x32, 0x06, 0x06,
    0x46, 0x2e, 0x22, 0x06, 0x06, 0x1e, 0x4c, 0x06,
    0x3a, 0x22, 0x42, 0x34, 0x42,
};

unsigned char linux_logo[] __initdata = {
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x22, 0x22,
    0x22, 0x21, 0x21, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x26, 0x26, 0x25, 0x28, 0x23, 0x22, 0x21, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x23, 0x25, 0x2a, 0x2b, 0x2c, 0x2d, 0x2d,
    0x2d, 0x2e, 0x2c, 0x2b, 0x2a, 0x25, 0x28, 0x22,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x24, 0x2a, 0x2c, 0x2f, 0x2c, 0x30, 0x30, 0x24,
    0x25, 0x27, 0x2b, 0x2c, 0x2f, 0x31, 0x32, 0x25,
    0x23, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x25,
    0x33, 0x34, 0x35, 0x21, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x21, 0x2b, 0x2f, 0x2c,
    0x30, 0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24, 0x33,
    0x2d, 0x27, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x31,
    0x2d, 0x32, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x21, 0x28, 0x2a, 0x34,
    0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x23, 0x32, 0x27, 0x21, 0x36,
    0x2a, 0x2d, 0x2a, 0x28, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x20, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x22, 0x26, 0x2c, 0x35,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x25, 0x2f, 0x37, 0x32, 0x22,
    0x36, 0x35, 0x31, 0x27, 0x22, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x23, 0x2a, 0x2f, 0x22,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x26, 0x38, 0x38, 0x35, 0x25,
    0x36, 0x21, 0x2d, 0x2b, 0x24, 0x21, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x21, 0x24, 0x39, 0x39, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x25, 0x2b, 0x30, 0x28, 0x22,
    0x36, 0x36, 0x27, 0x34, 0x30, 0x23, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x21, 0x26, 0x2d, 0x26, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x22, 0x22, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x2d, 0x33, 0x28, 0x21, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x22, 0x30, 0x2f, 0x23, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x2b, 0x2c, 0x25, 0x21, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x23, 0x2a, 0x34, 0x36, 0x36,
    0x36, 0x21, 0x22, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x21, 0x23, 0x22, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x28, 0x34, 0x27, 0x22, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x23, 0x32, 0x2f, 0x36, 0x36,
    0x21, 0x21, 0x24, 0x27, 0x21, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x28, 0x27, 0x22, 0x33, 0x24, 0x36,
    0x36, 0x36, 0x36, 0x22, 0x2f, 0x2a, 0x23, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x23, 0x32, 0x2f, 0x36, 0x36,
    0x30, 0x3a, 0x38, 0x24, 0x24, 0x36, 0x36, 0x36,
    0x23, 0x2f, 0x3b, 0x3c, 0x3d, 0x30, 0x25, 0x21,
    0x36, 0x36, 0x36, 0x36, 0x2f, 0x32, 0x23, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x23, 0x32, 0x2f, 0x36, 0x23,
    0x3e, 0x3f, 0x40, 0x3a, 0x22, 0x36, 0x36, 0x21,
    0x41, 0x42, 0x43, 0x44, 0x45, 0x3e, 0x23, 0x21,
    0x36, 0x36, 0x36, 0x36, 0x2f, 0x33, 0x28, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x29, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x23, 0x32, 0x2f, 0x36, 0x2b,
    0x44, 0x40, 0x46, 0x47, 0x35, 0x36, 0x36, 0x26,
    0x43, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x2e, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x31, 0x35, 0x24, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x23, 0x32, 0x34, 0x36, 0x4d,
    0x4e, 0x25, 0x2f, 0x46, 0x4a, 0x22, 0x23, 0x32,
    0x4f, 0x50, 0x21, 0x31, 0x51, 0x52, 0x53, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x31, 0x35, 0x24, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x29, 0x20, 0x29, 0x29, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x23, 0x2a, 0x2f, 0x21, 0x3a,
    0x4d, 0x21, 0x31, 0x54, 0x55, 0x28, 0x30, 0x2b,
    0x4b, 0x4d, 0x36, 0x23, 0x32, 0x50, 0x3f, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x2e, 0x39, 0x24, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x29, 0x20, 0x29, 0x20, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x23, 0x2a, 0x38, 0x23, 0x37,
    0x55, 0x36, 0x28, 0x3a, 0x56, 0x57, 0x57, 0x58,
    0x3c, 0x4d, 0x36, 0x36, 0x36, 0x40, 0x40, 0x21,
    0x36, 0x36, 0x36, 0x36, 0x2e, 0x39, 0x24, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x29, 0x29, 0x29, 0x20, 0x29, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x22, 0x30, 0x51, 0x23, 0x35,
    0x43, 0x25, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e,
    0x5f, 0x60, 0x61, 0x36, 0x31, 0x47, 0x3b, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x31, 0x2c, 0x25, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x22, 0x30, 0x2f, 0x23, 0x22,
    0x40, 0x62, 0x63, 0x5d, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x66, 0x5e, 0x6a, 0x6b, 0x2a, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x33, 0x2e, 0x26, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x22, 0x27, 0x2f, 0x23, 0x36,
    0x6c, 0x63, 0x6d, 0x64, 0x5c, 0x66, 0x69, 0x6e,
    0x6f, 0x70, 0x71, 0x69, 0x69, 0x72, 0x6c, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x33, 0x34, 0x27, 0x22,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x22, 0x27, 0x34, 0x26, 0x73,
    0x74, 0x75, 0x76, 0x64, 0x65, 0x77, 0x69, 0x78,
    0x70, 0x71, 0x71, 0x71, 0x72, 0x5f, 0x5e, 0x21,
    0x36, 0x36, 0x36, 0x36, 0x25, 0x38, 0x2a, 0x23,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x22, 0x26, 0x2d, 0x33, 0x79,
    0x63, 0x7a, 0x7b, 0x5c, 0x66, 0x69, 0x6e, 0x7c,
    0x71, 0x71, 0x69, 0x7d, 0x7e, 0x7a, 0x7f, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x21, 0x51, 0x2b, 0x28,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x22, 0x26, 0x2d, 0x32, 0x24,
    0x80, 0x81, 0x64, 0x82, 0x77, 0x69, 0x71, 0x71,
    0x69, 0x83, 0x84, 0x85, 0x7a, 0x85, 0x86, 0x36,
    0x21, 0x2b, 0x23, 0x36, 0x36, 0x39, 0x2e, 0x26,
    0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x22, 0x27, 0x2d, 0x33, 0x21,
    0x87, 0x88, 0x89, 0x72, 0x67, 0x66, 0x5f, 0x89,
    0x8a, 0x63, 0x85, 0x8b, 0x8c, 0x8d, 0x41, 0x36,
    0x36, 0x2d, 0x3a, 0x35, 0x36, 0x24, 0x51, 0x32,
    0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x22, 0x30, 0x2f, 0x33, 0x21,
    0x55, 0x8e, 0x8f, 0x8a, 0x7d, 0x5e, 0x90, 0x7e,
    0x75, 0x75, 0x90, 0x62, 0x40, 0x3f, 0x49, 0x23,
    0x36, 0x24, 0x3a, 0x3a, 0x24, 0x36, 0x2e, 0x31,
    0x26, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x21, 0x28, 0x33, 0x37, 0x25, 0x22,
    0x3b, 0x50, 0x8e, 0x8f, 0x90, 0x7e, 0x90, 0x63,
    0x74, 0x91, 0x92, 0x42, 0x93, 0x4b, 0x45, 0x2c,
    0x36, 0x36, 0x33, 0x39, 0x21, 0x36, 0x22, 0x51,
    0x33, 0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x22, 0x27, 0x2e, 0x2e, 0x36, 0x21,
    0x94, 0x3f, 0x50, 0x95, 0x96, 0x8f, 0x8f, 0x97,
    0x8e, 0x42, 0x50, 0x43, 0x47, 0x48, 0x48, 0x98,
    0x21, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x39,
    0x2e, 0x27, 0x23, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x22, 0x24, 0x2b, 0x38, 0x28, 0x36, 0x32,
    0x4c, 0x4b, 0x50, 0x50, 0x50, 0x42, 0x42, 0x50,
    0x50, 0x40, 0x45, 0x99, 0x48, 0x48, 0x48, 0x48,
    0x34, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x23,
    0x2f, 0x2b, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x28, 0x32, 0x51, 0x32, 0x28, 0x21, 0x98,
    0x48, 0x47, 0x9a, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x9a, 0x4f, 0x9b, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x93, 0x23, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x2a, 0x2f, 0x2a, 0x28, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x23, 0x30, 0x2e, 0x2c, 0x36, 0x21, 0x51, 0x9b,
    0x48, 0x48, 0x52, 0x3f, 0x50, 0x50, 0x40, 0x4b,
    0x47, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x48, 0x34, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x2d, 0x31, 0x27, 0x23, 0x21, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23,
    0x27, 0x2c, 0x2d, 0x21, 0x36, 0x28, 0x44, 0x48,
    0x48, 0x48, 0x48, 0x47, 0x46, 0x4f, 0x47, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x48, 0x9c, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x28, 0x51, 0x39, 0x26, 0x22, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x25,
    0x35, 0x51, 0x28, 0x36, 0x36, 0x9d, 0x48, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x9b, 0x48, 0x48, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x48, 0x4f, 0x28, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x28, 0x38, 0x2b, 0x25, 0x22, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24, 0x33,
    0x51, 0x25, 0x36, 0x36, 0x23, 0x40, 0x9b, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x9b, 0x99, 0x2b, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x30, 0x2f, 0x33, 0x24, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x21, 0x23, 0x30, 0x34,
    0x27, 0x36, 0x36, 0x36, 0x2a, 0x40, 0x47, 0x48,
    0x48, 0x48, 0x48, 0x9b, 0x99, 0x99, 0x9b, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x9b, 0x47, 0x52,
    0x46, 0x4f, 0x37, 0x21, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x30, 0x34, 0x2a, 0x23,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x22, 0x25, 0x39, 0x2c,
    0x36, 0x36, 0x36, 0x21, 0x31, 0x4e, 0x9a, 0x4c,
    0x47, 0x9b, 0x9b, 0x52, 0x46, 0x4f, 0x52, 0x9b,
    0x9b, 0x9b, 0x47, 0x4f, 0x45, 0x9a, 0x93, 0x93,
    0x3f, 0x93, 0x98, 0x28, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x39, 0x2c, 0x26,
    0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x23, 0x2a, 0x34, 0x28,
    0x36, 0x36, 0x36, 0x22, 0x38, 0x98, 0x44, 0x99,
    0x9b, 0x48, 0x48, 0x9b, 0x4c, 0x48, 0x48, 0x48,
    0x48, 0x48, 0x48, 0x47, 0x52, 0x46, 0x43, 0x93,
    0x40, 0x40, 0x43, 0x53, 0x21, 0x23, 0x33, 0x23,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x2f, 0x32,
    0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x21, 0x24, 0x2b, 0x31, 0x36,
    0x36, 0x22, 0x36, 0x24, 0x9e, 0x4f, 0x9b, 0x48,
    0x48, 0x48, 0x48, 0x9b, 0x99, 0x9f, 0x52, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x47,
    0x4f, 0x9a, 0x3f, 0x46, 0x38, 0x36, 0x21, 0x30,
    0x26, 0x36, 0x36, 0x36, 0x36, 0x36, 0x39, 0x2c,
    0x25, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x22, 0x26, 0x2e, 0x33, 0x36,
    0x25, 0x25, 0x36, 0x4d, 0x52, 0x48, 0x48, 0x48,
    0x47, 0x9f, 0x48, 0x48, 0x48, 0xa0, 0xa1, 0xa2,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x48, 0x47, 0x44, 0x93, 0x43, 0x23, 0x36, 0x36,
    0x26, 0x24, 0x36, 0x36, 0x36, 0x36, 0x28, 0x2f,
    0x2a, 0x23, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x23, 0x2a, 0x51, 0x24, 0x36,
    0x2a, 0x36, 0x28, 0x44, 0x48, 0x48, 0x48, 0x48,
    0xa3, 0xa4, 0x48, 0x48, 0x9f, 0xa5, 0xa6, 0x9f,
    0x48, 0x48, 0x48, 0xa2, 0xa7, 0x47, 0x48, 0x48,
    0x48, 0x48, 0x9b, 0x4b, 0x44, 0x37, 0x36, 0x23,
    0x28, 0x30, 0x22, 0x36, 0x36, 0x36, 0x36, 0x2d,
    0x35, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x21, 0x28, 0x2b, 0x34, 0x36, 0x25,
    0x24, 0x36, 0x4a, 0x48, 0x48, 0x48, 0x48, 0x48,
    0xa8, 0xa1, 0x48, 0x48, 0x9f, 0xa9, 0xa6, 0x9f,
    0x48, 0x48, 0xaa, 0xa1, 0xa5, 0x9f, 0x48, 0x48,
    0x48, 0x48, 0x48, 0x9b, 0x52, 0x3f, 0x21, 0x30,
    0x35, 0x25, 0x30, 0x36, 0x36, 0x36, 0x36, 0x32,
    0x2d, 0x26, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x22, 0x26, 0x2e, 0x35, 0x36, 0x2a,
    0x36, 0x24, 0x4f, 0x48, 0x52, 0x52, 0x48, 0x48,
    0xab, 0xac, 0xa0, 0x48, 0xad, 0xa6, 0xa6, 0x9f,
    0x48, 0xa2, 0xa9, 0xa6, 0xa2, 0x48, 0x48, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x47, 0x32, 0x30,
    0x2a, 0x23, 0x30, 0x23, 0x36, 0x36, 0x36, 0x21,
    0x2f, 0x32, 0x23, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x23, 0x2a, 0x51, 0x28, 0x28, 0x25,
    0x36, 0x3a, 0x48, 0x48, 0xae, 0xaf, 0x48, 0x48,
    0xad, 0xac, 0xa1, 0x9f, 0xa2, 0xa9, 0xa9, 0xa2,
    0x48, 0xab, 0x78, 0xa7, 0x48, 0x48, 0x48, 0x48,
    0x9f, 0x48, 0x48, 0x48, 0x48, 0x48, 0x38, 0x21,
    0x36, 0x36, 0x22, 0x27, 0x36, 0x36, 0x36, 0x36,
    0x2e, 0x35, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x22, 0x25, 0x2c, 0x34, 0x36, 0x30, 0x21,
    0x23, 0x43, 0x48, 0x48, 0xb0, 0xb1, 0xb2, 0x9f,
    0x48, 0xb3, 0xa5, 0xb3, 0xab, 0xa9, 0xa9, 0xb3,
    0xb4, 0xa9, 0xb5, 0xb0, 0x48, 0x48, 0xa0, 0xa5,
    0xa1, 0xad, 0x48, 0x48, 0x48, 0x48, 0x94, 0x36,
    0x36, 0x36, 0x36, 0x32, 0x36, 0x36, 0x36, 0x36,
    0x2a, 0x2e, 0x26, 0x22, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x23, 0x2a, 0x51, 0x25, 0x21, 0x2a, 0x36,
    0x2e, 0x9b, 0x48, 0x48, 0x48, 0xb6, 0xb7, 0xa4,
    0xa2, 0xa7, 0xb5, 0x78, 0x6f, 0x6f, 0x6e, 0x6f,
    0xa9, 0xb5, 0xab, 0x48, 0x9f, 0xab, 0xa9, 0xa1,
    0xaa, 0x48, 0x48, 0x48, 0x48, 0x48, 0x98, 0x36,
    0x36, 0x36, 0x36, 0x32, 0x36, 0x36, 0x36, 0x36,
    0x22, 0x2f, 0x30, 0x22, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x22, 0x25, 0x2c, 0x34, 0x36, 0x24, 0x28, 0x36,
    0x54, 0x48, 0x48, 0x48, 0x48, 0xa2, 0xa8, 0xa1,
    0xa5, 0xa6, 0x6e, 0x6e, 0x6f, 0x6f, 0x6f, 0x6f,
    0x6f, 0x78, 0xa5, 0xa0, 0xa0, 0x78, 0xa6, 0xa2,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x9a, 0x36,
    0x36, 0x36, 0x36, 0x30, 0x36, 0x36, 0x36, 0x36,
    0x21, 0x2f, 0x32, 0x23, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x28, 0x32, 0x2f, 0x28, 0x36, 0x27, 0x22, 0x21,
    0x43, 0x48, 0x4b, 0xa2, 0x9f, 0x48, 0xa2, 0xa1,
    0xb8, 0x6e, 0x6e, 0xb5, 0x78, 0x6f, 0x78, 0x78,
    0x6e, 0x6f, 0x78, 0xb5, 0xa6, 0xa1, 0xa0, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x4b, 0x21,
    0x36, 0x36, 0x21, 0x26, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x34, 0x2b, 0x28, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x25, 0x2c, 0x39, 0x36, 0x36, 0x30, 0x22, 0x25,
    0x52, 0x48, 0xa3, 0xb1, 0xb6, 0xb3, 0xaa, 0xac,
    0x68, 0x68, 0x6e, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f,
    0x78, 0x6f, 0x6f, 0xb5, 0xa6, 0xb4, 0x48, 0x9f,
    0xb4, 0xb4, 0xa2, 0x9f, 0x48, 0x48, 0x4f, 0x21,
    0x36, 0x36, 0x22, 0x26, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x2c, 0x35, 0x24, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x30, 0x2d, 0x21, 0x36, 0x36, 0x32, 0x23, 0x2a,
    0x47, 0x48, 0xa2, 0xb6, 0xaf, 0xb9, 0xba, 0x68,
    0x6e, 0x6e, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x78,
    0x6f, 0x6f, 0xa6, 0x6f, 0xb5, 0xa0, 0xaa, 0xa6,
    0xa6, 0xa9, 0xb2, 0xb3, 0x48, 0x48, 0x4c, 0x22,
    0x36, 0x36, 0x24, 0x23, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x2c, 0x39, 0x24, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x28,
    0x33, 0x2e, 0x36, 0x36, 0x23, 0x31, 0x27, 0x39,
    0x9b, 0x48, 0x48, 0x48, 0xb0, 0xb0, 0xba, 0xb8,
    0x68, 0x68, 0x69, 0x78, 0x6f, 0xb5, 0x6f, 0xb5,
    0x78, 0x78, 0x78, 0x78, 0x78, 0xa5, 0xbb, 0xa9,
    0xa5, 0x48, 0x48, 0x48, 0x48, 0x48, 0x4c, 0x23,
    0x36, 0x36, 0x26, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x2c, 0x39, 0x24, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x28,
    0x2b, 0x39, 0x36, 0x36, 0x36, 0x26, 0x32, 0x31,
    0x9b, 0x48, 0x48, 0x48, 0x48, 0x9f, 0xac, 0x68,
    0xbc, 0x6e, 0x6e, 0x6e, 0xb5, 0x6f, 0x6e, 0x6f,
    0x6f, 0x78, 0x78, 0xb5, 0xb5, 0xa5, 0x9f, 0x9f,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x46, 0x22,
    0x36, 0x21, 0x26, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x2c, 0x35, 0x24, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24,
    0x35, 0x39, 0x36, 0x36, 0x36, 0x36, 0x26, 0x2d,
    0x9b, 0x48, 0x48, 0xb0, 0xaa, 0xb3, 0xbd, 0xb8,
    0xb8, 0x68, 0x6e, 0x6e, 0xb5, 0x6f, 0x78, 0x6e,
    0x78, 0x6f, 0x78, 0x78, 0xb5, 0xa9, 0xa2, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x9a, 0x36,
    0x24, 0x27, 0xbe, 0x24, 0x25, 0x28, 0x21, 0x36,
    0x36, 0x34, 0x2b, 0x28, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x25,
    0x39, 0x4d, 0xbf, 0x84, 0x81, 0x57, 0x21, 0x39,
    0x52, 0x48, 0x48, 0x62, 0xb1, 0xc0, 0xc1, 0xc1,
    0xb8, 0xb8, 0x68, 0xbc, 0x6e, 0x6e, 0x6e, 0x78,
    0x78, 0x78, 0x78, 0x6e, 0x78, 0xa9, 0xa0, 0xab,
    0xb3, 0xa2, 0x48, 0x48, 0x48, 0x48, 0x53, 0x28,
    0x23, 0x36, 0x36, 0x36, 0x21, 0x28, 0x2c, 0x30,
    0x21, 0x38, 0x33, 0x28, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x21, 0x22, 0x22, 0x28, 0x30,
    0x2d, 0xc2, 0x7a, 0xc3, 0xc4, 0xc4, 0x7f, 0x22,
    0x51, 0x52, 0x48, 0x48, 0xb0, 0xaa, 0xa8, 0xbd,
    0x68, 0xb8, 0xb8, 0x68, 0x68, 0x6e, 0x6e, 0x6f,
    0x6e, 0x6e, 0xb5, 0x6e, 0x78, 0xab, 0xab, 0xb5,
    0x78, 0xa6, 0xb3, 0xc5, 0xac, 0xac, 0xc6, 0x61,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x30, 0x32,
    0x25, 0x4d, 0x2b, 0x28, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x23, 0x24, 0x26, 0x30, 0x33, 0x31,
    0x4d, 0x91, 0x5b, 0xc3, 0xc4, 0xc4, 0xc4, 0x5a,
    0x21, 0x2e, 0x46, 0x48, 0x48, 0x48, 0xb0, 0x64,
    0xc1, 0xb8, 0xb8, 0xb8, 0x68, 0x71, 0x6e, 0x6e,
    0x6f, 0x71, 0x6f, 0x6f, 0xa6, 0xa0, 0x9f, 0xb4,
    0xb4, 0xa0, 0xa1, 0xb7, 0xc7, 0x69, 0x66, 0xc8,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x26, 0x25,
    0x83, 0xc9, 0x2c, 0x25, 0x21, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x28, 0x30, 0x35, 0x2d, 0x2f, 0x37, 0x4a,
    0x60, 0x85, 0xca, 0xcb, 0xc4, 0xc4, 0xc4, 0x82,
    0x86, 0x36, 0x32, 0x3f, 0xa2, 0xa4, 0xa8, 0xa9,
    0xb8, 0xb8, 0xb8, 0xb8, 0x68, 0x6e, 0x6e, 0x6e,
    0x6e, 0x71, 0x6f, 0x71, 0xa6, 0xb4, 0x9f, 0x9f,
    0x48, 0x48, 0x48, 0xcc, 0xc3, 0xc7, 0xcd, 0xce,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x57,
    0x77, 0x66, 0x34, 0x27, 0x22, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x23, 0x30, 0x31, 0xcf, 0x91, 0x7e, 0x90, 0x90,
    0x8b, 0x5b, 0xc3, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0x5d, 0xd0, 0x36, 0x24, 0xd1, 0xb1, 0xaf, 0xaa,
    0xba, 0xb8, 0x68, 0x68, 0x68, 0x71, 0x6e, 0x6e,
    0x6e, 0x6f, 0x6e, 0x78, 0xa1, 0xa9, 0xa1, 0xb0,
    0x9f, 0x9b, 0x99, 0xcc, 0x64, 0x5c, 0x8b, 0xd0,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x73, 0x5d,
    0x82, 0x5c, 0xd2, 0x2a, 0x23, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x24, 0x2b, 0xcf, 0x8b, 0x5b, 0x76, 0x5b, 0x5b,
    0x7b, 0xc3, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc7, 0x5e, 0x22, 0x36, 0x21, 0x3a, 0x99, 0x48,
    0xa2, 0xa8, 0xb7, 0xc1, 0xb8, 0x68, 0x68, 0xbc,
    0x68, 0x6e, 0xb5, 0xb4, 0xb4, 0xab, 0xb5, 0xa1,
    0xb0, 0x4f, 0x3f, 0xd3, 0x7b, 0x7b, 0x85, 0x80,
    0xbe, 0x36, 0x36, 0x36, 0x21, 0xd4, 0x7e, 0x7b,
    0x64, 0x64, 0xd5, 0x35, 0x24, 0x21, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x26, 0x31, 0xd6, 0x5b, 0x64, 0xc3, 0xc3, 0xcb,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0x66, 0xd7, 0x36, 0x36, 0x36, 0x2c, 0x4b,
    0xd8, 0xd9, 0xb3, 0xa8, 0xbd, 0xbd, 0xbd, 0xbd,
    0xa9, 0xab, 0xb3, 0xa5, 0xa2, 0x9f, 0xa2, 0xa1,
    0x6a, 0x9a, 0x3f, 0xda, 0x76, 0x76, 0x7a, 0x63,
    0xdb, 0xdc, 0x86, 0xdc, 0xdd, 0x90, 0x5b, 0x64,
    0xc3, 0xc3, 0xde, 0x2d, 0x27, 0x23, 0x21, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x26, 0x2d, 0x91, 0x5b, 0x64, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc7, 0x83, 0xce, 0x36, 0x36, 0x36, 0x30,
    0xb1, 0xd9, 0x48, 0xa1, 0xb2, 0xb0, 0xb0, 0xb3,
    0xa2, 0x48, 0xa7, 0xbd, 0xa9, 0xa2, 0x48, 0x9f,
    0xaa, 0x9a, 0x3f, 0xb1, 0x5b, 0x7b, 0xdf, 0x85,
    0x7e, 0x90, 0x63, 0x90, 0x85, 0x5b, 0xc3, 0xc4,
    0xc4, 0xcb, 0x5d, 0xd5, 0x39, 0x26, 0x23, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x26, 0x2d, 0xe0, 0xdf, 0x64, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc7, 0x88, 0x36, 0x36, 0x36, 0x36,
    0x2d, 0x9b, 0x48, 0xb9, 0xaf, 0xa2, 0xa2, 0xb9,
    0xa8, 0x9f, 0x48, 0xa7, 0xb7, 0xd9, 0x48, 0x48,
    0x9b, 0x45, 0x3f, 0xe1, 0x6d, 0x7b, 0xca, 0xdf,
    0x7a, 0x8b, 0x8b, 0x7a, 0x5b, 0x64, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc3, 0xe2, 0x37, 0x35, 0x26, 0x23,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x26, 0x2e, 0xe0, 0x7a, 0x7b, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc7, 0x72, 0x73, 0x36, 0x36, 0x36,
    0x24, 0x52, 0x48, 0xa3, 0xaf, 0x9f, 0x48, 0xb6,
    0xaf, 0xa2, 0x48, 0x9f, 0xe3, 0xd8, 0x48, 0x48,
    0x48, 0x46, 0x42, 0xd6, 0x7a, 0x7b, 0x64, 0x7b,
    0x76, 0x5b, 0x5b, 0x76, 0x7b, 0xc3, 0xc4, 0xc4,
    0xc4, 0xc4, 0xcb, 0x64, 0xe2, 0x4d, 0x2c, 0x27,
    0x23, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x25, 0x31, 0xe4, 0x8b, 0x7b, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc7, 0x89, 0xbe, 0x36, 0x36,
    0x32, 0x47, 0x48, 0x4f, 0xa0, 0x48, 0x48, 0xe3,
    0x92, 0x9f, 0x48, 0x9f, 0x48, 0x48, 0x48, 0x48,
    0x48, 0x4b, 0x2f, 0x8f, 0x7a, 0x7b, 0xc3, 0xcb,
    0xc3, 0x64, 0x64, 0xc3, 0xc3, 0xcb, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc3, 0x5d, 0xe5, 0x2c,
    0x26, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x25, 0x31, 0xe4, 0x85, 0x7b, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0x66, 0x57, 0x27, 0x4d,
    0x4b, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x99, 0x34, 0xbe, 0xdb, 0x7a, 0x7b, 0xc3, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc3, 0xe4,
    0x32, 0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
    0x26, 0x2d, 0xe4, 0x85, 0x7b, 0xcb, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc7, 0x5f, 0x92, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x44,
    0x35, 0x36, 0xce, 0xdd, 0x7a, 0x7b, 0xcb, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xcb, 0xc3, 0xe1,
    0x2b, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23,
    0x30, 0x2f, 0xd6, 0x8b, 0x7b, 0xcb, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0x66, 0x89, 0x45,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x48, 0x9b, 0x4e, 0x25,
    0x36, 0x36, 0x61, 0xdb, 0x6d, 0x64, 0xcb, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xcb, 0x7b, 0xdf, 0xe5,
    0x32, 0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x28,
    0x33, 0xe6, 0x63, 0xdf, 0xc3, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc3, 0x72, 0x81, 0xe7,
    0x46, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48,
    0x48, 0x48, 0x48, 0x48, 0x3f, 0x2c, 0x36, 0x36,
    0x36, 0x36, 0xe8, 0x8f, 0x6d, 0x64, 0xcb, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc3, 0xca, 0x8b, 0xcf, 0x2c,
    0x26, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24,
    0x35, 0x96, 0x75, 0xca, 0xc3, 0xcb, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xcb, 0x7b, 0x81, 0xdb,
    0x73, 0x3b, 0x44, 0x9b, 0x48, 0x48, 0x48, 0x9b,
    0x99, 0x43, 0x94, 0x2c, 0x21, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x73, 0xdb, 0x7a, 0x7b, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0x64, 0x76, 0x7a, 0x91, 0xd5, 0x31, 0x30,
    0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24,
    0x39, 0x97, 0x75, 0xdf, 0x7b, 0x64, 0xc3, 0xc3,
    0xcb, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0x7b, 0x7a, 0xe9,
    0xea, 0x36, 0x21, 0x26, 0x2b, 0x39, 0x33, 0x30,
    0x23, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x21, 0xea, 0xdd, 0x8b, 0x7b, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc3, 0x64, 0x64,
    0x76, 0x85, 0xe0, 0xd5, 0x34, 0x2b, 0x27, 0x28,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x28,
    0x33, 0xeb, 0x63, 0x7e, 0x7a, 0x6d, 0xdf, 0x5b,
    0x76, 0x7b, 0x64, 0x64, 0xc3, 0xcb, 0xc4, 0xc4,
    0xc4, 0xc4, 0xc4, 0xc4, 0xcb, 0x76, 0x85, 0xdb,
    0x79, 0x22, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x21, 0xec, 0xdd, 0x75, 0x76, 0xc3, 0xc4,
    0xc4, 0xc4, 0xcb, 0xc3, 0x64, 0x76, 0xdf, 0x8b,
    0xd6, 0xd5, 0x2f, 0x35, 0x30, 0x24, 0x22, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23,
    0x27, 0x31, 0xed, 0xeb, 0xdd, 0x74, 0x63, 0x90,
    0x7e, 0x75, 0x8b, 0x6d, 0xdf, 0x76, 0x64, 0xc3,
    0xcb, 0xcb, 0xcb, 0xcb, 0x64, 0x7a, 0x84, 0xee,
    0x79, 0xbe, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x21, 0xea, 0xee, 0x63, 0x6d, 0x7b, 0x64,
    0xcb, 0xc3, 0x64, 0x7b, 0xdf, 0x75, 0x63, 0x96,
    0x38, 0x39, 0x2a, 0x24, 0x23, 0x21, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x28, 0x27, 0x35, 0x2d, 0x41, 0xd5, 0xe7, 0x8f,
    0xdb, 0xdd, 0xe9, 0x74, 0x84, 0x90, 0x85, 0x6d,
    0x5b, 0x7b, 0x7b, 0xca, 0x6d, 0x90, 0xdb, 0xef,
    0xec, 0x22, 0x36, 0x36, 0x28, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x25, 0x36,
    0x36, 0x21, 0xd4, 0x80, 0xe9, 0x7e, 0x6d, 0x76,
    0xca, 0x76, 0x6d, 0x85, 0x63, 0xdb, 0xd5, 0x34,
    0x33, 0x26, 0x23, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x23, 0x24, 0x27, 0x2a, 0x35, 0x2e, 0x2f,
    0x41, 0xf0, 0xf1, 0x6c, 0x80, 0xee, 0xdb, 0x74,
    0x84, 0x90, 0x75, 0x7e, 0x74, 0x8f, 0xef, 0x79,
    0xe8, 0x2b, 0x9d, 0x41, 0x2f, 0x34, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x34, 0x2f, 0x38,
    0x4d, 0x37, 0xf2, 0xf3, 0x8f, 0x74, 0x63, 0x7e,
    0x75, 0x7e, 0x63, 0xe9, 0x88, 0xe6, 0x31, 0x2a,
    0x24, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x21, 0x22, 0x23, 0x24, 0x26, 0x30,
    0x33, 0x39, 0x2e, 0x51, 0x41, 0xd2, 0x6c, 0xf3,
    0x80, 0xee, 0xee, 0xee, 0xf4, 0xf3, 0xd7, 0xf5,
    0x41, 0x34, 0x35, 0x32, 0x30, 0x27, 0x27, 0x27,
    0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x30, 0x2a,
    0x2b, 0x34, 0xf6, 0xec, 0xf7, 0x8f, 0xdd, 0xe9,
    0xe9, 0xdd, 0xee, 0x6c, 0x41, 0x39, 0x27, 0x28,
    0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x22,
    0x28, 0x24, 0x26, 0x2a, 0x33, 0x2c, 0x2f, 0x41,
    0xf8, 0xd7, 0x79, 0x79, 0x79, 0xec, 0xf9, 0x51,
    0x39, 0x30, 0x24, 0x23, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x22, 0x23,
    0x24, 0x2a, 0x31, 0xfa, 0xea, 0x79, 0xf3, 0x80,
    0xf7, 0xdc, 0xfb, 0x2f, 0x35, 0x26, 0x23, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x22, 0x23, 0x28, 0x25, 0x30, 0x2b,
    0x31, 0x2f, 0xf6, 0xfa, 0xfa, 0x2f, 0x2e, 0x33,
    0x26, 0x23, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x21, 0x28, 0x27, 0x35, 0x34, 0xfa, 0xfa, 0xfa,
    0xfc, 0xf6, 0x2e, 0x33, 0x25, 0x23, 0x21, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x23, 0x28,
    0x26, 0x30, 0x32, 0x2b, 0x33, 0x2a, 0x26, 0x28,
    0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x21, 0x23, 0x25, 0x30, 0x33, 0x35, 0x35,
    0x2b, 0x2a, 0x26, 0x28, 0x22, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
    0x21, 0x22, 0x23, 0x28, 0x28, 0x23, 0x22, 0x21,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x21, 0x23, 0x28, 0x24, 0x24,
    0x28, 0x23, 0x22, 0x21, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
};

unsigned char linux_logo16[1];

#endif /* INCLUDE_LINUX_LOGO_DATA */

#include <linux/linux_logo.h>

