/*
 * This is the interface to the BroadNAS configuration state database.
 *
 * Copyright 2003, Broadcom Corporation
 * All Rights Reserved.
 *
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Broadcom Corporation;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of Broadcom Corporation.
 */

#ifndef CONFIGURATION_STATE__EXTERNAL_H
#define CONFIGURATION_STATE_EXTERNAL_H

/*
 *  This file contains the interface to the BroadNAS configuration state
 *  database.  For state associated with a particular share, the state is saved
 *  on the same disk as the share itself, and for everything else the state is
 *  saved in non-volatile RAM.
 */

#include <typedefs.h>


typedef enum config_variable_type
  {
    CVT_BOOLEAN,
    CVT_ENUM,
    CVT_STRING,
    CVT_STRING_LIST
  } config_variable_type;

typedef struct config_variable_info
  {
    const char *variable_name;
    const char *user_visible_name;
    config_variable_type type;
    bool use_default_allowed;
    const char **enum_values;
    const char **user_enum_values;
    const char *default_value;
    const char *help_text;
    bool has_dependence;
    const char *dependent_on_variable_name;
    const char *dependence_activation_value;
  } config_variable_info;



extern const config_variable_info *lookup_config_variable_info(
        const char *name, bool *is_top_level);
extern void register_top_level_config_variable_info(const char *variable_name,
		const char *user_visible_name, config_variable_type type,
		bool use_default_allowed, const char **enum_values,
		const char **user_enum_values, const char *default_value,
		const char *help_text, bool has_dependence,
		const char *dependent_on_variable_name,
		const char *dependence_activation_value);


#endif /* CONFIGURATION_STATE_EXTERNAL_H */
