/*
 * This is the interface to the nvram registering shared library, which allows shared
 * libraries to register nvram variable values to the BroadNAS web server.
 *
 * Copyright 2003-2004, Broadcom Corporation
 * All Rights Reserved.
 *
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Broadcom Corporation;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of Broadcom Corporation.
 */

#ifndef NETVARPLUGIN_H
#define NETVARPLUGIN_H

#include "typedefs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <net/if.h>
#include <sys/types.h>

typedef struct netconfig_info_t netconfig_info_t;


struct netconfig_info_t
{
	int sockfd;
	struct ifreq ifr;
	pid_t pid;
};

typedef void (*netvar_handle)(void *);


/*
 *  The register_net_mode() function is used to register a value for a nvram variable.
 *  This function should be used only at initialization time, when a
 *  library is loaded, to register all the nvram values.  Once the server is
 *  initialized, this function would normally not be used again.
 *
 *  The enumerate_netmode_value() function is used to list all the registered values for 
 *  a nvram variable. The enumerate_netmode_text() function is used to list all the registered 
 *  user visible text for those values registered. NOTE: These two functions dynamically allocate memory
 *  inside and so the return pointer has to be freed after it has been used.
 *  The lookup_start_function() returns the function handle that needs to be invoked at startup for the current
 *  value of the nvram variable. Similarly lookup_stop_function() returns the function handle that
 *  needs to be invoked at shutdown for the current value of the nvram variable.
 */
extern void register_net_mode(const char *nvram_name,const char *nvram_value,const char *user_text, netvar_handle start_function,netvar_handle stop_function);
extern char **  enumerate_netmode_value(const char *nvram_name);
extern char **  enumerate_netmode_text(const char *nvram_name);
extern netvar_handle lookup_start_function(const char *nvram_name);
extern netvar_handle lookup_stop_function(const char *nvram_name);


#endif /* NETVARPLUGIN_H */
