/* 
   check lanman password

   This program is written to cooperate with the Unix SMB/CIFS implementation.

   Copyright (C) Broadcom Corporation              2005

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define _XOPEN_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
 
#define uchar unsigned char

 
/*
 */

int
main(int argc, char **argv)
{
	const char * lanman_password;
	const char * plaintext_password;
	char old_lanman_password[36];
	char new_lanman_password[36]; /*need 32 bytes*/
	int i;
	int result = 0;

	uchar new_lanman_p16[16];
	uchar junk[16];

 
	/* 
		Validate input. 
	 */	
	if (argc != 3)
	{
		fprintf(stderr, "Usage: %s\t<lanman_password> <plaintext_password>\n", argv[0]);
		exit( 3 );
	}
	lanman_password = argv[1];
	plaintext_password = argv[2];
	if (strspn(lanman_password, "0123456789ABCDEFabcdef") != 32)
	{
		fprintf(stderr, "ERROR: Lanman password parameter is invalid.\n");
		exit( 2 );
	}

 
	/*
		Convert old lanman password to upper case.
	 */
	for (i=0; i<32; i++)
	{
		old_lanman_password[i] = toupper(lanman_password[i]);
	}
	old_lanman_password[32] = '\0';

 
	/*
		Find hash for plaintext password and convert to string.
	 */
	nt_lm_owf_gen(plaintext_password, junk, new_lanman_p16);
 	for (i=0; i<16; i++)
	{
		sprintf(&new_lanman_password[i*2], "%02X", new_lanman_p16[i]);
	}
	new_lanman_password[32] = '\0';


	/*
		Check for equality.
	 */
 	if (strcmp(old_lanman_password, new_lanman_password) != 0)
		result = 1;
	return result;
}


