/* 
   check password in TDB file

   This program is written to cooperate with the Unix SMB/CIFS implementation.

   Copyright (C) Broadcom Corporation              2005

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <ctype.h>
#include <signal.h>
#include <tdb/tdb.h>
#include "includes.h"

void
setup()
{
	pstring configfile;
	pstrcpy(configfile, dyn_CONFIGFILE);

	if (!lp_load(configfile,True,False,False)) {
		fprintf(stderr, "Can't load %s - run testparm to debug it\n", 
			dyn_CONFIGFILE);
		exit(2);
	}

	setup_logging("tdb_check_password", True);
}


/*
	This function returns error codes in the 200's.
 */
int
authenticate(const char * username, const char * password)
{
	int result;
	struct pdb_context *context;
	const char * selected[2] = {"tdbsam", NULL};
	SAM_ACCOUNT * user_account = NULL;
	const uint8 * lanman_password;
	int i;
	char lanman_password_text[LM_HASH_LEN * 2 + 4];
	pstring cmd;


	/*
		Use Samba routines to LANMAN password hash from TDB file.
	 */
	if (!NT_STATUS_IS_OK(make_pdb_context_list(&context, selected))) 
	{
		fprintf(stderr, "ERROR: Cannot initialize tdbsam passdb backend.\n");
		result = 201;
		goto cleanup;
	}


	if (!NT_STATUS_IS_OK(pdb_init_sam(&user_account))) /* allocates user_account */
	{
		fprintf(stderr, "ERROR: Cannot initialize account data structure.\n");
		result = 202;
		goto cleanup;
	}


	if (!pdb_getsampwnam(user_account, username))
	{
		fprintf(stderr, "ERROR: Cannot get password database entry for %s.\n", username);
		result = 203;
		goto cleanup;
	}


	lanman_password = pdb_get_lanman_passwd(user_account);
	if (lanman_password == NULL)
	{
		fprintf(stderr, "ERROR: Cannot get lanman password for %s.\n", username);
		result = 204;
		goto cleanup;
	}


	/*
		Convert lanman password hash to string.
	 */
	for (i=0; i<sizeof(lanman_password_text); i++)
		lanman_password_text[i] = '\0';
	for (i=0; i<16; i++)
	{
		switch (lanman_password[i]&0xf0)
		{
		case 0x00: lanman_password_text[i*2] = '0'; break;
		case 0x10: lanman_password_text[i*2] = '1'; break;
		case 0x20: lanman_password_text[i*2] = '2'; break;
		case 0x30: lanman_password_text[i*2] = '3'; break;
		case 0x40: lanman_password_text[i*2] = '4'; break;
		case 0x50: lanman_password_text[i*2] = '5'; break;
		case 0x60: lanman_password_text[i*2] = '6'; break;
		case 0x70: lanman_password_text[i*2] = '7'; break;
		case 0x80: lanman_password_text[i*2] = '8'; break;
		case 0x90: lanman_password_text[i*2] = '9'; break;
		case 0xa0: lanman_password_text[i*2] = 'A'; break;
		case 0xb0: lanman_password_text[i*2] = 'B'; break;
		case 0xc0: lanman_password_text[i*2] = 'C'; break;
		case 0xd0: lanman_password_text[i*2] = 'D'; break;
		case 0xe0: lanman_password_text[i*2] = 'E'; break;
		case 0xf0: lanman_password_text[i*2] = 'F'; break;
		}

		switch (lanman_password[i]&0x0f)
		{
		case 0x00: lanman_password_text[i*2+1] = '0'; break;
		case 0x01: lanman_password_text[i*2+1] = '1'; break;
		case 0x02: lanman_password_text[i*2+1] = '2'; break;
		case 0x03: lanman_password_text[i*2+1] = '3'; break;
		case 0x04: lanman_password_text[i*2+1] = '4'; break;
		case 0x05: lanman_password_text[i*2+1] = '5'; break;
		case 0x06: lanman_password_text[i*2+1] = '6'; break;
		case 0x07: lanman_password_text[i*2+1] = '7'; break;
		case 0x08: lanman_password_text[i*2+1] = '8'; break;
		case 0x09: lanman_password_text[i*2+1] = '9'; break;
		case 0x0a: lanman_password_text[i*2+1] = 'A'; break;
		case 0x0b: lanman_password_text[i*2+1] = 'B'; break;
		case 0x0c: lanman_password_text[i*2+1] = 'C'; break;
		case 0x0d: lanman_password_text[i*2+1] = 'D'; break;
		case 0x0e: lanman_password_text[i*2+1] = 'E'; break;
		case 0x0f: lanman_password_text[i*2+1] = 'F'; break;
		}
	}

	pstrcpy(cmd, "/usr/local/samba/bin/check_lanman_password ");
	pstrcat(cmd, lanman_password_text);
	pstrcat(cmd, " ");
	pstrcat(cmd, password);
	
	result = smbrun(cmd, NULL);
	if (result != 0)
		goto cleanup;


cleanup:
	pdb_free_sam(&user_account);
	
	return result;
}


/*
	This function returns error codes in the 100's.
 */
int main(int argc, char *argv[])
{
	int result;
	char * username;
	char * password;


	if (argc != 3) {
		printf("Usage: %s <user name> <password>\n", argv[0]);
		exit(101);
	}

	username = argv[1];
	password = argv[2];


	if (strcmp(password, ":") == 0)
		password[0] = '\0';


	setup();


	/*
		Authenticate the user.
	 */
	result = authenticate(username, password);

	return result;
}

