/*
 * smartd.h
 *
 * Copyright (C) 2000 Michael Cornwell <cornwell@acm.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * You should have received a copy of the GNU General Public License
 * (for example COPYING); if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* smartctl version number */
#define VERSION_MAJOR 2
#define VERSION_MINOR 1

/* Defines for command line options */ 
#define DEBUGMODE 		'X'
#define EMAILNOTIFICATION	'e'

/* Boolean Values */
#define TRUE 0x01
#define FALSE 0x00

#define MAXATADEVICES	12
#define MAXSCSIDEVICES	26

/* Global Variables for command line options */
unsigned char debugmode               = FALSE;
unsigned char emailnotification       = FALSE;

/* Number of ata device to scan */
int numatadevices;
int numscsidevices;


/* how often SMART is checks in seconds */
int checktime = 1800;

typedef struct atadevices_s {
	int fd;
	char devicename[80];
	int selftest;
	struct hd_driveid drive;
	struct ata_smart_values smartval;
	struct ata_smart_thresholds smartthres;
}  atadevices_t;

typedef struct scsidevices_s {
	int fd;
	char devicename[80];
	unsigned char SmartPageSupported;
	unsigned char TempPageSupported;
	unsigned char Temperature;
} scsidevices_t;
