/*
 * Broadcom board-specific manifest constants.
 *
 * Copyright 2001-2004, Broadcom Corporation
 * All Rights Reserved.
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 */


#ifndef _bcmboard_h_
#define _bcmboard_h_

#ifndef _LANGUAGE_ASSEMBLY
#endif /* _LANGUAGE_ASSEMBLY */

/* Flash */
#define	BCM_BOOTROM_BASE_PHYS		0x1fc00000
#define	BCM_BOOTROM_BASE			0xbfc00000
#define	BCM_BOOTROM_MAX_SIZE		0x400000

#define	BCM_FLASH_BASE_PHYS			0x1c000000
#define	BCM_FLASH_BASE				0xbc000000
#define	BCM_FLASH_MAX_SIZE			0x02000000		/* Maximum flash size with chipc - 32M */

#define	BCM_FLASH_MIN_SIZE			(512 * 1024)	/* Minimum flash required is 512K */

#define BCM_BOOTLOADER_SIZE			(256 * 1024)	/* Space allocated for boot loader */


/* GPIO */
#define BCM_MAX_GPIO	8

/* Rootfs in RAM */
#define BCM_RAM_ROOTFS_SIZE			8	/* 8 MB */ /* Default amount of RAM reserved for rootfs */
#define BCM_RAM_MFG_ROOTFS_SIZE		4	/* 4 MB */ /* Default amount of RAM reserved for mfgtests rootfs */
#define BCM_RAM_ROOTFS_DEV		"/dev/mtdblock5"
#define BCM_RAM_ROOTFS_DEVSTR	"ram_rootfs"

#endif /* _bcmboard_h_ */
