/*
 * This is the internal header file for the misc_io module.
 *
 * Copyright 2001-2004, Broadcom Corporation
 * All Rights Reserved.
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 */


#ifndef MISC_IO_INTERNAL_H
#define MISC_IO_INTERNAL_H

#include <typedefs.h>


#define	MIO_MAX_DRIVES	4

#define MIO_IOCTL_TOGGLE	1
#define MIO_IOCTL_IO_REG_RD	2
#define MIO_IOCTL_IO_REG_WR	3


#define MIO_OUT_MASK	0x0003FFFF
#define MIO_IN_MASK		0x000000FF
				


				/* INPUTS */


/* Raw misc input (bits) */
typedef enum mio_in_enum
{
	MIO_SOFT_PWR,
	MIO_AUTH_BUTTON,
	MIO_TMP_ALARM,
	MIO_SEC_SEJT_REQ,
	MIO_PRI_SEJT_REQ,
	MIO_SEC_MEJT_REQ,
	MIO_TMP_WARN,
	MIO_PRI_MEJT_REQ,
	MIO_MAX_INS
} mio_inb_t;


				/* OUTPUTS */


/* Raw misc output (bits) */
typedef enum mio_out_enum
{
	MIO_SYSTEM_RDY_LED,
	MIO_PRI_RST,
	MIO_POWER_ON,
	MIO_SEC_RST,
	MIO_TP_15,
	MIO_TWIN_COPY_LED,
	MIO_UNUSED_0,
	MIO_UNUSED_1,
	MIO_SEC_MSTS_LED,
	MIO_SEC_MRMV_LED,
	MIO_SEC_SSTS_LED,
	MIO_SEC_SRMV_LED,
	MIO_TPH2,
	MIO_TPH1,
	MIO_PRI_SSTS_LED,
	MIO_PRI_SRMV_LED,
	MIO_PRI_MSTS_LED,
	MIO_PRI_MRMV_LED,
	MIO_MAX_OUTS
} mio_outb_t;


				/* COMMON */

/* Drive numbers used in API */
#define	MIO_PRI_MASTER_DRV	0
#define	MIO_SEC_MASTER_DRV	1
#define	MIO_PRI_SLAVE_DRV	2
#define	MIO_SEC_SLAVE_DRV	3


/* Misc input bits */
#define MIO_SOFT_PWR_BIT		(1 << MIO_SOFT_PWR)
#define MIO_AUTH_BUTTON_BIT		(1 << MIO_AUTH_BUTTON)
#define MIO_TMP_ALARM_BIT		(1 << MIO_TMP_ALARM)
#define MIO_TMP_WARN_BIT		(1 << MIO_TMP_WARN)
#define MIO_SEC_SEJT_REQ_BIT	(1 << MIO_SEC_SEJT_REQ)
#define MIO_SEC_MEJT_REQ_BIT	(1 << MIO_SEC_MEJT_REQ)
#define MIO_PRI_SEJT_REQ_BIT	(1 << MIO_PRI_SEJT_REQ)
#define MIO_PRI_MEJT_REQ_BIT	(1 << MIO_PRI_MEJT_REQ)

/* Misc output bits */
#define MIO_SYSTEM_RDY_LED_BIT	(1 << MIO_SYSTEM_RDY_LED)
#define MIO_PRI_RST_BIT			(1 << MIO_PRI_RST)
#define MIO_POWER_ON_BIT		(1 << MIO_POWER_ON)
#define MIO_SEC_RST_BIT			(1 << MIO_SEC_RST)
#define MIO_TWIN_COPY_LED_BIT	(1 << MIO_TWIN_COPY_LED)
#define MIO_SEC_SSTS_LED_BIT	(1 << MIO_SEC_SSTS_LED)
#define MIO_SEC_SRMV_LED_BIT	(1 << MIO_SEC_SRMV_LED)
#define MIO_SEC_MSTS_LED_BIT	(1 << MIO_SEC_MSTS_LED)
#define MIO_SEC_MRMV_LED_BIT	(1 << MIO_SEC_MRMV_LED)
#define MIO_PRI_SSTS_LED_BIT	(1 << MIO_PRI_SSTS_LED)
#define MIO_PRI_SRMV_LED_BIT	(1 << MIO_PRI_SRMV_LED)
#define MIO_PRI_MSTS_LED_BIT	(1 << MIO_PRI_MSTS_LED)
#define MIO_PRI_MRMV_LED_BIT	(1 << MIO_PRI_MRMV_LED)


/* Default Misc Output Value */
/* 
All LEDs are OFF (output high).  
Power ON is high and 
all drive Resets are high
*/
#define		MIO_OUT_DEF		(MIO_SYSTEM_RDY_LED_BIT	| \
							MIO_PRI_RST_BIT			| \
							MIO_POWER_ON_BIT		| \
							MIO_SEC_RST_BIT			| \
							MIO_TWIN_COPY_LED_BIT	| \
							MIO_SEC_SSTS_LED_BIT	| \
							MIO_SEC_SRMV_LED_BIT	| \
							MIO_SEC_MSTS_LED_BIT	| \
							MIO_SEC_MRMV_LED_BIT	| \
							MIO_PRI_SSTS_LED_BIT	| \
							MIO_PRI_SRMV_LED_BIT	| \
							MIO_PRI_MSTS_LED_BIT	| \
							MIO_PRI_MRMV_LED_BIT )


					/* PROC FILESYSTEM */
#define MIO_PROC_DIR					"miscio"
#define MIO_PROC_SOFT_POWER_SWITCH		"soft_power_switch"
#define MIO_PROC_AUTHENTICATION_BUTTON	"authentication_button"
#define MIO_PROC_TEMPERATURE_ALERT		"temperature_alert"
#define MIO_PROC_DRIVE_0_EJECT_REQUEST 	"drive_0_eject_request"
#define MIO_PROC_DRIVE_1_EJECT_REQUEST 	"drive_1_eject_request"
#define MIO_PROC_DRIVE_2_EJECT_REQUEST 	"drive_2_eject_request"
#define MIO_PROC_DRIVE_3_EJECT_REQUEST 	"drive_3_eject_request"
#define MIO_PROC_SYSTEM_READY_LED 		"system_ready_LED"
#define MIO_PROC_POWER_ENABLE			"power_enable"
#define MIO_PROC_DRIVE_0_RESET 			"drive_0_reset"
#define MIO_PROC_DRIVE_1_RESET 			"drive_1_reset"
#define MIO_PROC_DRIVE_0_STATUS_LED		"drive_0_status_LED"
#define MIO_PROC_DRIVE_0_REMOVEOK_LED	"drive_0_removeOK_LED"
#define MIO_PROC_DRIVE_0_SPUN_UP_LED	"drive_0_spun_up_LED"
#define MIO_PROC_DRIVE_0_SPUN_DOWN_LED	"drive_0_spun_down_LED"
#define MIO_PROC_DRIVE_1_STATUS_LED		"drive_1_status_LED"
#define MIO_PROC_DRIVE_1_REMOVEOK_LED	"drive_1_removeOK_LED"
#define MIO_PROC_DRIVE_1_SPUN_UP_LED	"drive_1_spun_up_LED"
#define MIO_PROC_DRIVE_1_SPUN_DOWN_LED	"drive_1_spun_down_LED"
#define MIO_PROC_DRIVE_2_STATUS_LED		"drive_2_status_LED"
#define MIO_PROC_DRIVE_2_REMOVEOK_LED	"drive_2_removeOK_LED"
#define MIO_PROC_DRIVE_2_SPUN_UP_LED	"drive_2_spun_up_LED"
#define MIO_PROC_DRIVE_2_SPUN_DOWN_LED	"drive_2_spun_down_LED"
#define MIO_PROC_DRIVE_3_STATUS_LED		"drive_3_status_LED"
#define MIO_PROC_DRIVE_3_REMOVEOK_LED	"drive_3_removeOK_LED"
#define MIO_PROC_DRIVE_3_SPUN_UP_LED	"drive_3_spun_up_LED"
#define MIO_PROC_DRIVE_3_SPUN_DOWN_LED	"drive_3_spun_down_LED"
#define MIO_PROC_TWIN_COPY_LED 			"twin_copy_LED"
#define MIO_PROC_USB_DISK_CONNECTED_LED	"usb_disk_connected_LED"



					/* PROTOTYPES */

extern int mio_init(void *unused);
extern int mio_set_out_bit(int bitNum);
extern int mio_clear_out_bit(int bitNum);
extern int mio_toggle_out_bits(unsigned int mask);
extern int mio_get_out_bit(int bitNum, bool *val);
extern bool mio_get_current_in_bit(int bitNum);
extern bool mio_get_sticky_high_in_bit(int bitNum);
extern bool mio_get_sticky_low_in_bit(int bitNum);
extern bool mio_get_sticky_rising_edge_in_bit(int bitNum);
extern bool mio_get_sticky_falling_edge_in_bit(int bitNum);
extern void mio_clear_sticky_high_in_bit(int bitNum);
extern void mio_clear_sticky_low_in_bit(int bitNum);
extern void mio_clear_sticky_rising_edge_in_bit(int bitNum);
extern void mio_clear_sticky_falling_edge_in_bit(int bitNum);
extern void mio_close(void);


#endif /* MISC_IO_INTERNAL_H */
