
/******************************************************************************
 *
 *  Copyright 2000
 *  Broadcom Corporation
 *  16215 Alton Parkway
 *  PO Box 57013
 *  Irvine CA 92619-7013
 *
 *****************************************************************************/
/* 
 * Broadcom Corporation uBSec SDK 
 */
/*
 * cfuncs.h: definitions related to export of SRL function pointers
 *
 *
 * Revision History:
 *
 * May 2002 DPA Created
 */

#ifndef _CFUNCS_H_
#define _CFUNCS_H_


/* Defines associated with exposing SRL functions via intermodule communication */
#define SRL_FUNC_STRING "bcm5820_SRL_functions"
#define SRL_IF_ACTIVATE_STRING "bcm5850_if_activate"
#define NEXT_DEVICE     -1

typedef struct _SRL_FUNC_STRUC
{
  int size;                         /* size of structure, for verification*/
  int numDevices;		    /* Number of Physical Devices */	
  void *context;                    /* device context */
  void *physDeviceInfoList;         /* PhyDeviceInfoList ptr (contains the context) */
  void *init;                       /* ubsec_InitDevice */
  void *testCrypto;                 /* ubsec_TestCryptoDevice */
  void *testKey;                    /* ubsec_TestKeyDevice */
  void *reset;                      /* ubsec_ResetDevice */
  void *shutdown;                   /* ubsec_ShutdownDevice */
  void *enableInt;                  /* ubsec_EnableInterrupt */
  void *disableInt;                 /* ubsec_DisableInterrupt */
  void *pollDevice;                 /* ubsec_PollDevice */
  void *cipherCommand;              /* ubsec_CipherCommand */
  void *initHMAC;                   /* ubsec_InitHMACState */
  void *initSSLV3MAC;               /* ubsec_InitSSLV3MACState */
  void *ISR;                        /* ubsec_ISR */
  void *ISRCallback;                /* ubsec_ISRCallback */
  void *keyCommand;                 /* ubsec_KeyCommand */
  void *mathCommand;                /* ubsec_MathCommand */
  void *RNGCommand;                 /* ubsec_RNGCommand */
  void *stats;                      /* ubsec_GetStatistics */
  void *SSLCommand;                 /* ubsec_SSLCommand */
  void  * (*get_NextContext)(int);  	/* get the next context */ 
  void * allocateDMAMemory; 		/* Linux Allocate DMA Memory */
  void * freeDMAMemory; 		/* Linux Free DMA Memory */
  void * getVirtualAddress;		/* Linux Get Virtual Address */
  void * getPhysicalAddress;		/* Linux Get Physical Address */
  void * getPhysicalAddress_ForOffset;	/* Linux Get Physical Address */
  void * mapDMAMemory; 			/* Linux map the memory for DMA */
  void * unmapDMAMemory; 		/* Linux unmap the memory  */
  void * initCipherContext;		/* Initialize CipherContext */
  void * cipherCommand_withSC;		/* CipherContext with Static Context */
} SRL_FUNC_STRUC;

void Activate582xInterface(SRL_FUNC_STRUC *pFuncs);
#endif /*  _CFUNCS_H_ */
