
/******************************************************************************
 *
 * Copyright 2000
 * Broadcom Corporation
 * 16215 Alton Parkway
 * PO Box 57013
 * Irvine CA 92619-7013
 *
 *****************************************************************************/

/* 
 * Broadcom Corporation uBSec SDK 
 */

/*
 * ubsec.h: Interface functions and defintions for the ubsec Software Reference
 * library.
 *
 * This file should be included by any files using the UBSEC 5501 SRL
 */

/*
 * Revision History:
 *
 *  Oct 99 SOR Created.
 *  Sep 00 SOR 5820 Support Added.
 *  Jul 01 RJT 5821 Support Added (1.2a)
 *  Oct 01 SRM 64 bit port.
 */

#ifndef _UBSEC_PUB_H_
#define _UBSEC_PUB_H_

/* 
 * Version of the SRL.
 */
#define UBSEC_VERSION_MAJOR 0x1
#define UBSEC_VERSION_MINOR 0x8
#define UBSEC_VERSION_REV   'b'  /* Single alphanumeric character, start with blank, then a,b,c... */


/*
 * Cryptographic parameter definitions
 */
#define UBSEC_DES_KEY_LENGTH 2    /* long */
#define UBSEC_3DES_KEY_LENGTH 6   /* long */
#define UBSEC_AES_KEY_LENGTH 8   	/* long */
#define UBSEC_MAX_CRYPT_KEY_LENGTH UBSEC_AES_KEY_LENGTH
#define UBSEC_IV_LENGTH		2 /* long */
#define UBSEC_IV_LENGTH_BYTES	8
#define UBSEC_AES_IV_LENGTH		4 /* long */
#define UBSEC_AES_IV_LENGTH_BYTES	16
#define UBSEC_MAX_IV_LENGTH UBSEC_AES_IV_LENGTH

#define UBSEC_MAC_KEY_LENGTH	64 /* Bytes */
#define UBSEC_MD5_LENGTH	16 /* Bytes */
#define UBSEC_SHA1_LENGTH	20 /* Bytes */
#define UBSEC_HMAC_LENGTH   20 /* Max of MD5/SHA1 */


/*
 * HMAC State type defines the current (inner/outer)
 * Hash state values. 
 */
typedef struct ubsec_HMAC_State_s {
  unsigned char	InnerState[UBSEC_HMAC_LENGTH];
  unsigned char	OuterState[UBSEC_HMAC_LENGTH];
} ubsec_HMAC_State_t, *ubsec_HMAC_State_pt;


/*
 * Cipher Command subtype flags.
 */
#define UBSEC_ENCODE		1
#define UBSEC_DECODE		2
#define UBSEC_3DES		4
#define UBSEC_DES		8
#define UBSEC_MAC_MD5		16
#define UBSEC_MAC_SHA1		32
/* flags kept common between ubsio and ubsec so flags from app can be passed accross till SRL */
/* 32 ...2048 taken by ubsio */
#define UBSEC_AES		4096
#define UBSEC_CTR_MODE		8192		/* Currently only supported by OPERATION_IPSEC_AES */ 
#define UBSEC_AES_128BITKEY	16384
#define UBSEC_AES_192BITKEY	32768
#define UBSEC_AES_256BITKEY	65536
/* Reserved for  	 	131072	 */
#define UBSEC_NO_CRYPTO		262144	

/*
 *	Command field definitions.
 */
#define UBSEC_ENCODE_3DES (UBSEC_ENCODE+UBSEC_3DES)
#define UBSEC_DECODE_3DES (UBSEC_DECODE+UBSEC_3DES)
#define UBSEC_ENCODE_DES  (UBSEC_ENCODE+UBSEC_DES)
#define UBSEC_DECODE_DES  (UBSEC_DECODE+UBSEC_DES)
#define UBSEC_ENCODE_AES  (UBSEC_ENCODE+UBSEC_AES)
#define UBSEC_DECODE_AES  (UBSEC_DECODE+UBSEC_AES)

#define UBSEC_ENCODE_3DES_MD5   (UBSEC_ENCODE_3DES+UBSEC_MAC_MD5)
#define UBSEC_DECODE_3DES_MD5   (UBSEC_DECODE_3DES+UBSEC_MAC_MD5)
#define UBSEC_ENCODE_3DES_SHA1  (UBSEC_ENCODE_3DES+UBSEC_MAC_SHA1)
#define UBSEC_DECODE_3DES_SHA1  (UBSEC_DECODE_3DES+UBSEC_MAC_SHA1)
#define UBSEC_ENCODE_DES_MD5	(UBSEC_ENCODE_DES+UBSEC_MAC_MD5)
#define UBSEC_DECODE_DES_MD5	(UBSEC_DECODE_DES+UBSEC_MAC_MD5)
#define UBSEC_ENCODE_DES_SHA1	(UBSEC_ENCODE_DES+UBSEC_MAC_SHA1)
#define UBSEC_DECODE_DES_SHA1	(UBSEC_DECODE_DES+UBSEC_MAC_SHA1)
#define UBSEC_ENCODE_AES_MD5   (UBSEC_ENCODE_AES+UBSEC_MAC_MD5)
#define UBSEC_DECODE_AES_MD5   (UBSEC_DECODE_AES+UBSEC_MAC_MD5)
#define UBSEC_ENCODE_AES_SHA1  (UBSEC_ENCODE_AES+UBSEC_MAC_SHA1)
#define UBSEC_DECODE_AES_SHA1  (UBSEC_DECODE_AES+UBSEC_MAC_SHA1)

#define UBSEC_USING_CRYPT(f) ( (f) & (UBSEC_3DES | UBSEC_DES | UBSEC_AES) )
#define UBSEC_USING_MAC(f)   ( (f) & (UBSEC_MAC_MD5 | UBSEC_MAC_SHA1) )

#define UBSEC_USING_CTR_MODE(f) ( (f) & (UBSEC_CTR_MODE) )

/*
 * Status codes
 */
#define UBSEC_STATUS_SUCCESS              0
#define UBSEC_STATUS_NO_DEVICE           -1
#define UBSEC_STATUS_TIMEOUT             -2
#define UBSEC_STATUS_INVALID_PARAMETER   -3
#define UBSEC_STATUS_DEVICE_FAILED       -4
#define UBSEC_STATUS_DEVICE_BUSY         -5
#define UBSEC_STATUS_NO_RESOURCE         -6
#define UBSEC_STATUS_CANCELLED           -7

  /* 
   * SRL  API function prototypes.
   */
#ifndef OS_DeviceInfo_t
#define OS_DeviceInfo_t void *
#endif

#ifndef OS_MemHandle_t
#define OS_MemHandle_t void *
#endif

#ifndef UBSECAPI
#define UBSECAPI
#endif

#endif /* _UBSEC_PUB_H_ */
