
/******************************************************************************
 *
 *  Copyright 2000
 *  Broadcom Corporation
 *  16215 Alton Parkway
 *  PO Box 57013
 *  Irvine CA 92619-7013
 *
 *****************************************************************************/

/* 
 * Broadcom Corporation uBSec SDK 
 */
/*
 * Character device header file.
 */
/*
 * Revision History:
 *
 * When       Who      What
 * June 2001  SRM      Added forced failure of a device/devices. 
 * Sept 2001  PW       Added selftest for bcmdiag
 * Sept 2000  DNA      Added SSL structures
 * May  2000  SOR/JTT  Created
 *
 */

#ifndef _UBSEC_IO_PUB_H_
#define _UBSEC_IO_PUB_H_

#include "ubsec_pub.h"

#define UBSEC_MAJOR 99
#define MAX_COMMANDS 500
#define MAX_FRAGMENTS 64
#define MAX_FILE_SIZE  128*1024 /*(PAGE_SIZE << PAGE_ORDER_FOR_BUFS) 64*1024 */
#define PAGE_ORDER_FOR_BUFS 5

#define MAX_DATA_SIZE  65528 /* Bytes */

#define IV_LENGTH  8 			/* 3DES 8 */
#define MAX_CRYPT_KEY_LENGTH  24	/* 3DES 24 */
#define AES_IV_LENGTH  16 		/* AES 8 */
#define AES_CRYPT_KEY_LENGTH  32	 /* AES(max) 32 */
#define MAC_KEY_LENGTH 64
#define MD5_LENGTH	16 /* Bytes */
#define SHA1_LENGTH	20 /* Bytes */

#define ENCODE			1
#define DECODE			2
#define CRYPT_3DES		4
#define CRYPT_DES		8
#define MAC_MD5			16
#define MAC_SHA1		32
#define CRYPT_NEW_KEY		128
#define DMA_FULL_NOBLOCK	512
#define USE_CALLBACK		1024
#define USE_MAC_STATES		2048
#define CRYPT_AES		4096
#define CTR_MODE		8192 	/* Currently supported by AES only */
#define AES_128BITKEY		16384
#define AES_192BITKEY		32768
#define AES_256BITKEY		65536
/* RESERVED 			131072	 */
#define NO_CRYPTO		262144	

#define USING_CALLBACK(f) 	((f) & USE_CALLBACK)
#define DOING_DECODE(f)		((f) & DECODE)
#define USING_MAC_STATES(f)   	( (f) & (USE_MAC_STATES) )

#define USING_CTR_MODE(f) ( (f) & (UBSEC_CTR_MODE) )

#define UBSEC_DEVICE_NAME "cryptonet"
#define UBSEC_KEYDEVICE_NAME "cryptonet"

#endif  /* _UBSEC_IO_PUB_H_ */
