/*
 * TRX image file header format.
 *
 * Copyright 2001-2004, Broadcom Corporation
 * All Rights Reserved.
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 */ 

#include <typedefs.h>
#include <bcmboard.h>
#include <bcmnvram.h>

#define TRX_MAGIC	0x30524448	/* "HDR0" */
#define TRX_VERSION	1
/* 
TRX_MAX_LEN is used to check that the trx image size is smaller than the 
maximum flash that the system can support - bootloader size - the space 
allocated for NVRAM and it's copy.
IMPORTANT - Make sure that the code checks for the size of the actual
Flash memory available on the system.
*/
#define TRX_MAX_LEN	(BCM_FLASH_MAX_SIZE - BCM_BOOTLOADER_SIZE - (2*NVRAM_SEC_SIZE))

#define TRX_NO_HEADER	0x1		/* Do not write TRX header */	
#define TRX_CFE_FILE	0x2     /* File is CFE boot loader */
#define TRX_MAX_OFFSET	3

struct trx_header {
	uint32 magic;					/* "HDR0" */
	uint32 len;						/* Length of file including header */
	uint32 crc32;					/* 32-bit CRC from flag_version to end of file */
	uint32 flag_version;			/* 0:15 flags, 16:31 version */
	uint32 offsets[TRX_MAX_OFFSET];	/* Offsets of partitions from start of header */
};

/* Compatibility */
typedef struct trx_header TRXHDR, *PTRXHDR;
