/******************************************************************************
 *
 *  Copyright 2003
 *  Broadcom Corporation
 *  16215 Alton Parkway
 *  PO Box 57013
 *  Irvine CA 92619-7013
 *
 *****************************************************************************/
/* 
 * Broadcom Corporation uBSec SDK  
 *  File: freeswan.h: uBSec driver functions for Linux/FreeSWAN offload
 *
 * Revision History:
 *
 * 12/01/02 Raouf Created.
 */
#undef __SMP__
#define _LINUX_MODVERSIONS_H
#define LINUX

#ifndef __KERNEL__
#define __KERNEL__
#endif

#include <linux/version.h>
#if 0
#define __NO_VERSION__ /* don't define kernel_verion in module.h */
#endif
#include <linux/config.h>

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0))
#define MODVERSIONS
#define LINUX2dot2
#endif

#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif

#include <linux/types.h>
#include <linux/config.h>
#include <linux/version.h>
#include <linux/module.h>
#include <linux/kernel.h> /* printk() */
#include <linux/slab.h>
#include <linux/delay.h>

#include <linux/skbuff.h>

#include <ubsec.h>

#define FREESWAN	1

#ifdef FREESWAN
#include "freeswanif.h"
#else
#include "bcmif.h"
#endif

#include <cfuncs.h>
SRL_FUNC_STRUC *p582xFuncs = NULL;	

//DONOT ENABLE
//#define USE_GLOBAL	1	// not tested in this file 

//fye: this is tested and can be enabled, however didn't see performance improvement
//#define USE_GLOBAL_CMDBUF	1
//#define USE_SPINLOCK		1


/* always enable */
#define USE_LOCAL_BUFFER	1

//#define USE_WAITQ	1
#define USE_UDELAY	1

// Return success always...
#define ALWAYS_RET_SUCCESS	1
#define USE_DMAMAPPING		1
#define USE_DMAMAPPING_OUTPUT		1

#ifdef FREESWAN
#define USE_DMAMAPPING_OUTPUT_REUSE		1
#define USE_AUTH_REUSE 		1
#else
//XVPN
#define USE_DMAMAPPING_IV		1
#define USE_DMAMAPPING_PAD		1
#endif

#define USE_EXPLICIT_IV		1

volatile static int InterfaceEnabled=0;

#define KMALLOC(size,flags)	kmalloc(size,flags)
#define KFREE(ptr)	kfree(ptr);ptr=NULL;

#if 0
void * _kmalloc(int size, int flags) {
	printk("kmalloc %d\n",size);
	return kmalloc(size,flags);
}

void _kfree(void * ptr) {
	printk("kfree %08x\n",ptr);
	return kfree(ptr);

}
#endif

#ifdef USE_GLOBAL_CMDBUF
#include <asm/atomic.h>
unsigned long freeswanif_flags;
#ifdef USE_SPINLOCK
//#include <asm/spinlock.h>
spinlock_t freeswanif_lock  = SPIN_LOCK_UNLOCKED;
#define SPINLOCK_INIT() 	spin_lock_init(&freeswanif_lock);
#define ENTER()	spin_lock_irqsave(&freeswanif_lock,freeswanif_flags);
#define LEAVE()	spin_unlock_irqrestore(&freeswanif_lock,freeswanif_flags);
//#define ENTER()	spin_lock_irqsave(&freeswanif_lock,flags);
//#define LEAVE()	spin_unlock_irqrestore(&freeswanif_lock,flags);
#else
#define SPINLOCK_INIT() 	
#define ENTER()	local_irq_save(freeswanif_flags);
#define LEAVE()	local_irq_restore(freeswanif_flags);
#endif

#define ATOMIC_INC_RING_GET(a,i,m) atomic_add_return_with_checkmax_andreset( a,i,  m)
extern __inline__ int atomic_add_return_with_checkmax_andreset(atomic_t * v,int i, int max)
{
	unsigned long flags;
	int temp;

//	ENTER()
	temp = v->counter;
	temp += i;
	if (temp >= max) {
		v->counter = 0;
		temp = v->counter;
	}
	v->counter = temp;
//	LEAVE()

	return temp;
}
#endif



inline ubsec_DeviceContext_t * get_NextContext(const int device)
{
        return (*p582xFuncs->get_NextContext)(device);
}

typedef ubsec_Status_t (*CIPHERCOMMAND)(ubsec_DeviceContext_t Context,
		    ubsec_CipherCommandInfo_pt command, int *NumCommands);
typedef ubsec_Status_t (*INITHMACSTATE)(ubsec_HMAC_State_pt HMAC_State,
	      ubsec_CipherCommand_t type, ubsec_HMAC_Key_pt Key);
typedef ubsec_Status_t (*RNGCOMMAND)(ubsec_DeviceContext_t Context,
              ubsec_RNGCommandInfo_pt pCommand, int *NumCommands);
typedef ubsec_Status_t (*RESETCOMMAND)(ubsec_DeviceContext_t Context);

typedef ubsec_Status_t (*INITCIPHERCONTEXT)(ubsec_PacketContext_t * context,
			ubsec_CipherCommand_t command, 
			ubsec_CipherContextInfo_t *pCipherInfo);
typedef ubsec_Status_t (*CIPHERCOMMAND_WITHSC)(ubsec_DeviceContext_t Context,
		    ubsec_CipherCommandInfo_withSC_t *command, int *NumCommands);

typedef void * (*ALLOCATEDMAMEMORY) (int size);
typedef void  (*FREEDMAMEMORY) (void *ptr);
typedef unsigned long (*GETPHYSICALADDRESS) (void *ptr);
typedef unsigned long (*GETVIRTUALADDRESS) (void *ptr);
typedef unsigned long (*GETPHYSICALADDRESS_FOROFFSET) (void *ptr,int offset);
typedef void * (*MAPDMAMEMORY) (void *ptr, int size, int direction);
typedef void  (*UNMAPDMAMEMORY) (void *hdl, int size, int direction);

/* always use the first device */
#undef NEXT_DEVICE
#define NEXT_DEVICE	0

#define UBSEC_RNGCOMMAND(ctxt,cmd,numcmd)		\
	(*(RNGCOMMAND)(p582xFuncs->RNGCommand))(	\
	get_NextContext(NEXT_DEVICE),cmd,numcmd)
#define UBSEC_CIPHERCOMMAND(ctxt,cmd,numcmd) 			\
	(*(CIPHERCOMMAND)(p582xFuncs->cipherCommand))(	\
	get_NextContext(NEXT_DEVICE),cmd,numcmd)
#define UBSEC_INITHMACSTATE(state,type,key)		\
	(*(INITHMACSTATE)(p582xFuncs->initHMAC))(state,type,key)
#define UBSEC_RESETCOMMAND(ctxt)		\
	(*(RESETCOMMAND)(p582xFuncs->reset))(	\
	ctxt)
#define UBSEC_INITCIPHERCONTEXT(context,command,info)		\
	(*(INITHMACSTATE)(p582xFuncs->initCipherContext))(context,command,info)
#define UBSEC_CIPHERCOMMAND_WITHSC(ctxt,cmd,numcmd) 			\
	(*(CIPHERCOMMAND)(p582xFuncs->cipherCommand_withSC))(	\
	ctxt,cmd,numcmd)

#define __OS_AllocateDMAMemory(size) \
            (*(ALLOCATEDMAMEMORY)(p582xFuncs->allocateDMAMemory))(size)
#define __OS_FreeDMAMemory(ptr) \
            (*(FREEDMAMEMORY)(p582xFuncs->freeDMAMemory))(ptr)
#define __OS_GetPhysicalAddress(ptr) \
            (*(GETPHYSICALADDRESS)(p582xFuncs->getPhysicalAddress))(ptr)
#define __OS_GetVirtualAddress(ptr) \
            (*(GETVIRTUALADDRESS)(p582xFuncs->getVirtualAddress))(ptr)
#define __OS_GetPhysicalAddress_ForOffset(ptr,offset) \
            (*(GETPHYSICALADDRESS_FOROFFSET)(p582xFuncs->getPhysicalAddress_ForOffset))(ptr,offset)
#define __OS_MapDMAMemory(ptr,size,direction) \
            (*(MAPDMAMEMORY)(p582xFuncs->mapDMAMemory))(ptr,size,direction)
#define __OS_UnmapDMAMemory(hdl,size,direction) \
            (*(UNMAPDMAMEMORY)(p582xFuncs->unmapDMAMemory))(hdl,size,direction)


#define FILE_DEBUG_TAG 	"FreeSwan582xif"
#define PRINTK  printk("%s: ",FILE_DEBUG_TAG); printk

//#define DEBUG 1	 /* fye DONOT enable not safe */

#ifdef DEBUG
#define DPRINTK  printk("Debug:%s: ",FILE_DEBUG_TAG); printk
#define DDPRINTK  printk("Debug:%s: ",FILE_DEBUG_TAG); printk
#define FRAGPRINTK  printk
#define DUMPARRAY   dumpArray
#define PPRINTK     printk
#define DDUMPARRAY  dumpArray
#else
#define FRAGPRINTK  //printk
#define DDPRINTK  
#define DPRINTK
#define DUMPARRAY 
#define DDUMPARRAY //dumpArray
#define PPRINTK //printk
#define GPRINTK //printk
#endif



#define MAX_SIZE_RNG		512	// maximum size random number 
//#define MAX_CRYPTO_MCRS 	100
#define MAX_CRYPTO_MCRS 	5
#define NUM_RNG_DWORDS		MAX_CRYPTO_MCRS*4*UBSEC_IV_LENGTH	// 4 is for number of packets/MCR higher, 
						// but can be lower because not 100%  
						// of packets will be outbound (ie, need IV)
#define NUM_RNG_COMMANDS	NUM_RNG_DWORDS/(MAX_SIZE_RNG/32)
#define NUM_CRYPTO_FRAGMENTS		(((NUM_RNG_DWORDS*sizeof(long)) - 1)/PAGE_SIZE) + 1	// number of pages


static ubsec_RNGCommandInfo_t commands[NUM_RNG_COMMANDS];
// structure for ubsec command and packet pointer
//#define OFFLOAD_MAX_FRAGS	17	// maximum is 64Kbytes (16 4K pages + 1 for non-alignment)
#define OFFLOAD_MAX_FRAGS	4	// maximum is 64Kbytes (16 4K pages + 1 for non-alignment)
typedef struct ubsecCmdStruct
{
	ubsec_CipherCommandInfo_t commandInfo;
	ubsec_FragmentInfo_t	sourceFrag[OFFLOAD_MAX_FRAGS];
	ubsec_FragmentInfo_t	destFrag[OFFLOAD_MAX_FRAGS];
} ubsecCmdStruct_t;
typedef struct ubsecCmdStruct_withSC
{
	ubsec_CipherCommandInfo_withSC_t commandInfo;
	ubsec_FragmentInfo_t	sourceFrag[OFFLOAD_MAX_FRAGS];
	ubsec_FragmentInfo_t	destFrag[OFFLOAD_MAX_FRAGS];
} ubsecCmdStruct_withSC_t;
static ubsecCmdStruct_t cryptoCommand;

void * gContext =NULL;		

void dumpArray(char * mesg, unsigned char * buf,int size); 
// variables associated with generation of random numbers for IVs
static  unsigned long * pRandBuf = 0;		// pointer to buffer of random numbers
static unsigned long curRandBufIndex = 0;	// index into buffer for random number generation 
#define MAX_FREESWAN_COMMANDS 	530

typedef struct ubsecCmdBuf
{
	unsigned long	bHasAuth; 	// determines post (ubsec) processing for packet
	unsigned long	encrypt;	// encrypt (send) or decrypt (receive)
	void		*auth; 		// authentication output (ubsec DMA memory handle)
#ifdef USE_AUTH_REUSE
	void		*auth_virtual;	// virtual address of the auth pointer
	int		auth_len;
#endif
#ifdef USE_LOCAL_BUFFER
	void		*datahdl; 	// data ptr (ubsec DMA memory handle)
	void		*rData; 	// result data ptr to copy the result
	int		rDataLen; 	// result data Len to copy the result
#endif
#ifdef USE_DMAMAPPING	
	void *		mappedData;	// mapped data Len 
	int		mappedDataLen;	// mapped data Len 
#endif
#ifdef USE_DMAMAPPING_IV
	void *		mappedIV;	// mapped IV Len 
	int		mappedIVLen;	// mapped IV Len 
#endif
#ifdef USE_DMAMAPPING_PAD
	void *		mappedPad;	// mapped IV Len 
	int		mappedPadLen;	// mapped IV Len 
#endif
#ifdef USE_DMAMAPPING_OUTPUT
	void *		omappedData;	// mapped data Len 
	int		omappedDataLen;	// mapped data Len 
#endif
	unsigned char *	pAuthPacket;	// pointer to packet location of authentication info
	/*void 	*callback;	*/	// callback routine
	void  	(*callback)(void *, void *, int);
	void	*callbackskb;		// callback skbuff
	void	*callbacksa;		// callback sa passed in at initialize context
	ubsec_Status_t result;		// result from ubsec processing
#ifdef USE_WAITQ
	wait_queue_head_t   WaitQ;	// for sync mode
#endif
#ifdef USE_UDELAY
#define COMMAND_DONE	0x00
	int   WaitQ;			// for sync mode
#endif
#ifdef USE_GLOBAL_CMDBUF
#define IN_USE	1
#define NOT_USED	0x00
	volatile int inuse;			// for Globaluse
#endif
} ubsecCmdBuf_t;

int init_RandomIVList(void)
{
	
	// allocate buffer to be used for holding random numbers to use for IV
	// note that the size of this buffer is based on the number of MCRs, because that way
	// it will refresh at least as often as the max number of MCRs
	static ubsec_MemAddress_t PhysAddr;
	unsigned long i,remBytes,szFrag;
	unsigned int numRNGCommands = NUM_RNG_COMMANDS;
	ubsec_Status_t status =UBSEC_STATUS_SUCCESS;

	gContext = get_NextContext(0); 

	if (!pRandBuf) 
	{
		// note that allocations less than a page in size will not cross page boundaries, however,
		// allocations greater than a page in size may cross page boundaries (but will be page aligned)
#ifndef USE_GLOBAL
		int randAllocSize = NUM_RNG_DWORDS*sizeof(unsigned long);
		pRandBuf = __OS_AllocateDMAMemory(randAllocSize);
#endif
		if (pRandBuf == NULL) {
			PRINTK("RandBuf is null\n");
			return UBSEC_STATUS_NO_RESOURCE;
		}
		curRandBufIndex = 0;

		// now set up RNG command buffer.  Note that this is sent out once to fill buffer with random numbers
		// and then the buffer is refreshed using crypto commands, since that is faster
		PhysAddr = (ubsec_MemAddress_t)__OS_GetPhysicalAddress(pRandBuf);
		for (i=0;i<NUM_RNG_COMMANDS;i++) {
			commands[i].Command = UBSEC_RNG_DIRECT;
			commands[i].Parameters.Result.KeyLength = MAX_SIZE_RNG;
			/*commands[i].Parameters.Result.KeyValue = (void *)(PhysAddr);*/
			commands[i].Parameters.Result.KeyValue = pRandBuf;
			commands[i].CompletionCallback = NULL;
			commands[i].CommandContext = 0;
			PhysAddr += MAX_SIZE_RNG/8;
		}

		// set up crypto command for running on random number buffer
		cryptoCommand.commandInfo.Command = UBSEC_DES | UBSEC_ENCODE;
		cryptoCommand.commandInfo.SourceFragments = &cryptoCommand.sourceFrag[0];
		cryptoCommand.commandInfo.DestinationFragments = &cryptoCommand.destFrag[0];
		cryptoCommand.commandInfo.CryptHeaderSkip = 0;
		cryptoCommand.commandInfo.CryptKey = &pRandBuf[0];
		cryptoCommand.commandInfo.InitialVector = &pRandBuf[0];
		cryptoCommand.commandInfo.NumSource = NUM_CRYPTO_FRAGMENTS;
		cryptoCommand.commandInfo.NumDestination = NUM_CRYPTO_FRAGMENTS;
		cryptoCommand.commandInfo.CompletionCallback = 0;
		cryptoCommand.commandInfo.CommandContext = 0;
		PhysAddr = (ubsec_MemAddress_t)__OS_GetPhysicalAddress(pRandBuf);
		remBytes = NUM_RNG_DWORDS*sizeof(unsigned long);
		for (i=0;i<NUM_CRYPTO_FRAGMENTS;i++) {
			szFrag = (remBytes > PAGE_SIZE) ? PAGE_SIZE : remBytes;
			cryptoCommand.sourceFrag[i].FragmentAddress = PhysAddr;
			cryptoCommand.sourceFrag[i].FragmentLength = szFrag;
			cryptoCommand.destFrag[i].FragmentAddress = PhysAddr;
			cryptoCommand.destFrag[i].FragmentLength = szFrag;
			PhysAddr += PAGE_SIZE;
			remBytes -= PAGE_SIZE;
		}

		// now kick off the first set of RNG commands to fill the buffer
		status = UBSEC_RNGCOMMAND(gContext,commands,&numRNGCommands);
		if (status != UBSEC_STATUS_SUCCESS) {
		        PRINTK("init_RandomIVList: ubsec_RNGCommand failed \n");
		}
	}
	return status;
}


void activate582xInterface(SRL_FUNC_STRUC *pFuncs)
{
	/* Validate the function ptr */
	if (pFuncs->size == sizeof(SRL_FUNC_STRUC)) {
		p582xFuncs = pFuncs;		/* is same */
		PRINTK("BCM582x interface activated\n");
		/* ??? what happens if bcm582x driver unloaded and loaded */
#ifdef USE_GLOBAL
		PRINTK("Using global buffers\n");
		if (allocateGlobalBuffers() != UBSEC_STATUS_SUCCESS) {
			PRINTK("activate582xInterface: allocateGlobalBuffers failed\n");
		}
#endif
#ifdef USE_GLOBAL_CMDBUF
		PRINTK("Using global Cmd buffers\n");
		if (allocateGlobalCmdBuffers() != UBSEC_STATUS_SUCCESS) {
			PRINTK("activate582xInterface: allocateGlobalBuffers failed\n");
		}
#endif

		/* Initialize the Random IV List */
                if (init_RandomIVList() == UBSEC_STATUS_SUCCESS) {
			InterfaceEnabled=1;
		}
		else {
			PRINTK("random IV creation error\n");
		}
	} else {
		p582xFuncs = NULL;		/* not going to use it */
		inter_module_put(SRL_FUNC_STRING);
		PRINTK("activate582xInterface: BCM582x function  pointer structure size mismatch.\n");
	}

}


#ifdef USE_GLOBAL_CMDBUF
#define MAX_CMDS	200
ubsecCmdBuf_t *  gCmdBufArray[MAX_CMDS] ;
atomic_t gCmdBufIndex;
int cmdBufSize =0;
int allocateGlobalCmdBuffers()
{
	int i=0;

	//need to have this check otherwise will reallocate if bcm driver unload and load
	if (gCmdBufArray[0] !=NULL) { 
		PRINTK("allocateGlobalCmdBuffers: Buffers has previously been allocated.\n");
		return UBSEC_STATUS_SUCCESS;
	}

	cmdBufSize=sizeof(ubsecCmdBuf_t);

	for (i=0; i< MAX_CMDS;i++) {
		if ((gCmdBufArray[i] = KMALLOC(cmdBufSize, GFP_ATOMIC) ) == NULL) {
			PRINTK("allocateGlobalCmdBuffers: gCmdBufArray memory allocation failed\n");
			return UBSEC_STATUS_NO_RESOURCE;
		}
		memset(gCmdBufArray[i], 0, cmdBufSize); /* this clears inuse flag */
	}

	SPINLOCK_INIT() ;	/* if using spinlocks */
	atomic_set(&gCmdBufIndex,MAX_CMDS);
	PRINTK("Using GLOBAL_CMDBUF: %d bufs\n",MAX_CMDS);
	return UBSEC_STATUS_SUCCESS;
}
void freeGlobalCmdBuffers()
{
	int i=0;
	for (i=0; i< MAX_CMDS;i++) {
		if (gCmdBufArray[i] != NULL)
			KFREE(gCmdBufArray[i]);
	}
}
#endif


#ifdef USE_GLOBAL
ubsecCmdBuf_t *  gCmdBuf =NULL;
void * gDatahdl =NULL;
void * gAuth =NULL;
int allocateGlobalBuffers()
{
	int randAllocSize = NUM_RNG_DWORDS*sizeof(unsigned long);
	if (gCmdBuf !=NULL) {
		PRINTK("allocateGlobalBuffers: Buffers once allocated ???\n");
		return UBSEC_STATUS_SUCCESS;
	}
	pRandBuf = __OS_AllocateDMAMemory(randAllocSize);
	if (pRandBuf == NULL) {
		PRINTK("allocateGlobalBuffers: pRandBuf memory allocation failed\n");
		return UBSEC_STATUS_NO_RESOURCE;
	}

	if ((gCmdBuf = KMALLOC(sizeof(ubsecCmdBuf_t), GFP_ATOMIC) ) == NULL) {
		PRINTK("allocateGlobalBuffers: pCmdBuf memory allocation failed\n");
		return UBSEC_STATUS_NO_RESOURCE;
	}

	gDatahdl = __OS_AllocateDMAMemory(10000); /* expecting KMALLOC to always return 8 byte align buffer */
	if (gDatahdl == NULL) {
		PRINTK("allocateGlobalBuffers: local buffer memory allocation failed\n");
		return UBSEC_STATUS_NO_RESOURCE;
	}
	if ((gAuth = __OS_AllocateDMAMemory(20)) == NULL) {
		PRINTK("allocateGlobalBuffers: Auth DMA memory allocation failed\n");
		return UBSEC_STATUS_NO_RESOURCE;
	}
	return UBSEC_STATUS_SUCCESS;
}
void freeGlobalBuffers()
{
	if (gAuth != NULL) 
		{__OS_FreeDMAMemory(gAuth);};
	if (gDatahdl != NULL) 
		{__OS_FreeDMAMemory(gDatahdl);};
	if (gCmdBuf != NULL)
		KFREE(gCmdBuf);
	/* Free the Random IV List */
	if (pRandBuf != NULL)
		__OS_FreeDMAMemory(pRandBuf);
}
#endif

/*--------------------------------------------------------------------------
 * Name    : BcmInitFreeSWANif
 * Purpose : Perform device initialization associated with FreeS/WAN
 *           and allocate memory to be used for holding random numbers 
 *           to use for IV
 * Input   : 
 * Output  :
 * Returns :
 * ---------------------------------------------------------------------*/
#ifdef FREESWAN
int BcmInitFreeSWANif()
#else
int BcmInitIf()			/* XVPN */
#endif
{
	/* Get the ubsec SRL function ptrs */
	p582xFuncs = (SRL_FUNC_STRUC *) inter_module_get(SRL_FUNC_STRING);
	if (p582xFuncs != NULL) {
		activate582xInterface(p582xFuncs);
		inter_module_put(SRL_FUNC_STRING);
	}
	/* Register interface for THIS MODULE, in case ubsec driver loaded afterwards, */
	/* it will be able to activate interface */
	inter_module_register(SRL_IF_ACTIVATE_STRING, THIS_MODULE, (void *) activate582xInterface);
	printk("Broadcom ipsec hardware offload interface version: %x.%x.%c\n", BCM_IF_VERSION_MAJOR, BCM_IF_VERSION_MINOR, BCM_IF_VERSION_REVISION);

	return UBSEC_STATUS_SUCCESS ;
}

#if 0
int BcmInitFreeSWANif(void)
{
	/* Get the ubsec SRL function ptrs */
	p582xFuncs = (SRL_FUNC_STRUC *) inter_module_get(SRL_FUNC_STRING);
	if (p582xFuncs != NULL) {
		activate582xInterface(p582xFuncs);
		inter_module_put(SRL_FUNC_STRING);
		inter_module_register(SRL_IF_ACTIVATE_STRING, THIS_MODULE, (void *) activate582xInterface);
		return UBSEC_STATUS_SUCCESS ;
	}
	else 
		PRINTK("BCM582x interface activate error\n");
#if 0
	/* Register interface for THIS MODULE, in case ubsec driver loaded afterwards, */
	/* it will be able to activate interface */
	inter_module_register(SRL_IF_ACTIVATE_STRING, THIS_MODULE, (void *) activate582xInterface);
#endif
	return UBSEC_STATUS_DEVICE_FAILED;
}
#endif
/*--------------------------------------------------------------------------
 * Name    : BcmShutdownFreeSWANif
 * Purpose : Perform device shutdown associated with FreeS/WAN
 *           and free any allocated resources
 * Input   :
 * Output  :
 * Returns :
 * ---------------------------------------------------------------------*/
#ifdef FREESWAN
void BcmShutdownFreeSWANif(void) 
#else
void BcmShutdownIf(void) 		/* XVPN */
#endif
{
	/* Do we have to unregister the interface ??? */

#if 0
	/* Free the Random IV List */
	if (pRandBuf != NULL)
		__OS_FreeDMAMemory(pRandBuf);
#endif
	InterfaceEnabled=0;

	/* unregister the interface */
	inter_module_unregister(SRL_IF_ACTIVATE_STRING);
#ifdef USE_GLOBAL_CMDBUF
	freeGlobalCmdBuffers();
#endif
#ifdef USE_GLOBAL
	freeGlobalBuffers();
#endif
	PRINTK("BCM582x interface deactivated\n");
	
}

/*--------------------------------------------------------------------------
 * Name    : BcmGetRandomIV
 * Purpose : Create of replenish the random IV pool
 * Input   : 
 * Output  :
 * Returns :
 * Remarks : Requires the hardware device to be active
 * ---------------------------------------------------------------------*/
u8 *BcmGetRandomIV(int ivSize)
{
	// this routine supplies random IVs and refreshes random number buffer when necessary
	unsigned int numCommands = 1;
	char *pIV = (char *)&pRandBuf[curRandBufIndex];
	ubsec_Status_t status;

	DPRINTK("BcmGetRandomIV %d\n",ivSize);

	if (!InterfaceEnabled)
		return NULL;

	// now point index to next IV in buffer
	curRandBufIndex += UBSEC_IV_LENGTH;
	if (curRandBufIndex >= NUM_RNG_DWORDS)
		curRandBufIndex = 0;

	// determine if random number buffer needs to be refreshed
	if (!curRandBufIndex) {
		// yes, set up request for random numbers
		status = UBSEC_CIPHERCOMMAND(gContext,&cryptoCommand.commandInfo,&numCommands);
		if (status != UBSEC_STATUS_SUCCESS) {
			PRINTK("BcmGetRandomIV: Rng failed  %08x\n",(int)status);
		}
	}

	if (ivSize > MAX_SIZE_RNG) {
		PRINTK("BcmGetRandomIV: Rng size greater than %d(MAX_SIZE_RNG)\n",MAX_SIZE_RNG);
		pIV = (char *)&pRandBuf[0];	/* hoping not bigger than the total rng */
	}

	return pIV;
}


typedef struct ubsecSAContext {
	void  			* contextptr;
	void 			* sa;		/* contains the ptr passed in */
#define FALSE 	0
#define TRUE 	1
	ubsec_CipherCommand_t	command;
	unsigned short		encrypt; 	/* Boolean */
} ubsecSAContext_t;

#define BYTESWAPUINT32(a) (((a)<<24)|(((a)<<8)&0x00FF0000)|(((a)>>8)&0x0000FF00)|((a)>>24))

void swap(u32 * ptr,int size)
{
	int i=0;
	for (i=0; i< size/4 ; i++){
		ptr[i] = BYTESWAPUINT32(ptr[i]);
	}
}
#define SWAP(ptr,size)  swap(ptr,size)

/*--------------------------------------------------------------------------
 * Name    : BcmInitializeHwContext
 * Purpose :  Setup any contexts needed by the driver for packet processing
 * Input   : hwContext: is created and upon success the pointer is updated  
 *           sa;        This pointer must be saved inside the context and 
 *                      returned with the packet in a callback
 *           flags:     indicates any conditions that apply to this contextL:
 *                      such as the direction of the operation and the 
 *                      option to generate the IV
 *           encrType:  the type of encryption operation 
 *           encrKey:   the keys for the encryption operation 
 *           encrKeyLen: the length of the encryption key
 *           authType:  the type of authentication operation 
 *           authKey:   the keys for the authentication operation 
 *           authKeyLen: the length of the authentication key
 *         
 * Output  :
 * Returns :
 * Remarks : Does not require the hardware device be active
 * ---------------------------------------------------------------------*/
int BcmInitializeHwContext(void **hwContext, u32 flags, void *sa, 
	    BCM_ENCR_TYPE encType,  u8 *encKey,  u16 encKeyLen,
        BCM_AUTH_TYPE authType, u8 *authKey, u16 authKeyLen, u8 headerLen) 
{
	ubsecSAContext_t *pSA;
	ubsec_PacketContext_t *context;
	ubsec_CipherContextInfo_t contextInfo;
	u8 IVSize=0;

	if (!InterfaceEnabled){
		PRINTK("Interface not enabled.\n");
		return UBSEC_STATUS_NO_RESOURCE;
	}
	
	*hwContext= NULL;

	// first allocate a block for the SA
	pSA = KMALLOC(sizeof(ubsecSAContext_t), GFP_ATOMIC);
	if (pSA == NULL) {
		PRINTK("BcmInitializeHwContext: Out of memory\n");
		return UBSEC_STATUS_NO_RESOURCE;
	}
	pSA->contextptr = __OS_AllocateDMAMemory(sizeof(ubsec_PacketContext_t)); 
	context =  (ubsec_PacketContext_t *) __OS_GetVirtualAddress(pSA->contextptr);
	context->PhysicalAddress= __OS_GetPhysicalAddress(pSA->contextptr);

	// now initialize SA fields
	pSA->sa = sa;
	pSA->command = 0x00;
	if (flags & BCM_FLAGS_DIR_DECODE) {
		pSA->command = UBSEC_DECODE;
		pSA->encrypt  = FALSE;
	} 
	if (flags & BCM_FLAGS_DIR_ENCODE) {
		pSA->command = UBSEC_ENCODE;
		pSA->encrypt  = TRUE;
	} 
	if (flags & BCM_FLAGS_MASK_UNUSED) {
		PRINTK("BcmInitializeHwContext: UnSupported flag (%d)\n",flags);
		return UBSEC_STATUS_DEVICE_FAILED;
	}

	DPRINTK("flags %08x\n",pSA->encrypt);

	// set up encryption.  may or may not have authentication
	if (encType == BCM_ENCR_TYPE_DES) {
		pSA->command |= UBSEC_DES;
		IVSize = 8;
	} else if (encType == BCM_ENCR_TYPE_3DES) {
		pSA->command |= UBSEC_3DES;
		IVSize = 8;
	} else if (encType ==  BCM_ENCR_TYPE_AES256) {
		pSA->command |= UBSEC_AES;
		pSA->command |= UBSEC_AES_256BITKEY;
		IVSize = 16;
	} else if (encType ==  BCM_ENCR_TYPE_AES192) {
		pSA->command |= UBSEC_AES;
		pSA->command |= UBSEC_AES_192BITKEY;
		IVSize = 16;
	} else if (encType ==  BCM_ENCR_TYPE_AES128) {
		pSA->command |= UBSEC_AES;
		pSA->command |= UBSEC_AES_128BITKEY;
		IVSize = 16;
	} else {
		/*PRINTK("BcmInitializeHwContext: UnSupported encType (%d)\n",encType); */
		/*return UBSEC_STATUS_DEVICE_FAILED;*/
	}
#ifdef USE_EXPLICIT_IV
	pSA->command |= UBSEC_EXPLICIT_IV;
#endif


	DPRINTK("EncType %08x\n",encType);

	// now set up authentication, if any
	if (authType == BCM_AUTH_TYPE_MD5) {
		pSA->command |= UBSEC_MAC_MD5;
	} else if (authType == BCM_AUTH_TYPE_SHA1) {
		pSA->command |= UBSEC_MAC_SHA1;
	} else {
		/*PRINTK("BcmInitializeHwContext: UnSupported authType (%d)\n",authType);*/
		/*return UBSEC_STATUS_DEVICE_FAILED; */
	}
	DPRINTK("AuthType %08x\n",authType);

	// now set up HMAC state, if any
	if (UBSEC_USING_MAC(pSA->command)) {
		memset(contextInfo.Key, 0, UBSEC_MAC_KEY_LENGTH); //fye added, must do
		// first copy key into temp buffer, because ubsec expects 64 byte key
		memcpy(contextInfo.Key,authKey,(authKeyLen<UBSEC_MAC_KEY_LENGTH)?authKeyLen:UBSEC_MAC_KEY_LENGTH);
	} else if (UBSEC_USING_EXPLICIT_IV(pSA->command))  {
		headerLen = IVSize;
	}

	DPRINTK("CryptKey Len %d\n",encKeyLen);
	DPRINTK("AuthKey Len %d\n", authKeyLen);

	// set up crypto key, if any
	if (UBSEC_USING_CRYPT(pSA->command)) {
		memcpy(contextInfo.CryptKey,encKey,(encKeyLen<sizeof(ubsec_CryptKey_t))?encKeyLen:sizeof(ubsec_CryptKey_t));
	}
	DUMPARRAY("Enc Key",contextInfo.CryptKey, encKeyLen);
	DUMPARRAY("Auth Key", contextInfo.Key, authKeyLen); 



	//Header Len
	contextInfo.CryptHeaderSkip=headerLen/4;



	UBSEC_INITCIPHERCONTEXT(context,pSA->command,&contextInfo);

	//dumpArray("Context",context,sizeof(ubsec_PacketContext_t));
	DDPRINTK("context physicalAddress %08x\n",context->PhysicalAddress);
	DDPRINTK("context headerLen %d\n",headerLen);


	*hwContext = pSA;

	DPRINTK("BcmInitializeHwContext %08x\n",(unsigned int) pSA);

	return UBSEC_STATUS_SUCCESS;
}

/*--------------------------------------------------------------------------
 * Name    : BcmReleaseHwContext
 * Purpose :
 * Input   : skb: the buffer containing the completed packet
 *           sa:  a pointer to the SA copied back from the context
 *           status: the UBSEC status
 * Output  :
 * Returns :
 * Remarks : Does not require the hardware device to be active
 * ---------------------------------------------------------------------*/
int BcmReleaseHwContext(void *hwContext, u32 flags)
{
	ubsecSAContext_t *pSA = (ubsecSAContext_t *)hwContext;

	DPRINTK("BcmReleaseHwContext %08x\n", (unsigned int) hwContext);
	if (pSA->contextptr != NULL) 
		__OS_FreeDMAMemory(pSA->contextptr);
	
	
	if (hwContext  != NULL)
		KFREE(hwContext);
	hwContext= NULL;
	return UBSEC_STATUS_SUCCESS ;
}


void dumpArray(char * mesg, unsigned char * buf,int size) 
{
	int i=0;
	unsigned char * ptr;

    	printk("\n****** %s %d bytes buf=%x ******\n",mesg,size, buf);
	#define MAX_DISPLAY	64
	ptr = buf;
	for (i=0;i<((size<MAX_DISPLAY)?size:MAX_DISPLAY);i++) {
		printk("%02x ",(unsigned char) *ptr); ptr =ptr+1;
		if (!((i+1)%16))
			printk("\n");
	}
	printk("\n");
}

/*--------------------------------------------------------------------------
 * Name    : BcmProcessPacket
 * Purpose : The main interface to precessing the packet by the driver
 * Input   : skb:      the buffer containing the packet (or chain of packets)
 *                     to be processed
 *           context:  context created by the driver which has all the
 *                     data it needs to handle the packet
 *           data;     start of the data to be processed in the first skbuff
 *           dataLen;  total data length 
 *           callback; pointer to the callback function (if synchronous
 *                     mode the the callback is nULL)
 * Output  :
 * Returns :
 * Remarks : Requires the hardware device to be active
 * ---------------------------------------------------------------------*/
#define EXTRA_CHECK	1
//#define EXTRA_FRAG_CHECK	1
#ifdef USE_GLOBAL
ubsecCmdStruct_withSC_t cmdStruc;
#endif


#ifdef FREESWAN
int BcmProcessPacket(skbuff *skb, u8* data, u16 dataLen, void *hwContext, 
		void *callback, void *ctx) 
#else
int BcmProcessPacket(skbuff *skb, u8* data, u16 dataLen, u8 *odata, u16 odataLen, int flags, u8 *iv, void *hwContext, 
		void *callback, void *ctx, void * skbcallback, 
		u8* pad, u8 padLen ) 	/* XVPN */
#endif
{
	// this routine processes a packet 
#ifndef USE_GLOBAL
	ubsecCmdStruct_withSC_t cmdStruc;
	ubsec_CipherCommandInfo_withSC_t * pCommandInfo;
#endif
	ubsecCmdBuf_t *pCmdBuf =NULL;
	ubsecSAContext_t *pSA = (ubsecSAContext_t *)hwContext;
	void * packethdl = (void *) skb->nh.iph;
	void * datahdl = data;
	ubsec_MemAddress_t  vpacket , vdata ; 
	unsigned char * pIV;
	unsigned int numCommands = 1;
	long bytesToPageEnd,remBytes,fragNum;
	long  curVirtAddr;
	ubsec_MemAddress_t physAuthBuffer;
	ubsec_Status_t status;
	ubsec_DeviceContext_t context;

	/*unsigned int IVOffset =0;*/
	unsigned int IVSize =0;
	unsigned int headerLen=0;

	void * chipDataPtr =NULL;
	int  chipDataLen =0;

	void OffloadCompletionCallback(unsigned long PacketContext,ubsec_Status_t Result);

	DPRINTK("BcmProcessPacket Enter %08x\n",(unsigned int) hwContext);
	//dumpArray("Key",pSA->cryptKey,24);

	DPRINTK("args data %08x dataLen %d\n", data,dataLen);

	DUMPARRAY("data:",data,dataLen);

	//return UBSEC_STATUS_NO_RESOURCE; //fye



	if (!InterfaceEnabled)
		return UBSEC_STATUS_NO_RESOURCE;

#ifdef USE_GLOBAL
	pCmdBuf = gCmdBuf;
#else
#ifdef USE_GLOBAL_CMDBUF
{
	volatile int arrayIndex =0;
	unsigned long trycount=0;

	/* fye: should ENTER here instead of inside the atomic_inc_ring_get function,
	   because when number of cmdbuff is small, it can wrap around, cause race condition
	   of 2 packet use the same cmdbuff (the first one has not set inuse yet)
	*/
	ENTER();

try_again:
	arrayIndex =ATOMIC_INC_RING_GET(&gCmdBufIndex,1,MAX_CMDS);
	pCmdBuf =gCmdBufArray[arrayIndex];
	GPRINTK("using cmdbuf[%08x] index %d address %08x\n",gCmdBufArray,arrayIndex,pCmdBuf);
	if (pCmdBuf->inuse == IN_USE){
		trycount++;
		if (trycount==1){
			PRINTK("Huh....atomic is not safe/or run out of buffers[%d]/trying %d...??? \n",MAX_CMDS,arrayIndex);
		}
	//	goto try_again;
		LEAVE();
		return UBSEC_STATUS_NO_RESOURCE;
	}
	//disabled to get faster
	//memset(pCmdBuf, 0, sizeof(ubsecCmdBuf_t));

	pCmdBuf->inuse = IN_USE;

	LEAVE();

#define DEBUG_TRYCOUNT	1
#ifdef DEBUG_TRYCOUNT
	if ((trycount != 0) ) {

			PRINTK("Got after %d tries. Current index %d.\n",trycount,arrayIndex);
	}
#endif
}
#else
	if ((pCmdBuf = KMALLOC(sizeof(ubsecCmdBuf_t), GFP_ATOMIC) ) == NULL) {
		PRINTK("BcmProcessPacket: pCmdBuf memory allocation failed\n");
		return UBSEC_STATUS_NO_RESOURCE;
	}
#endif
#endif

	/* REMOVE */
	//memset(&cmdStruc,0x00, sizeof(ubsecCmdStruct_withSC_t));
	//memset(pCmdBuf,0x00, sizeof(ubsecCmdBuf_t));

	/* Assign the context for the packet */
	pCommandInfo = &cmdStruc.commandInfo;
	pCommandInfo->pContext = (ubsec_PacketContext_t *) __OS_GetVirtualAddress(pSA->contextptr);
	DDPRINTK("CommandInfo %08x \n", cmdStruc.commandInfo.pContext);
	DDPRINTK("CommandInfo %08x \n", pCommandInfo->pContext);
	DDPRINTK("pContext %08x phys %08x\n", cmdStruc.commandInfo.pContext,
		cmdStruc.commandInfo.pContext->PhysicalAddress);

#ifdef EXTRA_CHECK
	if ((dataLen & 0x03) != 0x00 ) {
		PRINTK("BcmProcessPacket: dataLen %d \n",dataLen);
		return UBSEC_STATUS_NO_RESOURCE;
	}
#endif


	vpacket = (ubsec_MemAddress_t) packethdl;
	//vpacket = (ubsec_MemAddress_t) __OS_GetVirtualAddress(packethdl); when passing in datahdl
#define ESP 1
#ifdef ESP
	headerLen = 16;
#else
	headerLen = data - vpacket;			//Expecting data to be virtual
	//headerLen = vdata - vpacket; 
#endif

#ifdef USE_LOCAL_BUFFER
	/* Crude clean it latter */
#ifdef USE_GLOBAL
	datahdl = gDatahdl;
#else
#ifndef USE_DMAMAPPING_OUTPUT
	datahdl = __OS_AllocateDMAMemory(headerLen+dataLen); /* expecting KMALLOC to always return 8 byte align buffer */
	if (datahdl == NULL) {
		PRINTK("BcmProcessPacket: local buffer memory allocation failed\n");
		return UBSEC_STATUS_NO_RESOURCE;
	}
#else
	datahdl = NULL;
#endif
#endif

#ifndef USE_DMAMAPPING_OUTPUT
	pCmdBuf->datahdl=datahdl;
	//vpacket = (ubsec_MemAddress_t) packethdl;
	vdata = (ubsec_MemAddress_t) __OS_GetVirtualAddress(datahdl);
	DUMPARRAY("HW Input: ",__OS_GetVirtualAddress(pCmdBuf->datahdl), pCmdBuf->rDataLen);
#endif
#ifdef FREESWAN
	pCmdBuf->rData=data;
	pCmdBuf->rDataLen=dataLen;
#else
	pCmdBuf->rData=odata;
	pCmdBuf->rDataLen=odataLen;
#endif

#else
	vpacket = (ubsec_MemAddress_t) __OS_GetVirtualAddress(packethdl);
	vdata = (ubsec_MemAddress_t) __OS_GetVirtualAddress(datahdl);
#endif
	if (UBSEC_USING_CRYPT(pSA->command)) {
		if ((pSA->command  & UBSEC_AES) == UBSEC_AES) {
			//pIV =  data - 16;
			//pIV =  vpacket + headerLen - 16;
			IVSize = 16;
		} else /* 3DES */ {
			//pIV = data - 8;
			//pIV =  vpacket + headerLen - 8;
			IVSize = 8;
		}
	}

	if (UBSEC_USING_MAC(pSA->command))  {
		chipDataPtr=data-headerLen; 
		chipDataLen=headerLen+dataLen;
	} else  {		/* hope atleast enc is there */
#ifdef USE_EXPLICIT_IV
		if (UBSEC_USING_EXPLICIT_IV(pSA->command))  {
			chipDataPtr=data-IVSize;
	       		chipDataLen=dataLen+IVSize ;
			headerLen = IVSize;

		}
		else
#endif
	       	{
			chipDataPtr=data;
	       		chipDataLen=dataLen ;
			headerLen = 0;
		}
	}

#ifdef USE_DMAMAPPING
#ifdef USE_DMAMAPPING_IV
	PPRINTK("Input args: iv %08x : %d data %08x : %d padLen %08x: %d \n",
						iv, IVSize,
						data, dataLen, 
						pad, padLen);
						
	if (pSA->encrypt){
		DDUMPARRAY("HW Input:IV ",iv, IVSize);
		pCmdBuf->mappedIV = __OS_MapDMAMemory(iv,IVSize,-1); 
		pCmdBuf->mappedIVLen = IVSize;
#ifdef USE_DMAMAPPING_PAD
		DDUMPARRAY("HW Input:Data ",data, dataLen-padLen);
		DDUMPARRAY("HW Input:Pad ",pad, padLen);
		pCmdBuf->mappedData = __OS_MapDMAMemory(data,dataLen-padLen,-1); 
		pCmdBuf->mappedDataLen = dataLen-padLen;
		pCmdBuf->mappedPad = __OS_MapDMAMemory(pad,padLen,-1); 
		pCmdBuf->mappedPadLen = padLen;
#else
		DDUMPARRAY("HW Input:Data ",data, dataLen);
		pCmdBuf->mappedData = __OS_MapDMAMemory(data,dataLen,-1); 
		pCmdBuf->mappedDataLen = dataLen;
#endif
	}else {	/* Decrypt */
		iv= data-IVSize;
		DDUMPARRAY("HW Input:Data ",iv, dataLen+IVSize);
		pCmdBuf->mappedData = __OS_MapDMAMemory(iv,dataLen+IVSize,-1); 
		pCmdBuf->mappedDataLen = dataLen+IVSize;
		pCmdBuf->mappedPad = NULL; 
		pCmdBuf->mappedPadLen = 0;
		pCmdBuf->mappedIV = NULL; 
		pCmdBuf->mappedIVLen = 0;
	}
#else /* USE_DMAMAPPING_IV */
	pCmdBuf->mappedData = __OS_MapDMAMemory(chipDataPtr,chipDataLen,-1); 
	pCmdBuf->mappedDataLen = chipDataLen;
#endif /* USE_DMAMAPPING_IV */
#ifdef USE_DMAMAPPING_OUTPUT
#ifdef USE_DMAMAPPING_OUTPUT_REUSE
	pCmdBuf->mappedData = __OS_MapDMAMemory(chipDataPtr,chipDataLen,-1); 
	pCmdBuf->mappedDataLen = chipDataLen;
	/* resue mappedData in fragment */
	pCmdBuf->omappedData = NULL; 
	pCmdBuf->omappedDataLen = dataLen;
#else
	pCmdBuf->omappedData = __OS_MapDMAMemory(odata,odataLen,-1); 
	pCmdBuf->omappedDataLen = odataLen;
#endif
#endif
#else /* USE_DMAMAPPING */
	if (UBSEC_USING_MAC(pSA->command) 
#ifdef USE_EXPLICIT_IV
			||  (UBSEC_USING_EXPLICIT_IV(pSA->command))
#endif
			)  
	{
		memcpy(__OS_GetVirtualAddress(datahdl), data-headerLen,headerLen+dataLen);
	}else {
		memcpy(__OS_GetVirtualAddress(datahdl), data, dataLen);
	}
#endif


	

	pCmdBuf->auth = NULL;		/* play safe */
	if (UBSEC_USING_MAC(pSA->command)) {	/* Auth */
		//printk("Using MAC...\n"); 	/* Gigi Remove*/
#ifdef USE_GLOBAL
		pCmdBuf->auth = gAuth;
		physAuthBuffer = (ubsec_MemAddress_t) __OS_GetPhysicalAddress(pCmdBuf->auth);
#else
#ifndef USE_AUTH_REUSE
		if ((pCmdBuf->auth = __OS_AllocateDMAMemory(20)) == NULL) {
			PRINTK("BcmProcessPacket: Auth DMA memory allocation failed\n");
			return UBSEC_STATUS_NO_RESOURCE;
		}
		physAuthBuffer = (ubsec_MemAddress_t) __OS_GetPhysicalAddress(pCmdBuf->auth);
#else
		pCmdBuf->auth_len = 20;
		if (pSA->encrypt){ //fye: reuse the auth space in outgoing packet
			// check tail room first, 8 = 20-12 (HW will write 20bytes, while only 12 space
			if (skb_tailroom(skb) < 8){
				printk("IPsec tx auth tail room too small: %d.\n", skb_tailroom(skb));
				return UBSEC_STATUS_NO_RESOURCE;
			}
			pCmdBuf->auth_virtual = data + dataLen;
		}
		else {
			// check tail room first, HW will write 20bytes
			if (skb_tailroom(skb) < 20){
				printk("IPsec rx auth tail room too small: %d.\n", skb_tailroom(skb));
				return UBSEC_STATUS_NO_RESOURCE;
			}
			pCmdBuf->auth_virtual = data + dataLen + 12;
		}
		pCmdBuf->auth = __OS_MapDMAMemory(pCmdBuf->auth_virtual, pCmdBuf->auth_len, -1);
		physAuthBuffer = pCmdBuf->auth; 
#endif
#endif
	}

	cmdStruc.commandInfo.Command = pSA->command;

	cmdStruc.commandInfo.SourceFragments = &cmdStruc.sourceFrag[0];
	cmdStruc.commandInfo.DestinationFragments = &cmdStruc.destFrag[0];
	//cmdStruc.commandInfo.CryptHeaderSkip = 0x00;	??
	//cmdStruc.commandInfo.CryptHeaderSkip = headerLen / 4;	/* done only if Mac */

	// set up crypto info, if any
	if (UBSEC_USING_CRYPT(pSA->command)) {
#if 0
		if ((pSA->command  & UBSEC_AES) == UBSEC_AES) {
			pIV =  data - 16;
			//pIV =  vpacket + headerLen - 16;
			IVSize = 16;
		} else /* 3DES */ {
			pIV = data - 8;
			//pIV =  vpacket + headerLen - 8;
			IVSize = 8;
		}
#endif
		//cmdStruc.commandInfo.CryptKey = &pSA->cryptKey[0]; ??
		// set up encrypt/decrypt specific

		DPRINTK("HeaderLen %d  IVSize %d DataLen %d\n",headerLen,  IVSize, dataLen);

		

//#define DEBUG 1
#ifdef DEBUG
		if (pSA->encrypt){
			PRINTK("Encrypt............\n");
		}else {
			PRINTK("Decrypt............\n");
		}
#endif

#if 0
		if (pSA->encrypt)
			memcpy((char *)pIV,BcmGetRandomIV(IVSize),IVSize);
#endif
		//cmdStruc.commandInfo.InitialVector = (ubsec_IV_pt)pIV; ??		/* this is virtual address OK */
	}

	// set up auth pointers
	pCmdBuf->pAuthPacket = 0x00;
	if (UBSEC_USING_MAC(pSA->command)) {
		//cmdStruc.commandInfo.CryptHeaderSkip = headerLen / 4; ??
		//cmdStruc.commandInfo.HMACState = &pSA->HMAC_State;??
		cmdStruc.commandInfo.AuthenticationInfo.FragmentLength = 12;	/* but copy only 12 in callback */
		cmdStruc.commandInfo.AuthenticationInfo.FragmentAddress = (ubsec_MemAddress_t) physAuthBuffer; 
		FRAGPRINTK("phyAuthBuffer=%x\n", physAuthBuffer);
		pCmdBuf->bHasAuth = TRUE;
		if (UBSEC_USING_CRYPT(pSA->command)) 
			pCmdBuf->pAuthPacket = data+dataLen;
		else
			pCmdBuf->pAuthPacket = data;
//#define TEST_DEBUG 1
#ifdef TEST_DEBUG	
			if (pCmdBuf->pAuthPacket > skb->data+skb->data_len) {
				PRINTK("BcmProcessPacket: Authpacket > skb->data_len\n");
				return UBSEC_STATUS_DEVICE_FAILED;
			}
#endif
		if (pSA->encrypt)
			pCmdBuf->encrypt = TRUE;
		else
			pCmdBuf->encrypt = FALSE;
	} else {
#ifdef USE_EXPLICIT_IV
		//cmdStruc.commandInfo.CryptHeaderSkip = headerLen / 4; ??
#endif
		pCmdBuf->bHasAuth = FALSE;
	}


	// now set up fragments by determining physical page breaks in buffer
#if 0
	if (pCmdBuf->bHasAuth == TRUE) {
#ifdef USE_LOCAL_BUFFER
		remBytes = dataLen +headerLen ;	
		curVirtAddr =  (long) datahdl;
#else
		remBytes = dataLen + headerLen;
		curVirtAddr = (long) packethdl;
#endif
	}else {
		remBytes = dataLen ;
		curVirtAddr =  (long) datahdl;
	}
#endif




#ifdef USE_DMAMAPPING
	/* curVirtAddr is the physical Address   */
	curVirtAddr = pCmdBuf->mappedData; 
	remBytes = pCmdBuf->mappedDataLen;
#else
	if ((pCmdBuf->bHasAuth == TRUE) 
#ifdef USE_EXPLICIT_IV
			||  (UBSEC_USING_EXPLICIT_IV(pSA->command))
#endif
	) {
		remBytes = dataLen +headerLen ;	
		curVirtAddr =  (long) datahdl;
	}else {
		remBytes = dataLen ;
		curVirtAddr =  (long) datahdl;
	}
#endif


	fragNum = 0;

#ifdef USE_DMAMAPPING_IV
	if (pSA->encrypt){
		cmdStruc.sourceFrag[fragNum].FragmentAddress = 
			(ubsec_MemAddress_t) (void *)  pCmdBuf->mappedIV; 
		cmdStruc.sourceFrag[fragNum].FragmentLength = pCmdBuf->mappedIVLen;
			FRAGPRINTK("cmdStruc.srcFrag %d phy %08x size %d \n",fragNum,
			cmdStruc.sourceFrag[fragNum].FragmentAddress,
			cmdStruc.sourceFrag[fragNum].FragmentLength);
		fragNum ++;
	}
#endif


	while (remBytes>0) {
		int offset=0;
		//bytesToPageEnd = PAGE_SIZE - (curVirtAddr & (PAGE_SIZE - 1));
		bytesToPageEnd = remBytes; // one segment only, since in embedded all mem are continuous.
#ifdef USE_DMAMAPPING
		/* curVirtAddr is the physical Address   */
		cmdStruc.sourceFrag[fragNum].FragmentAddress = (ubsec_MemAddress_t) (void *)curVirtAddr +offset;
#else
		cmdStruc.sourceFrag[fragNum].FragmentAddress = (ubsec_MemAddress_t) __OS_GetPhysicalAddress_ForOffset((void *)curVirtAddr,offset);
#endif
		cmdStruc.sourceFrag[fragNum].FragmentLength = (remBytes > bytesToPageEnd) ? bytesToPageEnd : remBytes;
		FRAGPRINTK("cmdStruc.srcFrag %d phy %08x size %d \n",fragNum,
			cmdStruc.sourceFrag[fragNum].FragmentAddress,
			cmdStruc.sourceFrag[fragNum].FragmentLength);
		remBytes -= bytesToPageEnd;
		//curVirtAddr += bytesToPageEnd;
	        offset += bytesToPageEnd;
		fragNum++;
	}
#ifdef USE_DMAMAPPING_PAD
	if (pSA->encrypt){
		cmdStruc.sourceFrag[fragNum].FragmentAddress = 
			(ubsec_MemAddress_t) (void *)  pCmdBuf->mappedPad; 
		cmdStruc.sourceFrag[fragNum].FragmentLength = pCmdBuf->mappedPadLen;
			FRAGPRINTK("cmdStruc.srcFrag %d phy %08x size %d \n",fragNum,
			cmdStruc.sourceFrag[fragNum].FragmentAddress,
			cmdStruc.sourceFrag[fragNum].FragmentLength);
		fragNum ++;
	}
#endif

	cmdStruc.commandInfo.NumSource = fragNum;

#ifdef EXTRA_FRAG_CHECK
	if (fragNum > 3)
		{PRINTK("Src Num Fragments %d\n",fragNum);}
#endif

	fragNum = 0;
	if (UBSEC_USING_CRYPT(pSA->command)) {
#ifdef USE_DMAMAPPING_OUTPUT
#ifdef USE_DMAMAPPING_OUTPUT_REUSE
		curVirtAddr = pCmdBuf->mappedData+headerLen; 
		remBytes = pCmdBuf->omappedDataLen;
#else
		/* curVirtAddr is the physical Address   */
		curVirtAddr = pCmdBuf->omappedData; 
		remBytes = pCmdBuf->omappedDataLen;
#endif
#else
		remBytes = dataLen ;
		curVirtAddr = (long) datahdl;
#endif
		while (remBytes>0) {
			int offset=0;
			//bytesToPageEnd = PAGE_SIZE - (curVirtAddr & (PAGE_SIZE - 1));
			bytesToPageEnd = remBytes;
#ifdef USE_DMAMAPPING_OUTPUT
			/* curVirtAddr is the physical Address   */
			cmdStruc.destFrag[fragNum].FragmentAddress = (ubsec_MemAddress_t) (void *)curVirtAddr +offset;
#else
			cmdStruc.destFrag[fragNum].FragmentAddress =(ubsec_MemAddress_t) __OS_GetPhysicalAddress_ForOffset((void *)curVirtAddr,offset);
#endif
			cmdStruc.destFrag[fragNum].FragmentLength = (remBytes > bytesToPageEnd) ? bytesToPageEnd : remBytes;
			FRAGPRINTK("cmdStruc.destFrag %d phy %08x size %d \n",fragNum,
			cmdStruc.destFrag[fragNum].FragmentAddress,
			cmdStruc.destFrag[fragNum].FragmentLength);
			remBytes -= bytesToPageEnd;
			//curVirtAddr += bytesToPageEnd;
			offset += bytesToPageEnd;
			fragNum++;
		}
	}
	else { /* Bug in the SRL. It needs at least one fragment. */
		cmdStruc.destFrag[0].FragmentAddress=0;
		cmdStruc.destFrag[0].FragmentLength=0;
		fragNum=1;
	}

	cmdStruc.commandInfo.NumDestination = fragNum;

#ifdef EXTRA_FRAG_CHECK
	if (fragNum > 3)
		{PRINTK("Dest Num Fragments %d\n",fragNum);}
#endif
	// Setup the callback parameters 	
	pCmdBuf->callback = callback;
#ifdef FREESWAN
	pCmdBuf->callbackskb = skb;
#else
	pCmdBuf->callbackskb = skbcallback;			/* XVPN */
#endif
	pCmdBuf->callbacksa = ctx ? ctx : pSA->sa; /* GG */
	//pCmdBuf->callbacksa = pSA->sa;
	pCmdBuf->result = UBSEC_STATUS_TIMEOUT;	/* be pessimistic */

	// now put completion info in command
	cmdStruc.commandInfo.CompletionCallback = (void *) OffloadCompletionCallback;
	cmdStruc.commandInfo.CommandContext = (unsigned long)pCmdBuf;

	/* Sync mode */
	if (callback == NULL) {
#ifdef USE_WAITQ
		init_waitqueue_head(&pCmdBuf->WaitQ);
#endif
#ifdef USE_UDELAY 
		pCmdBuf->WaitQ = ~COMMAND_DONE;
#endif
	}
	// send packet to ubsec
	context = get_NextContext(NEXT_DEVICE);

	//PRINTK("Device Context: %08x\n",context);	
	//
	//dumpArray("Output",vdata,dataLen);
	//dumpArray("packet",vpacket,vdata-vpacket+dataLen);




	status = UBSEC_CIPHERCOMMAND_WITHSC(context,pCommandInfo,&numCommands);

	PPRINTK("CipherPushed %d\n",status);

	if (status != UBSEC_STATUS_SUCCESS) { 
		PRINTK( "BcmProcessPacket:  command failure %d\n",status);
		if (status == UBSEC_STATUS_TIMEOUT) {		/* Should happen only in blocking mode */
			PRINTK("Flushing the device...\n");
			UBSEC_RESETCOMMAND(context);
		}
#ifdef USE_DMAMAPPING
		if (pCmdBuf->mappedData != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->mappedData,pCmdBuf->mappedDataLen,-1); 
#endif
#ifdef USE_DMAMAPPING_IV
	if (pSA->encrypt){
		if (pCmdBuf->mappedIV != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->mappedIV,pCmdBuf->mappedIVLen,-1); 
	}
#endif
#ifdef USE_DMAMAPPING_PAD
	if (pSA->encrypt){
		if (pCmdBuf->mappedPad != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->mappedPad,pCmdBuf->mappedPadLen,-1); 
	}
#endif
#ifdef USE_DMAMAPPING_OUTPUT
#ifndef USE_DMAMAPPING_OUTPUT_REUSE /*fye*/
		if (pCmdBuf->omappedData != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->omappedData,pCmdBuf->omappedDataLen,-1); 
#endif
#endif

#ifndef USE_GLOBAL
#ifdef USE_LOCAL_BUFFER
#ifndef USE_DMAMAPPING_OUTPUT /*fye*/
		if (pCmdBuf->datahdl != NULL)
			__OS_FreeDMAMemory(pCmdBuf->datahdl);
#endif
#endif

		if (pCmdBuf->auth != NULL)
#ifdef USE_AUTH_REUSE
			__OS_UnmapDMAMemory(pCmdBuf->auth, pCmdBuf->auth_len, -1);
#else
			__OS_FreeDMAMemory(pCmdBuf->auth);
#endif

#ifndef USE_GLOBAL_CMDBUF
		if (pCmdBuf != NULL)
  			KFREE(pCmdBuf);
		pCmdBuf=NULL;
#else
		pCmdBuf->inuse = NOT_USED;	
#endif

#endif	/* !USE_GLOBAL */
#ifdef ALWAYS_RET_SUCCESS
		//status = UBSEC_STATUS_SUCCESS; 			/* never return error */
#endif
	} else {	/* SUCCESS */
		/* sync mode */
		if (callback == NULL) {
#ifdef USE_WAITQ
			#define MAX_SLEEP_TIME	3*HZ
			sleep_on_timeout(&pCmdBuf->WaitQ,MAX_SLEEP_TIME);
#endif
#ifdef USE_UDELAY 
			{
				int delay=10000000;
				volatile int waitQStatus = pCmdBuf->WaitQ;
				while ((delay-- > 0) && (waitQStatus != COMMAND_DONE)) {
					udelay(1);
					waitQStatus = pCmdBuf->WaitQ;
				}
			}
#endif
		status= pCmdBuf->result;
#ifdef USE_DMAMAPPING
		if (pCmdBuf->mappedData != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->mappedData,pCmdBuf->mappedDataLen,-1); 
#endif
#ifdef USE_DMAMAPPING_IV
	if (pSA->encrypt){
		if (pCmdBuf->mappedIV != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->mappedIV,pCmdBuf->mappedIVLen,-1); 
	}
#endif
#ifdef USE_DMAMAPPING_PAD
	if (pSA->encrypt){
		if (pCmdBuf->mappedPad != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->mappedPad,pCmdBuf->mappedPadLen,-1); 
	}
#endif
#ifdef USE_DMAMAPPING_OUTPUT
#ifndef USE_DMAMAPPING_OUTPUT_REUSE
		if (pCmdBuf->omappedData != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->omappedData,pCmdBuf->omappedDataLen,-1); 
#endif
#endif

#ifndef USE_GLOBAL
#ifdef USE_LOCAL_BUFFER
#ifndef USE_DMAMAPPING_OUTPUT
			if (pCmdBuf->datahdl != NULL) 
				__OS_FreeDMAMemory(pCmdBuf->datahdl);
#endif
#endif

			if (pCmdBuf->auth != NULL)
#ifdef USE_AUTH_REUSE
				__OS_UnmapDMAMemory(pCmdBuf->auth, pCmdBuf->auth_len, -1);
#else
				__OS_FreeDMAMemory(pCmdBuf->auth);
#endif

#ifndef USE_GLOBAL_CMDBUF
			if (pCmdBuf != NULL)
  				KFREE(pCmdBuf);
			pCmdBuf=NULL;
#else
			pCmdBuf->inuse = NOT_USED;	
#endif
#endif	/* !USE_GLOBAL */
		} /* sync mode */
	}

	DPRINTK("Process Packet Return %d(%08x)\n",status,status);
	

	//status = UBSEC_STATUS_TIMEOUT;	
	return status;
}


/*--------------------------------------------------------------------------
 * Name    : BcmCompletionCallback
 * Purpose : Called upon completion of the operation in asynchronous mode
 * Input   : skb:    the buffer containing the completed packet
 *           sa:     a pointer to the SA copied back from the context
 *           status: the UBSEC status
 * Output  :
 * Returns :
 * ---------------------------------------------------------------------*/
void OffloadCompletionCallback(unsigned long PacketContext,ubsec_Status_t Result)
{
	// this callback gets invoked when SRL determines that a command has
	// completed
	
	ubsecCmdBuf_t *pCmdBuf = (ubsecCmdBuf_t *)PacketContext;

	PPRINTK("OffloadCompletionCallback %d\n",Result);

#ifdef EXTRA_CHECK
	if (pCmdBuf == NULL) {
		PRINTK("OffloadCompletionCallback: pCmdBuf->datahdl (NULL) ???" );
		return;
	}
#endif

	if (Result == UBSEC_STATUS_SUCCESS) {
		/* handle post-processing of auth differently for send and receive */
		if (pCmdBuf->bHasAuth) {
			if (pCmdBuf->encrypt) {
#ifdef USE_AUTH_REUSE
				//fye: don't need to copy since it's there already
#else
				// this is a send, need to put auth data into packet
				unsigned char * physHWAuthPtr= __OS_GetVirtualAddress(pCmdBuf->auth);
				RTL_Memcpy(pCmdBuf->pAuthPacket,physHWAuthPtr,BCM_IPSEC_AUTH_LEN);
#endif
			} else { 
#ifdef USE_AUTH_REUSE
				unsigned char * physHWAuthPtr;
				__OS_UnmapDMAMemory(pCmdBuf->auth, pCmdBuf->auth_len, -1); // need to do it here?
				physHWAuthPtr = pCmdBuf->auth_virtual;
#else
				unsigned char * physHWAuthPtr= __OS_GetVirtualAddress(pCmdBuf->auth);
#endif
				// this is a receive, see if auth matches
				DUMPARRAY("Expected Auth: ",pCmdBuf->pAuthPacket, BCM_IPSEC_AUTH_LEN);
				DUMPARRAY("HW Auth Output: ",physHWAuthPtr, BCM_IPSEC_AUTH_LEN);

				if (RTL_Memcmp((void *) physHWAuthPtr, (void *)pCmdBuf->pAuthPacket,BCM_IPSEC_AUTH_LEN) != 0) {
	 				Result = BCM_IPSEC_INVALID_SIGNATURE;
					PRINTK("OffloadCompletionCallback: Auth failed\n");
					dumpArray("HW Auth Output: ",physHWAuthPtr, BCM_IPSEC_AUTH_LEN);
					dumpArray("Expected Auth: ",pCmdBuf->pAuthPacket, BCM_IPSEC_AUTH_LEN);
				} 

			}

		}
#ifdef USE_LOCAL_BUFFER
		// Doing it blindly ..not required only if auth
		// copy data if successful else let the sw do it
#ifndef USE_DMAMAPPING_OUTPUT
		memcpy(pCmdBuf->rData,__OS_GetVirtualAddress(pCmdBuf->datahdl), pCmdBuf->rDataLen);
#endif
#endif
		DDUMPARRAY("HW Output: ",pCmdBuf->rData, pCmdBuf->rDataLen);
	} else {
		/* ok error ...should we try to flush */
		ubsec_DeviceContext_t context;		
		context = get_NextContext(NEXT_DEVICE);

		PRINTK( "OffloadCompletionCallback:  command failure %d\n",Result);
		PRINTK("Flushing the device...\n");
		//UBSEC_RESETCOMMAND(context);
	}
	
#ifdef ALWAYS_RET_SUCCESS
	Result = UBSEC_STATUS_SUCCESS; 			/* never return error */
#endif
	
	/* async mode */
	if (pCmdBuf->callback != NULL)  {
		DPRINTK("OffloadCompletionCallback: Async mode ");

#ifdef USE_DMAMAPPING
		/* so syncing is done ... */
		if (pCmdBuf->mappedData != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->mappedData,pCmdBuf->mappedDataLen,-1); 
#endif
#ifdef USE_DMAMAPPING_IV
	if (pCmdBuf->encrypt) {
		if (pCmdBuf->mappedIV != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->mappedIV,pCmdBuf->mappedIVLen,-1); 
	}
#endif
#ifdef USE_DMAMAPPING_PAD
	if (pCmdBuf->encrypt){
		if (pCmdBuf->mappedPad != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->mappedPad,pCmdBuf->mappedPadLen,-1); 
	}
#endif
#ifdef USE_DMAMAPPING_OUTPUT
#ifndef USE_DMAMAPPING_OUTPUT_REUSE
		if (pCmdBuf->omappedData != NULL)  
			__OS_UnmapDMAMemory(pCmdBuf->omappedData,pCmdBuf->omappedDataLen,-1); 
#endif
#endif

#ifdef USE_AUTH_REUSE
		if (pCmdBuf->auth != NULL) //fye
			__OS_UnmapDMAMemory(pCmdBuf->auth, pCmdBuf->auth_len, -1);
#endif

#if 1
		(*pCmdBuf->callback)(pCmdBuf->callbackskb,pCmdBuf->callbacksa,Result);
#else
		DPRINTK("Not calling callback %08x\n",pCmdBuf->callback);
#endif


#ifndef USE_GLOBAL
#ifdef USE_LOCAL_BUFFER
#ifndef USE_DMAMAPPING_OUTPUT
		if (pCmdBuf->datahdl != NULL) 
			__OS_FreeDMAMemory(pCmdBuf->datahdl);
#endif
#endif

#ifndef USE_AUTH_REUSE
		if (pCmdBuf->auth != NULL)
			__OS_FreeDMAMemory(pCmdBuf->auth);
#endif

#ifndef USE_GLOBAL_CMDBUF
		if (pCmdBuf != NULL)
  			KFREE(pCmdBuf);
		pCmdBuf=NULL;
#else
	pCmdBuf->inuse = NOT_USED;	
#endif
#endif	/* !USE_GLOBAL */

	} else  { /* sync mode */
		DPRINTK("OffloadCompletionCallback: Sync mode ");
#ifdef USE_WAITQ
      		wake_up(&pCmdBuf->WaitQ);
#endif
#ifdef USE_UDELAY 
		pCmdBuf->WaitQ = COMMAND_DONE;
#endif
		pCmdBuf->result = Result;
	}
	DPRINTK("OffloadCompletionCallback: return %d\n",(int) Result);

}
