/******************************************************************************
 *
 *  Copyright 2003
 *  Broadcom Corporation
 *  16215 Alton Parkway
 *  PO Box 57013
 *  Irvine CA 92619-7013
 *
 *****************************************************************************/
/* 
 * Broadcom Corporation uBSec SDK  
 *  File: freeswan.h: uBSec driver functions for Linux/FreeSWAN offload
 *
 * Revision History:
 *
 * 12/01/02 Raouf Created.
 */

#ifndef _FREESWANIF_H_
#define _FREESWANIF_H_

/* requires linux/skbuff.h and ubsec.h */

#if 0
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;
#endif

#define BCM_IF_VERSION_MAJOR    0x1
#define BCM_IF_VERSION_MINOR    0x0
#define BCM_IF_VERSION_REVISION ' '

#define BCM_ENCR_TYPE	unsigned short
#define BCM_AUTH_TYPE	unsigned short
#define skbuff		struct sk_buff



// BCM Flags
#define BCM_FLAGS_DIR_MASK        0x00000003    
#define BCM_FLAGS_DIR_ENCODE      0x00000001    
#define BCM_FLAGS_DIR_DECODE      0x00000002   
#define BCM_FLAGS_CREATE_IV       0x00000004
#define BCM_FLAGS_AH_AUTHENT      0x00000008
#define BCM_FLAGS_MASK_UNUSED     0xFFFFFFF0

// BCM Encryption Types
#define BCM_ENCR_TYPE_ERROR          0x00
#define BCM_ENCR_TYPE_NULL           0x01
#define BCM_ENCR_TYPE_DES            0x02
#define BCM_ENCR_TYPE_3DES           0x03
#define BCM_ENCR_TYPE_AES256         0x04
#define BCM_ENCR_TYPE_AES192         0x05
#define BCM_ENCR_TYPE_AES128         0x06

// BCM Athentication Types
#define BCM_AUTH_TYPE_ERROR          0x00
#define BCM_AUTH_TYPE_NONE           0x01
#define BCM_AUTH_TYPE_MD5            0x02
#define BCM_AUTH_TYPE_SHA1           0x03

#define IPSEC_HMAC_LEN		12
#define BCM_IPSEC_AUTH_LEN		12
#define ESP_HEADER_LEN		16
#define BCM_IPSEC_INVALID_SIGNATURE		-1

int BcmInitFreeSWANif(void);
void BcmShutdownFreeSWANif(void) ;
u8 *BcmGetRandomIV(int ivSize);
int BcmInitializeHwContext(void **hwContext, u32 flags, void *sa, 
	    BCM_ENCR_TYPE encType,  u8 *encKey,  u16 encKeyLen,
        BCM_AUTH_TYPE authType, u8 *authKey, u16 authKeyLen, u8 headerLen) ;
int BcmReleaseHwContext(void *hwContext, u32 flags);
int BcmProcessPacket(skbuff *skb, u8* data, u16 dataLen, void *hwContext, void *callback, void*ctx);
void BcmProcessInboundDone(skbuff *skb, void *sa, ubsec_Status_t status);
void BcmProcessOutboundDone(skbuff *skb, void *sa, ubsec_Status_t status);

#define  RTL_Memcpy(dest,source,bytes) memcpy(( void *)dest,( void *)source,bytes)
#define  RTL_Memcmp(dest,source,bytes) memcmp(( void *)dest,( void *)source,bytes)

#endif 	/* _FREESWANIF_H_ */
