#ifndef __MARS_CEC_H__
#define __MARS_CEC_H__

#include <linux/wait.h>

#define MISC_IRQ        3

typedef struct {
    unsigned char   state;
    unsigned char   dest;
    unsigned char*  p_data;
    unsigned char   data_len;
    unsigned char   xmit_data_len;
    unsigned long   timeout;    
    unsigned char   status;
    struct completion   complete;        
}mars_cec_xmit;



typedef struct {
    unsigned char   state;
    unsigned char   init;
    unsigned char*  p_buff;
    unsigned char   buff_len;
    unsigned char   rcv_data_len;     
    unsigned char   status;
}mars_cec_rcv;

enum 
{
    IDEL,
    WAIT_XMIT,
    XMIT,
    XMIT_COMPLETE,
    WAIT_RCV,
    RCV,
    RCV_COMPLETE    
};

enum 
{    
    XMIT_OK,
    XMIT_FAIL,    
    XMIT_TIMEOUT,
};

enum 
{    
    RCV_OK,
    RCV_FAIL,    
};

typedef struct {
    struct {
        unsigned char   enable : 1;   
    }status;
    
    mars_cec_xmit   xmit;    
    mars_cec_rcv    rcv;    
}mars_cec;


// prototypes
mars_cec* mars_cec_open         ();
void mars_cec_close             (mars_cec* p_this);
void mars_cec_do_xmit           (mars_cec* p_this);
void mars_cec_do_rcv            (mars_cec* p_this);
int mars_cec_start_xmit         (mars_cec* p_this);
int mars_cec_stop_xmit          (mars_cec* p_this);
int mars_cec_start_rcv          (mars_cec* p_this);
int mars_cec_stop_rcv           (mars_cec* p_this);
int mars_cec_init               (mars_cec* p_this);
int mars_cec_enable             (mars_cec* p_this, unsigned char on_off);
int mars_cec_send_message       (mars_cec* p_this, unsigned char* p_data, unsigned char data_len);
int mars_cec_rcv_message        (mars_cec* p_this, unsigned char* p_buff, unsigned char buff_len, unsigned char* p_rcv_len);
int mars_cec_set_logical_addr   (mars_cec* p_this, unsigned char log_addr);


#endif //__MARS_CEC_H__
