/*
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 2000 MIPS Technologies, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 * Defines of the Venus board specific address-MAP, registers, etc.
 *
 */
#ifndef _MACH_VENUS_H
#define _MACH_VENUS_H

#include <asm/addrspace.h>

/*
 * Yamon Prom print address.
 */
#define YAMON_PROM_PRINT_ADDR	0x1fc00504
  

#define VENUS_RESET_ADDR	0xbfc00000


#define VENUS_IO_PORT_BASE	0x18010000



/*
 * Venus SB2 registers.
 */
#define VENUS_SB2_HD_SEM		0xA000
#define VENUS_SB2_INV_INTEN		0xA004
#define VENUS_SB2_INV_INTSTAT		0xA008
#define VENUS_SB2_INV_ADDR		0xA00C

#define VENUS_SB2_CHIP_ID		0xA200
#define VENUS_SB2_CHIP_INFO			0xA204


/*
 * Software Debug registers
 */
#define SB2_DGB_START_REG0		0xA458
#define SB2_DGB_START_REG1		0xA45c
#define SB2_DGB_START_REG2		0xA460
#define SB2_DGB_START_REG3		0xA464
#define SB2_DGB_START_REG4		0xA468
#define SB2_DGB_START_REG5		0xA46c
#define SB2_DGB_START_REG6		0xA470
#define SB2_DGB_START_REG7		0xA474

#define SB2_DGB_END_REG0		0xA478
#define SB2_DGB_END_REG1		0xA47c
#define SB2_DGB_END_REG2		0xA480
#define SB2_DGB_END_REG3		0xA484
#define SB2_DGB_END_REG4		0xA488
#define SB2_DGB_END_REG5		0xA48c
#define SB2_DGB_END_REG6		0xA490
#define SB2_DGB_END_REG7		0xA494

#define SB2_DGB_CTRL_REG0		0xA498
#define SB2_DGB_CTRL_REG1		0xA49c
#define SB2_DGB_CTRL_REG2		0xA4a0
#define SB2_DGB_CTRL_REG3		0xA4a4
#define SB2_DGB_CTRL_REG4		0xA4a8
#define SB2_DGB_CTRL_REG5		0xA4ac
#define SB2_DGB_CTRL_REG6		0xA4b0
#define SB2_DGB_CTRL_REG7		0xA4b4

#define SB2_DGB_ADDR_ADUIO		0xA4b8
#define SB2_DGB_ADDR_VIDEO		0xA4bc
#define SB2_DGB_ADDR_SYSTEM		0xA4c0

#define SB2_DGB_INT			0xA4e0

/*
 * Venus MISC registers.
 */
#define VENUS_MIS_PSELH			0xB000
#define VENUS_MIS_PSELL			0xB004
#define VENUS_MIS_UMSK_ISR		0xB008
#define VENUS_MIS_ISR			0xB00C
#define VENUS_MIS_UMSK_ISR_GP0A		0xB010
#define VENUS_MIS_UMSK_ISR_GP0DA	0xB014
#define VENUS_MIS_UMSK_ISR_KPADAH	0xB018
#define VENUS_MIS_UMSK_ISR_KPADAL	0xB01C
#define VENUS_MIS_UMSK_ISR_KPADDAH	0xB020
#define VENUS_MIS_UMSK_ISR_KPADDAL	0xB024
#define VENUS_MIS_UMSK_ISR_SW		0xB028
#define VENUS_MIS_DBG			0xB02C
#define VENUS_MIS_DUMMY			0xB030
#define VENUS_MIS_PSEL2			0xB034
#define VENUS_MIS_UMSK_ISR_GP1A		0xB038
#define VENUS_MIS_UMSK_ISR_GP1DA	0xB03C

/*
 * Venus GPIO registers.
 */
#define VENUS_MIS_GP0DIR		0xB100
#define VENUS_MIS_GP1DIR		0xB104
#define VENUS_MIS_GP0DATO		0xB108
#define VENUS_MIS_GP1DATO		0xB10C
#define VENUS_MIS_GP0DATI		0xB110
#define VENUS_MIS_GP1DATI		0xB114
#define VENUS_MIS_GP0IE			0xB118
#define VENUS_MIS_GP1IE			0xB11C
#define VENUS_MIS_GP0DP			0xB120
#define VENUS_MIS_GP1DP			0xB124
#define VENUS_MIS_GPDEB			0xB128

/*
 * Venus UART registers.
 */
#define VENUS_MIS_U0RBR_THR_DLL		0xB200
#define VENUS_MIS_U0IER_DLH		0xB204
#define VENUS_MIS_U0IIR_FCR		0xB208
#define VENUS_MIS_U0LCR			0xB20C
#define VENUS_MIS_U0MCR			0xB210
#define VENUS_MIS_U0LSR			0xB214
#define VENUS_MIS_U0MSR			0xB218
#define VENUS_MIS_U0SCR			0xB21C
#define VENUS_MIS_U1RBR_THR_DLL		0xB220
#define VENUS_MIS_U1IER_DLH		0xB224
#define VENUS_MIS_U1IIR_FCR		0xB228
#define VENUS_MIS_U1LCR			0xB22C
#define VENUS_MIS_U1MCR			0xB230
#define VENUS_MIS_U1LSR			0xB234
#define VENUS_MIS_U1MSR			0xB238
#define VENUS_MIS_U1SCR			0xB23C



/*
 * Venus IrDA registers.
 */
#define VENUS_MIS_IR_PSR		0xB400
#define VENUS_MIS_IR_PRE		0xB404
#define VENUS_MIS_IR_SF			0xB408
#define VENUS_MIS_IR_DPIR		0xB40C
#define VENUS_MIS_IR_CR			0xB410
#define VENUS_MIS_IR_RP			0xB414
#define VENUS_MIS_IR_SR			0xB418



/*
 * Venus external timer registers.
 */
#define VENUS_MIS_TC0TVR		0xB500
#define VENUS_MIS_TC1TVR		0xB504
#define VENUS_MIS_TC2TVR		0xB508
#define VENUS_MIS_TC0CVR		0xB50C
#define VENUS_MIS_TC1CVR		0xB510
#define VENUS_MIS_TC2CVR		0xB514
#define VENUS_MIS_TC0CR			0xB518
#define VENUS_MIS_TC1CR			0xB51C
#define VENUS_MIS_TC2CR			0xB520
#define VENUS_MIS_TC0ICR		0xB524
#define VENUS_MIS_TC1ICR		0xB528
#define VENUS_MIS_TC2ICR		0xB52C
#define VENUS_MIS_TCWCR			0xB530
#define VENUS_MIS_TCWTR			0xB534
#define VENUS_MIS_CLK27M_CLK90K_CNT	0xB538
#define VENUS_MIS_CLK90K_TM_LO		0xB53C
#define VENUS_MIS_CLK90K_TM_HI		0xB540

/*
 * Venus VFD registers.
 */
#define VENUS_MIS_VFD_CTL		0xB700
#define VENUS_MIS_VFD_WRCTL		0xB704
#define VENUS_MIS_VFDO			0xB708
#define VENUS_MIS_VFD_ARDCTL 		0xB70C
#define VENUS_MIS_VFD_KPADLIE		0xB710
#define VENUS_MIS_VFD_KPADHIE		0xB714
#define VENUS_MIS_VFD_SWIE		0xB718
#define VENUS_MIS_VFD_ARDKPADL		0xB71C
#define VENUS_MIS_VFD_ARDKPADH		0xB720
#define VENUS_MIS_VFD_ARDSW		0xB724



/*
 * Venus USB registers.
 */
#define VENUS_USB_BASE			0x3000
//Ehci Capability Registers
#define VENUS_USB_EHCI_USBBASE		VENUS_USB_BASE
#define VENUS_USB_EHCI_HCCAPBASE	(VENUS_USB_EHCI_USBBASE+0x00)
#define VENUS_USB_EHCI_HCSPARAMS	(VENUS_USB_EHCI_USBBASE+0x04)
#define VENUS_USB_EHCI_HCCPARAMS	(VENUS_USB_EHCI_USBBASE+0x08)
//Ehci Operational Registers
#define VENUS_USB_EHCI_USBOPBASE	(VENUS_USB_EHCI_USBBASE+0x10)
#define VENUS_USB_EHCI_USBCMD		(VENUS_USB_EHCI_USBOPBASE+0x00)
#define VENUS_USB_EHCI_USBSTS		(VENUS_USB_EHCI_USBOPBASE+0x04)
#define VENUS_USB_EHCI_USBINTR		(VENUS_USB_EHCI_USBOPBASE+0x08)
#define VENUS_USB_EHCI_FRINDEX		(VENUS_USB_EHCI_USBOPBASE+0x0c)
#define VENUS_USB_EHCI_CTRLDSSEGMENT	(VENUS_USB_EHCI_USBOPBASE+0x10)
#define VENUS_USB_EHCI_PERIODICLISTBASE	(VENUS_USB_EHCI_USBOPBASE+0x14)
#define VENUS_USB_EHCI_ASYNCLISTADDR	(VENUS_USB_EHCI_USBOPBASE+0x18)
#define VENUS_USB_EHCI_CONFIGFLAG	(VENUS_USB_EHCI_USBOPBASE+0x40)
#define VENUS_USB_EHCI_PORTSC_0		(VENUS_USB_EHCI_USBOPBASE+0x44)
//Synopsys-Specific Registers
#define VENUS_USB_EHCI_INSNREG00	(VENUS_USB_EHCI_USBOPBASE+0x80)
#define VENUS_USB_EHCI_INSNREG01	(VENUS_USB_EHCI_USBOPBASE+0x84)
#define VENUS_USB_EHCI_INSNREG02	(VENUS_USB_EHCI_USBOPBASE+0x88)
#define VENUS_USB_EHCI_INSNREG03	(VENUS_USB_EHCI_USBOPBASE+0x8c)
#define VENUS_USB_EHCI_INSNREG04	(VENUS_USB_EHCI_USBOPBASE+0x90)
#define VENUS_USB_EHCI_INSNREG05	(VENUS_USB_EHCI_USBOPBASE+0x94)
//Ohci Registers
#define VENUS_USB_OHCI_USBBASE		(VENUS_USB_BASE+0x400)
#define VENUS_USB_OHCI_REVISION		(VENUS_USB_OHCI_USBBASE+0x00)
#define VENUS_USB_OHCI_CONTROL		(VENUS_USB_OHCI_USBBASE+0x04)
#define VENUS_USB_OHCI_COMMAND_STATUS	(VENUS_USB_OHCI_USBBASE+0x08)
#define VENUS_USB_OHCI_INTERRUPT_STATUS	(VENUS_USB_OHCI_USBBASE+0x0c)
#define VENUS_USB_OHCI_INTERRUPT_ENABLE	(VENUS_USB_OHCI_USBBASE+0x10)
#define VENUS_USB_OHCI_INTERRUPT_DISABLE	(VENUS_USB_OHCI_USBBASE+0x14)
#define VENUS_USB_OHCI_HCCA		(VENUS_USB_OHCI_USBBASE+0x18)
#define VENUS_USB_OHCI_PERIOD_CURRENTED	(VENUS_USB_OHCI_USBBASE+0x1c)
#define VENUS_USB_OHCI_CONTROL_HEADED	(VENUS_USB_OHCI_USBBASE+0x20)
#define VENUS_USB_OHCI_CONTROL_CURRENTED	(VENUS_USB_OHCI_USBBASE+0x24)
#define VENUS_USB_OHCI_BULK_HEADED	(VENUS_USB_OHCI_USBBASE+0x28)
#define VENUS_USB_OHCI_BULK_CURRENTED	(VENUS_USB_OHCI_USBBASE+0x2c)
#define VENUS_USB_OHCI_DONE_HEAD	(VENUS_USB_OHCI_USBBASE+0x30)
#define VENUS_USB_OHCI_FM_INTERVAL	(VENUS_USB_OHCI_USBBASE+0x34)
#define VENUS_USB_OHCI_FM_REMAINING	(VENUS_USB_OHCI_USBBASE+0x38)
#define VENUS_USB_OHCI_FM_NUMBER	(VENUS_USB_OHCI_USBBASE+0x3c)
#define VENUS_USB_OHCI_PERIODIC_START	(VENUS_USB_OHCI_USBBASE+0x40)
#define VENUS_USB_OHCI_LS_THRESHOLD	(VENUS_USB_OHCI_USBBASE+0x44)
#define VENUS_USB_OHCI_RH_DESC_A	(VENUS_USB_OHCI_USBBASE+0x48)
#define VENUS_USB_OHCI_RH_DESC_B	(VENUS_USB_OHCI_USBBASE+0x4c)
#define VENUS_USB_OHCI_RH_STATUS	(VENUS_USB_OHCI_USBBASE+0x50)
#define VENUS_USB_OHCI_PORT_STATUS_1	(VENUS_USB_OHCI_USBBASE+0x54)

// USB Host Registers
#define VENUS_USB_HOST_BASE		(VENUS_USB_BASE+0x800)
#define VENUS_USB_HOST_WRAPPER		(VENUS_USB_HOST_BASE+0x00)
#define VENUS_USB_HOST_VSTATUS		(VENUS_USB_HOST_BASE+0x04)
#define VENUS_USB_HOST_USBIP_INPUT	(VENUS_USB_HOST_BASE+0x08)
#define VENUS_USB_HOST_RESET_UTMI	(VENUS_USB_HOST_BASE+0x0c)
#define VENUS_USB_HOST_SELF_LOOP_BACK	(VENUS_USB_HOST_BASE+0x10)

/*
 * Venus RTC registers.
 */
#define VENUS_MIS_RTCSEC		0xB600
#define VENUS_MIS_RTCMIN		0xB604
#define VENUS_MIS_RTCHR			0xB608
#define VENUS_MIS_RTCDATE1		0xB60C
#define VENUS_MIS_RTCDATE2		0xB610
#define VENUS_MIS_ALMMIN		0xB614
#define VENUS_MIS_ALMHR			0xB618
#define VENUS_MIS_ALMDATE1		0xB61C
#define VENUS_MIS_ALMDATE2		0xB620
#define VENUS_MIS_RTCSTOP		0xB624
#define VENUS_MIS_RTCACR		0xB628
#define VENUS_MIS_RTCEN			0xB62C
#define VENUS_MIS_RTCCR			0xB630


/*
 * Defines for the Venus interrupt controller.
 */
#define VENUS_INT_BASE		2
#define VENUS_INT_USB		(VENUS_INT_BASE+0)
#define VENUS_INT_ETH		(VENUS_INT_BASE+0)

#define VENUS_INT_CP		(VENUS_INT_BASE+1)

#define VENUS_INT_1394		(VENUS_INT_BASE+2)
#define VENUS_INT_ATA		(VENUS_INT_BASE+2)

#define VENUS_INT_AUDIO_RISC	(VENUS_INT_BASE+3)
#define VENUS_INT_VIDEO_RISC	(VENUS_INT_BASE+3)
#define VENUS_INT_SB2		(VENUS_INT_BASE+3)
#define VENUS_INT_SE		(VENUS_INT_BASE+3)

#define VENUS_INT_EXTERNAL_TIMER	(VENUS_INT_BASE+4)

#define VENUS_INT_TIMER		(VENUS_INT_BASE+5)
#define VENUS_INT_RTC		(VENUS_INT_BASE+5)


/* Define for Venus Ethernet MAC. */
#define VENUS_ETH_BASE		0xb8016000
#define VENUS_ETH_CR		((volatile unsigned char *)(VENUS_ETH_BASE + 0x3B))
#define VENUS_ETH_IMR		((volatile unsigned short *)(VENUS_ETH_BASE + 0x3C))
#define VENUS_ETH_RCR		((volatile unsigned int *)(VENUS_ETH_BASE + 0x44))
#define VENUS_ETH_MIIAR		((volatile unsigned int *)(VENUS_ETH_BASE + 0x5C))


#endif /* !(_MACH_VENUS_H) */
