# ********************************************************************
# Board Components
# ********************************************************************
# flag                      value
# ********************************************************************

##Board_CPU =               [VENUS | NEPTUNE]
Board_CPU =                 VENUS
##Board_CPU_Package =       [TQFP | BGA]
Board_CPU_Package =         TQFP
##Board_FLASH_Type =        [NOR]
Board_FLASH_Type =          NOR
##Board_FLASH_Support =     [SERIAL | PARALLEL | ALL]
Board_FLASH_Support =       ALL
##Board_DRAM_Block =        [32 | 64]M
Board_DRAM_Block =          64
##Board_DRAM_Number =       [1 | 2]
Board_DRAM_Number =         1
##Board_IDE =               [DEFAULT | NULL]
Board_IDE =                 DEFAULT
##Board_USB_Driver =        [Enabled| Disabled]
Board_USB_Driver =          Enabled
#Board_USB_Driver =          Disabled
##Board_LAN =               [8139CP | NULL]
Board_LAN =                 8139CP
##Board_UART =              [SY16550C]
Board_UART =                SY16550C
##Board_RTC =               [DEFAULT | NULL]
Board_RTC =                 DEFAULT
##Board_VFD =               [DEFAULT | Customize1,2,K | NULL]
Board_VFD =                 NULL
##Board_GPIO =              [DEFAULT | 1262_PVRBOX | venus_avhdd |  NULL]
Board_GPIO =                venus_avhdd
##Board_Product =           [pvrbox|ipcam|avhdd|phviewer|pvr]
#Board_Product =             avhdd
Board_Product =             verona
##Board_Chip_Rev =          [1262|1282]
Board_Chip_Rev =            1261

# ********************************************************************
# GPIO setup
# ********************************************************************
# flag                      value
# ********************************************************************
## GPIO operations are leave to customer in the source code
## Please refer to source code for detailed implementation in
## Custom/gpio_ctrl.c and Custom/gpio_ctrl.h

##GPIO_PSELH =            [User_defined] // address: 1801_b000
##GPIO_PSELL =            [User_defined] // address: 1801_b004
##GPIO_PSEL2 =            [User_defined] // address: 1801_b034
##GPIO_GP0DIR =           [User_defined] // address: 1801_b100
##GPIO_GP1DIR =           [User_defined] // address: 1801_b104
##GPIO_GP0DATO =          [User_defined] // address: 1801_b108
##GPIO_GP1DATO =          [User_defined] // address: 1801_b10c

###---------NEPTUNE Rev A
###GPIO_PSELH =              0x5
###GPIO_PSELL =              0x54140555
###---------NEPTUNE Rev B
#GPIO_PSELH =              0x0
#GPIO_PSELL =              0x00140575
#GPIO_PSEL2 =              0x0
#GPIO_GP0DIR =             0x0
#GPIO_GP1DIR =             0x4c
#GPIO_GP1DATO =            0x8
###---------VENUS
GPIO_PSELH =            0x5
GPIO_PSELL =            0x54000505
GPIO_PSEL2 =            0x0
GPIO_GP0DIR =           0x20000003
GPIO_GP1DIR =           0x6
GPIO_GP0DATO =          0x20000000
GPIO_GP1DATO =          0x4

# ********************************************************************
# Config
# ********************************************************************
# flag                      value
# ********************************************************************
#################################################
## config bootcode parameters' location and size
#################################################

##Config_PLL_Prog =         [TRUE | FALSE]
Config_PLL_Prog =           TRUE
##Config_Param_Position =   [TOP | BOTTOM] TOP: > 0xbfc000000, BOTTOM: < 0xbfc00000
Config_Param_Position =     BOTTOM
##Config_Param_Addr =       [size]!!this variable is dependent on projects
Config_Param_Size =         0x10000

#################################################
## config booting time evaluation
#################################################
##Config_Time_Evaluatino =  [TRUE | FALSE]
Config_Time_Evaluation =    FALSE
##Config_Cache =            [TRUE | FALSE]
Config_Cache =              TRUE

#################################################
## config software reset register
#################################################
##Config_Reset_Assert =     [value]	
Config_Reset_Assert =       0x1002
##Config_Enable_Assert =    [value]
Config_Enable_Assert =      0x202
##Config_Reset_Deassert =   [value]	
Config_Reset_Deassert =     0x7ffff
##Config_Enable_Deassert =  [value]
Config_Enable_Deassert =    0xffff

#################################################
## config HDMI Keys
#################################################
##Config_HDMI_Key1 =  [value]
##Config_HDMI_Key2 =  [value]
##Config_HDMI_Key3 =  [value]
##Config_HDMI_Key4 =  [value]
##Config_HDMI_Key5 =  [value]
##Config_HDMI_Key6 =  [value]

#################################################
## config usb client detecting gpios
#################################################
##Config_USB_DET_GPIO = [value]
Config_USB_DET_GPIO = 28 //detect gpio
##Config_USB_Control_GPIO = [value]
Config_USB_Control_GPIO = 33 //GL811

#################################################
## config SATA Disk detecting gpio
#################################################
##Config_SATA_DET_GPIO = [value]
Config_SATA_DET_GPIO = 27 //sata detect gpio
##Config_SATA_DET_GPIO_Assertion = [0 | 1] //0: active low; 1: active high
Config_SATA_DET_GPIO_Assertion = 0x1          //active high

##Config_SATA_Asserted_GPIO = [value]
Config_SATA_Asserted_GPIO = 0x7
##Config_SATA_Asserted_GPIO_DIR = [0 | 1] //0: input; 1: output
Config_SATA_Asserted_GPIO_DIR = 0x1
##Config_SATA_Asserted_GPIO_Value = [0 | 1] //0: low; 1: high
Config_SATA_Asserted_GPIO_Value = 0x1

##Config_SATA_Deasserted_GPIO = [value]
Config_SATA_Deasserted_GPIO = 0x7
##Config_SATA_Deasserted_GPIO_DIR = [0 | 1] //0: input; 1: output
Config_SATA_Deasserted_GPIO_DIR = 0x1
##Config_SATA_Deasserted_GPIO_Value = [0 | 1] //0: low; 1: high
Config_SATA_Deasserted_GPIO_Value = 0x0

#################################################
## config QC memory test
#################################################
##Config_QC_Test_Prog =		[TRUE | FALSE]
Config_QC_Test_Prog =           TRUE
#Config_QC_Test_Prog =           FALSE

# ********************************************************************
# Boot parameters
# ********************************************************************
# flag                      value
# ********************************************************************

##Param_companyID =         [value]
Param_companyID =           "0000"
##Param_boardID =           [value]
Param_boardID =             "000f"
##Param_version =           [value]
Param_version =             "0003"
##Param_MAC_hi =            mac[0:3]
Param_MAC_hi =              0x00112233
##Param_MAC_lo =            mac[4:5]
Param_MAC_lo =              0x44550000


# ********************************************************************
# Logo attribute
# ********************************************************************
# flag                      value
# ********************************************************************

##Logo_Source =             [FLASH | NULL]
Logo_Source =               FLASH
##Logo_Type =               [NTSC | PAL]
Logo_Type =                 PAL
##Logo_File_Name =          [LOCAL | User_defined]
Logo_File_Name =            "logo_pal.bmp"

##Logo2_Source =            [FLASH | NULL]
#Logo2_Source =              NULL
Logo2_Source =              FLASH
##Logo2_Type =              [NTSC | PAL]
Logo2_Type =                PAL
##Logo2_File_Name =         [LOCAL | User_defined]
Logo2_File_Name =           "logo2_pal.bmp"

##Logo2_Source =            [FLASH | NULL]
Logo3_Source =              FLASH
##Logo2_Type =              [NTSC | PAL]
Logo3_Type =                PAL
##Logo2_File_Name =         [LOCAL | User_defined]
Logo3_File_Name =           "RTD1061_720x576_24bit_USBUpgrade.bmp"

# ********************************************************************
# Rescue Linux attribute
# ********************************************************************
# flag                      value
# ********************************************************************

##Rescue Linux included modules will be configured by Linux Makeconfig, 
##not by boot config. If rescue is included into flash image, 
##user must specify Rescue_Flash_File_Name to identify which 
##rescue should be merged into flash image

##Rescue_Source =           [FLASH | USB | NULL]
#Rescue_Source =             USB
Rescue_Source =             FLASH
##Rescue_Install_Key =      [0x09(TAB) | 0x20(SPACE) | GPIO]
##  if GPIO is set, please also set below 'Rescue_Install_GPIO value
Rescue_Install_Key =        0x09
##Rescue_Install_With_GPIO_Address = [value]
Rescue_Install_With_GPIO_Address = 0xb801b110
##Rescue_Install_With_GPIO_Mask = [value]
Rescue_Install_With_GPIO_Mask = 0x00000100
##Rescue_Install_With_GPIO_Value = [value]
Rescue_Install_With_GPIO_Value = 0x00000000
##Rescue_Loader_Param =     [rescue loading parameters]
Rescue_Loader_Param =       ""
##Rescue_File_Name =        [rescue loading parameters]
#Rescue_File_Name =          vmlinux.rescue.bin.lzma.1261_avhdd
Rescue_File_Name =          vmlinux.rescue.bin.lzma.verona_avhdd

# ********************************************************************
# Linux attribute
# ********************************************************************
# flag                      value
# ********************************************************************
## Disc partition will be created followed 
## by part.txt under the installation disc.

##Linux_Source =            [FLASH | IDE]
Linux_Source =              FLASH
##Linux_Loader_Param =      [linux loading parameters]
Linux_Loader_Param =        "go 803bc000 rootfstype=squashfs root=31:01 mtdparts="

# ********************************************************************
# Shell Setup
# ********************************************************************
# flag                      value
# ********************************************************************

##Shell_Enable =            [YES | NO]
Shell_Enable =              YES
##Cmd_compare =             [On | Off]
Cmd_compare =               On
##Cmd_comptime =            [On]
Cmd_comptime =              On
##Cmd_copy =                [On | Off]
Cmd_copy =                  On
##Cmd_cp0 =                 [On | Off]
Cmd_cp0 =                   Off
##Cmd_cp1 =                 [On | Off]
Cmd_cp1 =                   Off
##Cmd_disk =                [On | Off]
Cmd_disk =                  On
##Cmd_dump =                [On | Off]
Cmd_dump =                  On
##Cmd_erase =               [On | Off]
Cmd_erase =                 On
##Cmd_fill =                [On | Off]
Cmd_fill =                  On
##Cmd_format =              [On | Off]
Cmd_format =                Off
##Cmd_freadwrite =          [On | Off]
Cmd_freadwrite =            On
##Cmd_go =                  [On]
Cmd_go =                    On
##Cmd_help =                [On | Off]
Cmd_help =                  On
##Cmd_info =                [On]
Cmd_info =                  On
##Cmd_iping =               [On | Off]
Cmd_iping =                 On
##Cmd_load =                [On]
Cmd_load =                  On
##Cmd_port =                [On | Off]
Cmd_port =                  On
##Cmd_reset =               [On | Off]
Cmd_reset =                 On
##Cmd_setenv =              [On]
Cmd_setenv =                On
##Cmd_stty =                [On | Off]
Cmd_stty =                  On
##Cmd_test =                [On | Off]
Cmd_test =                  On
##Cmd_continue =            [On | Off]
Cmd_continue =              On

# ********************************************************************
# user defined 
# ********************************************************************
# flag                      value
# ********************************************************************
##User_Defined =            user specified definition
##User_Defined =              ENABLE_CONSOLE_SWITCH
##User_Defined =            ISR   9
##   !!!! attentino !!!! 
##   system_parameters_1 and system_parameters_2 are reserved!!
##   please do not use those two parameter names
##User_Defined =            system_parameters_3 
User_Defined =            system_parameters_3 "POWERKEY_IRRP=0xE51AB649"
User_Defined =            system_parameters_4 "12V5V_GPIO=34,hion"
#User_Defined =            disable_ethernet
