# ********************************************************************
# Directories specifics.
# ********************************************************************

include $(PRJ).inc

# ********************************************************************
# Directories specifics.
# ********************************************************************

ifeq ($(Board_LAN), NULL)
  ETH_DIR			= $(NULL_DIR)
  ETH_INC_DIR		= $(DRIVERS_DIR)/eth/8139cp
else
  ETH_DIR			= $(DRIVERS_DIR)/eth/$(Board_LAN)
  ETH_INC_DIR       = $(ETH_DIR)
endif

FLASH_DIR			= $(DRIVERS_DIR)/flash
USB_DIR				= $(DRIVERS_DIR)/usb

ifeq ($(Board_IDE), NULL)
  IDE_DIR			= $(NULL_DIR)
  IDE_INC_DIR		= $(DRIVERS_DIR)/ide/default
else
  IDE_DIR			= $(DRIVERS_DIR)/ide/$(Board_IDE)
  IDE_INC_DIR		= $(IDE_DIR)
endif

ISO9660_DIR			= $(DRIVERS_DIR)/iso9660
RS232_DIR			= $(DRIVERS_DIR)/rs232/16550c

ifeq ($(Board_RTC), NULL)
  RTC_DIR			= $(NULL_DIR)
  RTC_INC_DIR		= $(DRIVERS_DIR)/rtc/default
else
  RTC_DIR			= $(DRIVERS_DIR)/rtc/$(Board_RTC)
  RTC_INC_DIR		= $(RTC_DIR)
endif

TIMER_DIR			= $(DRIVERS_DIR)/timer

ifeq ($(Board_VFD), NULL)
  VFD_DIR			= $(NULL_DIR)
  VFD_INC_DIR		= $(DRIVERS_DIR)/vfd/default
else
  VFD_DIR			= $(DRIVERS_DIR)/vfd/$(Board_VFD)
  VFD_INC_DIR		= $(VFD_DIR)
endif


# ********************************************************************
# Modules compile specifics.
# ********************************************************************
ETH:
	cd $(ETH_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' TARGET='ETH' OBJ_DIR='$(OBJ_DIR)'\
    	 INCLUDE='$(INCLUDE) -I$(IO_DIR) -I$(SYSCON_DIR) -I$(RS232_DIR) -I$(PLATFORM_INCLUDE_DIR)'

FLASH:
	cd $(FLASH_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)' Board_FLASH_SUPPORT='$(Board_FLASH_SUPPORT)'\
	     INCLUDE='$(INCLUDE) -I$(IO_DIR) -I$(SYSCON_DIR) -I$(RS232_DIR) -I$(PLATFORM_INCLUDE_DIR)'
         
USB:
ifeq ($(Board_USB_Driver), Enabled)
	cd $(USB_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)' \
	     INCLUDE='$(INCLUDE) -I$(IO_DIR) -I$(SYSCON_DIR) -I$(RS232_DIR) -I$(PLATFORM_INCLUDE_DIR)'
endif
         
IDE:
	cd $(IDE_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' TARGET='IDE' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(IO_DIR) -I$(PLATFORM_INCLUDE_DIR) -I$(RS232_DIR)'

ISO9660:
	cd $(ISO9660_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(IO_DIR) -I$(IDE_INC_DIR)'

RS232:
	cd $(RS232_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
	      INCLUDE='$(INCLUDE) -I$(IO_DIR) -I$(SYSCON_DIR) -I$(PLATFORM_INCLUDE_DIR)'

RTC:
	cd $(RTC_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' TARGET='RTC' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(PLATFORM_INCLUDE_DIR)'

TIMER:
	cd $(TIMER_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)'\
	     OBJ_DIR='$(OBJ_DIR)' INCLUDE='$(INCLUDE) -I$(RTC_INC_DIR) -I$(PLATFORM_INCLUDE_DIR)'

VFD:
	cd $(VFD_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' TARGET='VFD' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(PLATFORM_INCLUDE_DIR) -I$(IO_DIR) -I$(RS232_DIR)'

