# ********************************************************************
# Include specifics.
# ********************************************************************

include $(PRJ).inc

# ********************************************************************
# Toolchain specifics.
# ********************************************************************
TOOLCHAIN   = sde

ifeq ($(TOOLCHAIN), sde)
  CROSS-COMPILE = sde-
else
  CROSS-COMPILE = mipsisa32-elf-
endif

# Tool-chain used for compilation of target code (cygnus or sde).
CC      = $(CROSS-COMPILE)gcc
LD      = $(CROSS-COMPILE)ld
OBJDUMP = $(CROSS-COMPILE)objdump
OBJCOPY = $(CROSS-COMPILE)objcopy
STRIP   = $(CROSS-COMPILE)STRIP

PERL    = perl
RM      = rm -rf
CD      = cd
CAT     = cat
CP      = cp

# ********************************************************************
# Directories specifics.
# ********************************************************************
TOP_DIR         = $(shell cd ..; pwd)
BIN_DIR         = $(TOP_DIR)/bin
IMAGE_DIR       = $(BIN_DIR)/image
LINK_DIR        = $(BIN_DIR)/link
OBJ_DIR         = $(BIN_DIR)/obj
TMP_DIR         = $(BIN_DIR)/tmp

SRC_DIR         = $(TOP_DIR)/src
APPS_DIR        = $(SRC_DIR)/apps
DRIVERS_DIR     = $(SRC_DIR)/drivers
INCLUDE_DIR     = $(SRC_DIR)/include
LIB_DIR         = $(SRC_DIR)/lib
LZMA_DIR        = $(LIB_DIR)/lzma

FS_DIR		= $(SRC_DIR)/fs


USERS_DIR       = $(SRC_DIR)/users

TOOLS_DIR       = $(TOP_DIR)/tools

CONFIGCONV_DIR  = $(TOOLS_DIR)/configconv

FLASH_IMAGE_MAKER_DIR = $(TOOLS_DIR)/flash_image_maker

SCRIPT_DIR      = $(TOOLS_DIR)/script

NULL_DIR        = $(TOOLS_DIR)/null

# ********************************************************************
# Compile Flag specifics.
# ********************************************************************

ifeq ($(Board_CPU), MARS)
  ARCH      = MIPS24KC
else
  ARCH      = MIPS4KEC
endif

CFLAG       = -mips32 -mcpu=4kec -g -O2 -G0 -T text -EL\
              -fno-builtin -fno-inline -Wimplicit -Wformat

AFLAG       = $(CFLAG) -no-traditional-cpp

CDEF        = -DEL

ADEF        = $(CDEF) -D_ASSEMBLER_

INCLUDE     = -I./ -I$(INCLUDE_DIR)


# ********************************************************************
# Modules compile specifics.
# ********************************************************************
LIB:
	cd $(LIB_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
    	 INCLUDE='$(INCLUDE) -I$(RS232_DIR) -I$(PLATFORM_INCLUDE_DIR)'

LZMA:
	cd $(LZMA_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
    	 INCLUDE='$(INCLUDE) -I$(SYSCON_DIR) -I$(PLATFORM_INCLUDE_DIR) -I$(RS232_DIR)'

FS:
ifeq ($(Board_USB_Driver), Enabled)
	cd $(FS_DIR)/disk;\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)' \
	     INCLUDE='$(INCLUDE) -I$(IO_DIR) -I$(SYSCON_DIR) -I$(RS232_DIR) -I$(PLATFORM_INCLUDE_DIR)'
	cd $(FS_DIR)/fat;\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)' \
	     INCLUDE='$(INCLUDE) -I$(IO_DIR) -I$(SYSCON_DIR) -I$(RS232_DIR) -I$(PLATFORM_INCLUDE_DIR)'
endif
         
