# ********************************************************************
# Include specifics.
# ********************************************************************

include $(PRJ).inc

# ********************************************************************
# Directories specifics.
# ********************************************************************
ifeq ($(Board_CPU), MARS)
  CONFIGS_DIR       = $(TOP_DIR)/configs/mars
  PLATFORM_DIR      = $(SRC_DIR)/platform/mars
else
  ifeq ($(Board_CPU), NEPTUNE)
    CONFIGS_DIR     = $(TOP_DIR)/configs/neptune
    PLATFORM_DIR    = $(SRC_DIR)/platform/neptune
  else
    CONFIGS_DIR     = $(TOP_DIR)/configs/venus
    PLATFORM_DIR    = $(SRC_DIR)/platform/venus
  endif
endif

PLATFORM_INCLUDE_DIR	= $(PLATFORM_DIR)/include


# ********************************************************************
# Modules compile specifics.
# ********************************************************************
PLATFORM:
	cd $(PLATFORM_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' CDEF='$(CDEF)' AFLAG='$(AFLAG)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(SYSCON_DIR) -I$(RS232_DIR) -I$(SHELL_DIR) -I$(ENV_DIR) -I$(SYSENV_DIR) -I$(NET_INC_DIR) -I$(IO_DIR) -I$(ETH_INC_DIR)'
