/************************************************************************
 *
 *  logo_525i.c
 *
 *  Belong to logo_disp module
 *
 *  This file implements logo display function in NTSC mode
 *
 ************************************************************************/

/************************************************************************
 *  Include files
 ************************************************************************/

#include <string.h>
#include <sys_api.h>
#include <stdio.h>
#include <extern_param.h>

#include <logo_disp_api.h>
#include <project_config.h>

/************************************************************************
 *  Implementation : Private functions
 ************************************************************************/

#if defined(Logo_Type_NTSC)
void  LOGO_DISP_setup(t_extern_param *logo_param_ptr)
{
	printf("NTSC logo\n");
	LOGO_DISP_525i(logo_param_ptr);
}
#endif


void  LOGO_DISP_525i(t_extern_param *logo)
{
	
// set VO registers

    *(volatile unsigned int *)0xb8005350 = 0xfffffffe ;
    *(volatile unsigned int *)0xb8005350 = 0x3 ;
    *(volatile unsigned int *)0xb8005354 = 0x2cf ;
    *(volatile unsigned int *)0xb8005358 = 0x2ef5df ;
    *(volatile unsigned int *)0xb800535c = 0xffff3210 ;
    *(volatile unsigned int *)0xb8005360 = 0x0 ;


//color lookup table of Sub-Picture , index0~index3

    *(volatile unsigned int *)0xb8005370 = logo->logo_reg_5370; //0x6ba53f ;
    *(volatile unsigned int *)0xb8005374 = logo->logo_reg_5374; //0x6da555 ;
    *(volatile unsigned int *)0xb8005378 = logo->logo_reg_5378; //0x749889 ;
    *(volatile unsigned int *)0xb800537c = logo->logo_reg_537c; //0x8080eb ;
    *(volatile unsigned int *)0xb80053b0 = 0xacf800 ;
    *(volatile unsigned int *)0xb80053b4 = 0x9df800 ;
    *(volatile unsigned int *)0xb80053bc = 0x4000 ;
    *(volatile unsigned int *)0xb80053c0 = 0x0 ;
    *(volatile unsigned int *)0xb80053c4 = 0x0 ;
    *(volatile unsigned int *)0xb80053c8 = 0x0 ;
    *(volatile unsigned int *)0xb80053cc = 0x0 ;
    *(volatile unsigned int *)0xb80053d0 = 0x200 ;
    *(volatile unsigned int *)0xb80053d8 = 0x4000 ;
    *(volatile unsigned int *)0xb80053dc = 0x0 ;
    *(volatile unsigned int *)0xb80053e0 = 0x0 ;
    *(volatile unsigned int *)0xb80053e4 = 0x0 ;
    *(volatile unsigned int *)0xb80053e8 = 0x0 ;
    *(volatile unsigned int *)0xb80053ec = 0x0 ;
    *(volatile unsigned int *)0xb80053f0 = 0x0 ;
    *(volatile unsigned int *)0xb80053f4 = 0x0 ;
    *(volatile unsigned int *)0xb80053f8 = 0x0 ;
    *(volatile unsigned int *)0xb80053fc = 0x400 ;
    *(volatile unsigned int *)0xb8005400 = 0xffd ;
    *(volatile unsigned int *)0xb8005404 = 0xf8f ;
    *(volatile unsigned int *)0xb8005408 = 0xf60 ;
    *(volatile unsigned int *)0xb800540c = 0xf50 ;
    *(volatile unsigned int *)0xb8005410 = 0xfa8 ;
    *(volatile unsigned int *)0xb8005414 = 0x207 ;
    *(volatile unsigned int *)0xb8005418 = 0x30a ;
    *(volatile unsigned int *)0xb800541c = 0x50b ;
    *(volatile unsigned int *)0xb80054b0 = 0x9dfacf ;
    *(volatile unsigned int *)0xb80054e8 = 0x2001400 ;
    *(volatile unsigned int *)0xb80054ec = 0x2001000 ;
    *(volatile unsigned int *)0xb80054f0 = 0x2001400 ;
    *(volatile unsigned int *)0xb80054f4 = 0x2001000 ;
    *(volatile unsigned int *)0xb80054f8 = 0x400 ;
    *(volatile unsigned int *)0xb80054fc = 0x20080200 ;
    *(volatile unsigned int *)0xb8005500 = 0xf010eb10 ;
    *(volatile unsigned int *)0xb8005564 = 0x0 ;
    *(volatile unsigned int *)0xb8005568 = 0x1 ;
    *(volatile unsigned int *)0xb800556c = 0x2 ;
    *(volatile unsigned int *)0xb8005570 = 0x3 ;
    *(volatile unsigned int *)0xb8005574 = 0x4 ;
    *(volatile unsigned int *)0xb8005578 = 0x5 ;
    *(volatile unsigned int *)0xb800557c = 0x6 ;
    *(volatile unsigned int *)0xb8005580 = 0x7 ;
    *(volatile unsigned int *)0xb8005584 = 0x8 ;


//Top and Bot address of Sub-Picture 

    *(volatile unsigned int *)0xb8005530 = 0xf0000 ;
    *(volatile unsigned int *)0xb8005534 = 0xf0000 + logo->logo_offset ;//0xf08dc ;


// set TVE registers

    *(volatile unsigned int *)0xb8000084 = 0x101cd800 ;
    *(volatile unsigned int *)0xb800000c = 0x1 ;
    *(volatile unsigned int *)0xb80180c8 = 0x124 ;
    *(volatile unsigned int *)0xb80180cc = 0x188 ;
    *(volatile unsigned int *)0xb8018134 = 0x278000 ;
    *(volatile unsigned int *)0xb80180d0 = 0x1f8bbb ;
    *(volatile unsigned int *)0xb80180d4 = 0x1f8cbb ;
    *(volatile unsigned int *)0xb80180e8 = 0x1 ;
    *(volatile unsigned int *)0xb8018154 = 0x200 ;
    *(volatile unsigned int *)0xb8018880 = 0x1f ;
    *(volatile unsigned int *)0xb8018884 = 0x7c ;
    *(volatile unsigned int *)0xb8018888 = 0xf0 ;
    *(volatile unsigned int *)0xb801888c = 0x21 ;
    *(volatile unsigned int *)0xb8018890 = 0x0 ;
    *(volatile unsigned int *)0xb8018894 = 0x2 ;
    *(volatile unsigned int *)0xb8018898 = 0x2 ;
    *(volatile unsigned int *)0xb801889c = 0x3f ;
    *(volatile unsigned int *)0xb80188a0 = 0x2 ;
    *(volatile unsigned int *)0xb80188a8 = 0x8d ;
    *(volatile unsigned int *)0xb80188ac = 0x78 ;
    *(volatile unsigned int *)0xb80188b0 = 0x10 ;
    *(volatile unsigned int *)0xb80188b4 = 0x7 ;
    *(volatile unsigned int *)0xb80188b8 = 0x1c ;
    *(volatile unsigned int *)0xb80188b8 = 0x1c ;
    *(volatile unsigned int *)0xb8018984 = 0x20 ;
    *(volatile unsigned int *)0xb801898c = 0x2 ;
    *(volatile unsigned int *)0xb80188bc = 0x0 ;
    *(volatile unsigned int *)0xb80188c8 = 0xc8 ;
    *(volatile unsigned int *)0xb80188cc = 0x0 ;
    *(volatile unsigned int *)0xb80188d0 = 0x0 ;
    *(volatile unsigned int *)0xb80188e0 = 0x8 ;
    *(volatile unsigned int *)0xb80188e4 = 0x31 ;
    *(volatile unsigned int *)0xb80188e8 = 0x6 ;
    *(volatile unsigned int *)0xb80188ec = 0x6 ;
    *(volatile unsigned int *)0xb80188f0 = 0xb3 ;
    *(volatile unsigned int *)0xb80188f4 = 0x3 ;
    *(volatile unsigned int *)0xb80188f8 = 0x59 ;
    *(volatile unsigned int *)0xb80189c0 = 0x64 ;
    *(volatile unsigned int *)0xb80189c4 = 0x2d ;
    *(volatile unsigned int *)0xb80189c8 = 0x7 ;
    *(volatile unsigned int *)0xb80189cc = 0x14 ;
    *(volatile unsigned int *)0xb8018920 = 0x0 ;
    *(volatile unsigned int *)0xb8018924 = 0x3a ;
    *(volatile unsigned int *)0xb8018928 = 0x11 ;
    *(volatile unsigned int *)0xb801892c = 0x4b ;
    *(volatile unsigned int *)0xb8018930 = 0x11 ;
    *(volatile unsigned int *)0xb8018934 = 0x3c ;
    *(volatile unsigned int *)0xb8018938 = 0x1b ;
    *(volatile unsigned int *)0xb801893c = 0x1b ;
    *(volatile unsigned int *)0xb8018940 = 0x24 ;
    *(volatile unsigned int *)0xb8018944 = 0x7 ;
    *(volatile unsigned int *)0xb8018948 = 0xf8 ;
    *(volatile unsigned int *)0xb801894c = 0x0 ;
    *(volatile unsigned int *)0xb8018950 = 0x0 ;
    *(volatile unsigned int *)0xb8018954 = 0xf ;
    *(volatile unsigned int *)0xb8018958 = 0xf ;
    *(volatile unsigned int *)0xb801895c = 0x60 ;
    *(volatile unsigned int *)0xb8018960 = 0xa0 ;
    *(volatile unsigned int *)0xb8018964 = 0x54 ;
    *(volatile unsigned int *)0xb8018968 = 0xff ;
    *(volatile unsigned int *)0xb801896c = 0x3 ;
    *(volatile unsigned int *)0xb80180d8 = 0x40 ;
    *(volatile unsigned int *)0xb8018990 = 0x10 ;
    *(volatile unsigned int *)0xb80189d0 = 0xc ;
    *(volatile unsigned int *)0xb80189d4 = 0x4b ;
    *(volatile unsigned int *)0xb80189d8 = 0x7a ;
    *(volatile unsigned int *)0xb80189dc = 0x2b ;
    *(volatile unsigned int *)0xb80189e0 = 0x85 ;
    *(volatile unsigned int *)0xb80189e4 = 0xaa ;
    *(volatile unsigned int *)0xb80189e8 = 0x5a ;
    *(volatile unsigned int *)0xb80189ec = 0x62 ;
    *(volatile unsigned int *)0xb80189f0 = 0x84 ;
    *(volatile unsigned int *)0xb8018000 = 0xae832359 ;
    *(volatile unsigned int *)0xb8018004 = 0x306505 ;
    *(volatile unsigned int *)0xb80180ac = 0xe0b59 ;
    *(volatile unsigned int *)0xb8018048 = 0x8212353 ;
    *(volatile unsigned int *)0xb8018050 = 0x815904 ;
    *(volatile unsigned int *)0xb8018054 = 0x91ca0b ;
    *(volatile unsigned int *)0xb801804c = 0x8222358 ;
    *(volatile unsigned int *)0xb8018058 = 0x82aa09 ;
    *(volatile unsigned int *)0xb80180c4 = 0x7ec00 ;
    *(volatile unsigned int *)0xb80180ec = 0x19 ;
    *(volatile unsigned int *)0xb80180ec = 0x6 ;
    *(volatile unsigned int *)0xb80180ec = 0x11 ;
    *(volatile unsigned int *)0xb80180f0 = 0x22d484 ;
    *(volatile unsigned int *)0xb8018098 = 0x6a081000 ;
    *(volatile unsigned int *)0xb801809c = 0x27e1040 ;
    *(volatile unsigned int *)0xb8018148 = 0xa56d0d0 ;
    *(volatile unsigned int *)0xb8018040 = 0x1 ;
    *(volatile unsigned int *)0xb80180d8 = 0x3fe ;
    *(volatile unsigned int *)0xb80180d8 = 0x3ab ;
    *(volatile unsigned int *)0xb8018140 = 0x3fff000 ;
    *(volatile unsigned int *)0xb8018144 = 0x3fff000 ;
    *(volatile unsigned int *)0xb80180a8 = 0xff4810 ;
    *(volatile unsigned int *)0xb80180ac = 0x8ff359 ;
    *(volatile unsigned int *)0xb8018150 = 0x4c80 ;
    *(volatile unsigned int *)0xb8018084 = 0x8000886e ;
    *(volatile unsigned int *)0xb8018088 = 0x80008000 ;
    *(volatile unsigned int *)0xb801808c = 0x8df4937c ;
    *(volatile unsigned int *)0xb8018090 = 0xa014fd50 ;
    *(volatile unsigned int *)0xb8018110 = 0x200e ;
    *(volatile unsigned int *)0xb8018094 = 0x8845805f ;
    *(volatile unsigned int *)0xb80180fc = 0x27e1804 ;
    *(volatile unsigned int *)0xb80180a4 = 0x8202352 ;
    *(volatile unsigned int *)0xb8018100 = 0x909803 ;
    *(volatile unsigned int *)0xb8018104 = 0x800816 ;
    *(volatile unsigned int *)0xb8018108 = 0x90691d ;
    *(volatile unsigned int *)0xb80180a0 = 0x7e ;
    *(volatile unsigned int *)0xb8018000 = 0x30000000 ;


/* MV OFF Start. */
    *(volatile unsigned int *)0xB8018920 = 0x0 ;      
    *(volatile unsigned int *)0xB8018924 = 0x0 ;     
    *(volatile unsigned int *)0xB8018928 = 0x0 ;     
    *(volatile unsigned int *)0xB801892C = 0x0 ;     
    *(volatile unsigned int *)0xB8018930 = 0x0 ;     
    *(volatile unsigned int *)0xB8018934 = 0x0 ;     
    *(volatile unsigned int *)0xB8018938 = 0x0 ;     
    *(volatile unsigned int *)0xB801893C = 0x0 ;     
    *(volatile unsigned int *)0xB8018940 = 0x0 ;     
    *(volatile unsigned int *)0xB8018944 = 0x0 ;      
    *(volatile unsigned int *)0xB8018948 = 0x0 ;     
    *(volatile unsigned int *)0xB801894C = 0x0 ;      
    *(volatile unsigned int *)0xB8018950 = 0x0 ;      
    *(volatile unsigned int *)0xB8018954 = 0x0 ;      
    *(volatile unsigned int *)0xB8018958 = 0x0 ;      
    *(volatile unsigned int *)0xB801895C = 0x0 ;     
    *(volatile unsigned int *)0xB8018960 = 0x0 ;     
    *(volatile unsigned int *)0xB8018964 = 0x0 ;     
    *(volatile unsigned int *)0xB8018968 = 0x0 ;     
    *(volatile unsigned int *)0xB801896C = 0x0 ;      
    *(volatile unsigned int *)0xB8018990 = 0x0 ; 
    *(volatile unsigned int *)0xB8018068 = 0x0 ;  
/* MV OFF End. */

// disable TVE colorbar, enable interrupt

    *(volatile unsigned int *)0xb80180ec = 0x10 ;
    *(volatile unsigned int *)0xb8005504 = 0xfffffffe ;
    *(volatile unsigned int *)0xb8005504 = 0xb ;
    *(volatile unsigned int *)0xb801810c = 0xa00a000 ;
    *(volatile unsigned int *)0xb80180e0 = 0x0 ;
    *(volatile unsigned int *)0xb80055e4 = 0x9 ;
    *(volatile unsigned int *)0xb80180dc = 0x1 ;

}

