/************************************************************************
 *
 *  logo_525i.c
 *
 *  Belong to logo_disp module
 *
 *  This file implements logo display function in NTSC mode
 *
 ************************************************************************/

/************************************************************************
 *  Include files
 ************************************************************************/

#include <string.h>
#include <sys_api.h>
#include <stdio.h>
#include <extern_param.h>

#include <logo_disp_api.h>
#include <project_config.h>

/************************************************************************
 *  Implementation : Private functions
 ************************************************************************/

#if defined(Logo_Type_NTSC)
void  LOGO_DISP_setup(t_extern_param *logo_param_ptr)
{
	printf("NTSC logo\n");
	LOGO_DISP_525p(logo_param_ptr);
}
#endif


void  LOGO_DISP_525p(t_extern_param *logo)
{
	
// set VO registers

    *(volatile unsigned int *)0xb8005350 = 0xfffffffe ;
    *(volatile unsigned int *)0xb8005350 = 0x3 ;
    *(volatile unsigned int *)0xb8005354 = 0x2cf ;
    *(volatile unsigned int *)0xb8005358 = 0x2ef5df ;
    *(volatile unsigned int *)0xb800535c = 0xffff3210 ;
    *(volatile unsigned int *)0xb8005360 = 0x0 ;


//color lookup table of Sub-Picture , index0~index3

    *(volatile unsigned int *)0xb8005370 = logo->logo_reg_5370; //0x6ba53f ;
    *(volatile unsigned int *)0xb8005374 = logo->logo_reg_5374; //0x6da555 ;
    *(volatile unsigned int *)0xb8005378 = logo->logo_reg_5378; //0x749889 ;
    *(volatile unsigned int *)0xb800537c = logo->logo_reg_537c; //0x8080eb ;
    *(volatile unsigned int *)0xb80053b0 = 0xacf800 ;
    *(volatile unsigned int *)0xb80053b4 = 0x9df800 ;
    *(volatile unsigned int *)0xb80053bc = 0x4000 ;
    *(volatile unsigned int *)0xb80053c0 = 0x0 ;
    *(volatile unsigned int *)0xb80053c4 = 0x0 ;
    *(volatile unsigned int *)0xb80053c8 = 0x0 ;
    *(volatile unsigned int *)0xb80053cc = 0x0 ;
    *(volatile unsigned int *)0xb80053d0 = 0x200 ;
    *(volatile unsigned int *)0xb80053d8 = 0x4000 ;
    *(volatile unsigned int *)0xb80053dc = 0x0 ;
    *(volatile unsigned int *)0xb80053e0 = 0x0 ;
    *(volatile unsigned int *)0xb80053e4 = 0x0 ;
    *(volatile unsigned int *)0xb80053e8 = 0x0 ;
    *(volatile unsigned int *)0xb80053ec = 0x0 ;
    *(volatile unsigned int *)0xb80053f0 = 0x0 ;
    *(volatile unsigned int *)0xb80053f4 = 0x0 ;
    *(volatile unsigned int *)0xb80053f8 = 0x0 ;
    *(volatile unsigned int *)0xb80053fc = 0x400 ;
    *(volatile unsigned int *)0xb8005400 = 0xffd ;
    *(volatile unsigned int *)0xb8005404 = 0xf8f ;
    *(volatile unsigned int *)0xb8005408 = 0xf60 ;
    *(volatile unsigned int *)0xb800540c = 0xf50 ;
    *(volatile unsigned int *)0xb8005410 = 0xfa8 ;
    *(volatile unsigned int *)0xb8005414 = 0x207 ;
    *(volatile unsigned int *)0xb8005418 = 0x30a ;
    *(volatile unsigned int *)0xb800541c = 0x50b ;
    *(volatile unsigned int *)0xb80054b0 = 0x9dfacf ;
    *(volatile unsigned int *)0xb80054e8 = 0x2001400 ;
    *(volatile unsigned int *)0xb80054ec = 0x2001000 ;
    *(volatile unsigned int *)0xb80054f0 = 0x2001400 ;
    *(volatile unsigned int *)0xb80054f4 = 0x2001000 ;
    *(volatile unsigned int *)0xb80054f8 = 0x400 ;
    *(volatile unsigned int *)0xb80054fc = 0x20080200 ;
    *(volatile unsigned int *)0xb8005500 = 0xf010eb10 ;
    *(volatile unsigned int *)0xb8005564 = 0x0 ;
    *(volatile unsigned int *)0xb8005568 = 0x1 ;
    *(volatile unsigned int *)0xb800556c = 0x2 ;
    *(volatile unsigned int *)0xb8005570 = 0x3 ;
    *(volatile unsigned int *)0xb8005574 = 0x4 ;
    *(volatile unsigned int *)0xb8005578 = 0x5 ;
    *(volatile unsigned int *)0xb800557c = 0x6 ;
    *(volatile unsigned int *)0xb8005580 = 0x7 ;
    *(volatile unsigned int *)0xb8005584 = 0x8 ;


//Top and Bot address of Sub-Picture 

    *(volatile unsigned int *)0xb8005530 = 0xf0000 ;
    *(volatile unsigned int *)0xb8005534 = 0xf0000 + logo->logo_offset ;//0xf08dc ;


// set TVE registers

    *(volatile unsigned int *)0xB80180C8 = 0x12D;     
    *(volatile unsigned int *)0xB80180CC = 0x188;     
    *(volatile unsigned int *)0xB8018134 = 0x278000;  
    *(volatile unsigned int *)0xB80180D0 = 0x1F9AAA;  
    *(volatile unsigned int *)0xB80180D4 = 0x1F9AAA;  
    *(volatile unsigned int *)0xB80180E8 = 0x1;       
    *(volatile unsigned int *)0xB8018154 = 0x200;     
    *(volatile unsigned int *)0xB8018880 = 0x1F;      
    *(volatile unsigned int *)0xB8018884 = 0x7C;      
    *(volatile unsigned int *)0xB8018888 = 0xF0;      
    *(volatile unsigned int *)0xB801888C = 0x21;      
    *(volatile unsigned int *)0xB8018890 = 0x0;       
    *(volatile unsigned int *)0xB8018894 = 0x2;       
    *(volatile unsigned int *)0xB8018898 = 0x2;       
    *(volatile unsigned int *)0xB801889C = 0x3F;      
    *(volatile unsigned int *)0xB80188A0 = 0x2;       
    *(volatile unsigned int *)0xB80188A8 = 0x8D;      
    *(volatile unsigned int *)0xB80188AC = 0x78;      
    *(volatile unsigned int *)0xB80188B0 = 0x10;      
    *(volatile unsigned int *)0xB80188B4 = 0x7;       
    *(volatile unsigned int *)0xB80188B8 = 0x1C;      
    *(volatile unsigned int *)0xB80188B8 = 0x1C;      
    *(volatile unsigned int *)0xB8018984 = 0x20;      
    *(volatile unsigned int *)0xB801898C = 0x2;       
    *(volatile unsigned int *)0xB80188BC = 0x0;       
    *(volatile unsigned int *)0xB80188C8 = 0xC8;      
    *(volatile unsigned int *)0xB80188CC = 0x0;       
    *(volatile unsigned int *)0xB80188D0 = 0x0;       
    *(volatile unsigned int *)0xB80188E0 = 0x8;       
    *(volatile unsigned int *)0xB80188E4 = 0x31;      
    *(volatile unsigned int *)0xB80188E8 = 0x6;       
    *(volatile unsigned int *)0xB80188EC = 0x6;       
    *(volatile unsigned int *)0xB80188F0 = 0xB3;      
    *(volatile unsigned int *)0xB80188F4 = 0x3;       
    *(volatile unsigned int *)0xB80188F8 = 0x59;      
    *(volatile unsigned int *)0xB80189C0 = 0x64;      
    *(volatile unsigned int *)0xB80189C4 = 0x2D;      
    *(volatile unsigned int *)0xB80189C8 = 0x7;       
    *(volatile unsigned int *)0xB80189CC = 0x14;      
    *(volatile unsigned int *)0xB8018920 = 0x0;       
    *(volatile unsigned int *)0xB8018924 = 0x3A;      
    *(volatile unsigned int *)0xB8018928 = 0x11;      
    *(volatile unsigned int *)0xB801892C = 0x4B;      
    *(volatile unsigned int *)0xB8018930 = 0x11;      
    *(volatile unsigned int *)0xB8018934 = 0x3C;      
    *(volatile unsigned int *)0xB8018938 = 0x1B;      
    *(volatile unsigned int *)0xB801893C = 0x1B;      
    *(volatile unsigned int *)0xB8018940 = 0x24;      
    *(volatile unsigned int *)0xB8018944 = 0x7;       
    *(volatile unsigned int *)0xB8018948 = 0xF8;      
    *(volatile unsigned int *)0xB801894C = 0x0;       
    *(volatile unsigned int *)0xB8018950 = 0x0;       
    *(volatile unsigned int *)0xB8018954 = 0xF;       
    *(volatile unsigned int *)0xB8018958 = 0xF;       
    *(volatile unsigned int *)0xB801895C = 0x60;      
    *(volatile unsigned int *)0xB8018960 = 0xA0;      
    *(volatile unsigned int *)0xB8018964 = 0x54;      
    *(volatile unsigned int *)0xB8018968 = 0xFF;      
    *(volatile unsigned int *)0xB801896C = 0x3;       
    *(volatile unsigned int *)0xB80180D8 = 0x40;      
    *(volatile unsigned int *)0xB8018990 = 0x0;       
    *(volatile unsigned int *)0xB80189D0 = 0xC;       
    *(volatile unsigned int *)0xB80189D4 = 0x4B;      
    *(volatile unsigned int *)0xB80189D8 = 0x7A;      
    *(volatile unsigned int *)0xB80189DC = 0x2B;      
    *(volatile unsigned int *)0xB80189E0 = 0x85;      
    *(volatile unsigned int *)0xB80189E4 = 0xAA;      
    *(volatile unsigned int *)0xB80189E8 = 0x5A;      
    *(volatile unsigned int *)0xB80189EC = 0x62;      
    *(volatile unsigned int *)0xB80189F0 = 0x84;      
    *(volatile unsigned int *)0xB8018000 = 0x2A832359;
    *(volatile unsigned int *)0xB8018004 = 0x306505;  
    *(volatile unsigned int *)0xB80180AC = 0xE0B16;   
    *(volatile unsigned int *)0xB8018048 = 0x8106310; 
    *(volatile unsigned int *)0xB8018050 = 0x815904;  
    *(volatile unsigned int *)0xB8018054 = 0x91CA0B;  
    *(volatile unsigned int *)0xB801804C = 0x820A352; 
    *(volatile unsigned int *)0xB8018058 = 0x82AA09;  
    *(volatile unsigned int *)0xB80180C4 = 0x7EC00;   
    *(volatile unsigned int *)0xB80180EC = 0x19;      
    *(volatile unsigned int *)0xB80180EC = 0x6;       
    *(volatile unsigned int *)0xB80180EC = 0x1;       
    *(volatile unsigned int *)0xB80180F0 = 0x22D43F;  
    *(volatile unsigned int *)0xB80180F4 = 0x22CC88;  
    *(volatile unsigned int *)0xB8018084 = 0x80009404;
    *(volatile unsigned int *)0xB8018088 = 0x80008000;
    *(volatile unsigned int *)0xB801808C = 0x93929392;
    *(volatile unsigned int *)0xB8018090 = 0x8C708D40;
    *(volatile unsigned int *)0xB8018110 = 0xC70;     
    *(volatile unsigned int *)0xB8018094 = 0x80008000;
    *(volatile unsigned int *)0xB80180FC = 0x27E1800; 
    *(volatile unsigned int *)0xB80180A8 = 0x7F4800;  
    *(volatile unsigned int *)0xB8018098 = 0x6A0817A0;
    *(volatile unsigned int *)0xB801809C = 0x28A1BB0; 
    *(volatile unsigned int *)0xB8018148 = 0xE56D0D0; 
    *(volatile unsigned int *)0xB801814C = 0x40;      
    *(volatile unsigned int *)0xB8018040 = 0x1;       
    *(volatile unsigned int *)0xB8018044 = 0x20E0024E;
    *(volatile unsigned int *)0xB801805C = 0x804232A; 
    *(volatile unsigned int *)0xB8018060 = 0x9AB;     
    *(volatile unsigned int *)0xB80180D8 = 0x7FE;     
    *(volatile unsigned int *)0xB80180D8 = 0x32B;     
    *(volatile unsigned int *)0xB80180A4 = 0x8216359; 
    *(volatile unsigned int *)0xB8018100 = 0xBE8800;  
    *(volatile unsigned int *)0xB8018104 = 0xA0C82C;  
    *(volatile unsigned int *)0xB8018108 = 0xBE8BE8;  
    *(volatile unsigned int *)0xB80180A0 = 0x7E;      
    *(volatile unsigned int *)0xB80180A0 = 0x2F;      
    *(volatile unsigned int *)0xB8018000 = 0x30000000;


/* MV OFF Start. */
    *(volatile unsigned int *)0xB8018920 = 0x0 ;      
    *(volatile unsigned int *)0xB8018924 = 0x0 ;     
    *(volatile unsigned int *)0xB8018928 = 0x0 ;     
    *(volatile unsigned int *)0xB801892C = 0x0 ;     
    *(volatile unsigned int *)0xB8018930 = 0x0 ;     
    *(volatile unsigned int *)0xB8018934 = 0x0 ;     
    *(volatile unsigned int *)0xB8018938 = 0x0 ;     
    *(volatile unsigned int *)0xB801893C = 0x0 ;     
    *(volatile unsigned int *)0xB8018940 = 0x0 ;     
    *(volatile unsigned int *)0xB8018944 = 0x0 ;      
    *(volatile unsigned int *)0xB8018948 = 0x0 ;     
    *(volatile unsigned int *)0xB801894C = 0x0 ;      
    *(volatile unsigned int *)0xB8018950 = 0x0 ;      
    *(volatile unsigned int *)0xB8018954 = 0x0 ;      
    *(volatile unsigned int *)0xB8018958 = 0x0 ;      
    *(volatile unsigned int *)0xB801895C = 0x0 ;     
    *(volatile unsigned int *)0xB8018960 = 0x0 ;     
    *(volatile unsigned int *)0xB8018964 = 0x0 ;     
    *(volatile unsigned int *)0xB8018968 = 0x0 ;     
    *(volatile unsigned int *)0xB801896C = 0x0 ;      
    *(volatile unsigned int *)0xB8018990 = 0x0 ; 
    *(volatile unsigned int *)0xB8018068 = 0x0 ;  
/* MV OFF End. */

// disable TVE colorbar, enable interrupt

    *(volatile unsigned int *)0xb80180ec = 0x18 ;				//525i is set to 0x10
    *(volatile unsigned int *)0xb8005504 = 0xfffffffe ;
    *(volatile unsigned int *)0xb8005504 = 0xf ;				//525i is set to 0xb
    *(volatile unsigned int *)0xb801810c = 0xa00a000 ;
    *(volatile unsigned int *)0xb80180e0 = 0x0 ;
    *(volatile unsigned int *)0xb80055e4 = 0x9 ;
    *(volatile unsigned int *)0xb80180dc = 0x1 ;

//set HDMI chip
	I2C_INIT1();//Brian 0912
	BusyWaiting1(70000);//Brian 0912
	SET_HDMI_480P();//Brian 0912
	BusyWaiting1(70000);//Brian 0912

}



void I2C_Write1(unsigned int addr, unsigned int *array)
{
	int n;
	unsigned int *interrupt;
	*(volatile unsigned int *)0xb801b36c = 0x0 ;//disable i2c
	*(volatile unsigned int *)0xb801b304 = addr&0x0ff;
	*(volatile unsigned int *)0xb801b36c = 0x1;//enable i2c
	interrupt=(void *)0xb801b334;
	for (n = 1; n <= array[0]; n++)
	{
	 while((*interrupt&0x00000010)!=0x10)		//wait for Tx empty
		wait();
		BusyWaiting1(7000);
	 *(volatile unsigned int *)0xb801b310=array[n]&0x0ff;

	}
}

void I2C_INIT1()
{
	*(volatile unsigned int *)0xb801b36c = 0x0 ;//disable i2c
	*(volatile unsigned int *)0xb801b300 = 0x63;//slave disabled, restart enabled, 7-bit addressing, standard mode, master enabled
	*(volatile unsigned int *)0xb801b330 = 0x0;//mask all interrupt
	*(volatile unsigned int *)0xb801b338 = 0x0;//Rx FIFO threshold 1
	*(volatile unsigned int *)0xb801b33c = 0x8;//Tx FIFO threshold 8
	*(volatile unsigned int *)0xb801b36c = 0x1;//enable i2c
}

void wait()
{
	int i;
	for(i=0; i<100000; i++) {}
}

void BusyWaiting1(UINT32 count)
{
	UINT32 i=0;

	for(i = 0; i < count;)
	   i++;
}


void SET_HDMI_480P()
{
	unsigned int   I2CBUF[5];
	UINT32 i=0;
	UINT32 i2c_addr=0x52;	
   	 //552
unsigned int P480[]={
0xff, 0x0,
 0x1, 0x0,
 0xa, 0x0,
 0xb, 0x0,
 0xc, 0x1,
 0xf, 0x0,
 0x10, 0x80,
 0x11, 0x0,
 0x12, 0x1,
 0x15, 0x0,
 0x16, 0x1,
 0x17, 0x0,
 0x18, 0xff,
 0x19, 0xff,
 0x1a, 0xff,
 0x1b, 0x0,
 0x1c, 0x0,
 0x1d, 0x0,
 0x1e, 0xff,
 0x1f, 0x0,
 0x20, 0x23,
 0x21, 0x50,
 0x22, 0x14,
 0x23, 0x8f,
 0x24, 0xc,
 0x25, 0x0,
 0x80, 0x5,
 0x81, 0x0,
 0x82, 0x0,
 0x83, 0x6,
 0x84, 0x0,
 0x85, 0x6,
 0x86, 0x0,
 0x87, 0x2,
 0x88, 0x0,
 0x89, 0x6,
 0x8a, 0x92,
 0x8b, 0x7,
 0x8c, 0x50,
 0x8d, 0x2,
 0x8e, 0x0,
 0x8f, 0x2,
 0x90, 0xce,
 0x91, 0x0,
 0x92, 0x0,
 0x93, 0x2,
 0x94, 0x0,
 0x95, 0x0,
 0x96, 0x0,
 0x97, 0x3,
 0x98, 0x8c,
 0x99, 0x0,
 0x9a, 0x0,
 0x9b, 0x0,
 0x9c, 0x0,
 0x9d, 0x0,
 0x9e, 0x0,
 0xa0, 0x1,
 0xa1, 0x0,
 0xa2, 0x8d,
 0xa3, 0x0,
 0xa4, 0x2b,
 0xa5, 0x0,
 0xa6, 0x0,
 0xa7, 0x0,
 0xa8, 0x0,
 0xa9, 0x0,
 0xaa, 0x0,
 0xab, 0x0,
 0xac, 0x0,
 0xad, 0x0,
 0xae, 0x0,
 0xaf, 0x0,
 0xb0, 0x0,
 0xb1, 0x0,
 0xb2, 0x0,
 0xb3, 0x0,
 0xb4, 0x0,
 0xb5, 0x0,
 0xb6, 0x0,
 0xb7, 0x0,
 0xb8, 0x0,
 0xb9, 0x0,
 0xba, 0x0,
 0xbb, 0x0,
 0xbc, 0x0,
 0xbd, 0x0,
 0xbe, 0x0,
 0xbf, 0x0,
 0xc0, 0x0,
 0xc1, 0x0,
 0xc2, 0x0,
 0xc3, 0x0,
 0xc4, 0x0,
 0xc5, 0x0,
 0xc6, 0x0,
 0xc7, 0x0,
 0xc8, 0x0,
 0xca, 0x40,
 0xcb, 0x0,
 0xcc, 0x0,
 0xcd, 0x0,
 0xce, 0x0,
 0xcf, 0x0,
 0xd0, 0x11,
 0xd1, 0x7a,
 0xe4, 0x0,
 0xe5, 0x48,
 0xe8, 0x80,
 0xe9, 0x75,
 0xea, 0x30,
 0xeb, 0x0,
 0xec, 0x0,
 0xee, 0x3,
 0xef, 0x1b,
 0xf0, 0x0,
 0xf1, 0x2,
 0xf2, 0x2,
 0xf5, 0x0,
 0xf8, 0x0,
 0xf9, 0x60,
 0xfc, 0x0,
 0xfd, 0x2,
 0xfe, 0xa1,
 0xff, 0x1,
 0x0, 0x0,
 0x1, 0x0,
 0x2, 0x0,
 0x3, 0x0,
 0x4, 0x0,
 0x5, 0x0,
 0x6, 0x0,
 0x7, 0x0,
 0x8, 0x0,
 0x9, 0x0,
 0xa, 0x0,
 0xb, 0x0,
 0xc, 0x0,
 0xd, 0x0,
 0x1b, 0x0,
 0x1c, 0x0,
 0x1d, 0x0,
 0x1e, 0x0,
 0x1f, 0x0,
 0x20, 0x0,
 0x21, 0x0,
 0x22, 0x0,
 0x23, 0x0,
 0x24, 0x0,
 0x25, 0x0,
 0x26, 0x0,
 0x27, 0x0,
 0x28, 0x0,
 0x29, 0x0,
 0x2a, 0x0,
 0x2b, 0x0,
 0x2c, 0x0,
 0x2d, 0x0,
 0x2e, 0x0,
 0x2f, 0x0,
 0x30, 0x0,
 0x31, 0x0,
 0x32, 0x0,
 0x33, 0x0,
 0x34, 0x0,
 0x35, 0x0,
 0x36, 0x0,
 0x37, 0x0,
 0x38, 0x0,
 0x39, 0x0,
 0x3a, 0x0,
 0x3b, 0x0,
 0x3c, 0x0,
 0x3d, 0x0,
 0x3e, 0x0,
 0x3f, 0x0,
 0x40, 0x0,
 0x41, 0x0,
 0x42, 0x0,
 0x43, 0x0,
 0x44, 0x0,
 0x45, 0x0,
 0x46, 0x0,
 0x47, 0x0,
 0x48, 0x0,
 0xa0, 0x0,
 0xa1, 0x0,
 0xa2, 0x0,
 0xa3, 0x0,
 0xa4, 0x0,
 0xa5, 0x0,
 0xa6, 0x0,
 0xa7, 0x0,
 0xa8, 0x0,
 0xbd, 0x0,
 0xbe, 0x0,
 0xbf, 0x0,
 0xc0, 0x0,
 0xc1, 0x0,
 0xc2, 0x0,
 0xc3, 0x0,
 0xc4, 0x0,
 0xc5, 0x0,
 0xc6, 0x0,
 0xc7, 0x0,
 0xc8, 0x0,
 0xca, 0x0,
 0xff, 0x2,
 0x0, 0x1e,
 0x1, 0x2,
 0x2, 0x0,
 0x3, 0x84,
 0x4, 0x0,
 0x5, 0x1,
 0x6, 0x92,
 0x7, 0x14,
 0x8, 0x0,
 0x9, 0xa,
 0xa, 0x0,
 0xb, 0xa1,
 0xc, 0x0,
 0xd, 0x1,
 0xe, 0x2,
 0x10, 0x0,
 0x11, 0x0,
 0xff, 0x9,
 0xfa, 0x0,
 0xfb, 0xa0,
 0xfc, 0x80,
 0xfd, 0x60,
 0xfe, 0x0,
 0xff, 0x10,
 0x20, 0x81,
 0x21, 0x0,
 0x22, 0x0,
 0x23, 0x0,
 0x24, 0x0,
 0x25, 0x0,
 0x26, 0x0,
 0x27, 0x0,
 0x28, 0x0,
 0x29, 0x0,
 0x2a, 0x0,
 0x2b, 0x0,
 0x2c, 0x0,
 0x2d, 0x0,
 0x2e, 0x0,
 0x2f, 0x0,
 0x30, 0x0,
 0x31, 0x0,
 0x32, 0x0,
 0x33, 0x0,
 0x34, 0x0,
 0x35, 0x0,
 0x36, 0x0,
 0x37, 0x0,
 0x38, 0x0,
 0x39, 0x0,
 0x3a, 0x0,
 0x3b, 0x0,
 0x3c, 0x0,
 0x3d, 0x0,
 0x3e, 0x0,
 0x40, 0x82,
 0x41, 0x2,
 0x42, 0xd,
 0x43, 0xe4,
 0x44, 0x20,
 0x45, 0x68,
 0x46, 0x0,
 0x47, 0x3,
 0x48, 0x0,
 0x49, 0x0,
 0x4a, 0x0,
 0x4b, 0x0,
 0x4c, 0x0,
 0x4d, 0x0,
 0x4e, 0x0,
 0x4f, 0x0,
 0x50, 0x0,
 0x51, 0x0,
 0x52, 0x0,
 0x53, 0x0,
 0x54, 0x0,
 0x55, 0x0,
 0x56, 0x0,
 0x57, 0x0,
 0x58, 0x0,
 0x59, 0x0,
 0x5a, 0x0,
 0x5b, 0x0,
 0x5c, 0x0,
 0x5d, 0x0,
 0x5e, 0x0,
 0x60, 0x83,
 0x61, 0x0,
 0x62, 0x0,
 0x63, 0x0,
 0x64, 0x0,
 0x65, 0x0,
 0x66, 0x0,
 0x67, 0x0,
 0x68, 0x0,
 0x69, 0x0,
 0x6a, 0x0,
 0x6b, 0x0,
 0x6c, 0x0,
 0x6d, 0x0,
 0x6e, 0x0,
 0x6f, 0x0,
 0x70, 0x0,
 0x71, 0x0,
 0x72, 0x0,
 0x73, 0x0,
 0x74, 0x0,
 0x75, 0x0,
 0x76, 0x0,
 0x77, 0x0,
 0x78, 0x0,
 0x79, 0x0,
 0x7a, 0x0,
 0x7b, 0x0,
 0x7c, 0x0,
 0x7d, 0x0,
 0x7e, 0x0,
 0x80, 0x84,
 0x81, 0x1,
 0x82, 0xa,
 0x83, 0x70,
 0x84, 0x1,
 0x85, 0x0,
 0x86, 0x0,
 0x87, 0x0,
 0x88, 0x0,
 0x89, 0x0,
 0x8a, 0x0,
 0x8b, 0x0,
 0x8c, 0x0,
 0x8d, 0x0,
 0x8e, 0x0,
 0x8f, 0x0,
 0x90, 0x0,
 0x91, 0x0,
 0x92, 0x0,
 0x93, 0x0,
 0x94, 0x0,
 0x95, 0x0,
 0x96, 0x0,
 0x97, 0x0,
 0x98, 0x0,
 0x99, 0x0,
 0x9a, 0x0,
 0x9b, 0x0,
 0x9c, 0x0,
 0x9d, 0x0,
 0x9e, 0x0,
 0xa0, 0x85,
 0xa1, 0x0,
 0xa2, 0x0,
 0xa3, 0x0,
 0xa4, 0x0,
 0xa5, 0x0,
 0xa6, 0x0,
 0xa7, 0x0,
 0xa8, 0x0,
 0xa9, 0x0,
 0xaa, 0x0,
 0xab, 0x0,
 0xac, 0x0,
 0xad, 0x0,
 0xae, 0x0,
 0xaf, 0x0,
 0xb0, 0x0,
 0xb1, 0x0,
 0xb2, 0x0,
 0xb3, 0x0,
 0xb4, 0x0,
 0xb5, 0x0,
 0xb6, 0x0,
 0xb7, 0x0,
 0xb8, 0x0,
 0xb9, 0x0,
 0xba, 0x0,
 0xbb, 0x0,
 0xbc, 0x0,
 0xbd, 0x0,
 0xbe, 0x0,
 0xff, 0x11,
 0x0, 0x0,
 0x1, 0x0,
 0x2, 0x0,
 0x3, 0x0,
 0x4, 0x80,
 0x5, 0x78,
 0x6, 0x69,
 0x7, 0x0,
 0x8, 0x0,
 0x9, 0x18,
 0xa, 0x0,
 0xb, 0x0,
 0xc, 0x33,
 0xd, 0x4,
 0xe, 0x1,
 0xf, 0x14,
 0x14, 0x0,
 0x15, 0x0,
 0x16, 0x2,
 0x17, 0x0,
 0x18, 0x0,
 0x19, 0x0,
 0x1a, 0x0,
 0x1b, 0x0,
 0x1c, 0x0,
 0x1d, 0x0,
 0x1e, 0x0,
 0x1f, 0x0,
 0x20, 0x5,
 0x21, 0x0,
 0x22, 0x0,
 0x23, 0x0,
 0x24, 0x0,
 0x25, 0x0,
 0x26, 0x0,
 0x27, 0x0,
 0x28, 0x0,
 0x29, 0x0,
 0x2a, 0x0,
 0x2b, 0x0,
 0x2c, 0x0,
 0x2d, 0x0,
 0x2e, 0x0,
 0x2f, 0x0,
 0x30, 0x0,
 0x31, 0x0,
 0x32, 0x0,
 0x33, 0x0,
 0x34, 0x0,
 0x35, 0x0,
 0x36, 0x0,
 0x37, 0x0,
 0x38, 0x0,
 0x39, 0x0,
 0x3a, 0x0,
 0x3b, 0x0,
 0x3c, 0x0,
 0x3d, 0x0,
 0x3e, 0x0,
 0x40, 0x6,
 0x41, 0x0,
 0x42, 0x0,
 0x43, 0x0,
 0x44, 0x0,
 0x45, 0x0,
 0x46, 0x0,
 0x47, 0x0,
 0x48, 0x0,
 0x49, 0x0,
 0x4a, 0x0,
 0x4b, 0x0,
 0x4c, 0x0,
 0x4d, 0x0,
 0x4e, 0x0,
 0x4f, 0x0,
 0x50, 0x0,
 0x51, 0x0,
 0x52, 0x0,
 0x53, 0x0,
 0x54, 0x0,
 0x55, 0x0,
 0x56, 0x0,
 0x57, 0x0,
 0x58, 0x0,
 0x59, 0x0,
 0x5a, 0x0,
 0x5b, 0x0,
 0x5c, 0x0,
 0x5d, 0x0,
 0x5e, 0x0,
 0x60, 0x4,
 0x61, 0x0,
 0x62, 0x0,
 0x63, 0x0,
 0x64, 0x0,
 0x65, 0x0,
 0x66, 0x0,
 0x67, 0x0,
 0x68, 0x0,
 0x69, 0x0,
 0x6a, 0x0,
 0x6b, 0x0,
 0x6c, 0x0,
 0x6d, 0x0,
 0x6e, 0x0,
 0x6f, 0x0,
 0x70, 0x0,
 0x71, 0x0,
 0x72, 0x0,
 0x73, 0x0,
 0x74, 0x0,
 0x75, 0x0,
 0x76, 0x0,
 0x77, 0x0,
 0x78, 0x0,
 0x79, 0x0,
 0x7a, 0x0,
 0x7b, 0x0,
 0x7c, 0x0,
 0x7d, 0x0,
 0x7e, 0x0,
 0xff, 0x12,
 0x31, 0x50,
 0x32, 0x9,
 0x33, 0xae,
 0x34, 0x0,
 0x36, 0x0,
 0x37, 0x0,
 0x38, 0x0,
 0x39, 0x0,
 0x40, 0x0,
 0x42, 0x12,
 0x43, 0x34,
 0x49, 0x0,
 0x4b, 0x5e,
 0x4c, 0x77,
 0x4d, 0x50,
 0x4e, 0x9,
 0x4f, 0xae,
 0x50, 0x0,
 0x60, 0x0,
 0x61, 0x0,
 0x63, 0x0,
 0x64, 0x0,
 0x65, 0x0,
 0x66, 0x0,
 0x67, 0x0,
 0x68, 0x0,
 0x69, 0x0,
 0x6a, 0x0,
 0x6b, 0x0,
 0x6c, 0x0,
 0x6d, 0x0,
 0x6e, 0x0,
 0x6f, 0x0,
 0x70, 0x0,
 0x71, 0x0,
 0x90, 0x0,
 0x91, 0x0,
 0x97, 0x9,
 0x98, 0x0,
 0x99, 0x0,
 0x9a, 0x64,
 0xb8, 0x16
};
	i2c_addr=0xe0;
	i2c_addr=i2c_addr>>1;
	I2CBUF[0] = 2;
	for(i=0;i<552;i++)
	{
		I2CBUF[1] = P480[i*2]&0x0ff;
		I2CBUF[2] = P480[(i*2)+1]&0x0ff;
		I2C_Write1(i2c_addr,I2CBUF);
		BusyWaiting1(70000);
	}
}		
