
/************************************************************************
 *
 *  main.c
 *
 *  First C-function
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/


/************************************************************************
 *  Include files
 ************************************************************************/

#include <sysdefs.h>
#include <string.h>
#include <syscon_api.h>
#include <sys_api.h>
#include <initmodules_api.h>
#include <env_api.h>
#include <shell_api.h>
#include <init.h>
#include <product.h>

#include <project_config.h>

/************************************************************************
 *  Definitions
 ************************************************************************/

/*  Macro for conversion between time interval in ns and number of
 *  SysAD bus cycles.
 *  Round result up.
 */
#if 0//cylee marked since 'sys_busfreq_hz is marked forever
#define NS2COUNT_ROUND_UP(ns,count)		   \
    count =  (sys_busfreq_hz + 999999) / 1000000;  \
    count *= ns;				   \
    count =  (count + 999) / 1000;
#endif

/************************************************************************
 *  Public variables (some not used here)
 ************************************************************************/

/* Platform attributes */
UINT32 sys_processor;
UINT32 sys_platform;
UINT32 sys_corecard;
UINT32 sys_manid;
UINT32 sys_manpd;
UINT32 sys_nb_base;
UINT32 sys_ramsize;
UINT32 sys_freemem;
//UINT32 sys_bootup; //marked by cylee
UINT32 sys_chiprev;  //cylee added for store chip revision
char   sys_chiprev_str[64]; //cylee added for recording chip revision
UINT32 sys_realtek_recovery;  //cylee added for bootcode recovery


/* CPU attributes */
bool   sys_64bit;
bool   sys_mips32_64;
bool   sys_mips16e;
bool   sys_smallpage_support;
bool   sys_ejtag;
UINT8  sys_arch_rev;
UINT32 sys_fpu;

/* CPU support for hw cache coherency */
bool   sys_cpu_cache_coherency;

/* Level 2 cache configuration */
bool   sys_l2cache;
bool   sys_l2cache_enabled;
UINT32 sys_l2cache_lines;
UINT32 sys_l2cache_linesize;
UINT32 sys_l2cache_assoc;

/* Level 1 cache configuration */
UINT32 sys_icache_linesize;
UINT32 sys_icache_lines;
UINT32 sys_icache_assoc;
UINT32 sys_dcache_linesize;
UINT32 sys_dcache_lines;
UINT32 sys_dcache_assoc;

char   *sys_default_prompt = DEFAULT_PROMPT;
char   sys_default_display[] = DEFAULT_PROMPT;

/************************************************************************
 *  Static function prototypes
 ************************************************************************/

static void
core_optimize( void );

/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/

/************************************************************************
 *
 *                          c_entry
 *  Description :
 *  -------------
 *
 *  First C-function
 *
 *  Return values :
 *  ---------------
 *
 *  Never returns
 *
 ************************************************************************/
int
c_entry(void)
{
    t_sys_cpu_decoded   decoded;
    bool                init_from_env;
    int                 len;
    
    /* if realtek_resuce is enabled, go to download image and update to flash */
    if (sys_realtek_recovery == 1)
        c_realtek_recovery_entry();
    
    /* Determine CPU type */
    sys_cpu_type();
    
#if 0 /* cylee marked since we already know we don't have FPU*/
    /* If FPU is available, enable it */
    if( sys_fpu )
        sys_fpu_enable();
#endif

    /* Initialise modules */
    initmodules();
    
    /* Configure cpu according to environment variable "cpuconfig" */

#if 0 //cylee marked since this item is no longer setup
    if( env_get( "cpuconfig", NULL, &decoded, sizeof(t_sys_cpu_decoded) ) )
    {       
        sys_cpu_config( TRUE, TRUE, TRUE, &decoded );
    }
#endif

    /* Enable interrupts */
    sys_enable_int();
    
    /* Done with initialisation. Now jump to shell (never returns) */
    shell_setup();
    
    return -1;  /* Should never happen */
}
