
/************************************************************************
 *
 *  main.c
 *
 *  First C-function
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/


/************************************************************************
 *  Include files
 ************************************************************************/

#include <sysdefs.h>
#include <string.h>
#include <syscon_api.h>
#include <sys_api.h>
#include <env_api.h>
#include <shell_api.h>
#include <init.h>
#include <product.h>

#include <project_config.h>

/************************************************************************
 *  Definitions
 ************************************************************************/

/*  Macro for conversion between time interval in ns and number of
 *  SysAD bus cycles.
 *  Round result up.
 */

#define POLLSIZE 0x1000
#define HW_LIMIT_STOP	(POLLSIZE-64)  /* RTS OFF when 64 chars in buf */
#define HW_LIMIT_START	(POLLSIZE-32)  /* RTS  ON when 32 chars in buf */
#define SERIAL_MCR_DTR           0x01  /* Data Terminal Ready          */
#define SERIAL_MCR_RTS           0x02  /* Request To Send              */
#define SERIAL_LSR_DR            0x01  /* Character ready              */
#define SERIAL_LSR_THRE          0x20  /* Transmit Holding empty       */
#define SERIAL_MSR_CTS           0x10  /* Clear to send                */


/************************************************************************
 *  Public variables (some not used here)
 ************************************************************************/

UINT32 sys_realtek_recovery;  //cylee added for realtek rescue bootcode
                              //0x0: normal bootcode flow
                              //0x1: update image then reboot

/************************************************************************
 *  Static variables
 ************************************************************************/
static UINT16  recv_buffer[POLLSIZE];
static UINT16 *putptr;
static UINT16 *getptr;



/************************************************************************
 *  Static function prototypes
 ************************************************************************/
static UINT32 realtek_recovery_util_loader_binary();

static void realtek_recovery_util_icache_invalidate_all( void );
static void realtek_recovery_util_dcache_flush_all( void );

static void realtek_recovery_util_init_serial(); 
static int  realtek_recovery_util_serial_poll();
static int  realtek_recovery_util_serial_read(char *lstat);
static void realtek_recovery_util_serial_write(UINT8 *p_param);
static void realtek_recovery_util_prints(const char *ch);

/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/

/************************************************************************
 *
 *                          c_realtek_recovery_entry
 *  Description :
 *  -------------
 *
 *  First C-function
 *
 *  Return values :
 *  ---------------
 *
 *  Never returns
 *
 ************************************************************************/
int c_realtek_recovery_entry(void)
{
    UINT32  rc;
    UINT32  idx;
    void (*jump_to_update_image)(void) = (void *)0xa0100000;
    
    
    /* init UART buffer */
    realtek_recovery_util_init_serial();
    
    /* show start download image message */
    realtek_recovery_util_prints("start capture\n");
    
    /*********************************************************
     * Start YModem-G protocol and receive image to 0x80100000
     *********************************************************/
    rc = realtek_recovery_util_loader_binary();
    
    if (rc == OK)
    {
    	/* show terminate download image message */
    	realtek_recovery_util_prints("\nstop capture\n");
    
    	/*********************************************************
     	* Execute image to perform flash update
     	*********************************************************/
    	realtek_recovery_util_prints("\nstart update image\n");
    
	    jump_to_update_image();
	}
	
    return NOT_OK;
}



/************************************************************************
 *  Implementation : Static function
 ************************************************************************/
/* routine get data from UART using YModem-G protocol as input rule */
static UINT32 realtek_recovery_util_loader_binary()
{
    char    *wdata;
    char    ch8;
    char    char_C   = 0x43, char_ACK = 0x6;
    char 	char_SOH = 0x01, char_STX = 0x02;
    char 	char_CR  = 0x0d, char_LF  = 0x0a;
    char    pre[3] = {0};
    
    UINT32  rc = OK;
    UINT32  i, j = 0;
    wdata = (char *)0xa0100000;
    
    realtek_recovery_util_dcache_flush_all();
    
    realtek_recovery_util_serial_write(&char_CR);
    realtek_recovery_util_serial_write(&char_LF);
    
    /* implement Y-modem G protocol */ 
    /* detecting Y-modem G transmitter tx signal */
    do
    {
        i = 0x400000;
    	while (i--);
        
        //send 'C'
        realtek_recovery_util_serial_write(&char_C);
        //send ACK
        realtek_recovery_util_serial_write(&char_ACK);
        //get input
        realtek_recovery_util_serial_read(&ch8);
    } 
    while((ch8 != char_SOH) && (ch8 != char_STX) && (ch8 != CTRL_C));
    
    //send ACK
    realtek_recovery_util_serial_write(&char_ACK);
    
    //user break!! return to normal flow */
    if (ch8 == CTRL_C)
    	return NOT_OK;
    
    if (ch8 == char_SOH)
    {
        
        //skip first block that contains file name
        i = 128 + 4 ; 
      	while(i)
         	if( realtek_recovery_util_serial_read(&ch8) ==  OK)
         	{
           		i--;
      	 	}
       
        //start receive data from UART0 and write to DRAM
        i = 100000;
        j = 0;
        
        while(i)
        {
            if ( realtek_recovery_util_serial_read(&ch8) ==  OK)
            {
                j++;
                
                //receive EOT, data rx completed
                if ((j == 1) && (ch8 ==0x04))
                {
                	realtek_recovery_util_serial_write(&char_ACK);
                    break;
                }
                
                if ((j != 1) && (j != 2) && (j != 3) && (j != 1028) && (j != 1029))
                    *wdata++ = ch8;
                
                if (j==1029)
                {
                    j = 0;
                    realtek_recovery_util_serial_write(&char_ACK);
                }
                
                i=100000;
            }  
            else
            {
                i--;
            }
        }
        
        /* YModem-G received completed. */
    }

    /* Flush caches */
    realtek_recovery_util_dcache_flush_all();
    realtek_recovery_util_icache_invalidate_all();
    
    return rc;
    
}


/* flush data in dcache to memory and invalidate all dcache lines */
static void realtek_recovery_util_dcache_flush_all( void )
{
    UINT32 line;
    UINT32 addr;
    
    /* Flush DCACHE */
    for( line = 0, addr = KSEG0(0);
         line < sys_dcache_lines; 
         line++, addr += sys_dcache_linesize )
    {
        sys_dcache_flush_index( addr );
    }
}

/* invalidate all icache lines */
static void realtek_recovery_util_icache_invalidate_all( void )
{
    UINT32 line;
    UINT32 addr;

    /* Invalidate ICACHE */
    for( line = 0, addr = KSEG0(0); 
         line < sys_icache_lines; 
         line++, addr += sys_icache_linesize )
    {
        sys_icache_invalidate_index( addr );
    }

    sys_flush_pipeline();
}







static void realtek_recovery_util_init_serial()
{
	getptr = putptr = &recv_buffer[0];
}

static int realtek_recovery_util_serial_poll()
{
    UINT32 lstat;
    UINT32 rdata;
    UINT32 room;
    
    for(lstat = *( (volatile unsigned int *) 0xb801b214); lstat & SERIAL_LSR_DR; lstat = *( (volatile unsigned int *) 0xb801b214))
    {
    	rdata = *( (volatile unsigned int *) 0xb801b200) & 0xff;
        
        /* compute room left in buffer, AFTER this byte has been put */
        room = ((UINT32)getptr - (UINT32)putptr - 1) & ((POLLSIZE - 1) * sizeof(*putptr));
#if 0       
        if (room <= HW_LIMIT_STOP * sizeof(*putptr) )
        {
            *( (volatile unsigned int *) 0xb801b210) &= ~SERIAL_MCR_RTS;
        }
#endif
        if(room == 0)
        {
        	/* overwrite previous char (overflow anyway) */
            if (--putptr < &recv_buffer[0])
                putptr= &recv_buffer[POLLSIZE-1];
        }

        *putptr = (lstat << 8) | rdata;
        
        /* increase putptr to its future position */
        if( ++putptr >= &recv_buffer[POLLSIZE] )
            putptr= &recv_buffer[0];
    }
    
    return lstat;
}

static int realtek_recovery_util_serial_read(char *ch)
{
	realtek_recovery_util_serial_poll();
	
	if (getptr == putptr)
       return NOT_OK; 
    
    *ch = *getptr;
       
       
    if (++getptr >= &recv_buffer[POLLSIZE])
        getptr= &recv_buffer[0];
#if 0       
     if (((*( (volatile unsigned int *) 0xb801b210) & SERIAL_MCR_RTS) == 0 )&&
         (((UINT32)getptr - (UINT32)putptr) &
         ((POLLSIZE - 1) * sizeof(*getptr))
                           >= HW_LIMIT_START * sizeof(*getptr)) )
     {
        *( (volatile unsigned int *) 0xb801b210) |= SERIAL_MCR_RTS;       
     }    
#endif
    
    return   OK;
}



static void realtek_recovery_util_serial_write(UINT8  *p_param)
{
	for (;;)
	{
        /* OBS: LSR_OE, LSR_PE, LSR_FE and LSR_BI are cleared on read */
        if ( (realtek_recovery_util_serial_poll( ) & SERIAL_LSR_THRE) 
        /* omit for temp , cy test */
// cy test             &&
//             ((*( (volatile unsigned int *) 0xb801b218) & SERIAL_MSR_CTS) == 0 ) 
             ) 
             
             break;
     }
     
     *( (volatile unsigned int *) 0xb801b200) = *p_param;
}

void realtek_recovery_util_prints(const char *ch)
{
    int ch8;
    
    while (*ch != '\0')
    {
    	ch8 = *ch;
    	
    	if (*ch++ == '\n')
    	{
    		ch8 = 0x0d;
    		realtek_recovery_util_serial_write((UINT8 *)&ch8);
    		ch8 = 0x0a;
    	}
    	
    	realtek_recovery_util_serial_write((UINT8 *)&ch8);
    }
}		

