/************************************************************************
 *  Include files
 ************************************************************************/
#include <shell.h>
#include <stdio.h>
#include <string.h>
#include <env_api.h>
#include <sysdev.h>
#include <flash_api.h>
#include <io_api.h>
#include <ide_api.h>
#include <syscon.h>

/************************************************************************
 *  Public variables
 ************************************************************************/
extern UINT16 HDD_CYL_COUNT;
extern UINT16 HDD_HEAD_COUNT;
extern UINT16 HDD_SEC_PER_TRACK;
extern UINT32 ide_minor_hdd  ;
extern UINT32 ide_minor_cdrom;

/************************************************************************
 *  Static variables
 ************************************************************************/
static char arg_copy[SHELL_MAX_TOKEN_LEN+1]; 

/* OPTIONS */
static t_cmd_option options[] =
{
#define OPTION_FLASH	0 
    { "f",  "format flash" } ,
#define OPTION_DISK	1 
    { "d",  "format disk" } ,    
    
};
#define OPTION_COUNT	(sizeof(options)/sizeof(t_cmd_option))

/************************************************************************
 *  Static function prototypes
 ************************************************************************/
static MON_FUNC(format);

static UINT32
get_options(
    UINT32 argc,
    char   **argv,
    UINT32 *src,
    UINT8  *sel
    );
    
static UINT32
format_flash(UINT32 *src);    

static UINT32
format_disk(UINT32 *src) ;

/************************************************************************
 *                          format
 ************************************************************************/
static MON_FUNC(format)
{
     UINT32 rc = OK;
     UINT32 src;
     UINT8  sel;
     
     rc = get_options( argc, argv, &src, &sel);
     if( rc != OK )
        return rc;
            
     switch(sel)
     {  
     	case OPTION_FLASH:
     	     rc = format_flash(&src);
     	     break;
     	     
     	case OPTION_DISK:
     	     rc = format_disk(&src);
     	     break;
     	           
     	default:     	     
     	      break;         
     }
  
    
     
     return rc;
}
/************************************************************************
 *                          get_options
 ************************************************************************/
static UINT32
get_options(
    UINT32 argc,
    char   **argv,
    UINT32 *src,
    UINT8  *sel
    )
{
    t_shell_option decode;
    UINT32	   type;
    bool	   ok 		 = TRUE;
    UINT32	   i;
    UINT32	   arg;
    UINT32	   error = SHELL_ERROR_SYNTAX;
    
  
    arg_copy[0] = '\0';

    for( arg = 1; 
	          ok && 
	          (arg < argc) && 
                  shell_decode_token( argv[arg], &type, &decode );
         arg++ )
    {
	switch( type )
	{
	  case SHELL_TOKEN_NUMBER :
	       *src      = decode.number;
	       break;
	       
	  case SHELL_TOKEN_OPTION :
	    if( strcmp(decode.option, options[OPTION_FLASH].option) == 0 )
	        *sel = OPTION_FLASH;	      
	    else if( strcmp(decode.option, options[OPTION_DISK].option) == 0 )
	        *sel = OPTION_DISK;		        
	    else
	        ok = FALSE;    
	    break;
	    
	  default :
	       ok = FALSE;
	       break;
        }
    }

    return ok ?
        OK : error;
}

/************************************************************************
 *                          format_flash
 ************************************************************************/
static UINT32
format_flash(UINT32 *src)
{
   UINT32  size_count =0;
   t_FLASH_write_descriptor  flash_write ;
   t_FLASH_ctrl_descriptor   flash_ctrl;
   
   UINT32 i, j;
   UINT32 wdata , linux_length = 0 ,squash1_length =0;
   UINT32 rc = OK;
   bool  first = TRUE;
   
   rc = SYSCON_read( SYSCON_BOARD_MONITORFLASH_SIZE_ID, &wdata,
	            sizeof(wdata) ) ;
              	    
   if( rc != OK )
     return rc;
     
   printf("formatting...\n");  
   /* copy flash to ram */   
   flash_write.adr    = 0x81000000;	
   flash_write.length = wdata ; 
   flash_write.buffer = (UINT8 *)(0xbfd00000 - wdata) ; 
   if( (rc = IO_write( SYS_MAJOR_FLASH, 0, &flash_write )) != OK )
	 return rc;  
   /* erase upper flash */ 
   flash_ctrl.user_physadr = PHYS(0xbfd00000 - wdata);
   flash_ctrl.user_length  = wdata - 0x100000;
   flash_ctrl.command = FLASH_CTRL_ERASE_FLASH_AREA;        
   rc = IO_ctrl( SYS_MAJOR_FLASH, 0, (UINT8 *)(&flash_ctrl) );
   if (rc != OK)
        return rc; 
        	 
   /* erase lower flash */ 
   flash_ctrl.user_physadr = PHYS(0xbfc40000);
   flash_ctrl.user_length  = 0xbfd00000 - 0xbfc40000;

   flash_ctrl.command = FLASH_CTRL_ERASE_FLASH_AREA;        
   rc = IO_ctrl( SYS_MAJOR_FLASH, 0, (UINT8 *)(&flash_ctrl) );
   if (rc != OK)
        return rc; 	      
        
         
   for (i = 0 ; i<128 ; i+=16)
   { 	
     switch (*(UINT8 *)(*src+i))
     {
      case 1: /* bootloader image */
             
                              
             break;	  
      case 2: /* linux kernel image */
                         	   	             
	     flash_write.adr    = 0x81000000 + 128;   
	     
	     *(UINT8 *)(&flash_write.length) =  *(UINT8 *)(*src+i+5);
	    
	     *((UINT8 *)(&flash_write.length)+1) =  *(UINT8 *)(*src+i+6);
	     
	     *((UINT8 *)(&flash_write.length)+2) =  *(UINT8 *)(*src+i+7);
	       
	     *((UINT8 *)(&flash_write.length)+3) =  *(UINT8 *)(*src+i+8);
	     
             
             flash_write.buffer = (UINT8 *)(*src+128);
             
          
             if( (rc = IO_write( SYS_MAJOR_FLASH, 0, &flash_write )) != OK )
	        return rc;
	     printf("update linux ..\n");//cy test   
	     
	     
	     /* update header */
	     for (j= 0 ; j<8 ; j++)
	     {
	       *(UINT8 *)(0x81000000 + 0x10 + j) 
	                 =  *(UINT8 *)(*src + i + j + 1); 
	     
	      
	     }            
	     
	     size_count +=  flash_write.length ;  
	     linux_length = flash_write.length ;    
             break;	     
	        
      case 3: /* ROS kernel image */
             
             
	     
             break;	  
      	     
      case 4: /* jffs2 file system */
      
            	     
             break;	     
      	        
      case 5: /* squash file system */
           
             /* 1024 byte alignment */ 
             *(UINT8 *)(&flash_write.length) =  *(UINT8 *)(*src+i+1);
	     *((UINT8 *)(&flash_write.length)+1) =  *(UINT8 *)(*src+i+2);
	     *((UINT8 *)(&flash_write.length)+2) =  *(UINT8 *)(*src+i+3);
	     *((UINT8 *)(&flash_write.length)+3) =  *(UINT8 *)(*src+i+4);
             
             if (first)
               flash_write.adr    = (0x81000000 + wdata - 0x100000
                                     + 0x40000); 
                                   /* should already align 1024 bytes */  
             else
               flash_write.adr    = (0x81000000 + wdata - 0x100000 
                                     + 0x40000 +  squash1_length + (0x400-1) 
                                      )&0xfffffc00 ;
                                   /* need align 1024 bytes */   
                                         
             flash_write.buffer = (UINT8 *)(*src +128 + size_count);
           
             if( (rc = IO_write( SYS_MAJOR_FLASH, 0, &flash_write )) != OK )
	        return rc;
	     printf("update squashfs%d ..\n", !first);//cy test
	     
	     
	     if (first)
	     {    
	        /* update header */
	        for (j= 0 ; j<4 ; j++)
	          *(UINT8 *)(0x81000000 + 0x50 + j) 
	                    =  *(UINT8 *)(*src + i + j + 1); 
	                    
	        squash1_length =   flash_write.length;          
	     }   
	     else
	        /* update header */
	        for (j= 0 ; j<4 ; j++)
	          *(UINT8 *)(0x81000000 + 0x60 + j) 
	                    =  *(UINT8 *)(*src + i + j + 1);                
	     
	     first = !first ;       
	     size_count +=  flash_write.length ;   
      	     break;   
      case 0 :
             break;
             
      default :
             printf("update error\n");//cy test     
             return (!OK);   
     }	
	
   }



   
   /* write back to upper flash */
   flash_write.adr    = 0xbfd00000 - wdata;  
   flash_write.length = 0x100000 ; 
   flash_write.buffer = (UINT8 *)(0x81000000) ; 
   
   
   if( (rc = IO_write( SYS_MAJOR_FLASH, 0, &flash_write )) != OK )
	 return rc;
   printf("write upper flash  ok !\n");//cy test 
  
  
   /* write back to lower flash */
   flash_write.adr    = 0xbfc40000;  
   flash_write.length = 0xbfd00000 - 0xbfc40000 ; 
   flash_write.buffer = (UINT8 *)(0x81000000 + wdata - 0xc0000) ; 
   if( (rc = IO_write( SYS_MAJOR_FLASH, 0, &flash_write )) != OK )
	 return rc;
   printf("write lower flash  ok !\n");//cy test
   


   return rc;	
   
}


/************************************************************************
 *                          format_disk
 ************************************************************************/
static UINT32
format_disk(UINT32 *src)
{ 
   return OK;	
	
}		
/*************************************************************************
*************************************************************************/
static t_cmd format_cmd =
{
    "format", 
    format, 
    "format ",
    "",

    NULL,
    0,
    TRUE  
};

/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/

/************************************************************************
 *
 *                          shell_format_init
 *  Description :
 *  -------------
 *
 *  Initialise command
 *
 *  Return values :
 *  ---------------
 *
 *  void
 *
 ************************************************************************/
t_cmd *
shell_format_init(void)
{
   
    return &format_cmd;
}
