/***********************************************************************
 *  shell_goliux.c
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/
#include <shell_api.h>
#include <shell.h>
#include <shell_golinux.h>

#include <sys_api.h>
#include <sysdefs.h>
#include <sysdev.h>
#include <flash_api.h>
#include <io_api.h>

#include <syserror.h>
#include <shell.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#if defined(Board_RTC_DEFAULT)
  #include <rtc_api.h>
#endif

#include <project_config.h>
#include <extern_param.h>
/************************************************************************
 *  Definitions
 ************************************************************************/
#define  MIS_GP0DIR         0x1801b100
#define  MIS_GP1DIR         0x1801b104
#define  MIS_GP0DATO        0x1801b108
#define  MIS_GP1DATO        0x1801b10c
#define  MIS_GP0DATI        0x1801b110
#define  MIS_GP1DATI        0x1801b114

#define  SB2_CHIP_INFO      0x1801A204
#define  ATA_PRIMARY_DIR	0x18000110

/************************************************************************
 *  Public variables
 ************************************************************************/
UINT32 *streamfile_ptrA  = (UINT32 *)0xa00000d8;
UINT32 *streamfile_ptrV  = (UINT32 *)0xa00000dc;
UINT32 *streamfile_flagA = (UINT32 *)0xa00000d0;
UINT32 *streamfile_flagV = (UINT32 *)0xa00000d4;

extern t_extern_param *ext_para_ptr;
extern t_RTC_calendar  rtc ; 
/************************************************************************
 *  Static variables
 ************************************************************************/
static UINT32 config_gpio_for_usb();
#ifdef Config_QC_Test_Prog_TRUE
UINT32 QC_test_enabled = 0;
#endif /* Config_QC_Test_Prog_TRUE */

/************************************************************************
 *                          shell_get_time
 ************************************************************************/
UINT32
shell_get_time(void) 
{
 UINT32 time;
        time =                       rtc.second      +
                              (60 *  rtc.minute)     +
                         (60 * 60 *  rtc.hour)       +
                    (24 * 60 * 60 *  rtc.dayofmonth) +
               (30 * 24 * 60 * 60 *  rtc.month)      +
              (365 * 24 * 60 * 60 * (rtc.year -1970)) ;
        return time;      
}

/************************************************************************
 *
 *                          shell_golinux
 *  Description :
 *  -------------
 *  Implements the shell
 *
 *  Return values :
 *  ---------------
 *  None, function never returns
 *
 ************************************************************************/
/* avhdd product judge rule */



char *shell_golinux( )
{
    int  idx;
    char ch = 0;
    bool install_flg = TRUE;
    t_FLASH_ctrl_descriptor   flash_ctrl;
    t_FLASH_write_descriptor  flash_write ;
    
    UINT32 *magic1_location = (UINT32 *)(ext_para_ptr->env_param_saddr + 0xff00);
    UINT32 *magic2_location = (UINT32 *)(ext_para_ptr->env_param_saddr + 0xff04);
    UINT32 *magic3_location = (UINT32 *)(ext_para_ptr->env_param_saddr + 0xff08);
    
    //if we don't set these address as '0', the avhdd rescue would crash!!
   	*streamfile_flagA = 0;
    *streamfile_flagV = 0;
    *streamfile_ptrA  = 0;
    *streamfile_ptrV  = 0;
    
    printf("Press 'ESC' to Monitor mode\n");
    
    /* detect for user selection and its */
    for (idx = 0; idx < 20; idx++)
    {

		////if detecting USB plug-in under booting(USB input pin = GPIO33)
        if (config_gpio_for_usb() == TRUE)
            return NULL;

        if (GETCHAR(DEFAULT_PORT, &ch ))
        {
            if (ch == ESC)
                return NULL;
#ifdef Config_QC_Test_Prog_TRUE
            if(ch == KEY_Q)
                QC_test_enabled = 1;
#endif /* Config_QC_Test_Prog_TRUE */
        }

#if 0
        /* if this product have IDE, then detect it
           and delay for IDE ready */
        if ((REG32(KSEG1(MIS_GP0DATI))&0x10000000) || 
            (REG32(KSEG1(SB2_CHIP_INFO))&0x0000ff00))
        {
            printf("I'm going to die !!\n");//cy test
            sys_wait_ms(20);
            /* suicide */
            REG32(KSEG1(MIS_GP1DIR))  = 0x08;
        }
#endif

        /* if we defined 'enter rescue with pressing softreset button,
           we need to check GPIO to see if it is pressed */
#if defined(Rescue_Source_FLASH) && defined(Rescue_Install_With_GPIO_Address)
        if ( (REG32(KSEG1(Rescue_Install_With_GPIO_Address)) & Rescue_Install_With_GPIO_Mask) 
             == Rescue_Install_With_GPIO_Value )
        {
            ch = Rescue_Install_Key;
            break;
        }
#endif
    }
    
    

#ifdef Config_QC_Test_Prog_TRUE
    if(QC_test_enabled) {
        printf("Entering Rescue Linux for QC Test...\n");
        return run_rescue_from_flash();
    }
#endif /* Config_QC_Test_Prog_TRUE */

#if defined(Rescue_Source_FLASH)
    if (ch == Rescue_Install_Key) {
        printf("Detecting Rescue_Install_Key=0x%x! Entering Rescue Linux...\n", Rescue_Install_Key);
        return run_rescue_from_flash();
    }
#endif

	if (*magic3_location == 0xdeadbeef)        /* already install */
	{
		if (*magic2_location == 0x20061231)     /* already run bootcode after install*/
		{
			if (*magic1_location == 0x65626162)  /* already run linux */
				return run_kernel_from_flash();
            else
            {
	    		/* bootcode install fail !! re-install again */
    			/* write magic2_location */

		        /* start and size of file flash */
		        void  *SYSENV_file_flash_start ;
		        UINT32 SYSENV_file_flash_size  ;
		        INT32  rcode;
		        
				printf("!!!!!!linux kernel fail !! clear magic number and re-install kernel again !\n");

		        /* get start of file flash */
		        rcode = SYSCON_read( SYSCON_BOARD_FILEFLASH_BASE_ID,
		                         &SYSENV_file_flash_start,
		                         sizeof(SYSENV_file_flash_start) ) ;
		      
		        if (rcode != OK)
		        {
		        	printf("get flash start address fail !!\n");   
		           	return NULL;
		        }
		        else
		           SYSENV_file_flash_start = (void *)KSEG1(SYSENV_file_flash_start);
		   
		        /* get size for file flash  */
		        rcode = SYSCON_read( SYSCON_BOARD_FILEFLASH_SIZE_ID,
		                             &SYSENV_file_flash_size,
		                             sizeof(SYSENV_file_flash_size) ) ;
		        
		        if (rcode != OK)
		        {
		        	printf("get flash file start address fail !!\n");   
		           	return NULL;
		        }
		
		        /* copy env. records area to ram */   
		        flash_write.adr    = 0x81000000;    
		        flash_write.length = SYSENV_file_flash_size ; 
		        flash_write.buffer = (UINT8 *)SYSENV_file_flash_start ; 
		        if( IO_write( SYS_MAJOR_FLASH, 0, &flash_write ) != OK )
		        {
		        	printf("copy env content to ram fail!!\n");   
		           	return NULL;
		        }
		     
		        /* Erase entire file flash */
		        flash_ctrl.command = FLASH_CTRL_ERASE_FILEFLASH;
		        if( IO_ctrl( SYS_MAJOR_FLASH, 0, (UINT8 *)(&flash_ctrl) ) != OK)
		        {
		        	printf("erase env fail!!\n");   
		           	return NULL;
		        }
		   
		        /* restore env. records  to flash */   
		        flash_write.adr    = (UINT32)SYSENV_file_flash_start;   
		        flash_write.length = SYSENV_file_flash_size ; 
		        flash_write.buffer = (UINT8 *)0x81000000; 
		        
		        if( IO_write( SYS_MAJOR_FLASH, 0, &flash_write ) != OK )
		        {
		        	printf("write env content back to flash fail!!!\n");   
		           	return NULL;
		        }		        

				printf("clear magic2 number ok !\n");
                printf("Cannot find magic1(0x65626162)! Entering Rescue Linux...\n");
            	return run_rescue_from_flash();    
            }
    	}
    	else
    	{
    		/* 1st  run bootcode after install */
    		/* write magic2_location */
			UINT32 magic2_N = 0x20061231;
			printf("magic2_location = 0x%x \n", (UINT32)magic2_location);//cy test
			flash_write.adr    = (UINT32)magic2_location;
			flash_write.length = 4;
			flash_write.buffer = (UINT8 *)&magic2_N ;
			
			if( (IO_write( SYS_MAJOR_FLASH, 0, &flash_write )) == OK )
			{
				printf("write magic2 number ok !\n");//cy test 
    		    return run_kernel_from_flash();
    		}
    	}	
	}
    else
    {
    	/* not install , never return*/
        printf("Cannot find magic3(0xdeadbeef)! Entering Rescue Linux...\n");
    	return run_rescue_from_flash();
    }
    
    return NULL;
}   


static UINT32 config_gpio_for_usb()
{
    UINT32 usb_det_gpio_addr, usb_det_gpio_mask;
    UINT32 usb_set_gpio_addr, usb_set_gpio_mask;
    
#if defined(Config_USB_DET_GPIO) && defined(Config_USB_Control_GPIO)
    //determine detecting gpio address and mask
    if (Config_USB_DET_GPIO < 32)
    {
        usb_det_gpio_addr = MIS_GP0DATI;
        usb_det_gpio_mask = 0x1 << Config_USB_DET_GPIO;
    }
    else
    {
        usb_det_gpio_addr = MIS_GP1DATI;
        usb_det_gpio_mask = 0x1 << (Config_USB_DET_GPIO - 32);
    }

    //determine GL811_EN gpio address and mask
    if (Config_USB_Control_GPIO < 32)
    {
        usb_set_gpio_addr = MIS_GP0DATO;
        usb_set_gpio_mask = 0x1 << Config_USB_Control_GPIO;
    }
    else
    {
        usb_set_gpio_addr = MIS_GP1DATO;
        usb_set_gpio_mask = 0x1 << (Config_USB_Control_GPIO - 32);
    }

# ifdef Config_QC_Test_Prog_TRUE
    if(QC_test_enabled) {
        return FALSE;
    }
# endif /* Config_QC_Test_Prog_TRUE */

    ////if detecting USB plug-in under booting stage
    if (REG32 (KSEG1(usb_det_gpio_addr)) & usb_det_gpio_mask)
    {
        //  1. set primary ATA as input
        REG32 (KSEG1( ATA_PRIMARY_DIR)) = 0x2a;
        //  2. set GPIO direction as input, and show notificatino message
        REG32 (KSEG1( usb_set_gpio_addr)) = REG32 (KSEG1( usb_set_gpio_addr)) | usb_set_gpio_mask;
        printf("Polling detects device connect to PC!!!\n");
        printf("Release HD control and stay in boot shell!!!\n");
        //  3. return to shell
        return TRUE;
    }
#else /* defined(Config_USB_DET_GPIO) && defined(Config_USB_Control_GPIO) */
	return FALSE;
#endif /* defined(Config_USB_DET_GPIO) && defined(Config_USB_Control_GPIO) */
    
    return FALSE;
}
