
/***********************************************************************
 *
 *  shell_kernel_inflash.c
 *
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/
#include <sysdefs.h>
#include <syserror.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#include <env_api.h>
#include <sys_api.h>
#include <excep_api.h>
#include <io_api.h>
#include <flash_api.h>
#include <sysdev.h>
#include <ide_api.h>
#include <shell.h>
#include <shell_api.h>
#include <shell_golinux.h>

#include <project_config.h>
#include <extern_param.h>
/************************************************************************
 *  Definitions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/
extern t_extern_param   *ext_para_ptr;

extern UINT32 *streamfile_ptrA;
extern UINT32 *streamfile_ptrV;
extern UINT32 *streamfile_flagA;
extern UINT32 *streamfile_flagV;

extern UINT32 ide_minor_hdd;
extern UINT32 is_sata;

char default_go1[128] = "";

/************************************************************************
 *  this function needed in shell subroutine 
 ************************************************************************/
static char *add2string(UINT32 size) 
{
	 UINT32 size_tmp;
	 char   *go;
	 UINT8  index = 0;
	 bool   pre_zero = FALSE; 
	 t_sys_malloc       mem ;
	 
	 mem.size     = 4 * sizeof(char) ;
         mem.boundary = sizeof(char) ;        
         mem.memory   = (void*) &go ; 
         SYSCON_read( SYSCON_BOARD_MALLOC_ID,
                         &mem,
                         sizeof(mem) ) ;
   
	 
         size_tmp = size /10000 ; 
         if (size_tmp == 0)
            pre_zero = TRUE;
         else          
         {            
	    go[index++] =  (char)(size_tmp+0x30) ;
	    
	 } 
	 
	 size     =  size - size_tmp*10000 ;
	 size_tmp =  size / 1000;
	 
	 if((size_tmp != 0)|| (!pre_zero))
	 { 
	       
	    go[index++] =  (char)(size_tmp+0x30) ;
	    pre_zero = FALSE;
	    
	 }   
	 
	
	 
	 
	 size     =  size - size_tmp*1000 ;
	 size_tmp =  size / 100;
	 
	 if((size_tmp != 0)|| (!pre_zero))
	 { 
	       
	    go[index++] =  (char)(size_tmp+0x30) ;
	    pre_zero = FALSE;
	    
	 }   
	
	
	 size     =  size - size_tmp*100 ;
	 size_tmp =  size / 10 ;
	 if((size_tmp != 0)|| (!pre_zero))
	 {
	    
	    go[index++] =  (char)(size_tmp+0x30) ;
	    pre_zero = FALSE;
	    
	 }   
	 
	 size     =  size - size_tmp*10  ;
	 size_tmp =  size / 1 ;
	
	 go[index++]=  (char)(size_tmp+0x30) ;
	  
	
	
	 go[index]= '\0'  ;
         return go;
       
}



/************************************************************************
 *                          run_kernel_from_flash
 ************************************************************************/
/* avhdd product judge rule */
char *run_kernel_from_flash()
{
    UINT32		streamfile_addr;
    UINT32		streamfile_size  = 0;
    UINT32		wdata;
    UINT32		rc = OK;
    char  		*rs;
    UINT32		magicN;
    UINT8 		*src;
          		
    int   		err;
    
    rc = SYSCON_read( SYSCON_BOARD_MONITORFLASH_SIZE_ID, &wdata, sizeof(wdata) );
    
    if( rc != OK )
    {
    	printf ("read flash size error!!\n");
        return NULL;
    }
    
   	
	if(is_sata) {
		t_ide_ctrl_descriptor  ide_ctrl;
		char ch;
		UINT32 time_on = shell_get_time(), time_now, time_round; 
		UINT32 i = 0;

		time_round = time_on;
		time_now = time_on;
		while((ide_minor_hdd == 0xff) && ((time_now - time_on) <= 30)) {
			time_now = shell_get_time();

			printf("Try to find HDD or 'ESC' to Monitor mode !\n"); 	
			if(GETCHAR(DEFAULT_PORT, &ch)) {
				if(ch == ESC)
					return NULL;
			}

			if((time_now - time_round) >= 15) {
				printf("HW Reset IDE !\n");
				IO_init( SYS_MAJOR_IDE, IDE_MINOR_PRIMARY_MASTER, 1);
				IO_init( SYS_MAJOR_IDE, IDE_MINOR_SECONDARY_MASTER, 1);
				time_round = time_now;
			} else {
				IO_init( SYS_MAJOR_IDE, i++, 0);
			}

			i = i % 4;
		}
		sys_dcache_flush_all();
	}
    
    /********* extract linux kernel  ***********/
    src = (UINT8  *)(0xbfc00000 - 0x80 + 0x10 + 0x04);
    streamfile_size = *(UINT32 *) src ;
    
    if (!streamfile_size)
    {
    	printf("no linux kernel in flash , to Monitor mode  \n");
    	return NULL;
    }

        
	streamfile_addr = 0xbfd00000 - wdata;
	
	printf("OS kernel in FLASH 0x%x , to 0x%x, size=0x%x\n", streamfile_addr, 
	                                                UNZIP_ADDRESS, streamfile_size);			  
	sys_dcache_flush_all();
	
    if( Lzma_main((char *)streamfile_addr, 
                  (char *)UNZIP_ADDRESS  , streamfile_size, rs) != 0)
    {
        printf("decompess Linux using LZMA error!!\n");
        return NULL;
    }
    
    /* Flush caches */
    sys_flush_caches();
    
    /********* extract audio ros kernel  ***********/
    
    streamfile_addr = streamfile_addr + streamfile_size;
    streamfile_size = *(UINT32 *)(0xbfc00000 - 0x80 + 0x20 + 0x04) ;
    *streamfile_ptrA = *(UINT32 *)(0xbfc00000 - 0x80 + 0x20 + 0x00) ;
    
    if (!streamfile_size)
    {
    	printf("no audio ros kernel in flash \n");
    	goto extract_video;
    }
    
    printf("OS kernel in FLASH 0x%x to 0x%x, size=0x%x\n",streamfile_addr, *streamfile_ptrA, streamfile_size);
    
    sys_dcache_flush_all();
    
    if( Lzma_main((char *)streamfile_addr, 
                  (char *)*streamfile_ptrA, streamfile_size, rs) != 0)
    {
        printf("decompess Audio using LZMA error!!\n");
        return NULL;
    }
    
    /* Flush caches */
    sys_flush_caches();
    
    *streamfile_ptrA = SWAPEND32(*streamfile_ptrA) ;
    
    /********* extract video ros kernel  ***********/
extract_video:
    streamfile_addr = streamfile_addr + streamfile_size;
    streamfile_size = *(UINT32 *)(0xbfc00000 - 0x80 + 0x30 + 0x04);
    *streamfile_ptrV = *(UINT32 *)(0xbfc00000 - 0x80 + 0x30 + 0x00);
    
    if (!streamfile_size)
    {
    	printf("no video ros kernel in flash \n");
    	goto jump_kernel;
    }
    
    printf("OS kernel in FLASH 0x%x to 0x%x, size=0x%x\n", streamfile_addr, *streamfile_ptrV, streamfile_size);
    
    sys_dcache_flush_all();
    
    if( Lzma_main((char *)streamfile_addr, 
                  (char *)*streamfile_ptrV, streamfile_size, rs) != 0)
    {
        printf("decompess Video using LZMA error!!\n");
        return NULL;
    }
    
    /* Flush caches */
    sys_flush_caches();
    
    *streamfile_ptrV = SWAPEND32(*streamfile_ptrV) ;
    
    /********* Release hardware semaphore **/
    /*other CPUs has been waiting for this  cy test */
    	REG32(KSEG1(HW_SEMAPHORE_ADDRESS)) = 0 ;
    
    /** jump to linux kernel **/
jump_kernel:

    {
        char *row;

        const UINT8      bin2char[16] = { 0x30, 0x31, 0x32, 0x33, 
				                          0x34, 0x35, 0x36, 0x37,
					                      0x38, 0x39, 0x41, 0x42,
					                      0x43, 0x44, 0x45, 0x46  };

        UINT32 size1, size2, size3, size4, size5;  
		        
        if( !env_get( "linuxparameter", &row, NULL, 0 ) )
        {
        	printf("\n\nerror !!! no linuxparameter existed!! return to mointor mode\n");
        	return NULL;
        }
        
        printf("linux param = %s \n", row);
        
        strcpy( default_go1, row);
        
        /* convert linux kernel start address to string */
        src--;
            
        default_go1[3] = bin2char[(*src >> 4 )&0x0f]; 
        default_go1[4] = bin2char[(*src >> 0 )&0x0f]; 
        src-- ;
        default_go1[5] = bin2char[(*src >> 4 )&0x0f]; 
        default_go1[6] = bin2char[(*src >> 0 )&0x0f];    
        src-- ;
        default_go1[7] = bin2char[(*src >> 4 )&0x0f]; 
        default_go1[8] = bin2char[(*src >> 0 )&0x0f];  
        src-- ;
        default_go1[9] = bin2char[(*src >> 4 )&0x0f]; 
        default_go1[10] = bin2char[(*src >> 0 )&0x0f];

        /* check flash type : serial / parallel */
        switch(ext_para_ptr->flash_type)
        {
        	/* parellel flash   */
        	case 0xbe:
        		strcat(default_go1, "phys_mapped_flash:");
        		break;
            /* serial SPI flash */
            case 0xde:
            	strcat(default_go1, "VenusSFC:");
            	break;
        }

#if 0
        size5 = (0x100000 + 0x20000) / 0x400 ;
        size4 = (*(UINT32 *)(0xbfc00000 - 0x80 + 0x40 )) /0x400 ;
        size3 = (*(UINT32 *)(0xbfc00000 - 0x80 + 0x60 )) /0x400 ;
        size2 = (*(UINT32 *)(0xbfc00000 - 0x80 + 0x50 )) /0x400 ;
        size1 =  wdata /0x400 - size2 - size3 - size4 - size5 ;

        strcat(default_go1, add2string(size1));
        strncat(default_go1, "k,", 2);

        strcat(default_go1, add2string(size2));
        strncat(default_go1, "k,", 2);

        strcat(default_go1, add2string(size3));
        strncat(default_go1, "k,", 2);

        strcat(default_go1, add2string(size4));
        strncat(default_go1, "k,", 2);

        strcat(default_go1, add2string(size5));
        strncat(default_go1, "k ", 2);
#else

	size1 = (*(UINT32 *)(0xbfc00000 - 0x80 + 0x64)) / 0x400;
	size2 = (*(UINT32 *)(0xbfc00000 - 0x80 + 0x60)) / 0x400;
	size3 = (*(UINT32 *)(0xbfc00000 - 0x80 + 0x50)) / 0x400;
	size4 = (*(UINT32 *)(0xbfc00000 - 0x80 + 0x40)) / 0x400;
	size5 = wdata /0x400 - size1 - size2 - size3 - size4;

        strcat(default_go1, add2string(size1));
        strncat(default_go1, "k,", 2);

        strcat(default_go1, add2string(size2));
        strncat(default_go1, "k,", 2);

        strcat(default_go1, add2string(size3));
        strncat(default_go1, "k,", 2);

        strcat(default_go1, add2string(size4));
        strncat(default_go1, "k,", 2);

        strcat(default_go1, add2string(size5));
        strncat(default_go1, "k ", 2);
#endif /* 0 */

        printf("%s \n" , default_go1);//cy test             	
        
        return default_go1;
	}
}
