/***********************************************************************
 *  shell_goliux.c
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/
#include <shell_api.h>
#include <shell.h>
#include <shell_golinux.h>

#include <sys_api.h>
#include <sysdefs.h>
#include <sysdev.h>
#include <flash_api.h>
#include <io_api.h>
#include <ide_api.h>

#include <syserror.h>
#include <shell.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#if defined(Board_RTC_DEFAULT)
  #include <rtc_api.h>
#endif

#include <project_config.h>
/************************************************************************
 *  Definitions
 ************************************************************************/
#define  MIS_GP0DIR         0x1801b100
#define  MIS_GP1DIR         0x1801b104
#define  MIS_GP0DATO        0x1801b108
#define  MIS_GP1DATO        0x1801b10c
#define  MIS_GP0DATI        0x1801b110
#define  MIS_GP1DATI        0x1801b114

#define  SB2_CHIP_INFO      0x1801A204
#define  ATA_PRIMARY_DIR	0x18000110

#define  LINUX_START_SECTOR	0x3f /* 63rd sector */
/************************************************************************
 *  Public variables
 ************************************************************************/
UINT32 *streamfile_ptrA  = (UINT32 *)0xa00000d8;
UINT32 *streamfile_ptrV  = (UINT32 *)0xa00000dc;
UINT32 *streamfile_flagA = (UINT32 *)0xa00000d0;
UINT32 *streamfile_flagV = (UINT32 *)0xa00000d4;

extern UINT32 ide_minor_hdd;
extern t_RTC_calendar  rtc ; 
extern UINT32 is_sata;
/************************************************************************
 *  Static variables
 ************************************************************************/
#if defined(PVRBOX_From_PC) || defined(CONFIG_PVRBOX_PC_V2)
static char * checkif_run_kernel();
#endif

static UINT32 config_gpio_for_usb();
/************************************************************************
 *                          shell_get_time
 ************************************************************************/
UINT32
shell_get_time(void) 
{
 UINT32 time;
        time =                       rtc.second      +
                              (60 *  rtc.minute)     +
                         (60 * 60 *  rtc.hour)       +
                    (24 * 60 * 60 *  rtc.dayofmonth) +
               (30 * 24 * 60 * 60 *  rtc.month)      +
              (365 * 24 * 60 * 60 * (rtc.year -1970)) ;
        return time;      
}

/************************************************************************
 *
 *                          shell_golinux
 *  Description :
 *  -------------
 *  Implements the shell
 *
 *  Return values :
 *  ---------------
 *  None, function never returns
 *
 ************************************************************************/
/* pvrbox product judge rule */
char shell_command[256] = "port 0xb8000004 0x0000ffef; \
                           port 0xb8000000 0x0007afff; \
                           port 0xb8000080 0x00000006; ";

char *shell_golinux( )
{
    int  idx;
    char ch = 0;
    
    //if we don't set these address as '0', the avhdd rescue would crash!!
    *streamfile_flagA = 0;
    *streamfile_flagV = 0;
    *streamfile_ptrA  = 0;
    *streamfile_ptrV  = 0;
    
    printf("Press 'ESC' to Monitor mode\n");
    
#if defined(CONFIG_PVRBOX_PC_V2)
	if (is_sata == 0)
		LOGO_DISP_change(1);
#endif
    
    /* detect for user selection and its */
    for (idx = 0; idx < 20; idx++)
    {

#if !defined(PVRBOX_From_PC) && !defined(CONFIG_PVRBOX_PC_V2)
		////if detecting USB plug-in under booting(USB input pin = GPIO33)
        if (config_gpio_for_usb() == TRUE)
            return NULL;
#endif

        if (GETCHAR(DEFAULT_PORT, &ch ))
        {
            if (ch == ESC)
                return NULL;

#if defined(Rescue_Source_FLASH)
            if (ch == Rescue_Install_Key)
            {
                printf("user pressed key to enter rescue\n");
                break;
            }
#endif
        }

        /* if we defined 'enter rescue with pressing softreset button,
           we need to check GPIO to see if it is pressed */
#if defined(Rescue_Source_FLASH) && defined(Rescue_Install_With_GPIO_Address)
        if ( (REG32(KSEG1(Rescue_Install_With_GPIO_Address)) & Rescue_Install_With_GPIO_Mask) 
             == Rescue_Install_With_GPIO_Value )
        {
            ch = Rescue_Install_Key;
            break;
        }
#endif
    }
    
    
#if defined(Rescue_Source_FLASH)
    if (ch == Rescue_Install_Key)
        return run_rescue_from_flash();
#endif

#if defined(PVRBOX_From_PC) || defined(CONFIG_PVRBOX_PC_V2)
    return checkif_run_kernel();
#else
    /* This shell command disables Ethernet clock for customer 00005 and board 000a */
    if( strncmp(Param_companyID, "0005", 4) == 0 &&
        strncmp(Param_boardID,   "000a", 4) == 0 )
    {
        char *tmpP;
        printf("Disable ethernet clock!\n");
        
        tmpP = run_kernel_from_hdd();
        
        if (tmpP != 0)
        {
            printf("Disable ethernet and 1394 clock!\n");

            strcat(shell_command, tmpP);
            printf("\n\n cylee debug : %s\n", shell_command);
            return shell_command;
        }
        else
            return tmpP;
    }
    else
        return run_kernel_from_hdd();
#endif
}


#ifdef PVRBOX_From_PC
char DeadBeef_Flg = 0;
/************************************************************************
 *                          checkif_run_kernel
 ************************************************************************/
static char * checkif_run_kernel()
{
    t_ide_ctrl_descriptor  ide_ctrl;    
    UINT32                 rc;  
    char                   ch;
    UINT32                 i=0;
    UINT32                 *src = (UINT32 *)0x800fff80;
    
    UINT32                 time_on = shell_get_time(), time_now; 
   	
   	
   	while(ide_minor_hdd == 0xff)  
   	{	
       
       time_now = shell_get_time();
        
       	printf("Try to find HDD or 'ESC' to Monitor mode !\n"); 	
       	if (GETCHAR(DEFAULT_PORT, &ch ))
       		if (ch == ESC)    
       	        return NULL;

       if ((time_now - time_on) >= 15) {
          
            printf("HW Reset IDE !\n");
            IO_init( SYS_MAJOR_IDE, IDE_MINOR_PRIMARY_MASTER, 1);
            IO_init( SYS_MAJOR_IDE, IDE_MINOR_SECONDARY_MASTER, 1);
            time_on = time_now ;
       }     
       else     
            IO_init( SYS_MAJOR_IDE, i++, 0);

       	i= i % 4 ;
   	}

   	sys_dcache_flush_all();
   	
   	/* read header */ 
   	ide_ctrl.command         =  IDE_CMD_READ;	
   	ide_ctrl.u.sector.sector =  LINUX_START_SECTOR;  /* 63rd sector */
   	ide_ctrl.u.sector.count  =  0x1;   /* 1 count would read 512 bytes */
   	ide_ctrl.u.sector.buffer =  (UINT8*)src;
 
   	rc = IO_ctrl( SYS_MAJOR_IDE, ide_minor_hdd, &ide_ctrl );
   
   	if( rc != OK )
   	{
   		printf("read ide sector error!!\n");
	    return NULL;
	}
	
	/* Flush caches */
   	sys_flush_caches();
   	
    
    if (*src == 0xdeadbeef)
    {
        DeadBeef_Flg = 1;
        
        if ( (REG32(KSEG1(MIS_GP0DATI  )) & 0x10000000) || 
             (REG32(KSEG1(SB2_CHIP_INFO)) & 0x0000ff00))
        {
            printf("I'm going to die !!\n");//cy test   
            sys_wait_ms(20);
            
            /* suicide */
            REG32(KSEG1(MIS_GP1DIR))  = 0x08;
        }
    }
    
    if ((*src == 0xdeadbeef) && (*(src+1) == 0xbabeface))
        return run_kernel_from_hdd();
    else
        return run_rescue_from_flash();
}
#elif defined(CONFIG_PVRBOX_PC_V2)
/************************************************************************
 *                          checkif_run_kernel
 ************************************************************************/
static char *checkif_run_kernel(void) {
	t_ide_ctrl_descriptor	ide_ctrl;    
	UINT32			rc;  
	char			ch;
	UINT32			i = 0;
	UINT32			*src = (UINT32 *)0x800fff80;
	UINT8			buf[512];	//512 bytes for 1 sector data block.
	platform_status_info_t	*p_info = (platform_status_info_t*)buf;
	pc_install_cmd_t	*p_cmd;
	UINT32			time_on = shell_get_time(), time_now; 
	UINT8			*p;
	UINT32			checksum;

	while(ide_minor_hdd == 0xff) {
		time_now = shell_get_time();
		printf("Try to find HDD or 'ESC' to Monitor mode !\n"); 	
		if(GETCHAR(DEFAULT_PORT, &ch )) {
			if(ch == ESC)
				return NULL;
		}

		if((time_now - time_on) >= 15) {
			printf("HW Reset IDE !\n");
			IO_init( SYS_MAJOR_IDE, IDE_MINOR_PRIMARY_MASTER, (void*)1);
			IO_init( SYS_MAJOR_IDE, IDE_MINOR_SECONDARY_MASTER, (void*)1);
			time_on = time_now;
		} else {
			IO_init( SYS_MAJOR_IDE, i++, 0);
		}

		i= i % 4;
	}

	sys_dcache_flush_all();

	/* read platform status info*/ 
	ide_ctrl.command		= IDE_CMD_READ;	
	ide_ctrl.u.sector.sector	= PLATFORM_STATUS_INFO_OFFSET;	/* 63rd sector */
	ide_ctrl.u.sector.count		= 0x1;	/* 1 count would read 512 bytes */
	ide_ctrl.u.sector.buffer	= buf;
 
	if((rc = IO_ctrl(SYS_MAJOR_IDE, ide_minor_hdd, &ide_ctrl)) != OK) {
		printf("read ide sector error!!\n");
		return NULL;
	}

	/* Flush caches */
	sys_flush_caches();

	p_info = (platform_status_info_t*)buf;
	checksum = 0;
	if(strncmp(p_info->platform_signature, PLATFORM_SIGNATURE_STRING_V2,
					strlen(PLATFORM_SIGNATURE_STRING_V2)) == 0) {
		for(p = (UINT8*)p_info->platform_signature;
				(UINT32)p < (UINT32)((UINT32)p_info +
					sizeof(platform_status_info_t) +
					LE32_TO_CPU(p_info->part_info_len)); p++) {
			checksum += (UINT32)*p;
			if(checksum > p_info->checksum) {
				break;
			}
		}
	}

	if(strncmp(p_info->platform_signature, PLATFORM_SIGNATURE_STRING_V2,
					strlen(PLATFORM_SIGNATURE_STRING_V2)) != 0 ||
					(p_info->checksum != checksum)) {
		if(p_info->checksum != checksum) {
			printf("Incorrect checksum, Rebuild platform info...\n");
		} else {
			printf("Incorrect signature. Rebuild platform info...\n");
		}

		memset(p_info->platform_signature, 0, sizeof(p_info->platform_signature));
		memcpy(p_info->platform_signature, PLATFORM_SIGNATURE_STRING_V2,
						strlen(PLATFORM_SIGNATURE_STRING_V2));
		p_info->inst		= 0;
		p_info->cmd_addr	= PC_INSTALL_V2_CMD_BUF_OFFSET;
		p_info->max_cmd_len	= PC_INSTALL_V2_CMD_BUF_MAX_LEN;
		p_info->part_info_len	= 0;

		p_info->checksum = 0;

		for(p = (UINT8*)p_info->platform_signature;
			(UINT32)p < (UINT32)((UINT32)p_info +
					sizeof(platform_status_info_t) +
					LE32_TO_CPU(p_info->part_info_len)); p++) {
			p_info->checksum += (UINT32)*p;
		}


		printf("p_info->platform_signature	= %s\n", p_info->platform_signature);
		printf("p_info->cmd_addr		= 0x%X sectors\n", p_info->cmd_addr);
		printf("p_info->max_cmd_len		= %u bytes\n", p_info->max_cmd_len);
		printf("p_info->checksum		= %u\n", p_info->checksum);

		p_info->checksum = CPU_TO_LE32(p_info->checksum);

		ide_ctrl.command		= IDE_CMD_WRITE;	
		ide_ctrl.u.sector.sector	= PLATFORM_STATUS_INFO_OFFSET;
		ide_ctrl.u.sector.count		= 0x1;   /* 1 count would read 512 bytes */
		ide_ctrl.u.sector.buffer	= buf;
 
		if((rc = IO_ctrl(SYS_MAJOR_IDE, ide_minor_hdd, &ide_ctrl)) != OK) {
			printf("write ide sector error!!(minor=%u)\n", ide_minor_hdd);
			return NULL;
		}
	}

	////if detecting USB plug-in under booting(USB input pin = GPIO33)
	if(config_gpio_for_usb() == TRUE)
		return NULL;

	if(p_info->inst) {
		printf("Already installed...\n");
		/* The firmwares have been installed already.
		 * So, we check installation request from cmd->dis. */
		ide_ctrl.command		= IDE_CMD_READ;
		ide_ctrl.u.sector.sector	= PC_INSTALL_V2_CMD_BUF_OFFSET;
		ide_ctrl.u.sector.count		= 0x1;   /* 1 count would read 512 bytes */
		ide_ctrl.u.sector.buffer	= buf;
 
		if((rc = IO_ctrl(SYS_MAJOR_IDE, ide_minor_hdd, &ide_ctrl)) != OK) {
			printf("read ide sector error!!\n");
			return NULL;
		}

		p_cmd = (pc_install_cmd_t*)buf;
		if(p_cmd->dis) {
			/* Command is disabled. */
			printf("Install command is disabled, run kernel from hdd.\n");
			return run_kernel_from_hdd();
		} else {
			printf("Install command is enabled, run rescue from flash.\n");
			/* Installation request. */
			return run_rescue_from_flash();
		}
	} else {
		printf("NOT INSTALLED YET!\n");
		LOGO_DISP_change(2);
	}

	printf("Not installed yet, run rescue from flash.\n");
	/* Not installed yet. */
	return run_rescue_from_flash();
}

UINT32 platform_signature_exists(void) {
	t_ide_ctrl_descriptor	ide_ctrl;    
	UINT32			rc;  
	UINT32			i = 0;
	//UINT32			*src = (UINT32 *)0x800fff80;
	UINT8			buf[512];	//512 bytes for 1 sector data block.
	platform_status_info_t	*p_info;
	UINT32			time_on = shell_get_time(), time_now; 

	while(ide_minor_hdd == 0xff) {
		time_now = shell_get_time();
		printf("Try to find HDD!\n"); 	

		if((time_now - time_on) >= 15) {
			printf("HW Reset IDE !\n");
			IO_init( SYS_MAJOR_IDE, IDE_MINOR_PRIMARY_MASTER, (void*)1);
			IO_init( SYS_MAJOR_IDE, IDE_MINOR_SECONDARY_MASTER, (void*)1);
			time_on = time_now;
		} else {
			IO_init( SYS_MAJOR_IDE, i++, 0);
		}

		i= i % 4;
	}

	sys_dcache_flush_all();

	/* read platform status info*/ 
	ide_ctrl.command		= IDE_CMD_READ;	
	ide_ctrl.u.sector.sector	= PLATFORM_STATUS_INFO_OFFSET;	/* 63rd sector */
	ide_ctrl.u.sector.count		= 0x1;	/* 1 count would read 512 bytes */
	ide_ctrl.u.sector.buffer	= buf;
 
	if((rc = IO_ctrl(SYS_MAJOR_IDE, ide_minor_hdd, &ide_ctrl)) != OK) {
		printf("read ide sector error!!\n");
		return FALSE;
	}

	/* Flush caches */
	sys_flush_caches();

	p_info = (platform_status_info_t*) buf;

	if(strncmp(p_info->platform_signature, PLATFORM_SIGNATURE_STRING_V2,
					strlen(PLATFORM_SIGNATURE_STRING_V2)) != 0) {
		printf("Platform signature does not exist!\n");
		return FALSE;
	}
	printf("Platform signature exists!\n");
	return TRUE;
}
#endif /* CONFIG_PVRBOX_PC_V2 */

static UINT32 config_gpio_for_usb()
{
    UINT32 usb_det_gpio_addr, usb_det_gpio_mask;
    UINT32 usb_set_gpio_addr, usb_set_gpio_mask;
    
    //determine detecting gpio address and mask
    if (Config_USB_DET_GPIO < 32)
    {
        usb_det_gpio_addr = MIS_GP0DATI;
        usb_det_gpio_mask = (UINT32)0x1 << Config_USB_DET_GPIO;
    }
    else
    {
        usb_det_gpio_addr = MIS_GP1DATI;
        usb_det_gpio_mask = 0x1 << (Config_USB_DET_GPIO - 32);
    }

    //determine GL811_EN gpio address and mask
    if (Config_USB_Control_GPIO < 32)
    {
        usb_set_gpio_addr = MIS_GP0DATO;
        usb_set_gpio_mask = (UINT32)0x1 << Config_USB_Control_GPIO;
    }
    else
    {
        usb_set_gpio_addr = MIS_GP1DATO;
        usb_set_gpio_mask = 0x1 << (Config_USB_Control_GPIO - 32);
    }

    ////if detecting USB plug-in under booting stage
    if (REG32 (KSEG1(usb_det_gpio_addr)) & usb_det_gpio_mask)
    {
        //  1. set primary ATA as input
        REG32 (KSEG1( ATA_PRIMARY_DIR)) = 0x2a;
        //  2. set GPIO direction as input, and show notificatino message
        REG32 (KSEG1( usb_set_gpio_addr)) = REG32 (KSEG1( usb_set_gpio_addr)) | usb_set_gpio_mask;
        printf("Polling detects device connect to PC!!!\n");
        printf("Release HD control and stay in boot shell!!!\n");
        //  3. return to shell
        return TRUE;
    }
    
    return FALSE;
}
