/***********************************************************************
 *  shell_goliux.c
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/
#include <shell_api.h>
#include <shell.h>
#include <shell_golinux.h>

#include <sys_api.h>
#include <sysdefs.h>
#include <sysdev.h>
#include <flash_api.h>
#include <io_api.h>
#include <ide_api.h>

#include <syserror.h>
#include <shell.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#include <project_config.h>
/************************************************************************
 *  Definitions
 ************************************************************************/
#define  MIS_GP0DATI        0x1801b110
#define  MIS_GP1DIR         0x1801b104
#define  SB2_CHIP_INFO      0x1801A204

/************************************************************************
 *  Public variables
 ************************************************************************/
UINT32 *streamfile_ptrA  = (UINT32 *)0xa00000d8;
UINT32 *streamfile_ptrV  = (UINT32 *)0xa00000dc;
UINT32 *streamfile_flagA = (UINT32 *)0xa00000d0;
UINT32 *streamfile_flagV = (UINT32 *)0xa00000d4;

extern UINT32 ide_minor_hdd;
/************************************************************************
 *  Static variables
 ************************************************************************/
#ifdef PVRBOX_From_PC
static char * checkif_run_kernel();
#endif
/************************************************************************
 *
 *                          shell_golinux
 *  Description :
 *  -------------
 *  Implements the shell
 *
 *  Return values :
 *  ---------------
 *  None, function never returns
 *
 ************************************************************************/
char *shell_golinux( )
{
    int  idx;
    char ch = 0;
    
    //if we don't set these address as '0', the avhdd rescue would crash!!
   	*streamfile_flagA = 0;
    *streamfile_flagV = 0;
    *streamfile_ptrA  = 0;
    *streamfile_ptrV  = 0;
    
    printf("Press 'ESC' to Monitor mode\n");
    
    /* detect for user selection and its */
    for (idx = 0; idx < 20; idx++)
    {
        if (GETCHAR(DEFAULT_PORT, &ch ))
        {
            if (ch == ESC)
                return NULL;

#if defined(Rescue_Source_FLASH)
            if (ch == Rescue_Install_Key)
            {
            	printf("user pressed key to enter rescue\n");
                break;
            }
#endif
        }



        /* if we defined 'enter rescue with pressing softreset button,
           we need to check GPIO to see if it is pressed */
#if defined(Rescue_Source_FLASH) && defined(Rescue_Install_With_GPIO)
        if ((REG32(KSEG1(MIS_GP0DATI)) & Rescue_Install_With_GPIO) )
        {
        	install_flg = FALSE;
        }
#endif
    }
    
    
#if defined(Rescue_Source_FLASH)
    if (ch == Rescue_Install_Key)
    	return run_rescue_from_flash();

  #if defined(Rescue_Install_With_GPIO)
    if (install_flg == TRUE)
        return run_rescue_from_flash();
  #endif
#endif

   	return run_kernel_from_hdd();
}
