/***********************************************************************
 *  shell_goliux.c
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/
#include <shell_api.h>
#include <shell.h>
#include <shell_golinux.h>

#include <sys_api.h>
#include <sysdefs.h>
#include <sysdev.h>
#include <flash_api.h>
#include <io_api.h>

#include <syserror.h>
#include <shell.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>
#include <stddef.h>

#if defined(Board_RTC_DEFAULT)
  #include <rtc_api.h>
#endif

#include <project_config.h>
#include <extern_param.h>
/************************************************************************
 *  Definitions
 ************************************************************************/
#define  MIS_GP0DIR         0x1801b100
#define  MIS_GP1DIR         0x1801b104
#define  MIS_GP0DATO        0x1801b108
#define  MIS_GP1DATO        0x1801b10c
#define  MIS_GP0DATI        0x1801b110
#define  MIS_GP1DATI        0x1801b114

#define  SB2_CHIP_INFO      0x1801A204
#define  ATA_PRIMARY_DIR	0x18000110

#define RESCUE_LINUX_FILE_NAME	"vmlinux.rescue.bin"
#define QC_LINUX_FILE_NAME	"vmlinux.qc.bin"
/************************************************************************
 *  Public variables
 ************************************************************************/
UINT32 *streamfile_ptrA  = (UINT32 *)0xa00000d8;
UINT32 *streamfile_ptrV  = (UINT32 *)0xa00000dc;
UINT32 *streamfile_flagA = (UINT32 *)0xa00000d0;
UINT32 *streamfile_flagV = (UINT32 *)0xa00000d4;

extern t_extern_param *ext_para_ptr;
extern t_RTC_calendar  rtc ; 
/************************************************************************
 *  Static variables
 ************************************************************************/
#ifdef Config_USB_DET_GPIO
static UINT32 config_gpio_for_usb();
#endif

#ifdef Config_QC_Test_Prog_TRUE
UINT32 QC_test_enabled = 0;
#endif /* Config_QC_Test_Prog_TRUE */

UINT32 MP_test_enabled = 0; //neil MP Test

/************************************************************************
 *                          shell_get_time
 ************************************************************************/
UINT32
shell_get_time(void) 
{
 UINT32 time;
        time =                       rtc.second      +
                              (60 *  rtc.minute)     +
                         (60 * 60 *  rtc.hour)       +
                    (24 * 60 * 60 *  rtc.dayofmonth) +
               (30 * 24 * 60 * 60 *  rtc.month)      +
              (365 * 24 * 60 * 60 * (rtc.year -1970)) ;
        return time;      
}


UINT32 get_checksum(UINT8 *p, UINT32 len) {
	UINT32 checksum = 0;
	UINT32 i;

	for(i = 0; i < len; i++) {
		checksum += *(p+i);
	}
	return checksum;
}

extern void		error_led_blinking(void); //neil flash/memory error blinking (shell.c)

//neil flash/memory rest
//neil {
extern UINT32 mem_pattern_write(UINT32, UINT32, UINT32, UINT32);
extern UINT32 *mem_pattern_verify(UINT32, UINT32, UINT32, UINT32);
extern UINT32 errordump[];
extern t_RTC_calendar  rtc;
#define MEMCHECK_LOOP	3
#define	TEST_BLOCK		0x80000


static bool memory_test(void)
{
	UINT32 start; 
	UINT32 size;
	UINT32 loops = MEMCHECK_LOOP;			
	UINT32 cnt;
	UINT32 dummy;
	UINT32 newstart, newend;
	UINT32 seed;
	UINT32 *erroradr;
	char   *wheel = "|/-\\";
	bool		ctrl_c = FALSE;
	int			wix = 0;
	UINT32	wdata;
	UINT32	log_endaddr;
	UINT32	log_len;

	if(SYSCON_read( SYSCON_BOARD_SYSTEMRAM_ACTUAL_SIZE_ID, &wdata, sizeof(wdata)) == OK)
		printf("SDRAM size = %08x, sys_ramsize = %08x\n", wdata, sys_ramsize);

	if (sys_ramsize != 0x04000000) return FALSE; // if not 64M, return false
		
	/* Setup default RAM parameters */	
	start = (KSEG1(sys_freemem) + 0xff) & ~0xff;  
	size  = KSEG1(sys_ramsize) - start;
    
  size = size -256 ; //cy test for bridge2 cal. cause
  printf("Memory test from 0x%08X to 0x%08X, ", start, start + size - 4 );

  if( !loops )	   
      printf("loop indefinitely.\n" );
  else
      printf("%d loop%s\n", loops, loops == 1 ? "." : "s.");

	if (loops != 1 || (size > TEST_BLOCK)) printf( "%s\n", shell_msg_ctrl_c);

	erroradr = 0;

	for (cnt=0; ((loops == 0) || (cnt<loops)) && erroradr==0 && !ctrl_c; cnt++) {
		printf("\rNow running loop %d %c", cnt+1, wheel[wix = ((wix+1) & 0x3)]);
		
		seed = cnt;
		for (newstart=start; (newstart<start+size) && erroradr==0 && !ctrl_c; newstart += TEST_BLOCK) {
			newend = newstart + TEST_BLOCK;
			if (newend > start+size) newend = start+size;
	    dummy = newstart;
	    mem_pattern_write(newstart, (UINT32)&dummy, newend, seed);
	    seed = dummy;
	    printf("\b%c", wheel[wix = ((wix+1) & 0x3)]);
	    if ( GETCHAR_CTRLC(DEFAULT_PORT) ) ctrl_c = TRUE;
		}
		seed = cnt;
        
		for (newstart=start;(newstart<start+size) && erroradr==0 && !ctrl_c; newstart += TEST_BLOCK) {     
	    newend = newstart + TEST_BLOCK;
	    if (newend > start+size) newend = start+size;
	    	
	    dummy = newstart;
	    if ((erroradr = mem_pattern_verify(newstart, (UINT32)&dummy, newend, seed))) {
	    	printf("\nFailed at address: 0x%08X\n", (UINT32)erroradr);
	    	printf("Written    Read       Difference Re-Read\n");
	    	for (cnt=0; cnt<8; cnt++)
	    		printf("0x%08X 0x%08X 0x%08X 0x%08X\n",
						errordump[cnt*2],  errordump[cnt*2+1],
						errordump[cnt*2] ^ errordump[cnt*2+1],
						erroradr[cnt]);
	    }
	    seed = dummy;
	    
	    if (erroradr == 0) {
	    	printf("\b%c", wheel[wix = ((wix+1) & 0x3)]);
	    	if (GETCHAR_CTRLC(DEFAULT_PORT)) ctrl_c = TRUE;
	    }
		}
	}
	
	if (!ctrl_c) printf("\n");
	return erroradr == 0;
}

#define SKIP_RATE	16

static bool short_memory_test(void)
{
	UINT32 start; 
	UINT32 size;
	UINT32 loops = 1;
	UINT32 cnt;
	UINT32 dummy;
	UINT32 newstart, newend;
	UINT32 seed;
	UINT32 *erroradr;
	char   *wheel = "|/-\\";
	bool		ctrl_c = FALSE;
	int			wix = 0;
	UINT32	wdata;
	UINT32	log_endaddr;
	UINT32	log_len;

	if(SYSCON_read( SYSCON_BOARD_SYSTEMRAM_ACTUAL_SIZE_ID, &wdata, sizeof(wdata)) == OK)
		printf("SDRAM size = %08x, sys_ramsize = %08x\n", wdata, sys_ramsize);

	if (sys_ramsize != 0x04000000) return FALSE; // if not 64M, return false
		
	//printf("logo1(%08x), logo2(%08x), logo3(%08x)\n",  ext_para_ptr->logo_img_len, ext_para_ptr->logo2_img_len, ext_para_ptr->logo3_img_len);

	/* Setup default RAM parameters */
	// skip logo memory	
	log_len = ext_para_ptr->logo_img_len > ext_para_ptr->logo2_img_len ? ext_para_ptr->logo_img_len : ext_para_ptr->logo2_img_len;
	log_len = log_len > ext_para_ptr->logo3_img_len ? log_endaddr : ext_para_ptr->logo3_img_len;

	log_endaddr = 0xa00f0000 + log_len;
	start = KSEG1(sys_freemem) > log_endaddr ? KSEG1(sys_freemem) : log_endaddr;
	
	start = (start + 0xff) & ~0xff;  
	size  = KSEG1(sys_ramsize) - start;
    
  size = size -256 ; //cy test for bridge2 cal. cause
  printf("Memory test from 0x%08X to 0x%08X, ", start, start + size - 4 );

  if( !loops )	   
      printf("loop indefinitely.\n" );
  else
      printf("%d loop%s\n", loops, loops == 1 ? "." : "s.");

	if (loops != 1 || (size > TEST_BLOCK)) printf( "%s\n", shell_msg_ctrl_c);

	erroradr = 0;

	for (cnt=0; ((loops == 0) || (cnt<loops)) && erroradr==0 && !ctrl_c; cnt++) {
		printf("\rNow running loop %d %c", cnt+1, wheel[wix = ((wix+1) & 0x3)]);
		
		seed = cnt;
		for (newstart=start; (newstart<start+size) && erroradr==0 && !ctrl_c; newstart += TEST_BLOCK * SKIP_RATE) {
			newend = newstart + TEST_BLOCK;
			if (newend > start+size) newend = start+size;
	    dummy = newstart;
	    mem_pattern_write(newstart, (UINT32)&dummy, newend, seed);
	    seed = dummy;
	    printf("\b%c", wheel[wix = ((wix+1) & 0x3)]);
	    if ( GETCHAR_CTRLC(DEFAULT_PORT) ) ctrl_c = TRUE;
		}
		seed = cnt;
        
		for (newstart=start;(newstart<start+size) && erroradr==0 && !ctrl_c; newstart += TEST_BLOCK * SKIP_RATE) {     
	    newend = newstart + TEST_BLOCK;
	    if (newend > start+size) newend = start+size;
	    	
	    dummy = newstart;
	    if ((erroradr = mem_pattern_verify(newstart, (UINT32)&dummy, newend, seed))) {
	    	printf("\nFailed at address: 0x%08X\n", (UINT32)erroradr);
	    	printf("Written    Read       Difference Re-Read\n");
	    	for (cnt=0; cnt<8; cnt++)
	    		printf("0x%08X 0x%08X 0x%08X 0x%08X\n",
						errordump[cnt*2],  errordump[cnt*2+1],
						errordump[cnt*2] ^ errordump[cnt*2+1],
						erroradr[cnt]);
	    }
	    seed = dummy;
	    
	    if (erroradr == 0) {
	    	printf("\b%c", wheel[wix = ((wix+1) & 0x3)]);
	    	if (GETCHAR_CTRLC(DEFAULT_PORT)) ctrl_c = TRUE;
	    }
		}
	}

	if (!ctrl_c) printf("\n");
	return erroradr == 0;
}
//neil }

/************************************************************************
 *
 *                          shell_golinux
 *  Description :
 *  -------------
 *  Implements the shell
 *
 *  Return values :
 *  ---------------
 *  None, function never returns
 *
 ************************************************************************/
/* avhdd product judge rule */

char *shell_golinux(void) {
	char ch = 0;
	bool install_flg = TRUE;
	t_FLASH_ctrl_descriptor flash_ctrl;
	t_FLASH_write_descriptor flash_write;
	fw_desc_table_t fw_desc_table;
	fw_desc_entry_t fw_desc_entry[8];
	UINT32 flash_start_addr;
	UINT32 flash_size;
	INT32 rcode;
	UINT32 checksum;
	char signature_str_buf[32];
	int i;
	//UINT32 *babe_magic_addr = (UINT32 *)(ext_para_ptr->env_param_saddr + 0xff00);
	UINT32 *scit_signature_addr;

	//if we don't set these address as '0', the avhdd rescue would crash!!
	*streamfile_flagA = 0;
	*streamfile_flagV = 0;
	*streamfile_ptrA  = 0;
	*streamfile_ptrV  = 0;

	printf("Press 'ESC' to Monitor mode, 'q' to Memory/Flash test mode\n");

	/* detect for user selection and its */
	for(i = 0; i < 50; i++) {
		if(GETCHAR(DEFAULT_PORT, &ch)) {
			if(ch == ESC)
				return NULL;
#ifdef Config_QC_Test_Prog_TRUE
			if(ch == KEY_Q)
				QC_test_enabled = 1;
#endif /* Config_QC_Test_Prog_TRUE */
		}
#if 0
		/* if this product have IDE, then detect it
			and delay for IDE ready */
		if((REG32(KSEG1(MIS_GP0DATI))&0x10000000) || 
			(REG32(KSEG1(SB2_CHIP_INFO))&0x0000ff00)) {
			printf("I'm going to die !!\n");//cy test
			sys_wait_ms(20);
			/* suicide */
			REG32(KSEG1(MIS_GP1DIR)) = 0x08;
		}
#endif

		/* if we defined 'enter rescue with pressing softreset button,
			we need to check GPIO to see if it is pressed */
#if defined(Rescue_Install_With_GPIO_Address)
		if((REG32(KSEG1(Rescue_Install_With_GPIO_Address))
				& Rescue_Install_With_GPIO_Mask) 
					== Rescue_Install_With_GPIO_Value) {
			ch = Rescue_Install_Key;
			break;
		}
#endif
		if((REG32(KSEG1(0xb801b114)) & 0x00000008) == 0) {
			MP_test_enabled = 1;
			REG32(KSEG1(0xb801b104)) |= 2;
			REG32(KSEG1(0xb801b10C)) |= 2;
			break;
		}
			sys_wait_ms(20); //neil
	}
    
	////if detecting USB plug-in under booting(USB input pin = GPIO33)
#ifdef Config_USB_DET_GPIO
	if (config_gpio_for_usb() == TRUE)
		return NULL;
#endif

	if (ch == Rescue_Install_Key) {
		LOGO_DISP_change(2);
#if defined(Rescue_Source_USB) && defined(Board_USB_Driver_Enabled)
		return run_rescue_from_usb(RESCUE_LINUX_FILE_NAME);
#elif defined(Rescue_Source_FLASH)
		return run_rescue_from_flash();
#endif
	}

#ifdef Config_QC_Test_Prog_TRUE
	if(QC_test_enabled) {
		//neil printf("Entering QC Linux for QC Test...\n");
		//neil return run_rescue_from_usb(QC_LINUX_FILE_NAME);
		//printf("Entering Flash/Memory Test...\n"); //neil
	}
#endif /* Config_QC_Test_Prog_TRUE */

	/* Get flash size. */
	if((rcode = SYSCON_read(SYSCON_BOARD_MONITORFLASH_SIZE_ID,
				&flash_size, sizeof(flash_size))) != OK) {
		printf("get flash size fail!!\n");
		error_led_blinking(); //neil   
		return NULL;
	}

	flash_start_addr = 0xbfd00000 - flash_size;

	memcpy(&fw_desc_table, (void*)flash_start_addr, sizeof(fw_desc_table));
	fw_desc_table.checksum = BE32_TO_CPU(fw_desc_table.checksum);

	memcpy(fw_desc_entry, (void*)flash_start_addr+sizeof(fw_desc_table),
							sizeof(fw_desc_entry));
	checksum = get_checksum((UINT8*)&fw_desc_table + offsetof(fw_desc_table_t, version),
			sizeof(fw_desc_table_t) - offsetof(fw_desc_table_t, version));
	checksum += get_checksum((UINT8*)fw_desc_entry, sizeof(fw_desc_entry));

	memset(signature_str_buf, 0, sizeof(signature_str_buf));
	memcpy(signature_str_buf, fw_desc_table.signature, sizeof(fw_desc_table.signature));
	/* Check checksum and signature. */
	if(fw_desc_table.checksum != checksum || 
		strncmp(fw_desc_table.signature,
			FIRMWARE_DESCRIPTION_TABLE_SIGNATURE,
			sizeof(fw_desc_table.signature)) != 0) {
		printf("Checksum(0x%x) or signature(%s) error! Entering rescue linux...\n",
				fw_desc_table.checksum, signature_str_buf);
		LOGO_DISP_change(2);
#if defined(Rescue_Source_USB) && defined(Board_USB_Driver_Enabled)
		return run_rescue_from_usb(RESCUE_LINUX_FILE_NAME);
#else /* defined(Rescue_Source_USB) && defined(Board_USB_Driver_Enabled) */
		return run_rescue_from_flash();
#endif /* defined(Rescue_Source_USB) && defined(Board_USB_Driver_Enabled) */
	}

	scit_signature_addr = (UINT32*)(0xbfd00000 - 0x100000 - 0x100);

	if(strncmp((char*)scit_signature_addr, VERONA_SCIT_SIGNATURE_STRING,
				strlen(VERONA_SCIT_SIGNATURE_STRING)) != 0) {
		printf("Can not find signature string, \"%s\"! Entering rescue linux...\n",
				VERONA_SCIT_SIGNATURE_STRING);
		LOGO_DISP_change(2);
#if defined(Rescue_Source_USB) && defined(Board_USB_Driver_Enabled)
		return run_rescue_from_usb(RESCUE_LINUX_FILE_NAME);
#else /* defined(Rescue_Source_USB) && defined(Board_USB_Driver_Enabled) */
		return run_rescue_from_flash();
#endif /* defined(Rescue_Source_USB) && defined(Board_USB_Driver_Enabled) */
	}
#if 0
	if(*babe_magic_addr != 0x65626162) { /* Not installed yet. */
		printf("Can not find magic babe! Entering rescue linux...\n");
		return run_rescue_from_flash();
	}
#endif /* 0 */

	if(QC_test_enabled) printf("Entering Flash Testing...\n"); //neil
	
	fw_desc_table.length = BE32_TO_CPU(fw_desc_table.length);

	for(i = 0; i < (int)ARRAY_COUNT(fw_desc_entry); i++) {
		fw_desc_entry[i].version = BE32_TO_CPU(fw_desc_entry[i].version);
		fw_desc_entry[i].target_addr = BE32_TO_CPU(fw_desc_entry[i].target_addr);
		fw_desc_entry[i].offset = BE32_TO_CPU(fw_desc_entry[i].offset);
		fw_desc_entry[i].length = BE32_TO_CPU(fw_desc_entry[i].length);
		fw_desc_entry[i].paddings = BE32_TO_CPU(fw_desc_entry[i].paddings);
		fw_desc_entry[i].checksum = BE32_TO_CPU(fw_desc_entry[i].checksum);
		fw_desc_entry[i].offset_1 = BE32_TO_CPU(fw_desc_entry[i].offset_1);
//neil
		if(QC_test_enabled) { //neil flash test
			if (fw_desc_entry[i].checksum == 0 || i == FW_IDX_JFFS2) continue; // skip no checksum and JFFS2
			//printf("=== RTC : %02d:%02d:%02d ===\n", rtc.hour, rtc.minute, rtc.second);
			checksum = get_checksum((char *)(flash_start_addr+fw_desc_entry[i].offset), fw_desc_entry[i].length);
			//printf("flash_start_addr(%08x)+fw_desc_entry[%d].offset(%08x) = (%08x), fw_desc_entry[%d].length = %08x\n", flash_start_addr, i, fw_desc_entry[i].offset, (flash_start_addr+fw_desc_entry[i].offset), i, fw_desc_entry[i].length);
			if (fw_desc_entry[i].checksum != checksum) {
				printf("fw_desc_entry[%d].checksum = %08x, get_checksum() = %08x\n", i, fw_desc_entry[i].checksum, checksum);
				printf("ErrCode: 12001 Msg: Memcheck Fail\n");
				error_led_blinking();
				return NULL;
			}
		}
	}

	if(QC_test_enabled) 

	if(QC_test_enabled) { //neil memory test
		printf("ErrCode: 0 Msg: OK\n");
		printf("Entering Memory Testing...\n"); //neil
//printf("=== RTC : %02d:%02d:%02d ===\n", rtc.hour, rtc.minute, rtc.second);
		if (!memory_test()) {
			printf("ErrCode: 12001 Msg: Memcheck Fail\n");
			error_led_blinking();
			return NULL;
		} else
			printf("ErrCode: 0 Msg: OK\n");
//printf("=== RTC : %02d:%02d:%02d ===\n", rtc.hour, rtc.minute, rtc.second);
	} else {
//printf("=== RTC : %02d:%02d:%02d ===\n", rtc.hour, rtc.minute, rtc.second);
		if (!short_memory_test()) {
			printf("ErrCode: 12001 Msg: Memcheck Fail\n");
			error_led_blinking();
			return NULL;			
		}
//printf("=== RTC : %02d:%02d:%02d ===\n", rtc.hour, rtc.minute, rtc.second);
	}
	
    	return run_kernel_from_flash(flash_start_addr, flash_size,
			fw_desc_entry, ARRAY_COUNT(fw_desc_entry));
}

#ifdef Config_USB_DET_GPIO
static UINT32 config_gpio_for_usb()
{
    UINT32 usb_det_gpio_addr, usb_det_gpio_mask;
    UINT32 usb_set_gpio_addr, usb_set_gpio_mask;
    
    //determine detecting gpio address and mask
    if (Config_USB_DET_GPIO < 32)
    {
        usb_det_gpio_addr = MIS_GP0DATI;
        usb_det_gpio_mask = 0x1 << Config_USB_DET_GPIO;
    }
    else
    {
        usb_det_gpio_addr = MIS_GP1DATI;
        usb_det_gpio_mask = 0x1 << (Config_USB_DET_GPIO - 32);
    }

#ifndef Board_CPU_VENUS
    //determine GL811_EN gpio address and mask
    if (Config_USB_Control_GPIO < 32)
    {
        usb_set_gpio_addr = MIS_GP0DATO;
        usb_set_gpio_mask = 0x1 << Config_USB_Control_GPIO;
    }
    else
    {
        usb_set_gpio_addr = MIS_GP1DATO;
        usb_set_gpio_mask = 0x1 << (Config_USB_Control_GPIO - 32);
    }
#endif /* Board_CPU_VENUS */

# ifdef Config_QC_Test_Prog_TRUE
    if(QC_test_enabled) {
        return FALSE;
    }
# endif /* Config_QC_Test_Prog_TRUE */

    ////if detecting USB plug-in under booting stage
    if (REG32 (KSEG1(usb_det_gpio_addr)) & usb_det_gpio_mask)
    {
#ifdef Board_CPU_VENUS
        printf("I'm going to die !!\n");//cy test
        sys_wait_ms(20);
        /* suicide */
        REG32(KSEG1(MIS_GP1DIR)) = 0x08;
#else /* Board_CPU_VENUS */
        //  1. set primary ATA as input
        REG32 (KSEG1( ATA_PRIMARY_DIR)) = 0x2a;
        //  2. set GPIO direction as input, and show notificatino message
        REG32 (KSEG1( usb_set_gpio_addr)) = REG32 (KSEG1( usb_set_gpio_addr)) | usb_set_gpio_mask;
        printf("Polling detects device connect to PC!!!\n");
        printf("Release HD control and stay in boot shell!!!\n");
        //  3. return to shell
#endif /* Board_CPU_VENUS */
        return TRUE;
    }
    
    return FALSE;
}
#endif
