
/***********************************************************************
 *
 *  shell_rescue_inflash.c
 *
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/

#include <shell_api.h>
#include <sysdefs.h>
#include <syserror.h>
#include <shell.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#include <flash_api.h>

#include <shell_golinux.h>
#include <project_config.h>
#include <extern_param.h>

extern UINT32 shell_go_rescue;

char *go_rescue_inusb = "go 0x80100000 ";

/************************************************************************
 *                          run_rescue_from_usb_
 ************************************************************************/
char *run_rescue_from_usb(const char *rescue_file_name)
{
    UINT32      streamfile_size = 0;
    UINT8       *src;   
    UINT32      ret;
    char        cmd[64];
    
    /********* extract rescue linux kernel  ***********/       
	
    printf("Rescue kernel in USB\n");

    memset((void*)0x80100000, 0, 0x100);

    memset(cmd, 0, sizeof(cmd));
    sprintf(cmd, "usb fw %s 0x80100000", rescue_file_name);
    if((ret = execute_line(cmd, TRUE)) == OK) {
        /* Flush caches */ 
        sys_flush_caches();    
        shell_go_rescue = TRUE;
        return go_rescue_inusb;
    }

    return NULL;
}   
