/************************************************************************
 *
 *  syscon_core.c
 *
 *  Core card specific parts of SYSCON module.
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/


/************************************************************************
 *  Include files
 ************************************************************************/

#include <sysdefs.h>
#include <syscon_api.h>
#include <sys_api.h>
#include <syscon.h>
#include <syserror.h>
#include <stdio.h>
#include <product.h>
#include <malta.h>

#include <core_sys.h>

#include <string.h>

/************************************************************************
 *  Definitions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/

/************************************************************************
 *  Static variables
 ************************************************************************/

/* Pointer to array of objects */
static t_syscon_obj       *syscon_objects;

/* Core card names */
static char   *name_qed_rm5261	      = "QED RM5261 Board";
static char   *name_core_lv	      = "CoreLV";
static char   *name_core_bonito	      = "CoreBonito64"; /* also "Bonito64" */
static char   *name_core_20k	      = "Core20K";
static char   *name_core_fpga	      = "CoreFPGA";
static char   *name_core_sys	      = "CoreSYS";
static char   *name_core_emul	      = "CoreEMUL";
static char   *name_core_fpga2        = "CoreFPGA-2";
static char   *name_galileo           = "Galileo";
       char   *name_msc01             = "MIPS SOC-it 101\0       ";
static char   version_syscntrl[32]    = "unknown version";

/* North Bridge settings */
static UINT32 pci_mem_start;
static UINT32 pci_mem_size;
static UINT32 pci_mem_offset;
static UINT32 pci_io_start;
static UINT32 pci_io_size;
static UINT32 pci_io_offset;

static UINT32 ram_range_base;
static UINT32 ram_range_size;

/************************************************************************
 *  Static function prototypes
 ************************************************************************/



/************************************************************************
 *  Static functions
 ************************************************************************/


/************************************************************************
 *  Static functions registered for handling particular SYSCON objects 
 *  for particular core cards.
 ************************************************************************/







/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/


/************************************************************************
 *
 *                          syscon_arch_core_init
 *  Description :
 *  -------------
 *
 *  Initialize core card specific part of SYSCON
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
void 
syscon_arch_core_init( 
    t_syscon_obj *objects,		/* Array of SYSCON objects      */
    UINT32	 nb_ram_size		/* Size of MAX RAM range	*/
     )	
{
    UINT32 n;
    char  *s;
    syscon_objects = objects;

    ram_range_base = 0;	/* RAM must always reside at base address 0 */

   
	ram_range_size = nb_ram_size;

     

    /* SDRAM parameters */

    syscon_register_generic( SYSCON_BOARD_SYSTEMRAM_BASE_ID,
	     syscon_uint32_read, (void *)&ram_range_base,
	     NULL,		 NULL );

    syscon_register_generic( SYSCON_BOARD_SYSTEMRAM_SIZE_ID,
	     syscon_uint32_read, (void *)&ram_range_size,
	     NULL,		 NULL );


}   



