/************************************************************************
 *      Include files
 ************************************************************************/
#include <string.h>
#include <io_api.h> 
#include <ide_api.h>
#include <sysdev.h>
#include <iso_api.h>
#include <stdio.h>

 


/*****************************************************
 * public variable
 ****************************************************/
short serial;  

/*****************************************************
 * static function
 ****************************************************/
short    
Find_dir(struct iso_path_table **ptp, char *path, 
          short parent, struct iso_path_table **foundptp);
/*****************************************************
 *
 ****************************************************/
UINT32
ISO_file_read( char   *filename,
               UINT8  *buffer)
{
   t_ide_ctrl_descriptor  ide_ctrl;
   struct iso_primary_descriptor * vdp;
   struct iso_path_table         * ptp; 
   struct iso_path_table         * foundptp;
   struct iso_directory_record   * drp; 
   char   *path;
   char   *tmpname;
   char   *kptr;
   short  parent;
   UINT32 fl_size;
   int    i;
   
   
	
   tmpname = filename ;	
#if 1   	
   ide_ctrl.command         = IDE_PACKET_CMD_READ;	
   ide_ctrl.u.sector.sector = 16;
   ide_ctrl.u.sector.count  =  1;
   ide_ctrl.u.sector.buffer = buffer;
   	
   IO_ctrl( SYS_MAJOR_IDE, 0, &ide_ctrl );	
   
   vdp = (struct iso_primary_descriptor *)buffer;
#else
   vdp = (struct iso_primary_descriptor *)0xbfc70000;   
#endif
  
   if (strncmp(vdp->id, ISO_STANDARD_ID, sizeof(vdp->id)) != 0)
      return ERROR_ISO_UNKNOWN;
          
   if (*(vdp->type) != ISO_VD_PRIMARY)
      return ERROR_ISO_UNKNOWN;
    
  
   
#if 1      
   ide_ctrl.command         = IDE_PACKET_CMD_READ;	
   ide_ctrl.u.sector.sector = CPU_TO_BE32(*(UINT32*)vdp->type_m_path_table);
   ide_ctrl.u.sector.count  =  1;
   ide_ctrl.u.sector.buffer = buffer;
      
   IO_ctrl( SYS_MAJOR_IDE, 0, &ide_ctrl );    
   
   ptp = (struct iso_path_table *)buffer;
#else   
   ptp = (struct iso_path_table *)0xbfc60000; 
#endif    
   foundptp = ptp ;
   serial = 0;   
   parent = 0x0001;
       
   while((kptr = strchr(tmpname , '/'))!=0)
   {   
       path = tmpname;
       *kptr = '\0'; 
       tmpname = kptr+1;	           
       parent = Find_dir(&ptp, path, parent, &foundptp);
       
       if (parent == 0)
          return ERROR_PATH_UNKNOWN;
          
//       printf("parent =0x%x \n", parent);
//       printf("tmpname =%s \n", tmpname);
             
   }
 
//   printf("foundptp = 0x%x \n", (UINT32)foundptp);//cy test
   
   for (i =0 ; i<4 ; i++)
     *((char *)(&ide_ctrl.u.sector.sector)+i) = foundptp->extent[3-i];
   
  

    
#if 1   
   ide_ctrl.command         = IDE_PACKET_CMD_READ;	
   for (i =0 ; i<4 ; i++)
     *((char *)(&ide_ctrl.u.sector.sector)+i) = foundptp->extent[3-i];
   ide_ctrl.u.sector.count  =  1;
   ide_ctrl.u.sector.buffer = buffer;
      
   IO_ctrl( SYS_MAJOR_IDE, 0, &ide_ctrl );    
   
   drp  = (struct iso_directory_record *)buffer;
#else
   drp  = (struct iso_directory_record *)0xbfc80000;
#endif   
   (char *)drp += *(drp->length);
   (char *)drp += *(drp->length);
   
   while ((strncmp(drp->name, tmpname, strlen(tmpname)) != 0) ||
          (*(drp->name_len) != strlen(tmpname))||
          (*(drp->flags) != 0x00)) 
   {      
   	 
   	 if (*(drp->length) == 0x00)
   	    return  ERROR_FILE_UNKNOWN;      
   	    
         (char *)drp += *(drp->length);
   }
   
   for (i =0 ; i<4 ; i++)
   {
     *((char *)(&fl_size)+i) = drp->size[i];
     *((char *)(&ide_ctrl.u.sector.sector)+i) = drp->extent[i];
   }  
     
    ide_ctrl.command         = IDE_PACKET_CMD_READ;	
    ide_ctrl.u.sector.count  = 1;  
    ide_ctrl.u.sector.buffer = buffer;
   
   for (i =0 ; i < (fl_size/0x800 +1); i++)
   {   
     IO_ctrl( SYS_MAJOR_IDE, 0, &ide_ctrl );    
     
     ide_ctrl.u.sector.sector = ide_ctrl.u.sector.sector + 1 ; 
     ide_ctrl.u.sector.buffer = ide_ctrl.u.sector.buffer + 0x800;  
   }   
   
  
   
   
   printf("file size = 0x%x \n" , fl_size);

   return OK;   
}    
      
     
      
short    
Find_dir(struct iso_path_table **ptp, char *path, 
          short parent, struct iso_path_table **foundptp)
{      
   	
   short next_parent= 0;
   char  *newptp = *(char **)ptp;
   
   while (CPU_TO_BE16(*(short *)((*ptp)->parent))!=parent)
   { 
     serial++;
     newptp =  newptp + 8 + *(UINT8 *)((*ptp)->name_len)+ (*(UINT8 *)((*ptp)->name_len)%2 ?  1 : 0 );
    
     *ptp =(struct iso_path_table * )newptp;
   }  	
   
  
   while (CPU_TO_BE16(*(short *)((*ptp)->parent))==parent)
   { 
     serial++;
     
     if ((strncmp((*ptp)->name, path, *((*ptp)->name_len))== 0) &&
         (*((*ptp)->name_len) == strlen(path)) )        
     {    
          next_parent = serial;
          *foundptp = *ptp;
     }         
          
     newptp =  newptp + 8 + *(UINT8 *)((*ptp)->name_len)+ (*(UINT8 *)((*ptp)->name_len)%2 ?  1 : 0 );
    
     *ptp =(struct iso_path_table * )newptp;
     	       
   } 
   return next_parent;
}   


   
