#include <sysdefs.h>
#include <excep_api.h>
#include <rtc_api.h>

#define  MIS_RTCSEC_REG 0x1801b600
#define  MIS_RTCACR_REG 0x1801b628
#define  MIS_RTCEN_REG  0x1801b62c
#define  MIS_RTCCR_REG  0x1801b630

#define  MIS_ISR_REG    0x1801b00c


t_RTC_calendar  rtc; 

static void      
rtc_int_handler();
/************************************************************************
 *
 *                          RTC_init
 *  Description :
 *  -------------
 *  Initialize the RTC device
 *
 *
 *  Parameters :
 *  ------------
 *  -
 *
 *
 *  Return values :
 *  ---------------
 *  'OK'(=0) 
 *
 ************************************************************************/
UINT32 RTC_init( void )
{
     UINT32 old_value ;	
  	
  
      	
     /* clock select */
     REG32(KSEG1(MIS_RTCACR_REG)) = 0x0;	
     
     /* enable RTC */	
     REG32(KSEG1(MIS_RTCEN_REG)) = 0x5A;
     
     
     /* register IM7 interrupt of CPU */ 			    
     EXCEP_register_cpu_isr( 7,             
			     rtc_int_handler,           
			     NULL,
		             NULL );
		             
     /* enable half second interrupt */	
     REG32(KSEG1(MIS_RTCCR_REG)) = 0x01;	
     		             
  	             
		             
     rtc.halfsecond = 0 ; //cy test		             
     rtc.year = 1970 ;

     return; 		             
}

static void      
rtc_int_handler()
{
    UINT32 status;	
    UINT32 old_value ;
	
	
    status = REG32(KSEG1(MIS_ISR_REG)) & 0x3e00;	
   	
    if (status== 0)
        return;
      
      
     REG32(KSEG1(MIS_ISR_REG)) = status;    
        
    
    if (status&0x200)
    {   
    	
 
             
        rtc.halfsecond++;
        
        rtc.second += (rtc.halfsecond /2 ) ;
        rtc.minute += (rtc.second /60) ;
        rtc.hour   += (rtc.minute /60) ;
        rtc.dayofmonth += (rtc.hour /24) ;
        rtc.month  += (rtc.dayofmonth /30) ;
        rtc.year   += (rtc.month /12) ;

        rtc.halfsecond %= 2;
        rtc.second %= 60 ; 
        rtc.minute %= 60 ; 
        rtc.hour   %= 24 ; 
        rtc.dayofmonth %= 30;
        rtc.month  %= 12;
      
    }
    return;
     
}    	

