/************************************************************************
 *  Include Header File
 ************************************************************************/

#include <sysdefs.h>
#include <excep_api.h>
#include <timer_api.h>
#include <rtc_api.h>

/************************************************************************
 *  Global variables
 ************************************************************************/
//#ifdef Board_Product_pvr
#if defined(Board_Product_pvr) || defined(Board_RTC_NULL)
t_RTC_calendar  rtc; 
#endif

static UINT32   current_sec = ONE_SECOND;

static void     timer_int_handler();

/************************************************************************
 *
 *                          TIMER_init
 *  Description :
 *  -------------
 *  Initialize the TIMER device
 *
 *
 *  Parameters :
 *  ------------
 *  -
 *
 *
 *  Return values :
 *  ---------------
 *  'OK'(=0) 
 *
 ************************************************************************/
UINT32 TIMER_init( void )
{
     /* enable 90KHz counter */ 
     REG32(KSEG1(MIS_CLK27M_CLK90K_REG)) = 0x200; 
     
     REG32(KSEG1(MIS_TC2IVR_REG)) = current_sec;
     /* timer2 enable , counter mode */
     REG32(KSEG1(MIS_TC2CR_REG))  = 0x80000000; 

//#ifdef Board_Product_pvr
#if defined(Board_Product_pvr) || defined(Board_RTC_NULL)
     /* timer2 interrupt enable */
     REG32(KSEG1(MIS_TC2ICR_REG)) = 0x80000000;
     /* register IM6 interrupt of CPU */
    
     EXCEP_register_cpu_isr( 6,
                 timer_int_handler,
                 NULL,
                 NULL );
#endif

}

//#ifdef Board_Product_pvr
#if defined(Board_Product_pvr) || defined(Board_RTC_NULL)
static void timer_int_handler()
{
    if (!(REG32(KSEG1(MIS_ISR_REG))&0x100))
       return;
   
    REG32(KSEG1(MIS_ISR_REG)) = 0x100;
  
    current_sec += ONE_SECOND ;
    REG32(KSEG1(MIS_TC2IVR_REG)) = current_sec; 
    REG32(KSEG1(MIS_TC2ICR_REG)) = 0x80000000; //timer interrupt enable
    
    // rtc.halfsecond++;
    rtc.second ++;
    rtc.minute += (rtc.second /60) ;
    rtc.hour   += (rtc.minute /60) ;
    rtc.dayofmonth += (rtc.hour /24) ;
    rtc.month  += (rtc.dayofmonth /30) ;
    rtc.year   += (rtc.month /12) ;

    rtc.halfsecond %= 2;
    rtc.second %= 60 ; 
    rtc.minute %= 60 ; 
    rtc.hour   %= 24 ; 
    rtc.dayofmonth %= 30;
    rtc.month  %= 12;
    
    return;
}       
#endif
