//#include <rtd_system.h>
//#include <rtd_types.h>
//#include <mem.h>
//#include <misc.h>
//#include <asm/addrspace.h>

#include <sysdefs.h>
#include <stdio.h>

#if defined(CONFIG_BOOT_TIMER)
#include <timer.h>
#endif

#if !defined(CONFIG_FPGA)
//#include <rtd2885_pll.h>
#endif

#include "rl5829_reg.h"
#include "rtd_usb.h"

extern void sys_wait_us(UINT32 us);
	
#define  WRAP_BASE                           RTD_WRAP_BASE
#define  WRAP_VStatusOut                     (WRAP_BASE + 0x04)
#define  WRAP_VStatusOut_set_vstatus(data)   (0x000000FF&(data))

#define  USBIPINPUT_REG						(WRAP_BASE + 0x8)
#define  RESET_UTMI_REG						(WRAP_BASE + 0xC)

#define  EHCI_INSNREG01                               (RTD_EHCI_BASE + 0x94)
#define  INSNREG01_IN_THRESHOLD(x)			(x&0xffff)
#define  INSNREG01_OUT_THRESHOLD(x)			((x&0xffff)<<16)

#define  EHCI_INSNREG03                               (RTD_EHCI_BASE + 0x9C)
#define  INSNREG03_BREAK_MEM_TRAN_EN		(1)

#define  EHCI_INSNREG05                               (RTD_EHCI_BASE + 0xa4)
#define  EHCI_INSNREG05_set_VPort(data)               (0x0001E000&((data)<<13))
#define  EHCI_INSNREG05_bit_VLoadM                    (0x00001000)
#define  EHCI_INSNREG05_set_VLoadM(data)              (0x00001000&((data)<<12))
#define  EHCI_INSNREG05_bit_VCtrl                     (0x00000F00)
#define  EHCI_INSNREG05_set_VCtrl(data)               (0x00000F00&((data)<<8))
#define  EHCI_INSNREG05_get_VBusy(data)               ((0x00020000&(data))>>17)
#define  EHCI_INSNREG05_get_VStatus(data)             (0x000000FF&(data))

#define writel(val,addr)	rtd_outl(addr,val)
#define readl(addr)		rtd_inl(addr)

#define SC_CLKEN1	KSEG1(0x18000004)
#define USB_CLKEN	0x00000008

// #define CONFIG_REALTEK_VENUS_USB_1261_ECO 				1
#define CONFIG_REALTEK_VENUS_USB_1261			1

void UTMI_VendorIF_Init(void){

   // polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));
   // VPort[3:0] = 0001, VLoadM = 1, VControl[3:0] = 0000
   writel((readl((UINT32 *) EHCI_INSNREG05) & 
   				(~ EHCI_INSNREG05_bit_VLoadM) &
   				(~ EHCI_INSNREG05_bit_VCtrl)) |
   				EHCI_INSNREG05_set_VPort(0x1) |
   				EHCI_INSNREG05_set_VLoadM(0x1) |
   				EHCI_INSNREG05_set_VCtrl(0x0),
   				(UINT32 *) EHCI_INSNREG05);
}


void USBPHY_SetReg(UINT8 addr, UINT8 data){

   // write data out first
   writel((UINT32)WRAP_VStatusOut_set_vstatus(data), WRAP_VStatusOut);

   // polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));
   // VCtrl = low nibble of addr, VLoadM = 0
   writel((readl(EHCI_INSNREG05) &
   				(~ EHCI_INSNREG05_bit_VLoadM) &
   				(~ EHCI_INSNREG05_bit_VCtrl)) |
   				EHCI_INSNREG05_set_VPort(0x1) |
   				EHCI_INSNREG05_set_VLoadM(0x1) |
   				EHCI_INSNREG05_set_VCtrl((0x0f & addr)),
   				EHCI_INSNREG05);

   // polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));
   // VCtrl = low nibble of addr, VLoadM = 1
   writel((readl( EHCI_INSNREG05) &
   				(~ EHCI_INSNREG05_bit_VLoadM) &
   				(~ EHCI_INSNREG05_bit_VCtrl)) |
   				EHCI_INSNREG05_set_VPort(0x1) |
   				EHCI_INSNREG05_set_VLoadM(0x0) |
   				EHCI_INSNREG05_set_VCtrl((0x0f & addr)),
   				EHCI_INSNREG05);

   // polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));
   // VCtrl = high nibble of addr, VLoadM = 0
   writel((readl(EHCI_INSNREG05) &
   				(~ EHCI_INSNREG05_bit_VLoadM) &
   				(~ EHCI_INSNREG05_bit_VCtrl)) |
   				EHCI_INSNREG05_set_VPort(0x1) |
   				EHCI_INSNREG05_set_VLoadM(0x1) |
   				EHCI_INSNREG05_set_VCtrl(((0xf0 & addr) >> 4)),
   				EHCI_INSNREG05);	 
	 
   // polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));
   // VCtrl = high nibble of addr, VLoadM = 1
   writel((readl(EHCI_INSNREG05) &
   				(~ EHCI_INSNREG05_bit_VLoadM) &
   				(~ EHCI_INSNREG05_bit_VCtrl)) |
   				EHCI_INSNREG05_set_VPort(0x1) |
   				EHCI_INSNREG05_set_VLoadM(0x0) |
   				EHCI_INSNREG05_set_VCtrl(((0xf0 & addr) >> 4)),
   				EHCI_INSNREG05);


   // polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));
}

	
UINT8 USBPHY_GetReg(UINT8 addr){
	

   if((USBPHY_30 == addr) | (USBPHY_31 == addr) | (USBPHY_32 == addr) |
      (USBPHY_33 == addr) | (USBPHY_34 == addr) | (USBPHY_35 == addr) |
      (USBPHY_36 == addr) | (USBPHY_38 == addr) ){
      while(1){
         // invalid address access, these registers should not be read 
      }
   }
  
   // polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));
   // VCtrl = low nibble of addr, VLoadM = 0
   writel((readl(EHCI_INSNREG05) &
   				(~ EHCI_INSNREG05_bit_VLoadM) &
   				(~ EHCI_INSNREG05_bit_VCtrl)) |
   				EHCI_INSNREG05_set_VPort(0x1) |
   				EHCI_INSNREG05_set_VLoadM(0x1) |
   				EHCI_INSNREG05_set_VCtrl(((0xf0 & addr) >> 4)),
   				EHCI_INSNREG05);   
   
   // polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));
   // VCtrl = low nibble of addr, VLoadM = 1
   writel((readl(EHCI_INSNREG05) &
   				(~ EHCI_INSNREG05_bit_VLoadM) &
   				(~ EHCI_INSNREG05_bit_VCtrl)) |
   				EHCI_INSNREG05_set_VPort(0x1) |
   				EHCI_INSNREG05_set_VLoadM(0x0) |
   				EHCI_INSNREG05_set_VCtrl((0x0f & addr)),
   				EHCI_INSNREG05);
	 

	// polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));
   // VCtrl = high nibble of addr, VLoadM = 0
   writel((readl(EHCI_INSNREG05) &
   				(~ EHCI_INSNREG05_bit_VLoadM) &
   				(~ EHCI_INSNREG05_bit_VCtrl)) |
   				EHCI_INSNREG05_set_VPort(0x1) |
   				EHCI_INSNREG05_set_VLoadM(0x1) |
   				EHCI_INSNREG05_set_VCtrl((0x0f & addr)),
   				EHCI_INSNREG05);
	 
   // polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));
   // VCtrl = high nibble of addr, VLoadM = 1
   writel((readl(EHCI_INSNREG05) &
   				(~ EHCI_INSNREG05_bit_VLoadM) &
   				(~ EHCI_INSNREG05_bit_VCtrl)) |
   				EHCI_INSNREG05_set_VPort(0x1) |
   				EHCI_INSNREG05_set_VLoadM(0x0) |
   				EHCI_INSNREG05_set_VCtrl(((0xf0 & addr) >> 4)),
   				EHCI_INSNREG05);   

   // polling until VBusy == 0
   while(EHCI_INSNREG05_get_VBusy(readl(EHCI_INSNREG05)));

   return((UINT8)EHCI_INSNREG05_get_VStatus(readl(EHCI_INSNREG05)));
}


void USBPHY_SetReg_Default_30(void)
{
   USBPHY_SetReg(USBPHY_30, USBPHY_30_set_xcvr_autok(0x1) |       // POR = 1
                            USBPHY_30_set_xcvr_SC(0x3) |          // POR = 3, PLL_C
                            USBPHY_30_set_xcvr_CP(0x1));          // POR = 1
}


void USBPHY_SetReg_Default_31(void)
{
   USBPHY_SetReg(USBPHY_31, USBPHY_31_set_xcvr_call_host(0x1) |   // POR = 1
                            USBPHY_31_set_xcvr_zeres_sel(0x0) |   // POR = 0
                            USBPHY_31_set_xcvr_zo_en(0x1) |       // POR = 1
                            USBPHY_31_set_xcvr_SD(0x1) |          // POR = 1
                            USBPHY_31_set_xcvr_SR(0x4));          // POR = 4, PLL_R
}


void USBPHY_SetReg_Default_32(int sh)
{
   USBPHY_SetReg(USBPHY_32, USBPHY_32_set_SEN(0x8) |              // POR = 8
                            USBPHY_32_set_SH((sh & 0xf)));        // POR = 5, swing
}


void USBPHY_SetReg_Default_33(void)
{
   USBPHY_SetReg(USBPHY_33, USBPHY_33_set_HSXMPTPDEN(0x1) |       // POR = 1, hi-speed XCVR power down enable
                            USBPHY_33_set_xcvr_CAL(0x1) |         // POR = 1
                            USBPHY_33_set_xcvr_DB(0x4) |          // POR = 4
#ifdef CONFIG_REALTEK_VENUS_USB_1261
			    USBPHY_33_set_xcvr_DR(0x1)  	  // POR = 0, 1 for LS FIB
#else /* CONFIG_REALTEK_VENUS_USB_1261_ECO */
			    USBPHY_33_set_xcvr_DR(0x0)  	  // POR = 0
#endif /* CONFIG_REALTEK_VENUS_USB_1261_ECO */
			    );
			    
}


void USBPHY_SetReg_Default_34(void)
{
   USBPHY_SetReg(USBPHY_34, USBPHY_34_set_TPA_EN(0x0) |      // POR = 0
                            USBPHY_34_set_TPB_EN(0x0) |      // POR = 0
                            USBPHY_34_set_xcvr_TS(0x0) |          // POR = 0
                            USBPHY_34_set_xcvr_SE(0x2));          // POR = 2
}


void USBPHY_SetReg_Default_35(int src)
{
   USBPHY_SetReg(USBPHY_35, USBPHY_35_set_TPC_EN(0x0) |          // POR = 0
                            USBPHY_35_set_xcvr_SP(0x0) |          // POR = 0
                            USBPHY_35_set_xcvr_SRC((src & 0x7)) | // POR = 7,  slew rate control
                            USBPHY_35_set_HSTESTEN(0x0) |         // POR = 0
                            USBPHY_35_set_xcvr_nsqdly(0x1));      // POR = 1
}


void USBPHY_SetReg_Default_36(int senh)
{
   USBPHY_SetReg(USBPHY_36, USBPHY_36_set_xcvr_senh((senh & 0xf)) | // POR = 9,  sensitivity for host, for HS disconnect detect (EOP) 
                            USBPHY_36_set_xcvr_adjr(0x8));          // POR = 8
}


void USBPHY_SetReg_Default_38(int slb_en)
{
   if(slb_en != 0)
   	slb_en = 1;
   USBPHY_SetReg(USBPHY_38, USBPHY_38_set_dbnc_en(0x1) |          // POR = 1
                            USBPHY_38_set_discon_enable(0x1) |    // POR = 1
                            USBPHY_38_set_EN_ERR_UNDERRUN(0x1) |  // POR = 1
                            USBPHY_38_set_LATE_DLLEN(0x1) |       // POR = 1
                            USBPHY_38_set_INTG(0x1) |             // POR = 0
                            USBPHY_38_set_SOP_KK(0x1) |           // POR = 1
                            USBPHY_38_set_SLB_INNER(0x0) |        // POR = 0
                            USBPHY_38_set_SLB_EN((slb_en & 0x1)));        // POR = 0
}


void USBPHY_Register_Setting(void){
   int param[3];//, value, i = 0, index = 0;

   param[0] = 0x5;		// reg 32 sh, POR = 5, 4bit;
   param[1] = 0x7;		// reg 35 src, POR = 7, 3bit;
   param[2] = 0xd;		// reg 36 senh, POR = 9, 4bit;

#if 0
//#if !defined(CONFIG_FPGA)

#define PG6_PS(x)	((x&0x3) << 24)
#define PG5_PS(x)	((x&0x3) << 20)

#define EHCI_ECO_BIT	(1<<13)

   /* Open USB's clock gating. */
   rtd_outl(SC_CLKEN1,rtd_inl(SC_CLKEN1) | USB_CLKEN);
   rtd_outl(SC_PHY_CLKEN,(rtd_inl(SC_PHY_CLKEN) & (~USB_PHY_CLKEN)) | EHCI_ECO_BIT);   	
   rtd_outl(PG_CFG0,rtd_inl(PG_CFG0) &  (~(PG6_PS(0x3)| PG5_PS(0x3))) );
#endif      

   // rtd_outl(USBIPINPUT_REG,0x4400A081/*0x0400A081*/);
   //rtd_outl(RESET_UTMI_REG,0x1);   
   //udelay(100*1000);   


   UTMI_VendorIF_Init();
   
   USBPHY_SetReg_Default_30();

   USBPHY_SetReg_Default_31();

   USBPHY_SetReg_Default_32(param[0]);

   USBPHY_SetReg_Default_33();

   USBPHY_SetReg_Default_34();

   USBPHY_SetReg_Default_35(param[1]);

   USBPHY_SetReg_Default_36(param[2]);

   USBPHY_SetReg_Default_38(0);


   // printk("usbphy reg 38 = 0x%x\n" , USBPHY_GetReg(USBPHY_38));

   printk("usbphy reg 32, set sh = 0x%x, get sh = 0x%x, 4bit\n", \
		   param[0], USBPHY_GetReg(USBPHY_22) & 0xf);
   printk("usbphy reg 35, set src = 0x%x, get src = 0x%x, 3bit\n", \
		   param[1], (USBPHY_GetReg(USBPHY_25)>>2) & 0x7);
   printk("usbphy reg 36, set senh = 0x%x, get senh = 0x%x, 4bit\n", \
		   param[2], (USBPHY_GetReg(USBPHY_26)>>4) & 0xf);
			   
   rtd_outl(EHCI_INSNREG01,INSNREG01_IN_THRESHOLD(0x40) | INSNREG01_OUT_THRESHOLD(0x40));		   
   rtd_outl(EHCI_INSNREG03,INSNREG03_BREAK_MEM_TRAN_EN);
 
}
