/************************************************************************
 *
 *  project_config.h
 *
 *  external parameters was included in this file
 * 
 *
 ************************************************************************/

#ifndef PROJECT_CONFIG_H
#define PROJECT_CONFIG_H
//********************************************************************
//Board Components
//********************************************************************
//flag                      value
//********************************************************************
#define Board_CPU_VENUS
#define Board_CPU_Package_TQFP
#define Board_FLASH_Type_NOR
#define Board_FLASH_Support_ALL
#define Board_DRAM_Block			64
#define Board_DRAM_Number			1
#define Board_DRAM_Size				64
#define Board_IDE_DEFAULT
#define Board_USB_Driver_Enabled
#define Board_LAN_8139CP
#define Board_UART_SY16550C
#define Board_RTC_DEFAULT
#define Board_VFD_NULL
#define Board_GPIO_venus_avhdd
#define Board_Product_verona
#define Board_Chip_Rev_1261
//********************************************************************
//GPIO setup
//********************************************************************
//flag                      value
//********************************************************************
#define GPIO_PSELH			0x5
#define GPIO_PSELL			0x54000005
#define GPIO_PSEL2			0x0
#define GPIO_GP0DIR			0xe4000003
#define GPIO_GP1DIR			0x6
#define GPIO_GP0DATO			0xa4000000
#define GPIO_GP1DATO			0x4
//********************************************************************
//Config
//********************************************************************
//flag                      value
//********************************************************************
#define Config_PLL_Prog_TRUE
#define Config_Param_Position_BOTTOM
#define Config_Param_Size			0x10000
#define Config_Time_Evaluation_FALSE
#define Config_Cache_TRUE
#define Config_Reset_Assert			0x1002
#define Config_Enable_Assert			0x202
#define Config_Reset_Deassert			0x7ffff
#define Config_Enable_Deassert			0xffff
#define Config_QC_Test_Prog_TRUE
//********************************************************************
//Boot parameters
//********************************************************************
//flag                      value
//********************************************************************
#define Param_companyID			"0"
#define Param_boardID			"01"
#define Param_version			"03"
#define Param_MAC_hi			0x00112233
#define Param_MAC_lo			0x44550000
//********************************************************************
//Logo attribute
//********************************************************************
//flag                      value
//********************************************************************
#define Logo_Source_FLASH
#define Logo_Offset			1312
#define Logo_Reg5370			0x808010
#define Logo_Reg5374			0x808055
#define Logo_Reg5378			0x8080b2
#define Logo_Reg537c			0x8080eb
#define Logo_Type_NTSC
#define Logo_File_Name			"logo_ntsc.bmp"
#define Logo2_Source_FLASH
#define Logo2_Offset			2724
#define Logo2_Reg5370			0x648936
#define Logo2_Reg5374			0x48925d
#define Logo2_Reg5378			0x749889
#define Logo2_Reg537c			0x8080eb
#define Logo2_Type_PAL
#define Logo2_File_Name			"logo2_pal.bmp"
#define Logo3_Source_FLASH
#define Logo3_Offset			2860
#define Logo3_Reg5370			0xef5b51
#define Logo3_Reg5374			0x8080eb
#define Logo3_Reg5378			0x867ee2
#define Logo3_Reg537c			0x897ddd
#define Logo3_Type_PAL
#define Logo3_File_Name			"RTD1061_720x576_24bit_USBUpgrade.bmp"
//********************************************************************
//Rescue Linux attribute
//********************************************************************
//flag                      value
//********************************************************************
#define Rescue_Source_FLASH
#define Rescue_Install_Key			0x09
#define Rescue_Install_With_GPIO_Address			0xb801b110
#define Rescue_Install_With_GPIO_Mask			0x00000800
#define Rescue_Install_With_GPIO_Value			0x00000000
#define Rescue_Loader_Param			""
#define Rescue_File_Name			vmlinux.rescue.usb.flash.bin.lzma
//********************************************************************
//Linux attribute
//********************************************************************
//flag                      value
//********************************************************************
#define Linux_Source_FLASH
#define Linux_Loader_Param			"go 803bc000 rootfstype=squashfs root=31:01 mtdparts="
//********************************************************************
//Shell Setup
//********************************************************************
//flag                      value
//********************************************************************
#define Shell_Enable_YES
#define Cmd_compare_On
#define Cmd_comptime_On
#define Cmd_copy_On
#define Cmd_cp0_Off
#define Cmd_cp1_Off
#define Cmd_disk_On
#define Cmd_dump_On
#define Cmd_erase_On
#define Cmd_fill_On
#define Cmd_format_Off
#define Cmd_freadwrite_On
#define Cmd_go_On
#define Cmd_help_On
#define Cmd_info_On
#define Cmd_iping_On
#define Cmd_load_On
#define Cmd_port_On
#define Cmd_reset_On
#define Cmd_setenv_On
#define Cmd_stty_On
#define Cmd_test_On
#define Cmd_continue_On
//********************************************************************
//user defined 
//********************************************************************
//flag                      value
//********************************************************************
#define system_parameters_3 "POWERKEY_GPIO=12 POWERKEY_IRRP=0xc738e286"
#define disable_ethernet

#endif //#ifndef EXTERN_PARAM_H	
