
/************************************************************************
 *
 *  init.S
 *
 *  Startup code for bootprom
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/

/************************************************************************
 *  Include files
 ************************************************************************/

#include <sysdefs.h>
#include <mips.h>
#include <product.h>
#include <init.h>
#include <sys_api.h>

#include <project_config.h>                    
/************************************************************************
 *  Definitions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/

/************************************************************************
 *  Static variables
 ************************************************************************/

/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/


/************************************************************************
 *  reset_handler
 ************************************************************************/
LEAF(__reset_handler)

/* This is the entry point of the endian dependent code. It is called
 * from the reset handler (reset.S) located at bfc00000. Processor is running
 * at uncached addresses, but this code was linked cached. This function
 * will shift to cached when caches have been initialised.
 */ 
    
    .set noreorder
    
    b       1f          /* 0xBfc01000 */
    nop                 /* 0xBfc01004 */
    nop                 /* 0xBfc01008 */
    .word   0xffffffff  /* 0xBfc0100C */ 
    .word   0xffffffff  /* 0xBfc01010 = 'flash_type'            */
    .word   0xffffffff  /* 0xBfc01014 = 'region'                */
    .word   0xffffffff  /* 0xBfc01018 = 'mac_hi'                */
    .word   0xffffffff  /* 0xBfc0101C = 'mac_lo'                */
    .word   0xffffffff  /* 0xBfc01020 = 'logo_img_saddr'        */
    .word   0xffffffff  /* 0xBfc01024 = 'logo_img_len'          */
    .word   0xffffffff  /* 0xBfc01028 = 'logo_type'             */
    .word   0xffffffff  /* 0xBfc0102C = 'logo_offset'           */
    .word   0xffffffff  /* 0xBfc01030 = 'logo_reg_5370'         */
    .word   0xffffffff  /* 0xBfc01034 = 'logo_reg_5374'         */
    .word   0xffffffff  /* 0xBfc01038 = 'logo_reg_5378'         */
    .word   0xffffffff  /* 0xBfc0103C = 'logo_reg_537c'         */

    .word   0xffffffff  /* 0xBfc01040 = 'rescue_img_size'       */
    .word   0xffffffff  /* 0xBfc01044 = 'rescue_img_part0_saddr'*/
    .word   0xffffffff  /* 0xBfc01048 = 'rescue_img_part0_len'  */
    .word   0xffffffff  /* 0xBfc0104C = 'rescue_img_part1_saddr'*/
    .word   0xffffffff  /* 0xbfc01050 = 'rescue_img_part1_len'  */
    .word   0xffffffff  /* 0xbfc01054 = 'env_param_saddr'*/
    .word   0xffffffff  /* 0xbfc010a0 = ''*/
    .word   0xffffffff  /* 0xbfc010a4 = ''*/
    
    .word   0xffffffff  /* 0xBfc01060 = 'logo2_img_saddr'        */
    .word   0xffffffff  /* 0xBfc01064 = 'logo2_img_len'          */
    .word   0xffffffff  /* 0xBfc01068 = 'logo2_type'             */
    .word   0xffffffff  /* 0xBfc0106C = 'logo2_offset'           */
    .word   0xffffffff  /* 0xBfc01070 = 'logo2_reg_5370'         */
    .word   0xffffffff  /* 0xBfc01074 = 'logo2_reg_5374'         */
    .word   0xffffffff  /* 0xBfc01078 = 'logo2_reg_5378'         */
    .word   0xffffffff  /* 0xBfc0107C = 'logo2_reg_537c'         */
    
    .word   0xffffffff  /* 0xBfc01080 = 'logo3_img_saddr'        */
    .word   0xffffffff  /* 0xBfc01084 = 'logo3_img_len'          */
    .word   0xffffffff  /* 0xBfc01088 = 'logo3_type'             */
    .word   0xffffffff  /* 0xBfc0108C = 'logo3_offset'           */
    .word   0xffffffff  /* 0xBfc01090 = 'logo3_reg_5370'         */
    .word   0xffffffff  /* 0xBfc01094 = 'logo3_reg_5374'         */
    .word   0xffffffff  /* 0xBfc01098 = 'logo3_reg_5378'         */
    .word   0xffffffff  /* 0xBfc0109C = 'logo3_reg_537c'         */
    
    .word   0xffffffff  /* 0xbfc010a0 = ''*/
    .word   0xffffffff  /* 0xbfc010a4 = ''*/
    
1:
    /* Setup cause register (clear cause code)  */
    li      k0, M_CauseIV
#if defined(Config_Time_Evaluation_FALSE)  //cylee 20071220: keep enable counter to evaluate time from power up to linux
    or      k0, k0, M_CauseDC
#endif
    MTC0(   k0, C0_Cause)

    /* cyhuang added */
    MTC0(   zero, C0_COMPARE)   
    
    /* Determine processor */
    MFC0(   k1, C0_PRId)
    li      t0, M_PRIdImp | M_PRIdCoID
    and     k1, t0

    /**** k1 now holds the ProcessorID field ****/

    /* Perform CPU specific initialisation */
    jal     sys_init_processor
    nop
    
1:
    bne     v0, zero, error
    nop

    /*  Initialise caches. If compiled for simulation, we
     *  skip this since caches can be assumed to be invalidated.
     */
    
    
    jal     sys_init_cache
    nop
1:
    bne     v0, zero, error
    nop
        
    /* Caches have now been initialised, so shift to kseg0 */
    la      t0, 1f
    KSEG0A( t0)      
    j       t0
    nop
1:

    /**** From now on, we are executing cached ****/
    /* Check and recovery bootcode if user pressed 'I' from console */
    jal		realtek_recovery
    nop
        

    /* Perform platform specific initialisation.
     *
     * This does not include memory test/clear.
     * The function returns the following parameters :
     * v0 = error code (0 = no error)
     * v1 = RAM size in bytes
     */
         
    jal     access_core01     
    nop
1:
    bne     v0, zero, error
    nop


    li      t1, KSEG1BASE
    la      t0, HW_SEMAPHORE_ADDRESS
    or      t0, t1               /*Make sure it is uncached*/
    lw      t0, 0(t0)            /* read semaphore out , advance 5280 */


    li      s0, Board_DRAM_Size; //if Board_DRAM_Size =128, s0 = 0x08000000
    sll     s0, 20               //if Board_DRAM_Size = 64, s0 = 0x04000000
                                 //if Board_DRAM_Size = 32, s0 = 0x02000000
    /**** s0 now holds RAM size in bytes ****/

    /* Now perform memory test/clear */

    move    a0, s0
    jal     sys_memory_setup    /* v0 != 0 on error */
    nop
    bne     v0, zero, error
    nop
    
    /* load chip-revision (added by cylee) */
    lw      t0, 0xb801a204
    lui     t1, 0xffff
    and     t0, t1
    srl     t0, 16
    
    la      t1, sys_chiprev
    sw      t0, 0(t1)
    
    /* save bootcode image recovery detection (added by cylee) */
    la      t1, sys_realtek_recovery
    sw      s8, 0(t1)
    
    
    /* Copy code to RAM */
        
    la      t0, _etext_init     /* SRC  */
    la      t1, _ftext_ram      /* DST  */
    la      t2, _etext_ram      /* STOP */
    KSEG0A( t1 )     
    KSEG0A( t2 )     
    beq     t1, t2, copy_data
    nop
    
    addiu   t2, -4
    
    /*  Whenever an instruction has been stored to KSEG0, we must
     *  make sure the instruction has been flushed to physical memory
     *  and invalidate the corresponding I-Cache line.
     *  At this point L2 caches (if available) will be disabled.
     *
     *  We bypass the cache operations if CPU is running uncached.
     *  (We assume Config.k0 == K_CacheAttrU is the
     *  only uncached mode used).
     */
    
    MFC0(   t4, C0_Config )
    li      t3, M_ConfigK0
    and     t4, t3
    li      t3, S_ConfigK0
    srlv    t4, t4, t3
    li      t3, K_CacheAttrU
    xor     t4, t3

    la      t5, _e_aventry_ram
1:  
    lw      t3, 0(t0)

    bgeu    t1, t5, no_swap       /*cyhuang av_entry end */

    SWAPEND32(t3, t6, t7)
        
no_swap:        
    
    
    sw      t3, 0(t1)

    beq     t4, zero, 2f    
    add     t0, 4       

SET_MIPS3()     
    cache   DCACHE_ADDR_HIT_WRITEBACK, 0(t1)
    sync
    ICACHE_ADDR_INVALIDATE_OP(t1,a0)
SET_MIPS0()
2:  
    bne     t1, t2, 1b
    add     t1, 4

    /* Copy initialised data to RAM */
    
copy_data:      

    la      t0, _etext      /* SRC  */
    la      t1, _fdata      /* DST  */
    la      t2, _fbss       /* STOP */
    KSEG0A( t1 )        
    KSEG0A( t2 )        
    beq     t1, t2, setup_sp
    nop
    
    addiu   t2, -4

1:
    lw      t3, 0(t0)
    add     t0, 4
    sw      t3, 0(t1)
SET_MIPS3()    
    cache   DCACHE_ADDR_HIT_WRITEBACK, 0(t1)
    sync
    ICACHE_ADDR_INVALIDATE_OP(t1,a0)
SET_MIPS0()     
    
    bne     t1, t2, 1b
    add     t1, 4   
    
setup_sp :

    /* Setup sp (at top of memory) */
      
    la      sp, _freemem
    
    li      t0, SYS_STACK_SIZE
    addu     sp, t0
    /* Align sp to 16 byte boundary (required by Cygnus) */
    li      t0, ~0xf
    and     sp, t0

    /* Store system info */

    
    
    la      t0, sys_processor
    sw      k1, 0(t0)
    la      t0, sys_ramsize
    sw      s0, 0(t0)
    
    /* Redetermine cache info and store it */
    
    move    a0, k1

    
    
1:
    /* L1 Cache */
    jal     sys_determine_icache_assoc_flash
    nop
    la      t0, sys_icache_assoc
    sw      v0, 0(t0)
    
    jal     sys_determine_icache_lines_flash
    nop
    la      t0, sys_icache_lines
    sw      v0, 0(t0)

    jal     sys_determine_icache_linesize_flash
    nop
    la      t0, sys_icache_linesize
    sw      v0, 0(t0)

    jal     sys_determine_dcache_assoc_flash
    nop
    la      t0, sys_dcache_assoc
    sw      v0, 0(t0)
                
    jal     sys_determine_dcache_lines_flash
    nop
    la      t0, sys_dcache_lines
    sw      v0, 0(t0)
        
    jal     sys_determine_dcache_linesize_flash
    nop
    la      t0, sys_dcache_linesize
    sw      v0, 0(t0)

        /*  Calc first free RAM address. We add the dcache line size
     *  to avoid cache writeback problem if user executes uncached
     *  code.
     */
    li      t0, SYS_APPL_STACK_SIZE
    addu    t0, sp
    addu    t0, v0
    la      t1, sys_freemem
    sw      t0, 0(t1)
         
    /*  C-functions can now be called (memory ready and sp,gp have been set).
     *  Interrupts are disabled .
     *  We are using the exception handlers of the bootprom.
     */

    /*  Call the first C-function. It should never return. If it does, we
     * consider it an error, and expect v0 to hold the error code.
     */
        
       

    li      t0, 4*4
    subu    sp, t0  
    la      t0, c_entry
    jalr    t0    
    nop

error:
    /*  Error handling. Display error code (if device for this is available) and
     *  enter an infinite loop (from init.h)
     */

    ERROR_HANDLING  
    
END(__reset_handler)
    

/************************************************************************
 *  Implementation : Static functions
 ************************************************************************/
    
/************************************************************************
 *  sys_memory_setup
 ************************************************************************/
SLEAF(sys_memory_setup)

    /*  a0 = RAM size */
#if 0
//#ifdef Config_QC_Test_Prog_TRUE
    /* First calc start, middle and end addresses   */
    li      t0, KSEG1(8)    /* First , cyhuang modified     */
    add     t2, t0, a0  /* First non valid  */
    move    t1, t0
    srl     t6, a0, 1
    add     t1, t6      /* Middle+4     */

    /*  Test first, middle and last address by writing magic values and
     *  reading values back. The middle value is needed to test for
     *  mirroring.
     */



    /* Setup values */
#define MAGIC_LO    0xAAAAAAAA
#define MAGIC_MI    0xDEADBEEF
#define MAGIC_HI    0x55555555

    li      t3, MAGIC_LO
    li      t4, MAGIC_MI
    li      t5, MAGIC_HI

    /* Perform the writes */
    sw      t3,  0(t0)  /* first */

    move    t1, t0
    srl     t6, a0, 1
    add     t1, t6  
    sw      t4, -4(t1)  /* (last/2)-4 */

    move    t1, t0
    srl     t6, a0, 2
    add     t1, t6  
    sw      t4, -4(t1)  /* (last/4)-4 */

    move    t1, t0
    srl     t6, a0, 3
    add     t1, t6  
    sw      t4, -4(t1)  /* (last/8)-4 */

    move    t1, t0
    srl     t6, a0, 1
    add     t1, t6  
    srl     t6, a0, 2
    add     t1, t6  
    sw      t4, -4(t1)  /* (last/2) + (last/4) - 4 */

    move    t1, t0
    srl     t6, a0, 1
    add     t1, t6  
    srl     t6, a0, 2
    add     t1, t6  
    srl     t6, a0, 3
    add     t1, t6  
    sw      t4, -4(t1)  /* (last/2) + (last/4) + (last/8) - 4 */

    sw      t5, -32(t2) /* last-8 */

    /* Perform the reads and compares */
    lw      v0,  0(t0)
    bne     v0, t3, error
    

    move    t1, t0
    srl     t6, a0, 1
    add     t1, t6  
    lw      v0, -4(t1)  /* (last/2) - 4 */
    bne     v0, t4, error
    

    move    t1, t0
    srl     t6, a0, 2
    add     t1, t6  
    lw      v0, -4(t1)  /* (last/4) - 4 */
    bne     v0, t4, error
    

    move    t1, t0
    srl     t6, a0, 3
    add     t1, t6  
    lw      v0, -4(t1)  /* (last/8) - 4 */
    bne     v0, t4, error
    

    move    t1, t0
    srl     t6, a0, 1
    add     t1, t6  
    srl     t6, a0, 2
    add     t1, t6  
    lw      v0, -4(t1)  /* (last/2) + (last/4) - 4 */
    bne     v0, t4, error
    

    move    t1, t0
    srl     t6, a0, 1
    add     t1, t6  
    srl     t6, a0, 2
    add     t1, t6  
    srl     t6, a0, 3
    add     t1, t6  
    lw      v0, -4(t1)  /* (last/2) + (last/4) + (last/8) - 4 */
    bne     v0, t4, error
    


    lw  v0, -32(t2)
    bne     v0, t5, error
    

    /* ok */
    move    v0, zero
    

    /* Perform test of yamon RAM */



#if 1
    move    a1, a0	            /* RAM size */
    srl     a1, 1
    li      a0, KSEG1(0)            /* start ,cyhuang modified  */
    addu    a0, a1
#else /* 1 */
    li      a0, KSEG1(8)            /* start ,cyhuang modified  */
    la      a1, _freemem
    li      t0, SYS_STACK_SIZE
    addu    a1, t0 
    PHYSA( a1 )         /* size     */
#endif /* 1 */

    move    a2, zero        /* no callback  */
    move    s1, ra
    jal     sys_memory_test
    nop
    move    ra, s1
    bne     v0, zero, error
    nop
#endif /* Config_QC_Test_Prog_TRUE */
    move    v0, zero
 
    /* Perform memory clear */

mem_clear:  
    
    
    la      t0, _fbss 
    la      t1, _end
    addiu   t1, -4
    
    
    KSEG0A( t0 ) 
    KSEG0A( t1 )
    
1:      
          
   
    sw      zero,  0(t0)
    
                
    bne     t0, t1, 1b
    add     t0, 4          
      
mem_setup_done :        
    jr      ra
    nop
        
END(sys_memory_setup)   


/************************************************************************
 *
 *                          sys_memory_test
 *  Description :
 *  -------------
 *  Perform simple memory test
 *
 *  Parameters :
 *  ------------
 *  a0 = RAM start address
 *  a1 = RAM size
 *
 *  Return values :
 *  ---------------
 *  0 If OK, error code != 1 if error
 *
 ************************************************************************/
SLEAF(sys_memory_test)

    .set noreorder

#define ADDR     t0
#define LAST     t1
#define DATA     t2
    
    KSEG1A( a0 )
    
    li      t4, 0x0a;
    sw      t4, 0xb801b200; 
    li      t4, 0x4d;
    sw      t4, 0xb801b200; 
    li      t4, 0x65;
    sw      t4, 0xb801b200; 
    li      t4, 0x6d;
    sw      t4, 0xb801b200; 
    li      t4, 0x6f;
    sw      t4, 0xb801b200; 
    li      t4, 0x72;
    sw      t4, 0xb801b200; 
    li      t4, 0x79;
    sw      t4, 0xb801b200; 
    li      t4, 0x20;
    sw      t4, 0xb801b200; 
    li      t4, 0x54;
    sw      t4, 0xb801b200; 
    li      t4, 0x65;
    sw      t4, 0xb801b200; 
    li      t4, 0x73;
    sw      t4, 0xb801b200; 
    li      t4, 0x74;
    sw      t4, 0xb801b200; 
    li      t4, 0x20;
    sw      t4, 0xb801b200; 



#if 1
    li      t4, 0x30;
    sw      t4, 0xb801b200;
    li      t4, 0x78;
    sw      t4, 0xb801b200;
    li      t5, 32;
1:
    addi    t5, t5, -4;
    li      t6, 0xF;
    sll     t6, t6, t5;
    move    t4, a0;
    and     t4, t6;
    srl     t4, t4, t5;
    addi    t4, t4, 0x30;
    sw      t4, 0xb801b200; 
    bne     t5, zero, 1b;
    nop
    li      t4, 0x20;
    sw      t4, 0xb801b200;
#endif /* 0 */


    li      t4, 0x30;
    sw      t4, 0xb801b200;
    li      t4, 0x78;
    sw      t4, 0xb801b200;
    li      t5, 32;
1:
    addi    t5, t5, -4;
    li      t6, 0xF;
    sll     t6, t6, t5;
    move    t4, a1;
    and     t4, t6;
    srl     t4, t4, t5;
    addi    t4, t4, 0x30;
    sw      t4, 0xb801b200;
    bne     t5, zero, 1b;
    nop
    li      t4, 0x20;
    sw      t4, 0xb801b200;


    
    /**** WORD ACCESSES ****/

    /*li      t4, 0xFFFFF*/

    /* Default error */
    li      v0, 100
    
    addu    LAST, a0, a1
    addiu   LAST, -4

    /* Write */
    move    ADDR, a0
    move    DATA, zero
1:
    sw      DATA, 0(ADDR)
    addiu   DATA, 1
    bne     ADDR, LAST, 1b
    addiu   ADDR, 4

    /* Read */
    move    ADDR, a0
    move    DATA, zero
1:
    lw      t5, 0(ADDR)
    bne     t5, DATA, mem_test_done
    addiu   DATA, 1
    bne     ADDR, LAST, 1b
    addiu   ADDR, 4

    /* Write Zero */
    move    ADDR, a0
    move    DATA, zero
1:
    sw      DATA, 0(ADDR)
    bne     ADDR, LAST, 1b
    addiu   ADDR, 4

    /* No error */
    move    v0, zero
    
    /**** DONE ****/

mem_test_done:      
    jr      ra
    nop

END(sys_memory_test)


/******* Messages ********/

    

    
