/************************************************************************
 *
 *  msc01_core.S
 *
 *  MSC01 (Mips System Controller) specific functions
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/

/************************************************************************
 *  Include files
 ************************************************************************/

#include <sysdefs.h>
#include <mips.h>
#include <init.h>

#include <product.h>
#include <core_sys.h>

#include <project_config.h>

/************************************************************************
 *  Definitions
 ************************************************************************/
#ifndef KSEG1_BASE
# define KSEG0_BASE         0x80000000  /* unmapped, cachable   */
# define KSEG1_BASE         0xa0000000  /* unmapped, uncached   */
#endif
#define SYSCTRL_DDR_SUPPORT 1


/************************************************************************
 *  Compile time assertions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/

/************************************************************************
 *  Static variables
 ************************************************************************/

/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/

    .set noreorder


/************************************************************************   
 *      access_core01
 *  Common function calling conventions, see init_core.S
 ************************************************************************/

LEAF( access_core01 )
    
    li        t8, FUNC_CONFIGURE_SDRAM
    beq     t9, t8,configure_sdram
    nop

END( access_core01 )


/************************************************************************
 *  Implementation : Static functions
 ************************************************************************/


/************************************************************************
 *
 *          configure_sdram
 *  Description :
 *  -------------
 *  Setup  SDRAM configuration
 *
 *  Parameters :
 *  ------------
 *  
 * 
 *  
 *  
 *        
 *
 *  Return values :
 *  ---------------
 *  v0 = error code (0 = OK)
 *  v1 = RAM size
 *
 ************************************************************************/
SLEAF(configure_sdram)

#define RA          s0
#define MC_REGS     s1

    move    RA, ra  

    /********************************************
     ** Serial Flash clock
     *******************************************/
    
	lw		t0, 0xb801a800;
	srl		t0, 31;
	
	beq     zero, t0, parallel_flash;
	nop
	
serial_flash:
	li      t0, 0x01070009;
        sw      t0, 0xb801a808;
             
        li      t0, 0x000f0f0f;
        sw      t0, 0xb801a80c;    
parallel_flash:
    
    /********************************************
     ** PLL configuration
     *******************************************/
     
    /* check PLL */    
    lw      t0, 0xb8000004;
    bnez    t0, Return; 
    nop  
    
    
    /* SYS-PLL */
#ifdef Config_PLL_Prog_TRUE
    li      a0, 0xb800008c;
    li      a1, 8;
    jal     pll_mn
    nop
#else
    li      t0, 0x01c1cc14;
    sw      t0, 0xb800008c;
#endif    
    
    li      t0, 0x02;
    sw      t0, 0xb8000090;
    
    li      t0, 0x03;
    sw      t0, 0xb8000090;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    li      t0, 0x01;
    sw      t0, 0xb8000090;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    /* Turn on PLL */
    li      t0, 0x00;
    sw      t0, 0xb8000008;
    
    
    /* ETN PLL */
    li      t0, 0x02;
    sw      t0, 0xb8000080;
    
    li      t0, 0x03;
    sw      t0, 0xb8000080;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    li      t0, 0x01;
    sw      t0, 0xb8000080;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    /* DISP-PLL */
    li      t0, 0x02;
    sw      t0, 0xb80000c0;
    
    li      t0, 0x03;
    sw      t0, 0xb80000c0;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    li      t0, 0x01;
    sw      t0, 0xb80000c0;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    /* ACPU-PLL */
    li      t0, 0x02;
    sw      t0, 0xb80000c8;
    
    li      t0, 0x03;
    sw      t0, 0xb80000c8;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    li      t0, 0x01;
    sw      t0, 0xb80000c8;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    /* DDR-PLL */
#ifdef Config_PLL_Prog_TRUE

    li      a0, 0xb8000094;
    li      a1, 14;  
    jal     pll_mn
    nop
#else    
        li      t0, 0x01c1cc14;
        sw      t0, 0xb8000094;
#endif
    li      t0, 0x02;
    sw      t0, 0xb8000098;
    
    li      t0, 0x03;
    sw      t0, 0xb8000098;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    li      t0, 0x01;
    sw      t0, 0xb8000098;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    /* 1394 PLL */
    li      t0, 0x2a;
    sw      t0, 0xb800009c;
    
    li      t0, 0x3b;
    sw      t0, 0xb800009c;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    li      t0, 0x11;
    sw      t0, 0xb800009c;
    
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    /* De-assert USB PHY reset */
    li      t0, 0x20000;
    sw      t0, 0xb8000000;
    
     /* delay nops */
    li      t0, 200000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    

    /* Turn on clock */
    li      t0, 0xffff;
    sw      t0, 0xb8000004;
    
    /* delay nops */
    li      t0, 10000
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    /* 1394 OEB = 1 */
    li      t0, 0x13;
    sw      t0, 0xb800009c;
     
    /* Turn off clock */
    li      t0, 0x0000;
    sw      t0, 0xb8000004;
    
    /* delay nops */
    li      t0, 10000
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1

    
    /* De-assert reset */
    li      t0, 0x7ffff;
    sw      t0, 0xb8000000;
    
    /* delay nops */
    li      t0, 10000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    /* 1394 OEB = 0 */
    li      t0, 0x11;
    sw      t0, 0xb800009c;
    
    /* Turn on clock */
    li      t0, 0xffff; 
    sw      t0, 0xb8000004;
    
    /*************************
    ** Initialize UART port
    *************************/
    
    li      t0, 0x80;
    sw      t0, 0xb801b20c; 
    
    li      t0, 0xe;
    sw      t0, 0xb801b200; 
    
    li      t0, 0x0;
    sw      t0, 0xb801b204; 
    
    li      t0, 0x3;
    sw      t0, 0xb801b20c; 
    
    li      t0, 0x0;
    sw      t0, 0xb801b204; 
    
    li      t0, 0x4f;
    sw      t0, 0xb801b208; 
   
   li       t0, 0x02;
   sw       t0, 0xb801b210;
     

#if defined(Board_Product_pvrbox) || defined(Board_Product_avhdd)
    /* Check Test Mode */
    /* If pvrbox connect to PC, venus must enter test mode 
       to let PC owns HD control. */
  #ifdef PVRBOX_From_PC
  #else
    lw		t0, 0xb801a204;
    and     t0, 0x0000ff00;
    bnez    t0, Reset
    nop  
  #endif
#endif
      
        
    
       /*************************         
       ** spread spectrum
       *************************/         
       
        li      t0, 0xbf7f0000;
        sw      t0, 0xb8000020;
        sw      t0, 0xb800001c;
    
    /*************************     
     ** set GPIO setting 
     *************************/    
#if defined(GPIO_PSELH)
    li      t0, GPIO_PSELH;
    sw      t0, 0xb801b000;
#endif

#if defined(GPIO_PSELL)
    li      t0, GPIO_PSELL;
    sw      t0, 0xb801b004;
#endif

#if defined(GPIO_PSEL2)
    li      t0, GPIO_PSEL2;
    sw      t0, 0xb801b034;
#endif

#if defined(GPIO_GP0DIR)
    li      t0, GPIO_GP0DIR;
    sw      t0, 0xb801b100;
#endif

#if defined(GPIO_GP1DIR)
    li      t0, GPIO_GP1DIR;
    sw      t0, 0xb801b104;
#endif

#if defined(GPIO_GP0DATO)
    li      t0, GPIO_GP0DATO;
    sw      t0, 0xb801b108;
#endif

#if defined(GPIO_GP1DATO)
    li      t0, GPIO_GP1DATO;
    sw      t0, 0xb801b10c;
#endif

#if defined(Board_Product_pvr)
    /* since pvr-module had used UART-1,
       we have to enable it */
    li       t0, 0x18600000           /* pull up uart0/1 Rx */
    sw       t0, 0xb801a148;
#endif

    /*************************     
    ** set SB1 priority 
    *************************/ 
    
    li      t0, 0x13fdc61;
    sw      t0, 0xb8008008;  
    
    
    /********************************************
    ** Set SYSBRG2 time_out enable &     
    ** Set page size selection on DC_SYS_MISC Register
    */
    
    li      t0, 0x11; 
    sw      t0, INV_INTEN_REG    

    /* setup dram size to sys-bridge */
    li      t0, Board_DRAM_Size;  // if 64M, t0 now = 0x20000
    sll     t0, 11;               // if 32M, t0 now = 0x10000

    or      t0, 0x1818;
    sw      t0, DC_SYS_MISC_REG
    
    /********************************************
     ** Set up Timig and Mode controller register I & II    
     ********************************************/
    li      MC_REGS, MC_REG_BASE

//    li        t0, 0x258ca289;    //16 bits data bus width
    li      t0, 0x3d913533;     
#if Board_DRAM_Block==32 && Board_DRAM_Number==2
    li      t0, 0x3d913532;        //32 bits data bus width
#endif

1:
    sw      t0, MC_TMMOD1_OFS(MC_REGS) 
        li      t0, 0x20202020; 
	sw      t0, 0xb8008820;

        li      t0, 0x0CC85001;
        sw	t0, MC_TMMOD2_OFS(MC_REGS) 
        li      t0, 0x0C485001;
	sw	t0, MC_TMMOD2_OFS(MC_REGS) 
    
    /********************************************
     ** Set up Mode Control register
     ********************************************/
    
    li      t0, 0x00000032;  
    sw      t0, MC_MODCTRL_OFS(MC_REGS)

        li      t0, 0x1000800;
 	sw	t0, 0xb8008818;
    /********************************************
     ** Set up Calibration Address register
     ********************************************/
    
#if (Board_DRAM_Block == 64) && (Board_DRAM_Number == 1)	/* 64 x 1 */
    li      t0, 0x01bffffe; 
#elif (Board_DRAM_Block == 64) && (Board_DRAM_Number == 2)	/* 64 x 2 */
    li      t0, 0x019ffffe; 
#elif (Board_DRAM_Block == 32) && (Board_DRAM_Number == 2)	/* 32 x 2 */
    li      t0, 0x01bffffe; 
#else
    li      t0, 0x01bffffe; 
#endif
    sw      t0, MC_CALADR_OFS(MC_REGS)
    
    /********************************************
     ** Initialize RAM through Function control register
     ********************************************/
    
    li      t0, 0x00000010;
    sw      t0, MC_FUNCTRL_OFS(MC_REGS)
    
    /********************************************
     ** Check if SDRAM is ready
     ********************************************/
1:
    lw      t0, MC_FUNCTRL_OFS(MC_REGS)    
    and     t0, 0x00000010;
    bnez    t0, 1b 
    nop
    
    
    /********************************************
     ** Return
     ********************************************/

Return:
    
    jr  RA
    li  v0, 0

config_error:
    li  v0, 100
    
error_sdram:
    jr  RA
    nop
	
Reset:
    li      t0, 0x36 ;
    sw      t0, 0xb801b200
        
    /* delay nops */
    li      t0, 1000000   
    li      t1, 0
      
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1

    li      t0, 0x08 ;
    sw      t0, 0xb801b104
        
1:
    li      t2, 0x37 ;
    sw      t2, 0xb801b200
        
    b       1b         	
    nop

#undef RA
#undef MC_REGS

END(configure_sdram)






